/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class EntityExtendedRangeDamage
extends Entity {
    public int deathtimer = 60;
    public Entity thrower = null;
    public double oposx = 0.0;
    public double oposy = 0.0;
    public double oposz = 0.0;

    public EntityExtendedRangeDamage(World w) {
        super(w);
        this.maxrenderdist = 1;
        this.height = 0.0f;
        this.width = 0.0f;
        this.uniquename = "DangerZone:ExtendedRangeDamage";
        this.movement_friction = false;
        this.canthitme = true;
        this.setAttackDamage(0.0f);
        this.setBID(0);
        this.setMaxHealth(0.0f);
        this.setIID(0);
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 60, 60);
    }

    public void setDirectionAndVelocity(float x, float y, float z, float velocity, float variability) {
        this.motionx = x * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motiony = y * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motionz = z * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
    }

    public void setDamageType(int dt) {
        this.setBID(dt);
    }

    public void setExplosivePower(int exp) {
        this.setMaxHealth(exp);
    }

    public void setRange(int rng) {
        this.setIID(rng);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            float dist = (float)Math.sqrt(this.motionx * deltaT * this.motionx * deltaT + this.motiony * deltaT * this.motiony * deltaT + this.motionz * deltaT * this.motionz * deltaT);
            float blockdist = 0.0f;
            float edist = 0.0f;
            boolean hitblock = false;
            boolean hitentity = false;
            List<Entity> nearby_list = null;
            Entity enthit = null;
            Entity ridden = null;
            if (this.oposx == 0.0) {
                this.oposx = this.posx;
                this.oposy = this.posy;
                this.oposz = this.posz;
            }
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(dist + 16.0f, this.dimension, this.posx, this.posy, this.posz);
            int lz = 0;
            int ly = 0;
            int lx = 0;
            if (this.thrower != null && (ridden = this.thrower.getRiddenEntity()) == null) {
                ridden = this.thrower.getRiderEntity();
            }
            double fx = this.posx;
            double fy = this.posy;
            double fz = this.posz;
            while (blockdist < dist) {
                fx = this.posx + (double)(this.motionx * deltaT * blockdist / dist);
                fy = this.posy + (double)(this.motiony * deltaT * blockdist / dist);
                fz = this.posz + (double)(this.motionz * deltaT * blockdist / dist);
                int x = (int)fx;
                int y = (int)fy;
                int z = (int)fz;
                edist = (float)Math.sqrt((this.oposx - fx) * (this.oposx - fx) + (this.oposy - fy) * (this.oposy - fy) + (this.oposz - fz) * (this.oposz - fz));
                if (edist > (float)this.getIID()) {
                    this.deadflag = true;
                    break;
                }
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    enthit = li.next();
                    if (enthit == this || enthit.canthitme || enthit == this.thrower || enthit == ridden || !(fy > enthit.posy) || !(fy < enthit.posy + (double)enthit.getHeight())) continue;
                    edist = (float)enthit.getHorizontalDistanceFromEntity(fx, fz);
                    edist -= this.getWidth() / 2.0f;
                    if (!((edist -= enthit.getWidth() / 2.0f) < 0.0f)) continue;
                    hitentity = true;
                    break;
                }
                if (hitentity) break;
                if (x != lx || y != ly || z != lz) {
                    lx = x;
                    ly = y;
                    lz = z;
                    int bid = this.world.getblock(this.dimension, x, y, z);
                    if (bid != 0) {
                        hitblock = true;
                        break;
                    }
                }
                blockdist += 0.1f;
            }
            if (hitentity || hitblock) {
                this.motionx = this.motionx * deltaT * blockdist / dist;
                this.motiony = this.motiony * deltaT * blockdist / dist;
                this.motionz = this.motionz * deltaT * blockdist / dist;
                this.doHitSomething(hitblock, fx, fy, fz, hitentity, hitentity ? enthit : null);
                this.deadflag = true;
                return;
            }
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
        }
        super.update(deltaT);
    }

    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        if (this.getAttackDamage() > 0.0f && ent != null) {
            ent.doAttackFrom(this.thrower, this.getBID(), this.getAttackDamage());
        }
        if (this.getMaxHealth() > 0.0f) {
            Explosion.boom(this.world, this.dimension, x, y, z, (int)this.getMaxHealth(), true);
        }
    }
}

