/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class EntityBlockItem
extends Entity {
    public int deathtimer = 1200;
    public int pickup_delay = 0;
    private float mx;
    private float mz;
    boolean tried = false;

    public EntityBlockItem(World w) {
        super(w);
        this.maxrenderdist = 40;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = DangerZone.blockitemname;
        this.pickup_delay = 10;
        this.canthitme = true;
        if (w != null) {
            this.rotation_pitch = w.rand.nextInt(360);
            this.rotation_yaw = w.rand.nextInt(360);
            this.rotation_roll = w.rand.nextInt(360);
        }
        this.mx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.006f;
        this.mz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.006f;
        this.setFlying(true);
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
    }

    @Override
    public void update(float deltaT) {
        this.rotation_pitch_motion = 3.0f;
        this.rotation_yaw_motion = 9.0f;
        this.rotation_roll_motion = 5.0f;
        if (this.world.isServer) {
            Player p;
            boolean inliquid = false;
            if (this.posy < -10.0) {
                this.deadflag = true;
                return;
            }
            if (this.world.rand.nextInt(100) == 1) {
                float f = this.world.rand.nextFloat() * 0.12f;
                this.motiony += f;
            }
            if (this.world.rand.nextInt(200) == 1) {
                this.mx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.006f;
            }
            if (this.world.rand.nextInt(200) == 1) {
                this.mz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.006f;
            }
            this.motionx += this.mx;
            this.motionz += this.mz;
            int bbid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)this.getHeight()), (int)this.posz);
            if (Blocks.isSolid(bbid)) {
                this.motiony += 0.25f * deltaT;
            } else {
                if (Blocks.isLiquid(bbid)) {
                    Blocks.entityInLiquid(bbid, this);
                    inliquid = true;
                }
                this.motiony -= 0.05f * deltaT;
            }
            this.setInLiquid(inliquid);
            if (this.getOnFire() != 0) {
                this.deathtimer -= 5;
            }
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
            if (this.pickup_delay > 0) {
                --this.pickup_delay;
            }
            if (!this.deadflag && this.pickup_delay <= 0 && (p = DangerZone.server.findNearestPlayer(this)) != null && !p.deadflag && this.getDistanceFromEntity(p) < (double)(p.getWidth() / 2.0f + 5.0f)) {
                if (this.getDistanceFromEntity(p) < (double)(p.getWidth() * 3.0f / 2.0f)) {
                    boolean doplaysound = false;
                    int ntimes = this.gethotbarindex();
                    if (ntimes < 1) {
                        ntimes = 1;
                    }
                    while (ntimes > 0) {
                        if (!p.putMeInASlot(this.getBID(), this.getIID(), this.getItemDamage())) {
                            doplaysound = false;
                            this.sethotbarindex(ntimes);
                            break;
                        }
                        doplaysound = true;
                        --ntimes;
                    }
                    if (doplaysound) {
                        this.deadflag = true;
                        this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    }
                }
                float tdir = (float)Math.atan2(p.posx - this.posx, p.posz - this.posz);
                double factor = 1.0;
                double dist = this.getDistanceFromEntity(p);
                factor = (double)(p.getWidth() / 2.0f + 5.0f) / dist;
                if (factor > 1.0) {
                    factor = 1.0;
                }
                this.motionx = (float)((double)this.motionx + (double)0.08f * factor * Math.sin(tdir) * (double)deltaT);
                this.motionz = (float)((double)this.motionz + (double)0.08f * factor * Math.cos(tdir) * (double)deltaT);
                if (this.posy > p.posy) {
                    this.motiony -= 0.05f * deltaT;
                }
                if (this.posy < p.posy) {
                    this.motiony += 0.15f * deltaT;
                }
            }
            if (!this.deadflag && !this.tried && this.getItemDamage() == 0 && DangerZone.server.entityManager.active_entities > DangerZone.max_entities / 4) {
                List<Entity> nearby_list = null;
                Entity e = null;
                nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(8.0f, this.dimension, this.posx, this.posy, this.posz);
                if (nearby_list != null && !nearby_list.isEmpty()) {
                    ListIterator<Entity> li = nearby_list.listIterator();
                    while (li.hasNext()) {
                        int hiscount;
                        e = li.next();
                        if (e == this || !(e instanceof EntityBlockItem) || e.deadflag || this.getBID() != e.getBID() || this.getIID() != e.getIID() || e.getItemDamage() != 0) continue;
                        EntityBlockItem eb = (EntityBlockItem)e;
                        int mycount = this.gethotbarindex();
                        if (mycount < 1) {
                            mycount = 1;
                        }
                        if ((hiscount = eb.gethotbarindex()) < 1) {
                            hiscount = 1;
                        }
                        eb.sethotbarindex(hiscount + mycount);
                        eb.deathtimer = 1200;
                        this.deadflag = true;
                        break;
                    }
                }
                this.tried = true;
            }
            if (this.getInLiquid()) {
                this.doInLiquid(1.0f);
                this.motionx *= 0.9f;
                this.motiony *= 0.9f;
                this.motionz *= 0.9f;
                this.doSolidsPushback(0.0f, deltaT);
            }
        } else {
            float rate = DangerZone.entityupdaterate;
            int bbid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)this.getHeight()), (int)this.posz);
            this.motiony = Blocks.isSolid(bbid) ? (this.motiony += 0.25f * rate * deltaT) : (this.motiony -= 0.05f * (rate /= (float)DangerZone.serverentityupdaterate) * deltaT);
        }
        super.update(deltaT);
    }

    /*
     * Unable to fully structure code
     */
    public boolean doSolidsPushback(float kf, float deltaT) {
        wdth = this.getWidth();
        intwidth = (int)(wdth / 2.0f + 0.995f);
        tmx = this.motionx * deltaT;
        tmz = this.motionz * deltaT;
        rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        if (!this.world.isServer) {
            tmx *= rate;
            tmz *= rate;
        }
        hitsomething = false;
        dist = (float)Math.sqrt(tmx * tmx + tmz * tmz);
        curdist = 0.0f;
        bid = 0;
        if (dist != 0.0f) ** GOTO lbl72
        return false;
lbl-1000:
        // 1 sources

        {
            if ((curdist += 0.1f) > dist) {
                curdist = dist;
            }
            mx = curdist / dist * tmx;
            mz = curdist / dist * tmz;
            upx = this.posx + (double)mx;
            upz = this.posz + (double)mz;
            i = -intwidth;
            while (i <= intwidth) {
                j = -intwidth;
                while (j <= intwidth) {
                    bid = this.world.getblock(this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                    if (bid != 0 && Blocks.isSolid(bid, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j)) {
                        itemp = (int)upx + i;
                        dx = (double)itemp + 0.5 - this.posx;
                        itemp = (int)upz + j;
                        dz = (double)itemp + 0.5 - this.posz;
                        if (Math.abs(dx) - (double)(0.51f + wdth / 2.0f) < 0.0 && Math.abs(dz) - (double)(0.51f + wdth / 2.0f) < 0.0) {
                            this.posx = dx > 0.0 ? (this.posx -= 0.019999999552965164) : (this.posx += 0.019999999552965164);
                            this.posz = dz > 0.0 ? (this.posz -= 0.019999999552965164) : (this.posz += 0.019999999552965164);
                            itemp = (int)this.posx + i;
                            dx = (double)itemp + 0.5 - this.posx;
                            itemp = (int)this.posz + j;
                            dz = (double)itemp + 0.5 - this.posz;
                        }
                        dxsave = dx;
                        if (dx < 0.0 && mx < 0.0f) {
                            if (Math.abs(dz) < (double)(0.51f + wdth / 2.0f)) {
                                dx += 0.5099999904632568;
                                if ((dx += (double)(wdth / 2.0f)) > (double)mx) {
                                    this.motionx = (float)(dx / (double)deltaT);
                                    hitsomething = true;
                                    Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                                }
                            }
                        } else if (dx > 0.0 && mx > 0.0f && Math.abs(dz) < (double)(0.51f + wdth / 2.0f)) {
                            dx -= 0.5099999904632568;
                            if ((dx -= (double)(wdth / 2.0f)) < (double)mx) {
                                this.motionx = (float)(dx / (double)deltaT);
                                hitsomething = true;
                                Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                            }
                        }
                        dx = dxsave;
                        if (dz < 0.0 && mz < 0.0f) {
                            if (Math.abs(dx) < (double)(0.51f + wdth / 2.0f)) {
                                dz += 0.5099999904632568;
                                if ((dz += (double)(wdth / 2.0f)) > (double)mz) {
                                    this.motionz = (float)(dz / (double)deltaT);
                                    hitsomething = true;
                                    Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                                }
                            }
                        } else if (dz > 0.0 && mz > 0.0f && Math.abs(dx) < (double)(0.51f + wdth / 2.0f)) {
                            dz -= 0.5099999904632568;
                            if ((dz -= (double)(wdth / 2.0f)) < (double)mz) {
                                this.motionz = (float)(dz / (double)deltaT);
                                hitsomething = true;
                                Blocks.bumpedBlock(bid, this, this.world, this.dimension, (int)upx + i, (int)(this.posy + (double)kf), (int)upz + j);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
lbl72:
            // 2 sources

            ** while (curdist < dist && !hitsomething)
        }
lbl73:
        // 1 sources

        return hitsomething;
    }

    @Override
    public float getBrightness() {
        if (this.gethotbarindex() <= 1) {
            return 0.0f;
        }
        if (this.lifetimeticker % 30L < 15L) {
            return -0.1f;
        }
        return 0.5f;
    }
}

