/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityLiving;
import org.newdawn.slick.opengl.Texture;

public class EntityBlock
extends EntityLiving {
    public EntityBlock(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityBlock";
        this.width = 0.75f;
        this.height = 0.75f;
        this.takesFallDamage = false;
        this.movefrequency = 5;
        this.canSwim = false;
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            this.firecounter = 0;
            if (Blocks.getMaxStack(this.getBID()) == 0) {
                this.deadflag = true;
            } else if (Blocks.isSolid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)0.1f), (int)this.posz)) && !Blocks.isSolid(this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz))) {
                this.world.setblockandmeta(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, this.getBID(), this.getIID());
                if (!Blocks.isSolid(this.getBID())) {
                    this.world.playSound("DangerZone:big_splash", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
                } else if (this.world.rand.nextInt(3) == 1) {
                    this.world.playSound("DangerZone:dirt_place", this.dimension, this.posx, this.posy, this.posz, 0.125f, 1.0f);
                }
                this.deadflag = true;
            }
        }
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        return null;
    }

    @Override
    public boolean isDying() {
        return false;
    }

    @Override
    public void doDeathAnimation() {
        this.deathfactor = 0.0f;
        this.motionz = 0.0f;
        this.motionx = 0.0f;
        this.motiony = 0.0f;
    }
}

