/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.threads.VBODataBuilderThread;
import org.lwjgl.opengl.GL11;

public class StickyBlock
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    public StickyBlock(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.isLiquid = false;
        this.isSquishy = true;
        this.friction = 0.85f;
        this.maxstack = 32;
        this.hasOwnRenderer = true;
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:sand1";
        }
        if (i == 1) {
            return "DangerZone:sand2";
        }
        return "DangerZone:sand3";
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        float brw = this.blockrenderwidth / 2.0f;
        st = VBODataBuilderThread.findVBOtextureforblockside(0, bid);
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v != null) {
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(-brw + (float)xo, -brw + (float)yo, brw + (float)zo, st.xoffsetmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
            v.addVertexInfoToVBO(brw + (float)xo, -brw + (float)yo, -brw + (float)zo, st.xoffsetmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        }
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)this.myrenderid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(this.blockrenderwidth / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f), (float)(-this.blockrenderwidth / 2.0f));
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glCallList((int)this.myrenderid);
    }
}

