/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.StitchedTexture;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import org.newdawn.slick.opengl.Texture;

public class RoachBlock
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tside = null;
    String topname;
    String bottomname;
    String sidename;
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stside = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();

    public RoachBlock(String n, String top, String bottom, String side) {
        super(n, "");
        this.topname = top;
        this.bottomname = bottom;
        this.sidename = side;
        this.randomtick = true;
        this.isDirt = true;
        this.maxdamage = 10;
        this.burntime = 40;
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:dirt1";
        }
        if (i == 1) {
            return "DangerZone:dirt2";
        }
        return "DangerZone:dirt3";
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (Blocks.isSolid(w.getblock(d, x, y + 1, z))) {
            w.setblock(d, x, y, z, Blocks.dirt.blockID);
            return;
        }
        if (w.rand.nextInt(10) == 1) {
            int howmany = w.rand.nextInt(6) + 1;
            int i = 0;
            while (i < howmany) {
                Entity eb = w.createEntityByName("DangerZone:Cockroach", d, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5);
                if (eb != null) {
                    eb.init();
                    w.spawnEntityInWorld(eb);
                }
                ++i;
            }
        }
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tside == null) {
            this.tside = this.initBlockTexture(this.sidename);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        return this.tside;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        return this.stside;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        return this.sidename;
    }
}

