/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.StitchedTexture;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlock;
import dangerzone.entities.EntityBlockItem;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class PuddleMaker
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tleft = null;
    String topname;
    String bottomname;
    String leftname;
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture stleft = new StitchedTexture();

    public PuddleMaker(String n, String txttop, String txt2, String txt3) {
        super(n, "");
        this.isStone = true;
        this.maxdamage = 20;
        this.mindamage = 10;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.topname = txttop;
        this.bottomname = txt3;
        this.leftname = txt2;
        this.alwaystick = true;
        this.showTop = true;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        boolean spout = false;
        int bidtospout = Blocks.water.blockID;
        if (Blocks.isLiquid(w.getblock(d, x + 1, y, z))) {
            bidtospout = w.getblock(d, x + 1, y, z);
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x - 1, y, z))) {
            bidtospout = w.getblock(d, x - 1, y, z);
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y, z + 1))) {
            bidtospout = w.getblock(d, x, y, z + 1);
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y, z - 1))) {
            bidtospout = w.getblock(d, x, y, z - 1);
            spout = true;
        }
        if (Blocks.isLiquid(w.getblock(d, x, y - 1, z))) {
            bidtospout = w.getblock(d, x, y - 1, z);
            spout = true;
        }
        if (spout) {
            EntityBlockItem e;
            int meta = 1 + w.rand.nextInt(15);
            EntityBlock eb = (EntityBlock)w.createEntityByName("DangerZone:EntityBlock", d, (double)x + 0.5, (double)y + 1.25, (double)z + 0.5);
            if (eb != null) {
                eb.init();
                eb.setBID(bidtospout);
                eb.setIID(meta);
                eb.motiony = 1.25f + DangerZone.rand.nextFloat() / 2.0f;
                eb.motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 1.75f;
                eb.motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 1.75f;
                w.spawnEntityInWorld(eb);
            }
            int howmany = 10 + w.rand.nextInt(10);
            Utils.spawnParticlesFromServer(w, "DangerZone:ParticleWaterSpout", howmany, d, (double)x + 0.5, (double)y + (double)1.1f, (double)z + 0.5);
            w.playSound("DangerZone:bow", d, x, y, z, 0.5f, 0.75f);
            if (w.rand.nextInt(500) == 1 && (e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + (double)1.1f, (double)z + 0.5)) != null) {
                e.setBID(0);
                e.setIID(Items.fishmeat.itemID);
                e.rotation_pitch = w.rand.nextInt(360);
                e.rotation_yaw = w.rand.nextInt(360);
                e.rotation_roll = w.rand.nextInt(360);
                e.motiony = 0.75f + DangerZone.rand.nextFloat() / 4.0f;
                e.motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.02f;
                e.motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.02f;
                w.spawnEntityInWorld(e);
            }
        }
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tleft == null) {
            this.tleft = this.initBlockTexture(this.leftname);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        if (side == 3) {
            return this.tleft;
        }
        if (side == 4) {
            return this.tleft;
        }
        if (side == 1) {
            return this.tleft;
        }
        if (side == 2) {
            return this.tleft;
        }
        return null;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        if (side == 3) {
            return this.stleft;
        }
        if (side == 4) {
            return this.stleft;
        }
        if (side == 1) {
            return this.stleft;
        }
        return this.stleft;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        if (side == 3) {
            return this.leftname;
        }
        if (side == 4) {
            return this.leftname;
        }
        if (side == 1) {
            return this.leftname;
        }
        return this.leftname;
    }
}

