/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.StitchedTexture;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityExp;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class BlockWaterPump
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tleft = null;
    Texture tfront = null;
    String topname;
    String bottomname;
    String leftname;
    String frontname;
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture stleft = new StitchedTexture();
    StitchedTexture stfront = new StitchedTexture();

    public BlockWaterPump(String n) {
        super(n, "");
        this.isStone = true;
        this.maxdamage = 20;
        this.mindamage = 10;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.topname = "res/blocks/waterpumptop.png";
        this.bottomname = "res/blocks/waterpump.png";
        this.leftname = "res/blocks/waterpumpleftright.png";
        this.frontname = "res/blocks/waterspoutside.png";
        this.alwaystick = true;
        this.hasFront = true;
        this.showTop = true;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        int meta = w.getblockmeta(d, x, y, z);
        meta &= 0x3000;
        int bid = w.getblock(d, x, y - 1, z);
        if (Blocks.isLiquid(bid) && this.fillit(w, d, x, y + 1, z, bid)) {
            this.move_things(d, x, y, z, 0, 1, 0);
        }
        if (meta == 0 && Blocks.isLiquid(bid = w.getblock(d, x, y, z + 1)) && this.fillit(w, d, x, y, z - 1, bid)) {
            this.move_things(d, x, y, z, 0, 0, -1);
        }
        if (meta == 4096 && Blocks.isLiquid(bid = w.getblock(d, x + 1, y, z)) && this.fillit(w, d, x - 1, y, z, bid)) {
            this.move_things(d, x, y, z, -1, 0, 0);
        }
        if (meta == 8192 && Blocks.isLiquid(bid = w.getblock(d, x, y, z - 1)) && this.fillit(w, d, x, y, z + 1, bid)) {
            this.move_things(d, x, y, z, 0, 0, 1);
        }
        if (meta == 12288 && Blocks.isLiquid(bid = w.getblock(d, x - 1, y, z)) && this.fillit(w, d, x + 1, y, z, bid)) {
            this.move_things(d, x, y, z, 1, 0, 0);
        }
    }

    public boolean fillit(World w, int d, int x, int y, int z, int lib) {
        int bid = w.getblock(d, x, y, z);
        if (bid == 0 || Blocks.isLiquid(bid) || Blocks.isLeaves(bid)) {
            int bidtoset = Blocks.getActiveBlockid(lib);
            if (bidtoset == 0) {
                bidtoset = lib;
            }
            w.setblockandmeta(d, x, y, z, bidtoset, 1);
            return true;
        }
        return false;
    }

    public void move_things(int dimension, double posx, double posy, double posz, int xdir, int ydir, int zdir) {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(2.0f, dimension, posx - (double)xdir + 0.5, posy - (double)ydir + 0.5, posz - (double)zdir + 0.5);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                double dist = e.getDistanceFromEntityCenter(posx - (double)xdir + 0.5, posy - (double)ydir + 0.5, posz - (double)zdir + 0.5);
                if (!((dist -= (double)e.getWidth()) < 1.0) || !this.isSuitableTarget(e)) continue;
                e.posx = posx + (double)xdir + 0.5;
                e.posy = posy + (double)ydir + 0.5;
                e.posz = posz + (double)zdir + 0.5;
            }
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (e instanceof EntityExp) {
            return true;
        }
        return e instanceof EntityBlockItem;
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tleft == null) {
            this.tleft = this.initBlockTexture(this.leftname);
        }
        if (this.tfront == null) {
            this.tfront = this.initBlockTexture(this.frontname);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        if (side == 3) {
            return this.tleft;
        }
        if (side == 4) {
            return this.tleft;
        }
        if (side == 1) {
            return this.tfront;
        }
        if (side == 2) {
            return this.tbottom;
        }
        return null;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        if (side == 3) {
            return this.stleft;
        }
        if (side == 4) {
            return this.stleft;
        }
        if (side == 1) {
            return this.stfront;
        }
        return this.stbottom;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        if (side == 3) {
            return this.leftname;
        }
        if (side == 4) {
            return this.leftname;
        }
        if (side == 1) {
            return this.frontname;
        }
        return this.bottomname;
    }
}

