/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.entities.Entity;
import dangerzone.entities.EntitySpawner;
import dangerzone.gui.InventoryMenus;
import java.util.List;
import java.util.ListIterator;

public class BlockSpawner
extends Block {
    String critter;
    float scale = 1.0f;
    int spawntime = 100;
    int spawncount = 1;
    float minlight = 0.0f;
    float maxlight = 1.0f;

    public BlockSpawner(String n, String tospawn, float sz, int sptime, int scount, float mnlight, float mxlight) {
        super(n, "res/blocks/spawner.png");
        this.critter = tospawn;
        this.scale = sz;
        this.isSolidForRendering = false;
        this.isStone = true;
        this.renderAllSides = true;
        this.renderSmaller = true;
        this.breaksound = "DangerZone:stonebreak";
        this.placesound = "DangerZone:stoneplace";
        this.hitsound = "DangerZone:stonehit";
        this.alwaystick = true;
        this.maxdamage = 300;
        this.mindamage = 20;
        this.maxstack = 8;
        this.spawntime = sptime;
        this.spawncount = scount;
        this.minlight = mnlight;
        this.maxlight = mxlight;
        this.menu = InventoryMenus.SPAWNER;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        Entity eb;
        if (!w.isServer) {
            return;
        }
        List<Entity> nearby_list = null;
        EntitySpawner ec = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(2.0f, d, x, y, z);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof EntitySpawner) || (int)e.posx != x || (int)e.posy != y || (int)e.posz != z) continue;
                ec = (EntitySpawner)e;
                break;
            }
        }
        if (ec == null && (eb = w.createEntityByName("DangerZone:EntitySpawner", d, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5)) != null) {
            eb.init();
            eb.setVarString(0, this.critter);
            eb.setBID(this.blockID);
            eb.setVarFloat(0, this.scale);
            eb.setVarFloat(1, this.minlight);
            eb.setVarFloat(2, this.maxlight);
            eb.setVarInt(0, this.spawntime);
            eb.setVarInt(1, this.spawncount);
            w.spawnEntityInWorld(eb);
        }
    }

    @Override
    public void onBlockPlaced(World w, int dimension, int x, int y, int z) {
        Entity eb;
        if (!w.isServer && (eb = w.createEntityByName("DangerZone:EntitySpawner", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5)) != null) {
            eb.init();
            eb.setVarString(0, this.critter);
            eb.setBID(this.blockID);
            eb.setVarFloat(0, this.scale);
            eb.setVarFloat(1, this.minlight);
            eb.setVarFloat(2, this.maxlight);
            eb.setVarInt(0, this.spawntime);
            eb.setVarInt(1, this.spawncount);
            w.spawnEntityInWorld(eb);
        }
    }
}

