/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.Player;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;

public class BlockLiquidStatic
extends Block {
    public BlockLiquidStatic(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.isTranslucent = true;
        this.friction = 0.1f;
        this.maxdamage = 2;
        this.maxstack = 16;
        this.showInInventory = false;
        this.isLiquid = true;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        boolean change = false;
        if (w.isServer) {
            int i = -1;
            while (i <= 1) {
                int j = 0;
                while (j >= -1) {
                    int k = -1;
                    while (k <= 1) {
                        int bid = w.getblock(d, x + i, y + j, z + k);
                        if (bid == 0) {
                            change = true;
                        } else if (bid == Blocks.getActiveBlockid(this.blockID)) {
                            if (w.getblockmeta(d, x + i, y + j, z + k) != 0) {
                                change = true;
                            }
                        } else if (bid != this.blockID && Blocks.isLeaves(bid)) {
                            change = true;
                        }
                        ++k;
                    }
                    --j;
                }
                ++i;
            }
            if (change) {
                w.setblockandmeta(d, x, y, z, Blocks.getActiveBlockid(this.blockID), 0);
            }
        }
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }
}

