/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityExplosiveBlock;
import java.util.List;
import java.util.ListIterator;

public class BlockInstability
extends Block {
    public BlockInstability(String n, String txt, int hardness) {
        super(n, txt);
        this.maxdamage = hardness;
        this.mindamage = 5;
        this.isSolidForRendering = false;
        this.breaksound = "DangerZone:crystalblockbreak";
        this.placesound = "DangerZone:crystalblockplace";
        this.hitsound = "DangerZone:crystalblockhit";
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return;
        }
        if (!Blocks.isSolid(w.getblock(d, x, y - 1, z)) || this.isExplosionAround(w, d, x, y, z)) {
            int meta = w.getblockmeta(d, x, y, z);
            EntityExplosiveBlock eb = (EntityExplosiveBlock)w.createEntityByName("DangerZone:EntityExplosiveBlock", d, (double)x + 0.5 + (double)((w.rand.nextFloat() - w.rand.nextFloat()) * 0.01f), y, (double)z + 0.5 + (double)((w.rand.nextFloat() - w.rand.nextFloat()) * 0.01f));
            if (eb != null) {
                eb.init();
                w.setblock(d, x, y, z, 0);
                eb.rotation_roll = 0.0f;
                eb.rotation_yaw = 0.0f;
                eb.rotation_pitch = 0.0f;
                eb.rotation_roll_motion = 0.0f;
                eb.rotation_yaw_motion = 0.0f;
                eb.rotation_pitch_motion = 0.0f;
                eb.setBID(this.blockID);
                eb.setIID(meta);
                eb.setAttackDamage(this.maxdamage);
                w.spawnEntityInWorld(eb);
            }
        }
    }

    public boolean isExplosionAround(World w, int d, int x, int y, int z) {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(3.5f, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof EntityExplosiveBlock)) continue;
                return true;
            }
        }
        return false;
    }
}

