/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.threads.FastBlockTicker;
import dangerzone.threads.VBODataBuilderThread;
import java.util.List;
import java.util.ListIterator;
import org.lwjgl.opengl.GL11;

public class BlockBarrier
extends Block {
    private boolean compiled = false;
    private int myrenderid = 0;
    private float blockrenderwidth = 16.0f;

    public BlockBarrier(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = true;
        this.hasOwnRenderer = true;
        this.renderAllSides = true;
        this.renderSmaller = true;
        this.alwaystick = true;
        this.maxdamage = 10;
        this.burntime = 30;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid;
        if (w.isServer && !Blocks.isSolid(bid = w.getblock(d, x, y - 1, z))) {
            w.setblock(d, x, y, z, 0);
        }
    }

    @Override
    public void tickMeFast(World w, int d, int x, int y, int z) {
        this.tickMe(w, d, x, y, z);
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        if (w.isServer) {
            int bid = w.getblock(d, x, y - 1, z);
            if (!Blocks.isSolid(bid)) {
                w.setblock(d, x, y, z, 0);
                return;
            }
            if (bid == Blocks.autofence.blockID) {
                return;
            }
            FastBlockTicker.addFastTick(d, x, y, z, 2);
            List<Entity> nearby_list = null;
            Entity e = null;
            int maxh = 0;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    Player p;
                    InventoryContainer ic;
                    float dist;
                    e = li.next();
                    if (!(e instanceof EntityLiving)) continue;
                    if (maxh < 2) {
                        maxh = 2;
                    }
                    if (e.getHeight() * 2.0f + 0.9f > (float)maxh) {
                        maxh = (int)(e.getHeight() * 2.0f + 0.9f);
                    }
                    if (!(e instanceof Player) || !((double)(dist = (float)Math.sqrt((e.posx - ((double)x + 0.5)) * (e.posx - ((double)x + 0.5)) + (e.posz - ((double)z + 0.5)) * (e.posz - ((double)z + 0.5)))) < 1.5) || (ic = (p = (Player)e).getHotbar(p.gethotbarindex())) == null || ic.iid != Items.autofencekey.itemID) continue;
                    maxh = 0;
                    break;
                }
            }
            if (maxh > 1) {
                int i = 1;
                while (i < maxh) {
                    if (w.getblock(d, x, y + i, z) == 0) {
                        w.setblock(d, x, y + i, z, this.blockID);
                    }
                    ++i;
                }
                w.setblockandmeta(d, x, y, z, this.blockID, 1);
                if (w.rand.nextInt(1000) == 1) {
                    w.playSound("DangerZone:arc", d, x, y, z, 0.1f, 1.0f);
                }
            } else {
                if (w.getblock(d, x, y + 1, z) == this.blockID) {
                    w.setblock(d, x, y + 1, z, 0);
                }
                w.setblockandmeta(d, x, y, z, this.blockID, 0);
            }
        }
    }

    @Override
    public float getBrightness(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid == Blocks.autofence.blockID) {
            return 0.45f;
        }
        if ((w.getblockmeta(d, x, y, z) & 1) != 1) {
            return 0.0f;
        }
        return 0.65f;
    }

    @Override
    public int getBlockDrop(Player p, World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid == this.blockID) {
            return 0;
        }
        return this.blockID;
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = VBODataBuilderThread.findVBOtextureforblockside(0, bid);
        v = VBODataBuilderThread.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        float brw = this.blockrenderwidth / 2.0f;
        float brwtb = this.blockrenderwidth / 8.0f;
        float pixdiff = (st.xoffsetmax - st.xoffsetmin) / 16.0f;
        float tudmin = st.xoffsetmin + pixdiff * 6.0f;
        float tudmax = tudmin + pixdiff * 4.0f;
        float tlrmin = st.yoffsetmin;
        float tlrmax = tlrmin + pixdiff * 4.0f;
        float brud = (brw -= 0.01f) - 6.0f;
        v.addVertexInfoToVBO((brwtb -= 0.01f) + (float)xo, brw + (float)yo, -brwtb + (float)zo, tudmax, tlrmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brwtb + (float)xo, brw + (float)yo, -brwtb + (float)zo, tudmin, tlrmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brwtb + (float)xo, brw + (float)yo, brwtb + (float)zo, tudmin, tlrmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brwtb + (float)xo, brw + (float)yo, brwtb + (float)zo, tudmax, tlrmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brwtb + (float)xo, -brw + (float)yo, brwtb + (float)zo, tudmax, tlrmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brwtb + (float)xo, -brw + (float)yo, brwtb + (float)zo, tudmin, tlrmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brwtb + (float)xo, -brw + (float)yo, -brwtb + (float)zo, tudmin, tlrmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brwtb + (float)xo, -brw + (float)yo, -brwtb + (float)zo, tudmax, tlrmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brud + (float)xo, brw + (float)yo, brud + (float)zo, tudmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brud + (float)xo, brw + (float)yo, brud + (float)zo, tudmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brud + (float)xo, -brw + (float)yo, brud + (float)zo, tudmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brud + (float)xo, -brw + (float)yo, brud + (float)zo, tudmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brud + (float)xo, brw + (float)yo, -brud + (float)zo, tudmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brud + (float)xo, brw + (float)yo, -brud + (float)zo, tudmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brud + (float)xo, -brw + (float)yo, -brud + (float)zo, tudmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brud + (float)xo, -brw + (float)yo, -brud + (float)zo, tudmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brud + (float)xo, brw + (float)yo, brud + (float)zo, tudmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brud + (float)xo, brw + (float)yo, -brud + (float)zo, tudmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brud + (float)xo, -brw + (float)yo, -brud + (float)zo, tudmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(-brud + (float)xo, -brw + (float)yo, brud + (float)zo, tudmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brud + (float)xo, brw + (float)yo, -brud + (float)zo, tudmax, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brud + (float)xo, brw + (float)yo, brud + (float)zo, tudmin, st.yoffsetmin, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brud + (float)xo, -brw + (float)yo, brud + (float)zo, tudmin, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
        v.addVertexInfoToVBO(brud + (float)xo, -brw + (float)yo, -brud + (float)zo, tudmax, st.yoffsetmax, VBODataBuilderThread.cbr, VBODataBuilderThread.cbg, VBODataBuilderThread.cbb);
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        if (!this.compiled) {
            float brw = this.blockrenderwidth / 2.0f;
            float brwtb = this.blockrenderwidth / 8.0f;
            float txmin = 0.375f;
            float txmax = 0.625f;
            float tymax = 0.25f;
            this.myrenderid = DangerZone.wr.getNextRenderID();
            GL11.glNewList((int)this.myrenderid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)txmax, (float)0.0f);
            GL11.glVertex3f((float)brwtb, (float)brw, (float)(-brwtb));
            GL11.glTexCoord2f((float)txmin, (float)0.0f);
            GL11.glVertex3f((float)(-brwtb), (float)brw, (float)(-brwtb));
            GL11.glTexCoord2f((float)txmin, (float)tymax);
            GL11.glVertex3f((float)(-brwtb), (float)brw, (float)brwtb);
            GL11.glTexCoord2f((float)txmax, (float)tymax);
            GL11.glVertex3f((float)brwtb, (float)brw, (float)brwtb);
            GL11.glTexCoord2f((float)txmax, (float)0.0f);
            GL11.glVertex3f((float)brwtb, (float)(-brw), (float)brwtb);
            GL11.glTexCoord2f((float)txmin, (float)0.0f);
            GL11.glVertex3f((float)(-brwtb), (float)(-brw), (float)brwtb);
            GL11.glTexCoord2f((float)txmin, (float)tymax);
            GL11.glVertex3f((float)(-brwtb), (float)(-brw), (float)(-brwtb));
            GL11.glTexCoord2f((float)txmax, (float)tymax);
            GL11.glVertex3f((float)brwtb, (float)(-brw), (float)(-brwtb));
            GL11.glTexCoord2f((float)txmax, (float)0.0f);
            GL11.glVertex3f((float)brwtb, (float)brw, (float)brwtb);
            GL11.glTexCoord2f((float)txmin, (float)0.0f);
            GL11.glVertex3f((float)(-brwtb), (float)brw, (float)brwtb);
            GL11.glTexCoord2f((float)txmin, (float)1.0f);
            GL11.glVertex3f((float)(-brwtb), (float)(-brw), (float)brwtb);
            GL11.glTexCoord2f((float)txmax, (float)1.0f);
            GL11.glVertex3f((float)brwtb, (float)(-brw), (float)brwtb);
            GL11.glTexCoord2f((float)txmax, (float)0.0f);
            GL11.glVertex3f((float)(-brwtb), (float)brw, (float)(-brwtb));
            GL11.glTexCoord2f((float)txmin, (float)0.0f);
            GL11.glVertex3f((float)brwtb, (float)brw, (float)(-brwtb));
            GL11.glTexCoord2f((float)txmin, (float)1.0f);
            GL11.glVertex3f((float)brwtb, (float)(-brw), (float)(-brwtb));
            GL11.glTexCoord2f((float)txmax, (float)1.0f);
            GL11.glVertex3f((float)(-brwtb), (float)(-brw), (float)(-brwtb));
            GL11.glTexCoord2f((float)txmax, (float)0.0f);
            GL11.glVertex3f((float)(-brwtb), (float)brw, (float)brwtb);
            GL11.glTexCoord2f((float)txmin, (float)0.0f);
            GL11.glVertex3f((float)(-brwtb), (float)brw, (float)(-brwtb));
            GL11.glTexCoord2f((float)txmin, (float)1.0f);
            GL11.glVertex3f((float)(-brwtb), (float)(-brw), (float)(-brwtb));
            GL11.glTexCoord2f((float)txmax, (float)1.0f);
            GL11.glVertex3f((float)(-brwtb), (float)(-brw), (float)brwtb);
            GL11.glTexCoord2f((float)txmax, (float)0.0f);
            GL11.glVertex3f((float)brwtb, (float)brw, (float)(-brwtb));
            GL11.glTexCoord2f((float)txmin, (float)0.0f);
            GL11.glVertex3f((float)brwtb, (float)brw, (float)brwtb);
            GL11.glTexCoord2f((float)txmin, (float)1.0f);
            GL11.glVertex3f((float)brwtb, (float)(-brw), (float)brwtb);
            GL11.glTexCoord2f((float)txmax, (float)1.0f);
            GL11.glVertex3f((float)brwtb, (float)(-brw), (float)(-brwtb));
            GL11.glEnd();
            GL11.glEndList();
            this.compiled = true;
        }
        wr.loadtextureforblockside(0, bid, false);
        GL11.glCallList((int)this.myrenderid);
    }
}

