/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.biomes;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.World;
import dangerzone.biomes.Biome;
import java.util.Random;

public class BiomeManager {
    public Biome[] biomes;
    public static final int max_biomes = 128;
    public Random rand = new Random();
    public int nregistered = 0;
    float[][] distsx = new float[16][16];
    float[][] distsz = new float[16][16];
    float[][] distsxz = new float[16][16];

    public BiomeManager() {
        this.biomes = new Biome[128];
        int i = 0;
        while (i < 128) {
            this.biomes[i] = null;
            ++i;
        }
        i = -8;
        while (i < 8) {
            int j = -8;
            while (j < 8) {
                float ti = (float)i + 0.5f;
                float tj = (float)j + 0.5f;
                this.distsxz[i + 8][j + 8] = (float)Math.sqrt(ti * ti + tj * tj);
                this.distsx[i + 8][j + 8] = (float)Math.sqrt(ti * ti);
                this.distsz[i + 8][j + 8] = (float)Math.sqrt(tj * tj);
                ++j;
            }
            ++i;
        }
    }

    public int registerBiome(Biome b) {
        int i = 0;
        while (i < 128) {
            if (this.biomes[i] == null) break;
            ++i;
        }
        if (i < 0 || i >= 128) {
            return -1;
        }
        this.biomes[i] = b;
        ++this.nregistered;
        return i;
    }

    public float getValueForChunk(long bioseed, int x, int y, int z) {
        float retval = 0.0f;
        int biomesizefactor = 7;
        int i = -biomesizefactor;
        while (i <= biomesizefactor) {
            int j = -biomesizefactor;
            while (j <= biomesizefactor) {
                this.rand.setSeed(bioseed * (long)((x >> 4) + i) * (long)((z >> 4) + j) + DangerZone.server_world.worldseed);
                retval += this.rand.nextFloat();
                ++j;
            }
            ++i;
        }
        return retval /= (float)((biomesizefactor * 2 + 1) * (biomesizefactor * 2 + 1));
    }

    public Biome getBiomeForChunk(Chunk c, int d, int x, int y, int z) {
        if (this.nregistered == 0) {
            return null;
        }
        if (this.nregistered == 1) {
            return this.biomes[0];
        }
        if (c != null && c.mybiome != null) {
            return c.mybiome;
        }
        Chunk t = null;
        if (c == null && (t = DangerZone.server_chunk_cache.getChunk(null, d, x, y, z)) != null && t.mybiome != null) {
            return t.mybiome;
        }
        int highest = 0;
        float highestval = -1.0f;
        float thisval = 0.0f;
        int i = 0;
        while (i < this.nregistered) {
            thisval = this.getValueForChunk(this.biomes[i].bioRand, x, y, z) * this.biomes[i].rarityFactor;
            if (thisval > highestval) {
                highest = i;
                highestval = thisval;
            }
            ++i;
        }
        if (c != null) {
            c.mybiome = this.biomes[highest];
        }
        if (t != null) {
            t.mybiome = this.biomes[highest];
        }
        return this.biomes[highest];
    }

    public void generate(World w, int d, Biome b, Chunk c, int cx, int cz) {
        int[][] dirtlevelmap = new int[16][16];
        int[][] stonelevelmap = new int[16][16];
        int[][] bottomlevelmap = new int[16][16];
        if (this.nregistered == 1) {
            b.generateheightmaps(w, d, c, cx, cz, dirtlevelmap, stonelevelmap, bottomlevelmap);
            b.generate(w, d, c, cx, cz, dirtlevelmap, stonelevelmap, bottomlevelmap);
            return;
        }
        b.generateheightmaps(w, d, c, cx, cz, dirtlevelmap, stonelevelmap, bottomlevelmap);
        int mergedist = 1;
        int i = -mergedist;
        while (i <= mergedist) {
            int j = -mergedist;
            while (j <= mergedist) {
                if (i != 0 || j != 0) {
                    Biome tb = w.getBiome(d, cx + i << 4, 0, cz + j << 4);
                    if (!tb.uniquename.equals(b.uniquename)) {
                        float u;
                        float t;
                        int jj;
                        int ii;
                        int[][] tdirt = new int[16][16];
                        int[][] tstone = new int[16][16];
                        int[][] tbot = new int[16][16];
                        float maxdist = 32.0f;
                        tb.generateheightmaps(w, d, c, cx, cz, tdirt, tstone, tbot);
                        int istart = 0;
                        int jstart = 0;
                        int iend = 16;
                        int jend = 16;
                        if (i == 0) {
                            if (j > 0) {
                                jstart = 8;
                            }
                            if (j < 0) {
                                jend = 8;
                            }
                            ii = 0;
                            while (ii < 16) {
                                jj = jstart;
                                while (jj < jend) {
                                    t = dirtlevelmap[ii][jj];
                                    u = tdirt[ii][jj];
                                    t *= (maxdist - this.distsz[ii][jj]) / maxdist;
                                    dirtlevelmap[ii][jj] = (int)(t += u * this.distsz[ii][jj] / maxdist);
                                    if (t - (float)((int)t) > 0.99f) {
                                        int[] nArray = dirtlevelmap[ii];
                                        int n = jj;
                                        nArray[n] = nArray[n] + 1;
                                    }
                                    t = stonelevelmap[ii][jj];
                                    u = tstone[ii][jj];
                                    t *= (maxdist - this.distsz[ii][jj]) / maxdist;
                                    stonelevelmap[ii][jj] = (int)(t += u * this.distsz[ii][jj] / maxdist);
                                    if (t - (float)((int)t) > 0.99f) {
                                        int[] nArray = stonelevelmap[ii];
                                        int n = jj;
                                        nArray[n] = nArray[n] + 1;
                                    }
                                    t = bottomlevelmap[ii][jj];
                                    u = tbot[ii][jj];
                                    t *= (maxdist - this.distsz[ii][jj]) / maxdist;
                                    bottomlevelmap[ii][jj] = (int)(t += u * this.distsz[ii][jj] / maxdist);
                                    ++jj;
                                }
                                ++ii;
                            }
                        } else if (j == 0) {
                            if (i > 0) {
                                istart = 8;
                            }
                            if (i < 0) {
                                iend = 8;
                            }
                            ii = istart;
                            while (ii < iend) {
                                jj = 0;
                                while (jj < 16) {
                                    t = dirtlevelmap[ii][jj];
                                    u = tdirt[ii][jj];
                                    t *= (maxdist - this.distsx[ii][jj]) / maxdist;
                                    dirtlevelmap[ii][jj] = (int)(t += u * this.distsx[ii][jj] / maxdist);
                                    if (t - (float)((int)t) > 0.99f) {
                                        int[] nArray = dirtlevelmap[ii];
                                        int n = jj;
                                        nArray[n] = nArray[n] + 1;
                                    }
                                    t = stonelevelmap[ii][jj];
                                    u = tstone[ii][jj];
                                    t *= (maxdist - this.distsx[ii][jj]) / maxdist;
                                    stonelevelmap[ii][jj] = (int)(t += u * this.distsx[ii][jj] / maxdist);
                                    if (t - (float)((int)t) > 0.99f) {
                                        int[] nArray = stonelevelmap[ii];
                                        int n = jj;
                                        nArray[n] = nArray[n] + 1;
                                    }
                                    t = bottomlevelmap[ii][jj];
                                    u = tbot[ii][jj];
                                    t *= (maxdist - this.distsx[ii][jj]) / maxdist;
                                    bottomlevelmap[ii][jj] = (int)(t += u * this.distsx[ii][jj] / maxdist);
                                    ++jj;
                                }
                                ++ii;
                            }
                        } else {
                            if (i < 0) {
                                istart = 0;
                                iend = 8;
                            } else {
                                istart = 8;
                                iend = 16;
                            }
                            if (j < 0) {
                                jstart = 0;
                                jend = 8;
                            } else {
                                jstart = 8;
                                jend = 16;
                            }
                            maxdist = 50.0f;
                            ii = istart;
                            while (ii < iend) {
                                jj = jstart;
                                while (jj < jend) {
                                    t = dirtlevelmap[ii][jj];
                                    u = tdirt[ii][jj];
                                    t *= (maxdist - this.distsxz[ii][jj]) / maxdist;
                                    dirtlevelmap[ii][jj] = (int)(t += u * this.distsxz[ii][jj] / maxdist);
                                    if (t - (float)((int)t) > 0.99f) {
                                        int[] nArray = dirtlevelmap[ii];
                                        int n = jj;
                                        nArray[n] = nArray[n] + 1;
                                    }
                                    t = stonelevelmap[ii][jj];
                                    u = tstone[ii][jj];
                                    t *= (maxdist - this.distsxz[ii][jj]) / maxdist;
                                    stonelevelmap[ii][jj] = (int)(t += u * this.distsxz[ii][jj] / maxdist);
                                    if (t - (float)((int)t) > 0.99f) {
                                        int[] nArray = stonelevelmap[ii];
                                        int n = jj;
                                        nArray[n] = nArray[n] + 1;
                                    }
                                    t = bottomlevelmap[ii][jj];
                                    u = tbot[ii][jj];
                                    t *= (maxdist - this.distsxz[ii][jj]) / maxdist;
                                    bottomlevelmap[ii][jj] = (int)(t += u * this.distsxz[ii][jj] / maxdist);
                                    ++jj;
                                }
                                ++ii;
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        b.generate(w, d, c, cx, cz, dirtlevelmap, stonelevelmap, bottomlevelmap);
    }
}

