/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.Chunk;
import dangerzone.ChunkCache;
import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.ServerChunkCache;
import dangerzone.WorldDecorators;
import dangerzone.biomes.Biome;
import dangerzone.biomes.BiomeManager;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.particles.Particle;
import dangerzone.particles.Particles;
import dangerzone.threads.NotifyBlockTicker;
import java.util.Random;

public class World {
    public ChunkCache chunkcache = null;
    public ServerChunkCache serverchunkcache = null;
    public Random rand;
    public boolean isServer = false;
    public int timetimer;
    public int lengthOfDay = 360;
    public long worldseed = 0L;

    public World(ChunkCache c, ServerChunkCache s) {
        this.chunkcache = c;
        this.serverchunkcache = s;
        this.rand = new Random(System.currentTimeMillis());
        this.isServer = false;
        this.timetimer = 0;
    }

    public Biome getBiome(int d, int x, int y, int z) {
        if (!this.isServer) {
            return null;
        }
        if (Dimensions.getBiomeManager(d) == null) {
            return null;
        }
        Chunk t = DangerZone.server_chunk_cache.getChunk(this, d, x, y, z);
        if (t != null && t.mybiome != null) {
            return t.mybiome;
        }
        return Dimensions.getBiomeManager(d).getBiomeForChunk(t, d, x, y, z);
    }

    public BiomeManager getBiomeManager(int d, int x, int y, int z) {
        if (!this.isServer) {
            return null;
        }
        return Dimensions.getBiomeManager(d);
    }

    public int getblock(int d, int x, int y, int z) {
        if (this.isServer) {
            return this.serverchunkcache.getBlock(this, d, x, y, z);
        }
        return this.chunkcache.getBlock(this, d, x, y, z);
    }

    public int getblockmeta(int d, int x, int y, int z) {
        if (this.isServer) {
            return this.serverchunkcache.getBlockmeta(this, d, x, y, z);
        }
        return this.chunkcache.getBlockmeta(this, d, x, y, z);
    }

    public void setblock(int d, int x, int y, int z, int id) {
        if (this.isServer) {
            this.serverchunkcache.setBlock(this, d, x, y, z, id, 0);
            if (this.serverchunkcache.isDecorated(d, x, y, z)) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, 0);
            if (DangerZone.start_server) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        }
    }

    public void setblockandmeta(int d, int x, int y, int z, int id, int meta) {
        if (this.isServer) {
            this.serverchunkcache.setBlock(this, d, x, y, z, id, meta);
            if (this.serverchunkcache.isDecorated(d, x, y, z)) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, meta);
            if (DangerZone.start_server) {
                NotifyBlockTicker.addNotifyBlocksAround(d, x, y, z);
            }
        }
    }

    public void setblocknonotify(int d, int x, int y, int z, int id) {
        if (this.isServer) {
            this.serverchunkcache.setBlock(this, d, x, y, z, id, 0);
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, 0);
        }
    }

    public void setblockandmetanonotify(int d, int x, int y, int z, int id, int meta) {
        if (this.isServer) {
            this.serverchunkcache.setBlock(this, d, x, y, z, id, meta);
        } else {
            this.chunkcache.setBlock(this, d, x, y, z, id, meta);
        }
    }

    public void decorate(World world, int dimension, Biome b, int chunkx, int chunkz) {
        if (!this.isServer) {
            return;
        }
        int i = 0;
        while (i < 64) {
            if (WorldDecorators.WorldDecoratorArray[i] == null) break;
            WorldDecorators.WorldDecoratorArray[i].decorate(world, dimension, b, chunkx, chunkz);
            ++i;
        }
    }

    public Entity createEntityByName(String name, int dimension, double x, double y, double z) {
        Entity e = Entities.spawnEntityByName(name, this);
        if (e == null) {
            return null;
        }
        e.dimension = dimension;
        e.posx = x;
        e.posy = y;
        e.posz = z;
        e.rotation_yaw = e.rotation_yaw_head = (float)this.rand.nextInt(360);
        return e;
    }

    public void spawnEntityInWorld(Entity e) {
        if (this.isServer) {
            if (DangerZone.server.entityManager.addEntity(e) > 0) {
                DangerZone.server.sendSpawnEntityToAll(e);
            }
        } else {
            DangerZone.server_connection.spawnEntity(e);
        }
    }

    public Particle createParticleByName(String name, int dimension, double x, double y, double z) {
        if (this.isServer) {
            return null;
        }
        Particle e = Particles.spawnParticleByName(name);
        if (e == null) {
            return null;
        }
        e.dimension = dimension;
        e.posx = x;
        e.posy = y;
        e.posz = z;
        return e;
    }

    public void spawnParticleInWorld(Particle e) {
        if (this.isServer) {
            return;
        }
        DangerZone.particleManager.addParticle(e);
    }

    public void playSound(String name, int dimension, double posx, double posy, double posz, float volume, float frequency) {
        if (name == null) {
            return;
        }
        if (name.equals("")) {
            return;
        }
        if (this.isServer) {
            DangerZone.server.sendSoundToAll(name, dimension, posx, posy, posz, volume, frequency);
        } else {
            DangerZone.server_connection.sendSound(name, dimension, posx, posy, posz, volume, frequency);
            DangerZone.soundmangler.playSound(name, volume, frequency, dimension, posx, posy, posz);
        }
    }

    public void playSoundCloseClient(String name, int dimension, double posx, double posy, double posz, float volume, float frequency) {
        if (name == null) {
            return;
        }
        if (name.equals("")) {
            return;
        }
        if (!this.isServer) {
            DangerZone.soundmangler.playSoundClose(name, volume, frequency, dimension, posx, posy, posz);
        }
    }

    public boolean isDaytime() {
        return this.timetimer < this.lengthOfDay / 2;
    }

    public int getTimeOfDay() {
        return this.timetimer;
    }

    public int getLengthOfDay() {
        return this.lengthOfDay;
    }
}

