/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.util.ResourceLoader;

public class SoundManager {
    Map<String, Soundinfo> soundmap = new HashMap<String, Soundinfo>();
    public int master_volume = 10;
    public int music_master_volume = 10;
    private Audio currentsong = null;
    private static long lasttime = 0L;

    public SoundManager() {
        lasttime = System.currentTimeMillis();
        lasttime -= 600000L;
    }

    public void playMusic() {
        long curtime = System.currentTimeMillis();
        if ((curtime -= lasttime) > 900000L && this.music_master_volume > 0 && (this.currentsong == null || this.currentsong != null && !this.currentsong.isPlaying())) {
            lasttime = System.currentTimeMillis();
            try {
                String newfile = this.getRandomMusicFile();
                if (newfile == null) {
                    return;
                }
                this.currentsong = AudioLoader.getAudio((String)"WAV", (InputStream)ResourceLoader.getResourceAsStream((String)("res/music/" + newfile)));
            }
            catch (IOException e) {
                return;
            }
            float mx = this.music_master_volume;
            this.currentsong.playAsMusic(1.0f, 0.125f, false);
            DangerZone.setMusicVolume(mx /= 10.0f);
        }
    }

    public void playThisMusic(String songname) {
        if (songname == null) {
            return;
        }
        if (this.music_master_volume > 0 && (this.currentsong == null || this.currentsong != null && !this.currentsong.isPlaying())) {
            lasttime = System.currentTimeMillis();
            try {
                this.currentsong = AudioLoader.getAudio((String)"WAV", (InputStream)ResourceLoader.getResourceAsStream((String)("res/music/" + songname)));
            }
            catch (IOException e) {
                return;
            }
            float mx = this.music_master_volume;
            this.currentsong.playAsMusic(1.0f, 0.125f, false);
            DangerZone.setMusicVolume(mx /= 10.0f);
        }
    }

    public void setMusicVolume() {
        if (this.currentsong != null && this.currentsong.isPlaying()) {
            float mx = this.music_master_volume;
            DangerZone.setMusicVolume(mx /= 10.0f);
        }
    }

    public void registerSound(String soundname, String filepath) {
        this.soundmap.put(soundname, new Soundinfo(filepath));
    }

    public void playSound(String soundname, float vol, float freq, int d, double px, double py, double pz) {
        Soundinfo s = this.soundmap.get(soundname);
        if (s != null && !s.equals("")) {
            if (s.sound == null) {
                try {
                    s.sound = AudioLoader.getAudio((String)"WAV", (InputStream)ResourceLoader.getResourceAsStream((String)s.filepath));
                }
                catch (Exception e) {
                    System.out.printf("Failed to load sound file: %s\n", s.filepath);
                    e.printStackTrace();
                    s.sound = null;
                    this.soundmap.remove(soundname);
                }
            }
            if (s.sound != null && this.master_volume > 0 && DangerZone.start_client && d == DangerZone.player.dimension) {
                double mx = DangerZone.player.getDistanceFromEntityCenter(px, py, pz);
                float mv = this.master_volume;
                mv /= 10.0f;
                if ((mx -= 1.0) < 1.0) {
                    mx = 1.0;
                }
                mx /= 8.0;
                if ((mx *= mx) < 1.0) {
                    mx = 1.0;
                }
                if (mx < 256.0) {
                    mx = (double)vol / mx;
                    if ((mx *= (double)mv) > 0.0125) {
                        try {
                            s.sound.playAsSoundEffect(freq, (float)mx, false);
                        }
                        catch (Exception e) {
                            System.out.printf("Sound broke again...\n", new Object[0]);
                        }
                    }
                }
            }
        }
    }

    public void playSoundClose(String soundname, float vol, float freq, int d, double px, double py, double pz) {
        Soundinfo s = this.soundmap.get(soundname);
        if (s != null && !s.equals("")) {
            if (s.sound == null) {
                try {
                    s.sound = AudioLoader.getAudio((String)"WAV", (InputStream)ResourceLoader.getResourceAsStream((String)s.filepath));
                }
                catch (Exception e) {
                    System.out.printf("Failed to load sound file: %s\n", s.filepath);
                    e.printStackTrace();
                    s.sound = null;
                    this.soundmap.remove(soundname);
                }
            }
            if (s.sound != null && this.master_volume > 0 && DangerZone.start_client && d == DangerZone.player.dimension) {
                double mx = DangerZone.player.getDistanceFromEntityCenter(px, py, pz);
                float mv = this.master_volume;
                mv /= 10.0f;
                if ((mx -= 2.0) < 1.0) {
                    mx = 1.0;
                }
                if ((mx *= mx) < 1.0) {
                    mx = 1.0;
                }
                if (mx < 256.0) {
                    mx = (double)vol / mx;
                    if ((mx *= (double)mv) > 0.0125) {
                        try {
                            s.sound.playAsSoundEffect(freq, (float)mx, false);
                        }
                        catch (Exception e) {
                            System.out.printf("Sound broke again...\n", new Object[0]);
                        }
                    }
                }
            }
        }
    }

    public String getRandomMusicFile() {
        long curtime = System.currentTimeMillis();
        Random rand = new Random(curtime);
        String newsong = String.format("song%d.wav", rand.nextInt(12) + 1);
        return newsong;
    }

    private class Soundinfo {
        public String filepath;
        public Audio sound;

        Soundinfo(String f) {
            this.filepath = f;
            this.sound = null;
        }
    }
}

