/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.DangerZoneBase;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSword;
import dangerzone.items.Items;
import dangerzone.threads.LightingThread;
import dangerzone.threads.ServerConnection;
import dangerzone.threads.ServerThread;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class Player
extends EntityLiving {
    public Socket toServer;
    public Socket toClient;
    public ServerThread server_thread;
    public ServerConnection server_connection;
    public float armangle = 0.0f;
    public int armdir = 0;
    public byte[] tdata = null;
    public boolean donewtexture = false;
    public String myname = null;
    public int starthealth = 50;
    public int swimdelay = 0;
    public int lightupdatecounter = 0;
    public int inventoryticker = 0;
    public int player_privs = 0;
    public Entity morph = null;
    public Entity morphto = null;
    public boolean do_morph;
    public float morphspeed = -0.01f;
    public float morphscale = 1.0f;

    public Player(World w) {
        super(w);
        this.width = 0.65f;
        this.height = 1.75f;
        this.eyeheight = 1.65f;
        this.uniquename = "DangerZone:Player";
        this.has_inventory = true;
        this.setMaxHealth(this.starthealth);
        this.setHealth(this.starthealth);
        this.setDefense(1.0f);
        this.setMaxHunger(50.0f);
        this.setHunger(50.0f);
        this.setAttackDamage(1.0f);
        this.setMaxAir(50.0f);
        this.setAir(50.0f);
        this.setCanDespawn(false);
    }

    @Override
    public void init() {
        super.init();
        this.eyeheight = 0.943f * this.getHeight();
        this.setSitting(false);
        this.morph = null;
        this.morphto = null;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (this.getGameMode() != 0) {
            return;
        }
        if (!this.world.isServer) {
            if (!this.takesDamageFrom(dt)) {
                return;
            }
            this.setHealth(this.getHealth() - pain);
            float sf = this.getHeight() * this.getWidth() / 3.0f;
            if (sf < 0.15f) {
                sf = 0.15f;
            }
            if (sf > 5.0f) {
                sf = 5.0f;
            }
            double dir = this.world.rand.nextDouble() * Math.PI * 2.0;
            this.motionx = (float)((double)this.motionx + Math.cos(dir) * (double)sf);
            this.motionz = (float)((double)this.motionz + Math.sin(dir) * (double)sf);
            this.motiony += 0.25f * sf;
            if (this.getHealth() > 0.0f) {
                this.world.playSound(this.getHurtSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
            } else {
                this.world.playSound(this.getDeathSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.1f);
                this.doDeathDrops();
                this.deadflag = true;
                this.onDeath();
                this.removeAllEffects();
            }
        } else {
            super.doAttackFrom(e, dt, pain);
        }
    }

    @Override
    public void doEntityAction(float deltaT) {
    }

    @Override
    public String getHurtSound() {
        if (this.morph != null) {
            return this.morph.getHurtSound();
        }
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ouch1";
        }
        if (i == 1) {
            return "DangerZone:ouch2";
        }
        return "DangerZone:ouch3";
    }

    @Override
    public String getLivingSound() {
        if (this.morph != null) {
            return this.morph.getLivingSound();
        }
        return null;
    }

    @Override
    public float getScale() {
        if (this.do_morph) {
            return this.morphscale;
        }
        return super.getScale();
    }

    @Override
    public float getRightArmAngle() {
        return -this.armangle;
    }

    @Override
    public void update(float deltaT) {
        double pz;
        double py;
        double px;
        Entity tempent;
        this.stray_entity_ticker = 0;
        if (this.morph != null) {
            this.morph.posx = this.posx;
            this.morph.posy = this.posy;
            this.morph.posz = this.posz;
            this.morph.rotation_yaw = this.rotation_yaw;
            this.morph.rotation_pitch = this.rotation_pitch;
            this.morph.rotation_roll = this.rotation_roll;
            this.morph.rotation_yaw_head = this.rotation_yaw_head;
            this.morph.rotation_pitch_head = this.rotation_pitch_head;
            this.morph.rotation_roll_head = this.rotation_roll_head;
        }
        if (!this.world.isServer) {
            Entity e;
            if (this.getGameMode() != 2 && this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.02f, this.posz)) {
                if (this.isFlying()) {
                    this.setFlying(false);
                    Utils.spawnParticles(this.world, "DangerZone:ParticleBreak", 50, this.dimension, this.posx, this.posy, this.posz, this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)0.2f), (int)this.posz), true);
                    this.world.playSound(this.getHurtSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, 0.5f, 1.0f);
                }
                if (DangerZone.start_server && Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz) > 0.25 && this.world.rand.nextInt(3) == 1) {
                    Utils.spawnParticles(this.world, "DangerZone:ParticleBreak", 1, this.dimension, this.posx, this.posy, this.posz, this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)0.2f), (int)this.posz), true);
                }
            }
            if ((e = this.getRiddenEntity()) != null) {
                e.smoothMotion();
                e.update(deltaT);
            }
        } else if (this.morph != null && this.world.rand.nextInt(600) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        String morphname = this.getMorphName();
        if (!this.do_morph) {
            Entity ent;
            if (this.morph == null) {
                if (morphname != null && (ent = this.world.createEntityByName(morphname, this.dimension, this.posx, this.posy, this.posz)) != null) {
                    ent.init();
                    this.morphto = ent;
                    this.morphspeed = -0.01f;
                    this.do_morph = true;
                    if (!this.world.isServer) {
                        this.world.playSound("DangerZone:morph1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    }
                }
            } else {
                if (!this.morph.uniquename.equals(morphname)) {
                    if (morphname == null) {
                        this.morphto = this;
                        this.morphspeed = -0.01f;
                        this.do_morph = true;
                        if (!this.world.isServer) {
                            this.world.playSound("DangerZone:morph1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                        }
                        this.setMorphName(null);
                    } else if (morphname.equals(this.uniquename)) {
                        this.morphto = this;
                        this.morphspeed = -0.01f;
                        this.do_morph = true;
                        if (!this.world.isServer) {
                            this.world.playSound("DangerZone:morph1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                        }
                        this.setMorphName(null);
                    } else {
                        ent = this.world.createEntityByName(morphname, this.dimension, this.posx, this.posy, this.posz);
                        if (ent != null) {
                            ent.init();
                            this.morphto = ent;
                            this.morphspeed = -0.01f;
                            this.do_morph = true;
                            if (!this.world.isServer) {
                                this.world.playSound("DangerZone:morph1", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                            }
                        }
                    }
                }
                if (this.morph.has_inventory) {
                    this.morph.sethotbarindex(this.gethotbarindex());
                    this.morph.setHotbar(this.gethotbarindex(), this.getHotbar(this.gethotbarindex()));
                }
            }
        }
        if (this.do_morph) {
            this.morphscale += this.morphspeed;
            if (this.morphscale < 0.01f) {
                this.morphscale = 0.01f;
                this.morphspeed = 0.01f;
                this.morph = this.morphto;
                this.model = this.morphto.model;
                if (this.morph == this) {
                    this.morph = null;
                    this.model = DangerZoneBase.modelhumanoid;
                }
                if (!this.world.isServer) {
                    this.world.playSound("DangerZone:morph2", this.dimension, this.posx, this.posy, this.posz, 0.25f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                }
            }
            if (this.morphscale >= 1.0f) {
                this.morphscale = 1.0f;
                this.morphspeed = -0.01f;
                this.do_morph = false;
            }
            if (!this.world.isServer) {
                Utils.spawnParticles(this.world, "DangerZone:ParticleSparkle", 5, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), true);
                Utils.spawnParticles(this.world, "DangerZone:ParticleSmoke", 5, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), true);
                Utils.spawnParticles(this.world, "DangerZone:ParticleFire", 5, this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), this.posy + (double)(this.world.rand.nextFloat() * this.getHeight()), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.getWidth() / 2.0f), true);
            }
        }
        if (!(this.getForward() || this.getBackward() || this.getLeft() || this.getRight() || this.getGameMode() == 2)) {
            if (this.world.isServer) {
                this.motionx *= 1.0f - 0.35f * deltaT;
                this.motionz *= 1.0f - 0.35f * deltaT;
            } else {
                float rate = DangerZone.entityupdaterate;
                this.motionx *= 1.0f - 0.35f * deltaT * (rate /= (float)DangerZone.serverentityupdaterate);
                this.motionz *= 1.0f - 0.35f * deltaT * rate;
            }
        }
        this.eyeheight = this.getSitting() ? 0.586f * this.getHeight() : 0.943f * this.getHeight();
        if (!this.world.isServer) {
            InventoryContainer ic = null;
            Item icitem = null;
            ++this.inventoryticker;
            if (this.inventoryticker > 5) {
                this.inventoryticker = 0;
                int j = 0;
                while (j < 100) {
                    ic = this.entity_inventory[j];
                    if (ic != null && (icitem = ic.getItem()) != null) {
                        icitem.update(this, ic);
                    }
                    ++j;
                }
            }
            if (this.morph == null) {
                this.setMaxHealth(this.starthealth + this.getExperience() / 1000);
                this.setDefense(1.0f + (float)this.getExperience() / 100000.0f);
                this.setAttackDamage(1.0f + (float)this.getExperience() / 10000.0f);
            }
            if (this.getHealth() <= 0.0f) {
                this.deadflag = true;
            }
            if (this == DangerZone.player && this.getGameMode() == 0) {
                if (this.getHunger() > 0.0f) {
                    this.setHunger(this.getHunger() - 2.0E-4f);
                }
                if (this.getHealth() >= 0.0f && this.getHealth() < this.getMaxHealth() && this.getHunger() > this.getMaxHunger() / 2.0f) {
                    this.setHealth(this.getHealth() + this.getMaxHealth() * 4.0E-5f);
                }
                if (this.getHunger() <= 0.0f && this.world.rand.nextInt(100) == 1) {
                    this.doAttackFrom(null, 11, 0.1f);
                }
            }
            if (this.armdir != 0) {
                if (this.armdir > 0) {
                    this.armangle += 22.0f * deltaT;
                    if (this.armangle > 150.0f) {
                        this.armdir = -1;
                    }
                }
                if (this.armdir < 0) {
                    this.armangle -= 22.0f * deltaT;
                    if (this.armangle <= 0.0f) {
                        this.armdir = 0;
                        this.armangle = 0.0f;
                    }
                }
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
            ++this.lightupdatecounter;
            if (this.lightupdatecounter > 5) {
                ic = this.getHotbar(this.gethotbarindex());
                if (ic != null) {
                    float lvl = 0.0f;
                    if (ic.bid != 0) {
                        lvl = Blocks.getLightLevel(ic.bid, this.world, this.dimension, (int)this.posx, (int)(this.posy + 1.25), (int)this.posz);
                    }
                    if (ic.iid != 0) {
                        lvl = Items.getLightLevel(ic.iid);
                    }
                    if (lvl != 0.0f) {
                        LightingThread.addRequest(this.dimension, (int)this.posx, (int)(this.posy + 1.25), (int)this.posz, lvl);
                    }
                }
                this.lightupdatecounter = 0;
            }
        } else if (this.morph != null && (this.getLeft() || this.getRight()) && (tempent = this.world.createEntityByName("DangerZone:Cockroach", this.dimension, (px = (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)))) * 32.0 + this.posx, (py = (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)))) * 32.0 + this.posy, (pz = (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)))) * 32.0 + this.posz)) != null) {
            this.morph.doDistanceAttack(tempent);
        }
        boolean wasOnGround = this.getOnGround();
        super.update(deltaT);
        if (!this.world.isServer && !wasOnGround && this.getOnGround()) {
            int bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (double)0.2f), (int)this.posz);
            Utils.spawnParticles(this.world, "DangerZone:ParticleBreak", 50, this.dimension, this.posx, this.posy, this.posz, bid, true);
            Blocks.doblocktick(this.world, this.dimension, (int)this.posx, (int)(this.posy - (double)0.2f), (int)this.posz, bid);
            if (this.steppedOnCockroach()) {
                int i = 0;
                while (i < 256) {
                    int id = (this.dimension + i + 1) % 256;
                    if (Dimensions.DimensionArray[id] != null) {
                        Dimensions.DimensionArray[id].teleportToDimension(this, this.world, id, (int)this.posx, (int)this.posy, (int)this.posz);
                        this.world.playSound("DangerZone:big_splat", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
                        Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, this.posx, this.posy, this.posz, true);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public void tryfly() {
        if (this.morph != null && this.morph.canFly && !this.isFlying()) {
            this.setFlying(true);
            this.posy += (double)0.05f;
            this.motiony += 0.25f;
        }
    }

    @Override
    public void jump() {
        if (this.getInLiquid() && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 1.5), (int)this.posz))) {
            ++this.swimdelay;
            if (this.swimdelay > 40) {
                this.swimdelay = 0;
            }
            if (this.swimdelay > 15) {
                this.motiony += 0.035f;
                if (this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.35f, this.posz)) {
                    this.motiony += 0.55f;
                }
                if (!this.world.isServer && this.getHunger() > 0.0f && this.getGameMode() == 0) {
                    this.setHunger(this.getHunger() - 0.002f);
                }
            }
        }
        if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - (double)0.02f, this.posz)) {
            return;
        }
        if (Math.abs(this.motiony) > 0.05f) {
            return;
        }
        float jumpfactor = 0.8f + this.getHeight() / 8.0f;
        float jumpadjust = this.getTotalEffect(3);
        if (jumpadjust != 0.0f) {
            jumpfactor += jumpfactor * jumpadjust / 4.0f;
        }
        if ((jumpadjust = this.getTotalEffect(4)) != 0.0f) {
            jumpfactor /= jumpadjust;
        }
        this.motiony = this.isBaby() ? (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 1, (int)this.posz) != 0 ? (this.motiony += 0.75f) : (this.motiony += jumpfactor * 0.95f)) : (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 2, (int)this.posz) != 0 || this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 3, (int)this.posz) != 0 ? (this.motiony += 0.75f) : (this.motiony += jumpfactor * 0.95f));
        if (!this.world.isServer && this.getHunger() > 0.0f && this.getGameMode() == 0) {
            this.setHunger(this.getHunger() - 0.08f);
        }
    }

    public void leftclick(World world, int focus_x, int focus_y, int focus_z, int focus_side, int eid) {
        Entity e = null;
        boolean do_uses = false;
        if (world.isServer) {
            InventoryContainer ic = this.getHotbar(this.gethotbarindex());
            e = DangerZone.server.entityManager.findEntityByID(eid);
            boolean leftcontinue = true;
            if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    leftcontinue = it.onLeftClick(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    leftcontinue = bl.onLeftClick(this, e, ic);
                }
            }
            if (leftcontinue && e != null) {
                int dt = 0;
                float damage = this.getAttackDamage();
                if (ic != null) {
                    if (ic.bid != 0) {
                        dt = 3;
                    } else if (ic.iid > 0 && ic.iid < 2048) {
                        damage += (float)Items.getAttackStrength(ic.iid);
                        Item it = ic.getItem();
                        if (it != null) {
                            if (it instanceof ItemSword) {
                                dt = 1;
                            }
                            if (it instanceof ItemPickAxe) {
                                dt = 2;
                            }
                            if (it instanceof ItemAxe) {
                                dt = 2;
                            }
                            if (it instanceof ItemShovel) {
                                dt = 2;
                            }
                        }
                    }
                }
                if (e.leftClickedByPlayer(this, ic)) {
                    e.doAttackFrom(this, dt, damage);
                }
            }
        } else {
            this.armdir = 1;
            e = DangerZone.entityManager.findEntityByID(eid);
            if (e == null) {
                this.server_connection.playerActionToServer(0, 0, 0);
            } else {
                this.server_connection.playerActionToServer(0, 0, e.entityID);
            }
            InventoryContainer ic = this.getHotbar(this.gethotbarindex());
            boolean leftcontinue = true;
            if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    leftcontinue = it.onLeftClick(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    leftcontinue = bl.onLeftClick(this, e, ic);
                }
            }
            if (leftcontinue) {
                if (e == null) {
                    int bid;
                    if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) > 0) {
                        do_uses = true;
                        if (Blocks.leftClickOnBlock(bid, this, this.dimension, focus_x, focus_y, focus_z) || this.getGameMode() != 0) {
                            String particlename;
                            float dmg = this.getAttackDamage();
                            if (ic != null && ic.iid != 0) {
                                if (Blocks.isWood(bid) || Blocks.isLeaves(bid)) {
                                    dmg += (float)Items.getWoodStrength(ic.iid);
                                }
                                if (Blocks.isStone(bid)) {
                                    dmg += (float)Items.getStoneStrength(ic.iid);
                                }
                                if (Blocks.isDirt(bid)) {
                                    dmg += (float)Items.getDirtStrength(ic.iid);
                                }
                                if (ic.getItem() instanceof ItemSword && !Blocks.isLeaves(bid)) {
                                    dmg = 0.0f;
                                }
                                if (ic.getItem() instanceof ItemSword && Blocks.isLeaves(bid)) {
                                    dmg += (float)Items.getAttackStrength(ic.iid);
                                }
                                ic.getItem().leftClickOnBlock(this, this.dimension, focus_x, focus_y, focus_z, focus_side);
                            }
                            if (dmg != 0.0f) {
                                float damageadjust = this.getTotalEffect(3);
                                if (damageadjust != 0.0f) {
                                    dmg *= damageadjust;
                                }
                                if ((damageadjust = this.getTotalEffect(4)) != 0.0f) {
                                    dmg /= damageadjust;
                                }
                            }
                            if ((particlename = Blocks.getParticleName(bid)) == null || particlename.equals("")) {
                                particlename = "DangerZone:ParticleBreak";
                            }
                            Utils.spawnParticles(this.world, particlename, 10, this.dimension, (double)focus_x + 0.5, (double)focus_y + 0.5, (double)focus_z + 0.5, bid, true);
                            int md = Blocks.getMinDamage(bid);
                            if (dmg >= (float)md) {
                                WorldRenderer.focus_damage += dmg;
                            }
                            if (dmg != 0.0f && (WorldRenderer.focus_damage >= WorldRenderer.focus_maxdamage || this.getGameMode() != 0)) {
                                world.playSound(Blocks.getBreakSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
                                Blocks.onBlockBroken(bid, this, this.dimension, focus_x, focus_y, focus_z);
                                int dbid = Blocks.getBlockDrop(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                                int diid = Blocks.getItemDrop(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                                int howmany = Blocks.getDropCount(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                                world.setblockandmeta(this.dimension, focus_x, focus_y, focus_z, 0, 0);
                                if (howmany > 0) {
                                    int i = 0;
                                    while (i < howmany) {
                                        EntityBlockItem eb;
                                        if (dbid > 0 && (eb = (EntityBlockItem)world.createEntityByName(DangerZone.blockitemname, this.dimension, (double)focus_x + 0.5, (double)focus_y + 0.5, (double)focus_z + 0.5)) != null) {
                                            eb.setBID(dbid);
                                            eb.setIID(0);
                                            world.spawnEntityInWorld(eb);
                                        }
                                        if (diid > 0 && (eb = (EntityBlockItem)world.createEntityByName(DangerZone.blockitemname, this.dimension, (double)focus_x + 0.5, (double)focus_y + 0.5, (double)focus_z + 0.5)) != null) {
                                            eb.setBID(0);
                                            eb.setIID(diid);
                                            world.spawnEntityInWorld(eb);
                                        }
                                        ++i;
                                    }
                                }
                            } else {
                                world.playSound(Blocks.getHitSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
                            }
                        }
                    }
                } else {
                    do_uses = true;
                    Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, e.posx, e.posy, e.posz, true);
                    if (this.getHunger() > 0.0f && this.getGameMode() == 0) {
                        this.setHunger(this.getHunger() - 0.25f);
                    }
                }
                if (do_uses && this.getGameMode() == 0 && ic != null && ic.iid > 0 && ic.iid < 2048 && Items.getMaxStack(ic.iid) == 1) {
                    ++ic.currentuses;
                    this.setHotbarChanged(this.gethotbarindex());
                    if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                        if (world.rand.nextInt(2) == 1) {
                            world.playSound("DangerZone:toolbreak1", this.dimension, focus_x, focus_y, focus_z, 0.45f, 1.0f);
                        } else {
                            world.playSound("DangerZone:toolbreak2", this.dimension, focus_x, focus_y, focus_z, 0.45f, 1.0f);
                        }
                        this.setHotbar(this.gethotbarindex(), null);
                    }
                }
            }
        }
    }

    public void middleclick(World world, int focus_x, int focus_y, int focus_z, int eid) {
        int bid;
        if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) != 0) {
            world.playSound(Blocks.getHitSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
            DangerZone.messagetimer = 100;
            DangerZone.messagestring = Blocks.BlockArray[bid].uniquename;
        }
    }

    public void rightclick(World world, int focusx, int focusy, int focusz, int side, int eid) {
        Entity e = null;
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        boolean rightcontinue = true;
        if (world.isServer) {
            e = DangerZone.server.entityManager.findEntityByID(eid);
            if (e != null) {
                if (e.rightClickedByPlayer(this, ic) && this.getGameMode() == 0) {
                    if (ic != null) {
                        --ic.count;
                        if (ic.count <= 0) {
                            ic = null;
                        }
                    }
                    this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                } else if (ic != null) {
                    Block bl;
                    Item it = ic.getItem();
                    if (it != null) {
                        rightcontinue = it.onRightClick(this, e, ic);
                    }
                    if ((bl = ic.getBlock()) != null) {
                        rightcontinue = bl.onRightClick(this, e, ic);
                    }
                    if (this.getGameMode() == 0 && rightcontinue) {
                        if (ic.iid > 0 && ic.iid < 2048 && Items.getMaxStack(ic.iid) == 1) {
                            ++ic.currentuses;
                            this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                            if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                                this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), null);
                            }
                        } else {
                            --ic.count;
                            if (ic.count <= 0) {
                                ic = null;
                            }
                            this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                        }
                    }
                }
            } else if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    rightcontinue = it.onRightClick(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    rightcontinue = bl.onRightClick(this, e, ic);
                }
                if (this.getGameMode() == 0 && rightcontinue) {
                    if (ic.count == 1) {
                        ++ic.currentuses;
                        this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                        if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                            this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), null);
                        }
                    } else {
                        --ic.count;
                        if (ic.count <= 0) {
                            ic = null;
                        }
                        this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                    }
                }
            }
        } else {
            e = DangerZone.entityManager.findEntityByID(eid);
            if (e != null) {
                this.server_connection.playerActionToServer(0, 1, e.entityID);
                e.rightClickedByPlayer(this, ic);
            } else {
                int bid = 0;
                int iid = 0;
                if (ic != null && ic.count >= 1) {
                    bid = ic.bid;
                    iid = ic.iid;
                }
                if (focusx > 0 && focusy >= 0 && focusz > 0) {
                    int fbid = world.getblock(this.dimension, focusx, focusy, focusz);
                    boolean cont = Blocks.rightClickOnBlock(fbid, this, this.dimension, focusx, focusy, focusz);
                    if (cont) {
                        if (bid != 0) {
                            Blocks.doPlaceBlock(bid, fbid, this, world, this.dimension, focusx, focusy, focusz, side);
                        } else if (ic != null && iid != 0) {
                            boolean delme = Items.rightClickOnBlock(iid, this, this.dimension, focusx, focusy, focusz, side);
                            world.playSound(Blocks.getHitSound(fbid), this.dimension, focusx, focusy, focusz, 0.35f, 1.0f);
                            if (this.getGameMode() == 0 && delme) {
                                if (ic.count == 1) {
                                    ++ic.currentuses;
                                    this.setHotbarChanged(this.gethotbarindex());
                                    if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                                        this.setHotbar(this.gethotbarindex(), null);
                                    }
                                } else {
                                    --ic.count;
                                    if (ic.count <= 0) {
                                        this.setHotbar(this.gethotbarindex(), null);
                                        ic = null;
                                    }
                                    this.setHotbarChanged(this.gethotbarindex());
                                }
                            }
                        }
                    }
                } else {
                    this.server_connection.playerActionToServer(0, 1, 0);
                }
            }
        }
    }

    public boolean putMeInASlot(int bid, int iid, int uses) {
        InventoryContainer ic;
        int i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic != null && ic.bid == bid && ic.iid == iid) {
                if (ic.bid != 0 && ic.count < Blocks.getMaxStack(bid)) {
                    ++ic.count;
                    this.setHotbarChanged(i);
                    this.sendInventoryUpdate(0, i, ic);
                    return true;
                }
                if (ic.iid != 0 && ic.count < Items.getMaxStack(iid)) {
                    ++ic.count;
                    this.setHotbarChanged(i);
                    this.sendInventoryUpdate(0, i, ic);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic != null && ic.bid == bid && ic.iid == iid) {
                if (ic.bid != 0 && ic.count < Blocks.getMaxStack(bid)) {
                    ++ic.count;
                    this.setInventoryChanged(i);
                    this.sendInventoryUpdate(1, i, ic);
                    return true;
                }
                if (ic.iid != 0 && ic.count < Items.getMaxStack(iid)) {
                    ++ic.count;
                    this.setInventoryChanged(i);
                    this.sendInventoryUpdate(1, i, ic);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            if (this.getHotbar(i) == null) {
                ic = new InventoryContainer();
                this.setHotbar(i, ic);
                ic.bid = bid;
                ic.iid = iid;
                ic.count = 1;
                ic.currentuses = uses;
                this.sendInventoryUpdate(0, i, ic);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            if (this.getInventory(i) == null) {
                ic = new InventoryContainer();
                this.setInventory(i, ic);
                ic.bid = bid;
                ic.iid = iid;
                ic.count = 1;
                ic.currentuses = uses;
                this.sendInventoryUpdate(1, i, ic);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void sendInventoryUpdate(int which, int slot, InventoryContainer ic) {
        if (this.world.isServer) {
            this.server_thread.sendInventoryUpdateToPlayer(which, slot, ic);
        } else {
            this.server_connection.inventoryUpdate(which, slot, ic);
        }
    }

    private boolean steppedOnCockroach() {
        List<Entity> nearby_list = null;
        if (this.world.isServer) {
            return false;
        }
        nearby_list = DangerZone.entityManager.findEntitiesInRange(4.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                double dist;
                e = li.next();
                if (!(e instanceof Cockroach) || !((dist = this.getDistanceFromEntity(e)) < 0.75)) continue;
                Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, e.posx, e.posy, e.posz, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public Texture getTexture() {
        if (this.morph != null) {
            return this.morph.getTexture();
        }
        if (this.donewtexture) {
            File file = null;
            try {
                file = File.createTempFile("TmpSkin", ".tmp");
                file.deleteOnExit();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int width = 64;
            int height = 32;
            String format = "PNG";
            BufferedImage image = new BufferedImage(width, height, 1);
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int i = (x + width * y) * 4;
                    int r = this.tdata[i] & 0xFF;
                    int g = this.tdata[i + 1] & 0xFF;
                    int b = this.tdata[i + 2] & 0xFF;
                    int a = this.tdata[i + 3] & 0xFF;
                    image.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                    ++y;
                }
                ++x;
            }
            try {
                ImageIO.write((RenderedImage)image, format, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            image.flush();
            if (this.texture != null) {
                this.texture.release();
                this.texture = null;
            }
            try {
                this.texture = TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)file.getPath()));
                this.tdata = this.texture.getTextureData();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.texture = null;
            }
            this.donewtexture = false;
        }
        if (this.texture == null) {
            try {
                this.texture = TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)"Player.png"));
                this.tdata = this.texture.getTextureData();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.texture = null;
            }
        }
        return this.texture;
    }

    @Override
    public float getWidth() {
        if (this.morph != null) {
            float w = this.morph.getWidth();
            if (this.isBaby()) {
                w /= 4.0f;
            }
            return w;
        }
        return super.getWidth();
    }

    @Override
    public float getHeight() {
        if (this.morph != null) {
            float h = this.morph.getHeight();
            if (this.isBaby()) {
                h /= 4.0f;
            }
            return h;
        }
        return super.getHeight();
    }

    @Override
    public float getNameHeight() {
        if (this.morph != null) {
            return this.morph.getNameHeight();
        }
        return this.height;
    }

    @Override
    public void onKill(Entity victim) {
        if (victim == null) {
            return;
        }
        if (!(victim instanceof EntityLiving)) {
            return;
        }
        float ef = this.getTotalEffect(8);
        if (ef != 0.0f) {
            this.setMorphName(victim.uniquename);
            if (this.world.isServer) {
                this.server_thread.sendVarStringUpdate(2, victim.uniquename);
            }
        }
    }

    @Override
    public float getAttackDamage() {
        if (this.morph != null) {
            return this.morph.getAttackDamage();
        }
        return super.getAttackDamage();
    }

    @Override
    public float getDefense() {
        float df = 0.0f;
        if (this.morph != null) {
            df = this.morph.getDefense();
        }
        return df + super.getDefense();
    }

    @Override
    public float getAdjustedFallDamage(float ouch) {
        if (this.morph != null) {
            return this.morph.getAdjustedFallDamage(ouch);
        }
        return ouch;
    }

    @Override
    public void setOnFire(int fire) {
        if (this.morph != null && this.morph.isImmuneToFire) {
            this.setOnFire(0);
            return;
        }
        super.setOnFire(fire);
    }

    @Override
    public void setAttacking(boolean tf) {
        if (this.morph != null) {
            this.morph.setAttacking(tf);
        }
        super.setAttacking(tf);
    }

    @Override
    public boolean takesDamageFrom(int dt) {
        if (this.morph != null && !this.morph.takesDamageFrom(dt)) {
            return false;
        }
        return super.takesDamageFrom(dt);
    }

    @Override
    public void setFlying(boolean tf) {
        if (this.morph != null) {
            this.morph.setFlying(tf);
        }
        super.setFlying(tf);
    }
}

