/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class NetworkOutputBuffer {
    int currentlen = 0;
    ByteBuffer b = null;
    int maxlen = 0;
    OutputStream out = null;
    boolean error_happened = false;

    public NetworkOutputBuffer(OutputStream inout, int howbig) {
        this.out = inout;
        this.b = ByteBuffer.allocate(howbig + 200);
        this.maxlen = howbig;
    }

    public void close() {
    }

    public boolean errorOccurred() {
        return this.error_happened;
    }

    public void flush() {
        if (this.error_happened) {
            return;
        }
        if (this.currentlen > 0) {
            try {
                this.out.write(this.b.array(), 0, this.currentlen);
                this.out.flush();
                this.b.rewind();
                this.b.position(0);
                this.currentlen = 0;
            }
            catch (IOException e) {
                if (DangerZone.start_client) {
                    DangerZone.gameover = 1;
                }
                this.error_happened = true;
            }
        }
    }

    public void writeInt(int in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 4) {
            this.flush();
        }
        this.b.putInt(in);
        this.currentlen += 4;
    }

    public void writeShort(short in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 2) {
            this.flush();
        }
        this.b.putShort(in);
        this.currentlen += 2;
    }

    public void writeByte(byte in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 1) {
            this.flush();
        }
        this.b.put(in);
        ++this.currentlen;
    }

    public void writeFloat(float in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 4) {
            this.flush();
        }
        this.b.putFloat(in);
        this.currentlen += 4;
    }

    public void writeDouble(double in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 8) {
            this.flush();
        }
        this.b.putDouble(in);
        this.currentlen += 8;
    }

    public void writeLong(long in) {
        if (this.error_happened) {
            return;
        }
        if (this.maxlen - this.currentlen < 8) {
            this.flush();
        }
        this.b.putLong(in);
        this.currentlen += 8;
    }

    public void writeString(String in) {
        if (this.error_happened) {
            return;
        }
        int len = 0;
        byte[] stringbytes = null;
        if (in != null) {
            stringbytes = in.getBytes();
            len = stringbytes.length;
        }
        this.writeInt(len);
        if (this.maxlen - this.currentlen < len) {
            this.flush();
        }
        if (len > 0) {
            int i = 0;
            while (i < len) {
                this.b.put(stringbytes[i]);
                ++i;
            }
        }
        this.currentlen += len;
    }

    public void writeShortArray(short[] sh, int len) {
        if (this.error_happened) {
            return;
        }
        this.writeInt(len);
        if (len > 0) {
            int i = 0;
            while (i < len) {
                this.writeShort(sh[i]);
                ++i;
            }
        }
    }

    public void writeByteArray(byte[] sh, int len) {
        if (this.error_happened) {
            return;
        }
        this.writeInt(len);
        if (this.error_happened) {
            return;
        }
        if (len > 0) {
            if (this.maxlen - this.currentlen < len) {
                this.flush();
                if (this.error_happened) {
                    return;
                }
            }
            int i = 0;
            while (i < len) {
                this.b.put(sh[i]);
                if (this.error_happened) {
                    return;
                }
                ++i;
            }
            this.currentlen += len;
        }
    }
}

