/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class NetworkInputBuffer {
    int currentlen = 0;
    ByteBuffer b = null;
    int maxlen = 0;
    InputStream datain = null;
    boolean error_happened = false;

    public NetworkInputBuffer(InputStream inout, int howbig) {
        this.datain = inout;
        this.b = ByteBuffer.allocate(howbig + 200);
        this.maxlen = howbig;
    }

    public void close() {
    }

    public boolean errorOccurred() {
        return this.error_happened;
    }

    private void getAtLeast(int min) {
        int i;
        if (this.currentlen >= min) {
            return;
        }
        if (this.error_happened) {
            this.b.rewind();
            this.b.position(0);
            return;
        }
        int maxread = 0;
        if (this.currentlen > 0) {
            byte[] b1 = this.b.array();
            i = 0;
            while (i < this.currentlen) {
                b1[i] = this.b.get();
                ++i;
            }
        }
        this.b.position(this.currentlen);
        try {
            maxread = this.datain.available();
        }
        catch (IOException e1) {
            this.error_happened = true;
            if (DangerZone.start_client) {
                DangerZone.gameover = 1;
            }
            this.b.rewind();
            this.b.position(0);
            return;
        }
        if (maxread < min - this.currentlen) {
            maxread = min - this.currentlen;
        }
        if (maxread > this.maxlen - this.currentlen) {
            maxread = this.maxlen - this.currentlen;
        }
        i = 0;
        while (i < maxread) {
            try {
                int newval = this.datain.read();
                this.b.put((byte)newval);
                ++this.currentlen;
            }
            catch (IOException e) {
                this.error_happened = true;
                if (!DangerZone.start_client) break;
                DangerZone.gameover = 1;
                break;
            }
            ++i;
        }
        this.b.rewind();
        this.b.position(0);
    }

    public int readInt() {
        int retval = 0;
        this.getAtLeast(4);
        if (this.error_happened) {
            return retval;
        }
        retval = this.b.getInt();
        this.currentlen -= 4;
        return retval;
    }

    public short readShort() {
        short retval = 0;
        this.getAtLeast(2);
        if (this.error_happened) {
            return retval;
        }
        retval = this.b.getShort();
        this.currentlen -= 2;
        return retval;
    }

    public byte readByte() {
        byte retval = 0;
        this.getAtLeast(1);
        if (this.error_happened) {
            return retval;
        }
        retval = this.b.get();
        --this.currentlen;
        return retval;
    }

    public float readFloat() {
        float retval = 0.0f;
        this.getAtLeast(4);
        if (this.error_happened) {
            return retval;
        }
        retval = this.b.getFloat();
        this.currentlen -= 4;
        return retval;
    }

    public double readDouble() {
        double retval = 0.0;
        this.getAtLeast(8);
        if (this.error_happened) {
            return retval;
        }
        retval = this.b.getDouble();
        this.currentlen -= 8;
        return retval;
    }

    public long readLong() {
        long retval = 0L;
        this.getAtLeast(8);
        if (this.error_happened) {
            return retval;
        }
        retval = this.b.getLong();
        this.currentlen -= 8;
        return retval;
    }

    public String readString() {
        if (this.error_happened) {
            return null;
        }
        byte[] stringbytes = this.readByteArray();
        if (stringbytes == null) {
            return null;
        }
        String s = "";
        int i = 0;
        while (i < stringbytes.length) {
            s = String.valueOf(s) + (char)stringbytes[i];
            ++i;
        }
        return s;
    }

    public short[] readShortArray() {
        int len = this.readInt();
        if (len <= 0) {
            return null;
        }
        short[] sh = new short[len];
        int i = 0;
        while (i < len) {
            sh[i] = this.readShort();
            ++i;
        }
        return sh;
    }

    public byte[] readByteArray() {
        int len = this.readInt();
        if (len <= 0) {
            return null;
        }
        byte[] sh = new byte[len];
        this.getAtLeast(len);
        if (this.error_happened) {
            return null;
        }
        int i = 0;
        while (i < len) {
            sh[i] = this.b.get();
            --this.currentlen;
            ++i;
        }
        return sh;
    }
}

