/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.items.Item;
import dangerzone.items.Items;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class InventoryContainer {
    public int count;
    public int bid;
    public int iid;
    public int currentuses = 0;

    public InventoryContainer() {
        this.iid = 0;
        this.bid = 0;
        this.count = 0;
    }

    public InventoryContainer(String uniquename, int incount) {
        this.bid = Blocks.findByName(uniquename);
        if (this.bid == 0) {
            this.iid = Items.findByName(uniquename);
        }
        this.count = 0;
        if (this.bid != 0 || this.iid != 0) {
            this.count = incount;
        }
    }

    public InventoryContainer(int inbid, int iniid, int incount, int incurrentuses) {
        this.bid = inbid;
        this.iid = iniid;
        this.count = incount;
        this.currentuses = incurrentuses;
    }

    public void writeSelf(Properties prop, String tag) {
        prop.setProperty(String.format("%s%s", tag, "BID"), String.format("%d", this.bid));
        prop.setProperty(String.format("%s%s", tag, "IID"), String.format("%d", this.iid));
        prop.setProperty(String.format("%s%s", tag, "count"), String.format("%d", this.count));
        prop.setProperty(String.format("%s%s", tag, "currentuses"), String.format("%d", this.currentuses));
    }

    public void readSelf(Properties prop, String tag) {
        this.bid = Utils.getPropertyInt(prop, String.format("%s%s", tag, "BID"), 0, 2047, 0);
        this.iid = Utils.getPropertyInt(prop, String.format("%s%s", tag, "IID"), 0, 2047, 0);
        this.count = Utils.getPropertyInt(prop, String.format("%s%s", tag, "count"), 0, 128, 1);
        this.currentuses = Utils.getPropertyInt(prop, String.format("%s%s", tag, "currentuses"), 0, Integer.MAX_VALUE, 0);
    }

    public Texture getTexture() {
        if (this.count <= 0) {
            return null;
        }
        if (this.bid != 0) {
            if (Blocks.showTop(this.bid)) {
                return Blocks.getTextureForSide(this.bid, 0);
            }
            return Blocks.getTexture(this.bid);
        }
        if (this.iid != 0) {
            return Items.getTexture(this.iid);
        }
        return null;
    }

    public String getUniqueName() {
        if (this.count <= 0) {
            return null;
        }
        if (this.bid != 0) {
            return Blocks.getUniqueName(this.bid);
        }
        if (this.iid != 0) {
            return Items.getUniqueName(this.iid);
        }
        return null;
    }

    public int getMaxStack() {
        if (this.bid != 0) {
            return Blocks.getMaxStack(this.bid);
        }
        if (this.iid != 0) {
            return Items.getMaxStack(this.iid);
        }
        return 1;
    }

    public Item getItem() {
        if (this.bid != 0) {
            return null;
        }
        return Items.getItem(this.iid);
    }

    public Block getBlock() {
        if (this.iid != 0) {
            return null;
        }
        return Blocks.getBlock(this.bid);
    }
}

