/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlock;
import java.util.List;
import java.util.ListIterator;

public class Explosion {
    public static void boom(World world, int dimension, double x, double y, double z, int pwr, boolean doentitydamage) {
        double fz;
        double fy;
        double fx;
        float dr;
        double dir;
        int which;
        if (!world.isServer) {
            return;
        }
        if (pwr <= 0 || pwr > 20000) {
            return;
        }
        if (pwr < 50) {
            which = world.rand.nextInt(5);
            if (which == 0) {
                world.playSound("DangerZone:small_explosion1", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 1) {
                world.playSound("DangerZone:small_explosion2", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 2) {
                world.playSound("DangerZone:small_explosion3", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 3) {
                world.playSound("DangerZone:small_explosion4", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 4) {
                world.playSound("DangerZone:small_explosion5", dimension, x, y, z, 1.0f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
        } else {
            which = world.rand.nextInt(3);
            if (which == 0) {
                world.playSound("DangerZone:large_explosion1", dimension, x, y, z, 2.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 1) {
                world.playSound("DangerZone:large_explosion2", dimension, x, y, z, 2.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
            if (which == 2) {
                world.playSound("DangerZone:large_explosion3", dimension, x, y, z, 2.5f, 1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.3f);
            }
        }
        float raydist = (float)Math.sqrt(pwr);
        float curdist = 0.0f;
        int nray = pwr * 30;
        int spk = 4;
        if (pwr >= 10) {
            spk = 10;
        }
        if (pwr >= 100) {
            spk = 50;
        }
        if (pwr >= 1000) {
            spk = 250;
        }
        if (pwr >= 5000) {
            spk = 2000;
        }
        if (pwr >= 5000) {
            raydist *= 0.75f;
            nray *= 2;
        }
        int i = 0;
        while (i < nray) {
            int bid;
            int iz;
            int iy;
            int ix;
            dir = Math.toRadians(world.rand.nextDouble() * 360.0);
            double xzscale = Math.toRadians(world.rand.nextDouble() * 360.0);
            double dx = Math.cos(dir);
            double dz = Math.sin(dir);
            double dy = Math.cos(xzscale) / 2.0;
            xzscale = Math.abs(Math.sin(xzscale));
            dx *= xzscale;
            dz *= xzscale;
            float raypower = pwr * 40;
            float powerlost = 0.0f;
            int lz = 0;
            int ly = 0;
            int lx = 0;
            dr = pwr < 500 ? raydist + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f * raydist : raydist + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.1f * raydist;
            curdist = i;
            curdist /= (float)nray;
            curdist *= dr;
            while (curdist < dr) {
                fx = x + dx * (double)curdist;
                fy = y + dy * (double)curdist;
                fz = z + dz * (double)curdist;
                ix = (int)fx;
                iy = (int)fy;
                iz = (int)fz;
                if (ix != lx || iy != ly || iz != lz) {
                    lx = ix;
                    ly = iy;
                    lz = iz;
                    bid = world.getblock(dimension, ix, iy, iz);
                    if (bid != 0) {
                        float powerleft = raypower * (dr - curdist) / dr;
                        if ((powerleft -= powerlost) <= 0.0f) break;
                        if (powerleft > (float)Blocks.getMinDamage(bid) && powerleft > (float)Blocks.getMaxDamage(bid)) {
                            if (pwr > 500 && curdist / dr < 0.9f) {
                                world.setblockandmetanonotify(dimension, ix, iy, iz, 0, 0);
                            } else {
                                world.setblockandmeta(dimension, ix, iy, iz, 0, 0);
                            }
                            if (world.rand.nextInt(spk) == 0) {
                                Utils.spawnParticlesFromServer(world, "DangerZone:ParticleSmoke", world.rand.nextInt(3) + 3, dimension, fx, fy, fz);
                            }
                            if (world.rand.nextInt(spk * 2) == 0) {
                                Utils.doDropRand(world, bid, 0, raydist, dimension, fx, fy, fz);
                            }
                        }
                        powerlost += (float)Blocks.getMaxDamage(bid);
                    }
                    if (world.rand.nextInt(spk) == 0) {
                        Utils.spawnParticlesFromServer(world, "DangerZone:ParticleSparkle", 1, dimension, fx, fy, fz);
                    }
                }
                curdist += 0.1701f;
            }
            if (powerlost == 0.0f) {
                lz = 0;
                ly = 0;
                lx = 0;
                while (curdist < dr * 2.0f) {
                    fx = x + dx * (double)curdist;
                    fy = y + dy * (double)curdist;
                    fz = z + dz * (double)curdist;
                    ix = (int)fx;
                    iy = (int)fy;
                    iz = (int)fz;
                    if (ix != lx || iy != ly || iz != lz) {
                        lx = ix;
                        ly = iy;
                        lz = iz;
                        bid = world.getblock(dimension, ix, iy, iz);
                        if (bid != 0) {
                            Entity eb;
                            if (Blocks.getBurnTime(bid) <= 0 || world.rand.nextInt(5) != 1 || (eb = world.createEntityByName("DangerZone:Fire", dimension, (double)ix + 0.5, (double)iy - 0.0625, (double)iz + 0.5)) == null) break;
                            eb.init();
                            world.spawnEntityInWorld(eb);
                            break;
                        }
                    }
                    curdist += 0.3301f;
                }
            }
            ++i;
        }
        if (!doentitydamage) {
            return;
        }
        dr = raydist * 2.0f;
        List<Entity> nearby_list = null;
        Entity enthit = null;
        float knockback = pwr / 10;
        if (knockback > 10.0f) {
            knockback = 10.0f;
        }
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f + dr, dimension, x, y, z);
        ListIterator<Entity> li = nearby_list.listIterator();
        while (li.hasNext()) {
            enthit = li.next();
            if (enthit.canthitme || enthit instanceof EntityBlock) continue;
            fx = x - enthit.posx;
            fy = y - enthit.posy;
            fz = z - enthit.posz;
            curdist = (float)Math.sqrt(fx * fx + fy * fy + fz * fz);
            if ((curdist -= enthit.getWidth() / 2.0f) < 0.0f) {
                curdist = 0.0f;
            }
            if (!(curdist < dr)) continue;
            if (!(enthit instanceof EntityBlock)) {
                enthit.doSetOnFire(50);
                enthit.doAttackFrom(null, 9, knockback * (dr - curdist) / dr);
            }
            dir = Math.atan2(enthit.posz - z, enthit.posx - x);
            float hdist = (float)Math.sqrt((enthit.posx - x) * (enthit.posx - x) + (enthit.posz - z) * (enthit.posz - z));
            float ydir = (float)Math.atan2(enthit.posy + (double)(enthit.getHeight() / 2.0f) - y, hdist);
            enthit.motionx = (float)((double)enthit.motionx + Math.cos(dir) * (double)knockback * (double)(dr - curdist) * Math.cos(ydir) / (double)dr);
            enthit.motionz = (float)((double)enthit.motionz + Math.sin(dir) * (double)knockback * (double)(dr - curdist) * Math.cos(ydir) / (double)dr);
            enthit.motiony = (float)((double)enthit.motiony + (double)(0.35f * knockback * (dr - curdist)) * Math.sin(ydir) / (double)dr);
            if (!(enthit instanceof Player)) continue;
            Player pl = (Player)enthit;
            pl.server_thread.sendVelocityUpdateToPlayer(enthit.motionx, enthit.motiony, enthit.motionz);
        }
    }
}

