/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.Dimension;
import dangerzone.Utils;
import dangerzone.biomes.BiomeManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class Dimensions {
    public static Dimension overworlddimension = new Dimension("DangerZone: Overworld Dimension");
    public static Dimension bigroundtreedimension = new Dimension("DangerZone: Big Round Tree Dimension");
    public static Dimension pathwaydimension = new Dimension("DangerZone: Pathway Dimension");
    public static Dimension ruggedhillsdimension = new Dimension("DangerZone: Rugged Hills Dimension");
    public static Dimension skyislandsdimension = new Dimension("DangerZone: Sky Islands Dimension");
    public static Dimension[] DimensionArray;
    public static final int dimensionsMAX = 256;
    public static Properties prop;

    static {
        prop = null;
    }

    public Dimensions() {
        DimensionArray = new Dimension[256];
        int i = 0;
        while (i < 256) {
            Dimensions.DimensionArray[i] = null;
            ++i;
        }
    }

    public static int registerDimension(Dimension b) {
        int i = 0;
        i = 1;
        while (i < 256) {
            if (DimensionArray[i] != null && Dimensions.DimensionArray[i].uniquename.equals(b.uniquename)) {
                return 0;
            }
            ++i;
        }
        i = 1;
        while (i < 256) {
            if (DimensionArray[i] == null) break;
            ++i;
        }
        if (i >= 255) {
            return 0;
        }
        if (prop != null) {
            i = Utils.getPropertyInt(prop, b.uniquename, 1, 255, i);
        }
        if (DimensionArray[i] == null) {
            Dimensions.DimensionArray[i] = b;
            b.dimensionID = i;
            if (prop != null) {
                prop.setProperty(b.uniquename, String.format("%d", i));
            }
            return i;
        }
        Dimension intruder = DimensionArray[i];
        int isave = i;
        Dimensions.DimensionArray[i] = b;
        b.dimensionID = i;
        i = 1;
        while (i < 256) {
            if (DimensionArray[i] == null) {
                Dimensions.DimensionArray[i] = intruder;
                intruder.dimensionID = i;
                if (prop != null) {
                    prop.setProperty(intruder.uniquename, String.format("%d", i));
                }
                return isave;
            }
            ++i;
        }
        return 0;
    }

    public static void reRegisterDimensionAt(String s, int loc) {
        if (loc <= 0 || loc >= 256) {
            return;
        }
        if (s == null || s.equals("")) {
            return;
        }
        if (DimensionArray[loc] != null) {
            if (s.equals(Dimensions.DimensionArray[loc].uniquename)) {
                return;
            }
            int i = 1;
            while (i < 256) {
                if (DimensionArray[i] != null && s.equals(Dimensions.DimensionArray[i].uniquename)) {
                    Dimension me = DimensionArray[i];
                    Dimension intruder = DimensionArray[loc];
                    Dimensions.DimensionArray[loc] = me;
                    Dimensions.DimensionArray[loc].dimensionID = loc;
                    Dimensions.DimensionArray[i] = intruder;
                    Dimensions.DimensionArray[i].dimensionID = i;
                    return;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < 256) {
                if (DimensionArray[i] != null && s.equals(Dimensions.DimensionArray[i].uniquename)) {
                    Dimensions.DimensionArray[loc] = DimensionArray[i];
                    Dimensions.DimensionArray[loc].dimensionID = loc;
                    Dimensions.DimensionArray[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static void load() {
        FileInputStream input = null;
        prop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/dimensionIDs.dat", DangerZone.worldname);
        try {
            input = new FileInputStream(filepath);
            prop.load(input);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/dimensionIDs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            output = new FileOutputStream(filepath);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static BiomeManager getBiomeManager(int dim) {
        if (dim <= 0) {
            return null;
        }
        if (dim >= 256) {
            return null;
        }
        if (DimensionArray[dim] == null) {
            return null;
        }
        return DimensionArray[dim].getBiomeManager();
    }

    public static String getName(int dim) {
        if (dim <= 0) {
            return null;
        }
        if (dim >= 256) {
            return null;
        }
        if (DimensionArray[dim] == null) {
            return null;
        }
        return Dimensions.DimensionArray[dim].uniquename;
    }
}

