/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.StuffList;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldDecorator;
import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;
import dangerzone.items.Items;

public class DZWorldDecorator
extends WorldDecorator {
    public static StuffList[] things = new StuffList[]{new StuffList(Items.coinsilver, 5, 25, 75), new StuffList(Items.coingold, 3, 15, 65), new StuffList(Items.coinplatinum, 1, 5, 55), new StuffList(Items.diamond, 1, 5, 5), new StuffList(Items.emerald, 1, 5, 5), new StuffList(Items.bloodstone, 1, 5, 5), new StuffList(Items.sunstone, 1, 5, 5), new StuffList(Items.woodenaxe, 1, 1, 25), new StuffList(Items.woodenshovel, 1, 1, 25), new StuffList(Items.woodenhoe, 1, 1, 25), new StuffList(Items.woodenpickaxe, 1, 1, 25), new StuffList(Items.woodensword, 1, 1, 25), new StuffList(Items.silveraxe, 1, 1, 20), new StuffList(Items.silvershovel, 1, 1, 20), new StuffList(Items.silverhoe, 1, 1, 20), new StuffList(Items.silverpickaxe, 1, 1, 20), new StuffList(Items.silversword, 1, 1, 20), new StuffList(Items.tinsword, 1, 1, 20), new StuffList(Items.tinaxe, 1, 1, 20), new StuffList(Items.tinshovel, 1, 1, 20), new StuffList(Items.tinhoe, 1, 1, 20), new StuffList(Items.tinpickaxe, 1, 1, 20), new StuffList(Items.coppersword, 1, 1, 20), new StuffList(Items.copperaxe, 1, 1, 20), new StuffList(Items.coppershovel, 1, 1, 20), new StuffList(Items.copperhoe, 1, 1, 20), new StuffList(Items.copperpickaxe, 1, 1, 20), new StuffList(Items.platinumaxe, 1, 1, 15), new StuffList(Items.platinumshovel, 1, 1, 15), new StuffList(Items.platinumhoe, 1, 1, 15), new StuffList(Items.platinumpickaxe, 1, 1, 15), new StuffList(Items.platinumsword, 1, 1, 15), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.furball, 1, 16, 65), new StuffList(Items.instability, 1, 16, 25), new StuffList(Items.instabilitylarge, 1, 16, 20), new StuffList(Items.instabilityhuge, 1, 16, 15), new StuffList(Items.corn, 1, 16, 45), new StuffList(Items.corn, 1, 16, 45), new StuffList(Items.radish, 1, 16, 45), new StuffList(Items.radish, 1, 16, 45), new StuffList(Items.moosemeat, 1, 16, 45), new StuffList(Items.moosemeat_cooked, 1, 16, 35), new StuffList(Items.moosebone, 1, 16, 45), new StuffList(Items.goosemeat, 1, 16, 45), new StuffList(Items.goosemeat_cooked, 1, 16, 35), new StuffList(Items.feather, 1, 16, 45), new StuffList(Items.ostrichmeat, 1, 16, 35), new StuffList(Items.ostrichmeat_cooked, 1, 16, 45), new StuffList(Items.silverhelmet, 1, 1, 20), new StuffList(Items.silverchestplate, 1, 1, 20), new StuffList(Items.silverleggings, 1, 1, 20), new StuffList(Items.silverboots, 1, 1, 20), new StuffList(Items.platinumhelmet, 1, 1, 15), new StuffList(Items.platinumchestplate, 1, 1, 15), new StuffList(Items.platinumleggings, 1, 1, 15), new StuffList(Items.platinumboots, 1, 1, 15), new StuffList(Items.copperhelmet, 1, 1, 20), new StuffList(Items.copperchestplate, 1, 1, 20), new StuffList(Items.copperleggings, 1, 1, 20), new StuffList(Items.copperboots, 1, 1, 20), new StuffList(Items.tinhelmet, 1, 1, 20), new StuffList(Items.tinchestplate, 1, 1, 20), new StuffList(Items.tinleggings, 1, 1, 20), new StuffList(Items.tinboots, 1, 1, 20), new StuffList(Items.firestick, 1, 1, 45), new StuffList(Items.deadbug, 1, 16, 45), new StuffList(Items.peachseed, 1, 16, 45), new StuffList(Items.appleseed, 1, 16, 45), new StuffList(Items.cherryseed, 1, 16, 45), new StuffList(Items.dark, 1, 16, 25), new StuffList(Items.light, 1, 16, 25), new StuffList(Items.bottle, 1, 16, 45), new StuffList(Items.experiencebottle, 1, 16, 45), new StuffList(Items.bread, 1, 16, 45), new StuffList(Items.rice, 1, 16, 45), new StuffList(Items.eggbutterfly, 1, 6, 15), new StuffList(Items.eggghost, 1, 6, 15), new StuffList(Items.eggghostskelly, 1, 6, 15), new StuffList(Items.eggrat, 1, 6, 15), new StuffList(Items.eggcockroach, 1, 6, 15), new StuffList(Items.eggmoose, 1, 6, 15), new StuffList(Items.egggoose, 1, 6, 15), new StuffList(Items.egggosling, 1, 6, 15), new StuffList(Items.eggostrich, 1, 6, 15), new StuffList(Items.eggsparklemuffin, 1, 6, 15), new StuffList(Items.eggskeletorus, 1, 6, 15), new StuffList(Items.egganteater, 1, 6, 15), new StuffList(Items.eggvampire, 1, 6, 15), new StuffList(Items.eggthecount, 1, 6, 15), new StuffList(Items.eggwerewolf, 1, 6, 15), new StuffList(Items.frog_speed1, 1, 6, 15), new StuffList(Items.frog_slowness1, 1, 6, 15), new StuffList(Items.frog_speed2, 1, 6, 15), new StuffList(Items.frog_slowness2, 1, 6, 15), new StuffList(Items.frog_speed3, 1, 6, 15), new StuffList(Items.frog_slowness3, 1, 6, 15), new StuffList(Items.frog_strength1, 1, 6, 15), new StuffList(Items.frog_weakness1, 1, 6, 15), new StuffList(Items.frog_strength2, 1, 6, 15), new StuffList(Items.frog_weakness2, 1, 6, 15), new StuffList(Items.frog_strength3, 1, 6, 15), new StuffList(Items.frog_weakness3, 1, 6, 15), new StuffList(Items.frog_regen1, 1, 6, 15), new StuffList(Items.frog_poison1, 1, 6, 15), new StuffList(Items.frog_regen2, 1, 6, 15), new StuffList(Items.frog_poison2, 1, 6, 15), new StuffList(Items.frog_regen3, 1, 6, 15), new StuffList(Items.frog_poison3, 1, 6, 15), new StuffList(Items.frog_confusion1, 1, 6, 15), new StuffList(Items.frog_confusion2, 1, 6, 15), new StuffList(Items.frog_confusion3, 1, 6, 15), new StuffList(Items.frog_morph1, 1, 6, 15), new StuffList(Items.frog_morph2, 1, 6, 15), new StuffList(Items.frog_morph3, 1, 6, 15), new StuffList(Blocks.stone, 1, 5, 10), new StuffList(Blocks.greystone, 1, 5, 10), new StuffList(Blocks.lightstick, 1, 16, 60), new StuffList(Blocks.darkstick, 1, 16, 10), new StuffList(Blocks.blocklight, 1, 1, 5), new StuffList(Blocks.blockdark, 1, 1, 5), new StuffList(Blocks.blocksilver, 1, 1, 5), new StuffList(Blocks.blockcopper, 1, 1, 15), new StuffList(Blocks.blocktin, 1, 1, 15), new StuffList(Blocks.blockplatinum, 1, 1, 5), new StuffList(Blocks.oresilver, 5, 10, 15), new StuffList(Blocks.oreplatinum, 5, 10, 10), new StuffList(Blocks.log, 5, 10, 25), new StuffList(Blocks.willowlog, 5, 10, 25), new StuffList(Blocks.redwoodlog, 5, 10, 25), new StuffList(Blocks.stopblock, 1, 5, 10)};

    @Override
    public void decorate(World world, int dimension, Biome b, int chunkx, int chunkz) {
        int posY;
        int posX;
        int what;
        int iz;
        int m;
        if (!world.isServer) {
            return;
        }
        if (b == null) {
            return;
        }
        Trees tr = new Trees();
        if (b.should_add_caves) {
            double starty = 10.0f + world.rand.nextFloat() * 60.0f;
            double startx = world.rand.nextFloat() * 16.0f;
            double startz = world.rand.nextFloat() * 16.0f;
            this.add_cave(world, dimension, chunkx, chunkz, 0, 4.0f, 100.0f, startx += (double)(chunkx << 4), starty, startz += (double)(chunkz << 4));
        }
        if (b.should_add_dungeons) {
            this.add_dungeon(world, dimension, chunkx, chunkz);
        }
        if (b.should_add_roaches && world.rand.nextInt(40) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            m = 0;
            while (m < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                int iy = 150;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy, iz, Blocks.roachnest.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_butterflies && world.rand.nextInt(50) == 1) {
            int howmany = 1 + world.rand.nextInt(3);
            m = 0;
            while (m < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                int iy = 150;
                while (iy > 70) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.butterfly_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_flowers && world.rand.nextInt(12) == 1) {
            int howmany = 1 + world.rand.nextInt(5);
            m = 0;
            while (m < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                int iy = 165;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_red.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (b.should_add_flowers && world.rand.nextInt(12) == 1) {
            int howmany = 1 + world.rand.nextInt(6);
            m = 0;
            while (m < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                int iy = 180;
                while (iy > 60) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_yellow.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Overworld Dimension")) {
            int howmany = 0;
            what = world.rand.nextInt(5);
            howmany = world.rand.nextInt(5);
            if (what != 0) {
                howmany *= 2;
            }
            if (b.uniquename.equals("DangerZone:Overworld Tall Forest")) {
                what = 0;
            } else if (b.uniquename.equals("DangerZone:Overworld Tall Willow Forest")) {
                what = 1;
            } else if (b.uniquename.equals("DangerZone:Overworld Scraggly Forest")) {
                what = 2;
            } else if (world.rand.nextInt(5) != 0) {
                howmany = 0;
            }
            int cx = chunkx << 4;
            int cz = chunkz << 4;
            int i = 0;
            while (i < howmany) {
                int posX2 = cx + world.rand.nextInt(16);
                int posZ = cz + world.rand.nextInt(16);
                int posY2 = 128;
                while (posY2 > 40) {
                    if (world.getblock(dimension, posX2, posY2, posZ) == 0 && world.getblock(dimension, posX2, posY2 - 1, posZ) == Blocks.grassblock.blockID) {
                        if (what == 0) {
                            tr.TallWoodTree(world, dimension, posX2, posY2, posZ);
                            break;
                        }
                        if (what == 1) {
                            tr.TallWillowTree(world, dimension, posX2, posY2, posZ);
                            break;
                        }
                        tr.ScragglyRedwoodTree(world, dimension, posX2, posY2, posZ);
                        break;
                    }
                    --posY2;
                }
                ++i;
            }
        }
        if ((Dimensions.getName(dimension).equals("DangerZone: Overworld Dimension") || Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")) && world.rand.nextInt(64) == 1) {
            int howmany = 1 + world.rand.nextInt(5);
            m = 0;
            while (m < howmany) {
                int ix = (chunkx << 4) + world.rand.nextInt(16);
                iz = (chunkz << 4) + world.rand.nextInt(16);
                int iy = 100;
                while (iy > 50) {
                    if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                        int howhigh = 2 + world.rand.nextInt(4);
                        int i = 0;
                        while (i < howhigh) {
                            if (world.getblock(dimension, ix, iy + i + 2, iz) != 0) {
                                howhigh = i;
                                break;
                            }
                            world.setblock(dimension, ix, iy + i + 1, iz, world.rand.nextBoolean() ? Blocks.corn_plant2.blockID : Blocks.corn_plant3.blockID);
                            ++i;
                        }
                        world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                        world.setblock(dimension, ix, iy + howhigh + 1, iz, Blocks.corn_plant.blockID);
                        break;
                    }
                    --iy;
                }
                ++m;
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Big Round Tree Dimension")) {
            if (b.uniquename.equals("DangerZone:Big Trees") && !tr.addGenericTrees(world, dimension, chunkx << 4, chunkz << 4)) {
                tr.addTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Big Trees Flower") && !tr.addBigRoundLightTree(world, dimension, chunkx << 4, chunkz << 4)) {
                tr.addFlowerTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Big Trees Flower Two") && !tr.addBigRoundLightTree(world, dimension, chunkx << 4, chunkz << 4)) {
                tr.addFlowerTwoTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (world.rand.nextInt(7) == 1) {
                int howmany = 2 + world.rand.nextInt(5);
                m = 0;
                while (m < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    int iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_pink.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (world.rand.nextInt(64) == 1) {
                int howmany = 1 + world.rand.nextInt(5);
                m = 0;
                while (m < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    int iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            if (world.rand.nextInt(3) == 0) {
                                world.setblock(dimension, ix, iy + 1, iz, Blocks.radish_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.radish_plant3.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Pathway Dimension")) {
            if (b.uniquename.equals("DangerZone:Pathway")) {
                tr.addGenericTrees(world, dimension, chunkx << 4, chunkz << 4);
                if (world.rand.nextInt(3) == 0) {
                    int howmany = 0;
                    what = world.rand.nextInt(3);
                    howmany = world.rand.nextInt(6);
                    int i = 0;
                    while (i < howmany) {
                        posX = (chunkx << 4) + world.rand.nextInt(16);
                        int posZ = (chunkz << 4) + world.rand.nextInt(16);
                        posY = 90;
                        while (posY > 50) {
                            if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what == 0) {
                                    tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.cherryleaves.blockID);
                                    break;
                                }
                                if (what != 1) break;
                                tr.makeFruitTree(world, dimension, posX, posY - 1, posZ, Blocks.appleleaves.blockID);
                                break;
                            }
                            --posY;
                        }
                        ++i;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Pathway Forest")) {
                tr.addForestTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Umbrella Forest")) {
                tr.addUmbrellaTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Bulb Forest")) {
                tr.addBulbTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Loop Forest")) {
                tr.addlooplowspiralTree(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (b.uniquename.equals("DangerZone:Pathway Loop Forest II")) {
                tr.addloopTree(world, dimension, chunkx << 4, chunkz << 4);
            }
            if (world.rand.nextInt(8) == 1) {
                int howmany = 2 + world.rand.nextInt(6);
                m = 0;
                while (m < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    int iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_purple.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (world.rand.nextInt(64) == 1) {
                int howmany = 1 + world.rand.nextInt(5);
                m = 0;
                while (m < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    int iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            if (world.rand.nextInt(3) != 0) {
                                world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant3.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Rugged Hills Dimension")) {
            int posY3;
            int posZ;
            int i;
            if (world.rand.nextInt(18) == 1) {
                int howmany = 2 + world.rand.nextInt(6);
                m = 0;
                while (m < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    int iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.flower_purple.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            if (world.rand.nextInt(100) == 1) {
                int howmany = 1 + world.rand.nextInt(5);
                m = 0;
                while (m < howmany) {
                    int ix = (chunkx << 4) + world.rand.nextInt(16);
                    iz = (chunkz << 4) + world.rand.nextInt(16);
                    int iy = 100;
                    while (iy > 50) {
                        if (world.getblock(dimension, ix, iy, iz) == Blocks.grassblock.blockID && world.getblock(dimension, ix, iy + 1, iz) == 0) {
                            world.setblock(dimension, ix, iy, iz, Blocks.dirt.blockID);
                            if (world.rand.nextInt(3) != 0) {
                                world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant.blockID);
                                break;
                            }
                            world.setblock(dimension, ix, iy + 1, iz, Blocks.rice_plant3.blockID);
                            break;
                        }
                        --iy;
                    }
                    ++m;
                }
            }
            int howoften = 30;
            int howmany = 1;
            if (b.uniquename.equals("DangerZone:Rugged Hills") && world.rand.nextInt(howoften) == 0) {
                int what2 = world.rand.nextInt(3);
                i = 0;
                while (i < howmany) {
                    int posX3 = (chunkx << 4) + world.rand.nextInt(16);
                    posZ = (chunkz << 4) + world.rand.nextInt(16);
                    posY3 = 90;
                    while (posY3 > 50) {
                        if (world.getblock(dimension, posX3, posY3, posZ) == 0 && world.getblock(dimension, posX3, posY3 - 1, posZ) == Blocks.grassblock.blockID) {
                            if (what2 == 0) {
                                tr.makeFruitTree(world, dimension, posX3, posY3 - 1, posZ, Blocks.peachleaves.blockID);
                                break;
                            }
                            if (what2 != 1) break;
                            tr.makeFruitTree(world, dimension, posX3, posY3 - 1, posZ, Blocks.appleleaves.blockID);
                            break;
                        }
                        --posY3;
                    }
                    ++i;
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains")) {
                howoften = 8;
                howmany = 1 + world.rand.nextInt(3);
                if (world.rand.nextInt(howoften) == 0) {
                    int what3 = world.rand.nextInt(3);
                    i = 0;
                    while (i < howmany) {
                        int posX4 = (chunkx << 4) + world.rand.nextInt(16);
                        posZ = (chunkz << 4) + world.rand.nextInt(16);
                        posY3 = 90;
                        while (posY3 > 50) {
                            if (world.getblock(dimension, posX4, posY3, posZ) == 0 && world.getblock(dimension, posX4, posY3 - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what3 == 0) {
                                    tr.makeFruitTree(world, dimension, posX4, posY3 - 1, posZ, Blocks.peachleaves.blockID);
                                    break;
                                }
                                if (what3 != 1) break;
                                tr.makeFruitTree(world, dimension, posX4, posY3 - 1, posZ, Blocks.appleleaves.blockID);
                                break;
                            }
                            --posY3;
                        }
                        ++i;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains II")) {
                howoften = 3;
                howmany = 1;
                if (world.rand.nextInt(howoften) == 0) {
                    int what4 = world.rand.nextInt(3);
                    i = 0;
                    while (i < howmany) {
                        int posX5 = (chunkx << 4) + world.rand.nextInt(16);
                        posZ = (chunkz << 4) + world.rand.nextInt(16);
                        posY3 = 90;
                        while (posY3 > 50) {
                            if (world.getblock(dimension, posX5, posY3, posZ) == 0 && world.getblock(dimension, posX5, posY3 - 1, posZ) == Blocks.grassblock.blockID) {
                                if (what4 == 0) {
                                    tr.bowlTree(world, dimension, posX5, posY3 - 1, posZ);
                                    break;
                                }
                                if (what4 != 1) break;
                                tr.doublebowlTree(world, dimension, posX5, posY3 - 1, posZ);
                                break;
                            }
                            --posY3;
                        }
                        ++i;
                    }
                }
            }
            if (b.uniquename.equals("DangerZone:Rugged Plains Desert")) {
                tr.addScrubTrees(world, dimension, chunkx << 4, chunkz << 4);
            }
        }
        if (Dimensions.getName(dimension).equals("DangerZone: Sky Islands Dimension")) {
            int howmany = 0;
            int howoften = 8;
            howmany = world.rand.nextInt(3);
            if (world.rand.nextInt(howoften) == 0) {
                int i = 0;
                while (i < howmany) {
                    posX = (chunkx << 4) + world.rand.nextInt(16);
                    int posZ = (chunkz << 4) + world.rand.nextInt(16);
                    posY = 220;
                    while (posY > 100) {
                        if (world.getblock(dimension, posX, posY, posZ) == 0 && world.getblock(dimension, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                            tr.vaseTree(world, dimension, posX, posY - 1, posZ);
                            break;
                        }
                        --posY;
                    }
                    ++i;
                }
            }
        }
    }

    public void add_cave(World world, int dimension, int chunkx, int chunkz, int recur, float mxw, float mxlen, double startx, double starty, double startz) {
        if (!DangerZone.generatecaves) {
            return;
        }
        if (recur > 2) {
            return;
        }
        if (mxw < 0.0f) {
            return;
        }
        if (mxlen < 10.0f) {
            return;
        }
        if (recur == 0 && world.rand.nextInt(32 + (chunkx & 0x3F) * 8 + (chunkz & 0x3F) * 8) != 0) {
            return;
        }
        double dxz = world.rand.nextFloat() * 360.0f;
        double dy = (world.rand.nextFloat() - world.rand.nextFloat()) * 25.0f;
        double ddxz = world.rand.nextFloat() - world.rand.nextFloat();
        double ddy = world.rand.nextFloat() - world.rand.nextFloat();
        ddxz *= 2.0;
        double width = 2.0f + world.rand.nextFloat() * mxw;
        double length = mxlen + world.rand.nextFloat() * mxlen;
        double curx = startx;
        double cury = starty;
        double curz = startz;
        int i = 0;
        while ((double)i < length) {
            double currentwidth;
            if (cury > 35.0) {
                if (dy > 0.0) {
                    dy = -dy;
                }
                if (ddy > 0.0) {
                    ddy = -ddy;
                }
            }
            if (cury < 0.0) {
                if (dy < 0.0) {
                    dy = -dy;
                }
                if (ddy < 0.0) {
                    ddy = -ddy;
                }
            }
            if (world.rand.nextInt(25) == 1) {
                this.add_cave(world, dimension, chunkx, chunkz, recur + 1, mxw - 1.0f, (float)(length / 2.0), curx, cury, curz);
            }
            if ((currentwidth = (double)((float)Math.sin((double)i / length * Math.PI)) * width) > 1.0) {
                int da = 10;
                if (currentwidth < 4.0) {
                    da = 15;
                }
                if (currentwidth > 6.0) {
                    da = 5;
                }
                double dirang = (float)Math.toRadians(dxz - 90.0);
                double dirax = (float)Math.cos(dirang);
                double diraz = (float)Math.sin(dirang);
                int j = 0;
                while (j < 360) {
                    double currad = 0.0;
                    double ty = (float)Math.sin(Math.toRadians(j));
                    double tt = (float)Math.cos(Math.toRadians(j));
                    double tx = (float)(dirax * tt);
                    double tz = (float)(diraz * tt);
                    while (currad < currentwidth) {
                        int bid;
                        if ((int)(cury + ty * (currad += (double)0.2f)) <= 0 || !Blocks.isSolid(bid = world.getblock(dimension, (int)(curx + tx * currad), (int)(cury + ty * currad), (int)(curz + tz * currad)))) continue;
                        world.setblocknonotify(dimension, (int)(curx + tx * currad), (int)(cury + ty * currad), (int)(curz + tz * currad), 0);
                    }
                    j += da;
                }
            }
            curx += Math.cos(Math.toRadians(dxz));
            curz += Math.sin(Math.toRadians(dxz));
            dxz += ddxz;
            cury += Math.sin(Math.toRadians(dy));
            dy += ddy;
            if (world.rand.nextInt(20) == 1) {
                dy = (world.rand.nextFloat() - world.rand.nextFloat()) * 25.0f;
                ddy = world.rand.nextFloat() - world.rand.nextFloat();
            }
            if (world.rand.nextInt(50) == 1) {
                dxz += (double)(world.rand.nextFloat() * 45.0f);
                ddxz = world.rand.nextFloat() - world.rand.nextFloat();
                ddxz *= 2.0;
            }
            ++i;
        }
    }

    public void add_dungeon(World world, int dimension, int chunkx, int chunkz) {
        int bid;
        if (world.rand.nextInt(64) != 0) {
            return;
        }
        int x = chunkx << 4;
        int z = chunkz << 4;
        int xoff = world.rand.nextInt(16);
        int zoff = world.rand.nextInt(16);
        int yoff = world.rand.nextInt(40) + 5;
        int i = 0;
        while (i < 11) {
            int j = 0;
            while (j < 5) {
                int k = 0;
                while (k < 11) {
                    bid = 0;
                    if (i == 0 || i == 10) {
                        bid = Blocks.greystone.blockID;
                    }
                    if (j == 0 || j == 4) {
                        bid = Blocks.greystone.blockID;
                    }
                    if (k == 0 || k == 10) {
                        bid = Blocks.greystone.blockID;
                    }
                    world.setblocknonotify(dimension, x + xoff + i, yoff + j, z + zoff + k, bid);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int type = world.rand.nextInt(3);
        bid = Blocks.ratspawner.blockID;
        if (type == 1) {
            bid = Blocks.werewolfspawner.blockID;
        }
        if (type == 2) {
            bid = Blocks.vampirespawner.blockID;
        }
        world.setblock(dimension, x + xoff + 5, yoff + 1, z + zoff + 5, bid);
        Utils.add_chest(world, dimension, x + xoff + 5, yoff + 1, z + zoff + 1, things);
    }
}

