/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.CommandHandler;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityCloud;
import dangerzone.entities.EntityFire;
import dangerzone.entities.EntityLiving;
import java.util.StringTokenizer;

public class DZCommandHandler
extends CommandHandler {
    @Override
    public boolean doCommand(Player pl, String cmd) {
        StringTokenizer st = new StringTokenizer(cmd);
        boolean retval = false;
        if (!pl.world.isServer) {
            return false;
        }
        String s = st.nextToken();
        if (!st.hasMoreTokens()) {
            return true;
        }
        s = st.nextToken();
        if (s.equalsIgnoreCase("time")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x40) == 0) {
                return false;
            }
            if (st.hasMoreTokens() && (s = st.nextToken()).equalsIgnoreCase("set") && st.hasMoreTokens()) {
                s = st.nextToken();
                if (s.equalsIgnoreCase("day")) {
                    DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay / 4;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    retval = true;
                } else if (s.equalsIgnoreCase("night")) {
                    DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay * 3 / 4;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    retval = true;
                } else if (s.equalsIgnoreCase("dawn")) {
                    DangerZone.server_world.timetimer = 0;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    retval = true;
                } else if (s.equalsIgnoreCase("dusk")) {
                    DangerZone.server_world.timetimer = DangerZone.server_world.lengthOfDay / 2;
                    DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                    retval = true;
                } else {
                    int newtime;
                    try {
                        newtime = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        newtime = 0;
                    }
                    if (newtime >= 0 && newtime <= DangerZone.server_world.lengthOfDay) {
                        DangerZone.server_world.timetimer = newtime;
                        DangerZone.server.sendTimeToAll(DangerZone.server_world.timetimer, DangerZone.server_world.lengthOfDay);
                        retval = true;
                    }
                }
            }
        } else if (s.equalsIgnoreCase("tp") || s.equalsIgnoreCase("teleport")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 4) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                Entity e = DangerZone.server.entityManager.findPlayerByName(s);
                if (e != null) {
                    Utils.doTeleport(pl, e.dimension, e.posx, e.posy, e.posz);
                    retval = true;
                } else {
                    int newz = 0;
                    int newy = 0;
                    int newx = 0;
                    try {
                        newx = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ex) {
                        newx = 0;
                    }
                    if (st.hasMoreTokens()) {
                        s = st.nextToken();
                        try {
                            newy = Integer.parseInt(s);
                        }
                        catch (NumberFormatException ex) {
                            newy = 0;
                        }
                    }
                    if (st.hasMoreTokens()) {
                        s = st.nextToken();
                        try {
                            newz = Integer.parseInt(s);
                        }
                        catch (NumberFormatException ex) {
                            newz = 0;
                        }
                    }
                    if (newx > 0 && newy > 0 && newy < 256 && newz > 0) {
                        Utils.doTeleport(pl, pl.dimension, newx, newy, newz);
                        retval = true;
                    }
                }
            }
        } else if (s.equalsIgnoreCase("stop") || s.equalsIgnoreCase("shutdown")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x80) == 0) {
                return false;
            }
            DangerZone.gameover = 1;
            retval = true;
        } else if (s.equalsIgnoreCase("show")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x20) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                if (s.equalsIgnoreCase("eid")) {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null) {
                            e.setPetName(String.format("%d", i));
                            retval = true;
                        }
                        ++i;
                    }
                } else {
                    int i = 1;
                    while (i < DangerZone.max_entities) {
                        Entity e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null) {
                            e.setPetName(null);
                            retval = true;
                        }
                        ++i;
                    }
                }
            }
        } else if (s.equalsIgnoreCase("weather")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x10) == 0) {
                return false;
            }
            if (st.hasMoreTokens() && (s = st.nextToken()).equalsIgnoreCase("clear")) {
                int i = 1;
                while (i < DangerZone.max_entities) {
                    Entity e = DangerZone.server.entityManager.findEntityByID(i);
                    if (e != null) {
                        if (e instanceof EntityCloud && (e.getBID() == Blocks.cloud_thunder.blockID || e.getBID() == Blocks.cloud_rain.blockID)) {
                            e.deadflag = true;
                        }
                        retval = true;
                    }
                    ++i;
                }
            }
        } else if (s.equalsIgnoreCase("kill")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 8) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                Entity e;
                int i;
                s = st.nextToken();
                if (s.equalsIgnoreCase("all")) {
                    i = 1;
                    while (i < DangerZone.max_entities) {
                        e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && !(e instanceof Player) && e instanceof EntityLiving) {
                            e.deadflag = true;
                        }
                        ++i;
                    }
                    retval = true;
                }
                if (s.equalsIgnoreCase("hostile")) {
                    i = 1;
                    while (i < DangerZone.max_entities) {
                        e = DangerZone.server.entityManager.findEntityByID(i);
                        if (e != null && e.temperament == 1) {
                            e.deadflag = true;
                        }
                        ++i;
                    }
                    retval = true;
                }
            }
        } else if (s.equalsIgnoreCase("nofire")) {
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x100) == 0) {
                return false;
            }
            int i = 1;
            while (i < DangerZone.max_entities) {
                Entity e = DangerZone.server.entityManager.findEntityByID(i);
                if (e != null && !(e instanceof Player) && e instanceof EntityFire) {
                    e.deadflag = true;
                }
                ++i;
            }
            retval = true;
        } else if (s.equalsIgnoreCase("op")) {
            Entity e;
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens() && (e = DangerZone.server.entityManager.findPlayerByName(s = st.nextToken())) != null) {
                Player plyr = (Player)e;
                plyr.player_privs = -1;
                DangerZone.server.save_privs(plyr.myname, plyr.player_privs);
                retval = true;
            }
        } else if (s.equalsIgnoreCase("deop")) {
            Entity e;
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens() && (e = DangerZone.server.entityManager.findPlayerByName(s = st.nextToken())) != null) {
                Player plyr = (Player)e;
                plyr.player_privs = 0;
                DangerZone.server.save_privs(plyr.myname, plyr.player_privs);
                retval = true;
            }
        } else if (s.equalsIgnoreCase("givepriv")) {
            Entity e;
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens() && (e = DangerZone.server.entityManager.findPlayerByName(s = st.nextToken())) != null) {
                int newpriv = 0;
                if (st.hasMoreTokens()) {
                    s = st.nextToken();
                    if (s.equalsIgnoreCase("gamemode")) {
                        newpriv = 1;
                    }
                    if (s.equalsIgnoreCase("op")) {
                        newpriv = 2;
                    }
                    if (s.equalsIgnoreCase("teleport")) {
                        newpriv = 4;
                    }
                    if (s.equalsIgnoreCase("kill")) {
                        newpriv = 8;
                    }
                    if (s.equalsIgnoreCase("weather")) {
                        newpriv = 16;
                    }
                    if (s.equalsIgnoreCase("misc")) {
                        newpriv = 32;
                    }
                    if (s.equalsIgnoreCase("time")) {
                        newpriv = 64;
                    }
                    if (s.equalsIgnoreCase("shutdown")) {
                        newpriv = 128;
                    }
                    if (s.equalsIgnoreCase("nofire")) {
                        newpriv = 256;
                    }
                }
                Player plyr = (Player)e;
                plyr.player_privs |= newpriv;
                DangerZone.server.save_privs(plyr.myname, plyr.player_privs);
                retval = true;
            }
        } else if (s.equalsIgnoreCase("takepriv")) {
            Entity e;
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens() && (e = DangerZone.server.entityManager.findPlayerByName(s = st.nextToken())) != null) {
                int newpriv = 0;
                if (st.hasMoreTokens()) {
                    s = st.nextToken();
                    if (s.equalsIgnoreCase("gamemode")) {
                        newpriv = 1;
                    }
                    if (s.equalsIgnoreCase("op")) {
                        newpriv = 2;
                    }
                    if (s.equalsIgnoreCase("teleport")) {
                        newpriv = 4;
                    }
                    if (s.equalsIgnoreCase("kill")) {
                        newpriv = 8;
                    }
                    if (s.equalsIgnoreCase("weather")) {
                        newpriv = 16;
                    }
                    if (s.equalsIgnoreCase("misc")) {
                        newpriv = 32;
                    }
                    if (s.equalsIgnoreCase("time")) {
                        newpriv = 64;
                    }
                    if (s.equalsIgnoreCase("shutdown")) {
                        newpriv = 128;
                    }
                    if (s.equalsIgnoreCase("nofire")) {
                        newpriv = 256;
                    }
                }
                Player plyr = (Player)e;
                plyr.player_privs &= ~newpriv;
                DangerZone.server.save_privs(plyr.myname, plyr.player_privs);
                retval = true;
            }
        } else if (s.equalsIgnoreCase("mount")) {
            Entity bottom;
            Entity top;
            if ((pl.player_privs & 2) == 0 && (pl.player_privs & 0x20) == 0) {
                return false;
            }
            int rider = 0;
            int ridden = 0;
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                try {
                    rider = Integer.parseInt(s);
                }
                catch (NumberFormatException ex) {
                    rider = 0;
                }
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                try {
                    ridden = Integer.parseInt(s);
                }
                catch (NumberFormatException ex) {
                    ridden = 0;
                }
            }
            if (rider != 0 && ridden != 0 && (top = DangerZone.server.entityManager.findEntityByID(rider)) != null && (bottom = DangerZone.server.entityManager.findEntityByID(ridden)) != null) {
                bottom.Mount(top);
                retval = true;
            }
        } else if (s.equalsIgnoreCase("cavegeneration")) {
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.generatecaves = s.equalsIgnoreCase("true");
                retval = true;
            }
        } else if (s.equalsIgnoreCase("playnicely")) {
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.playnicely = s.equalsIgnoreCase("true");
                retval = true;
            }
        } else if (s.equalsIgnoreCase("validateplayers")) {
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.require_valid_passwords = s.equalsIgnoreCase("true");
                retval = true;
            }
        } else if (s.equalsIgnoreCase("defaultprivs")) {
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                int newdefprivs;
                s = st.nextToken();
                try {
                    newdefprivs = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    newdefprivs = 0;
                }
                DangerZone.default_privs = newdefprivs;
                retval = true;
            }
        } else if (s.equalsIgnoreCase("maxplayers")) {
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                int newmaxplayers;
                s = st.nextToken();
                try {
                    newmaxplayers = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    newmaxplayers = 10;
                }
                if (newmaxplayers < 2 || newmaxplayers > 255) {
                    newmaxplayers = 10;
                }
                DangerZone.max_players_on_server = newmaxplayers;
                retval = true;
            }
        } else if (s.equalsIgnoreCase("ban")) {
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.server.setBanned(s, true);
                retval = true;
            }
        } else if (s.equalsIgnoreCase("unban")) {
            if ((pl.player_privs & 2) == 0) {
                return false;
            }
            if (st.hasMoreTokens()) {
                s = st.nextToken();
                DangerZone.server.setBanned(s, false);
                retval = true;
            }
        }
        return retval;
    }
}

