/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.CustomPacket;
import dangerzone.CustomPackets;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.ListInt;
import dangerzone.NetworkInputBuffer;
import dangerzone.NetworkOutputBuffer;
import dangerzone.Player;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityChest;

public class ChestInventoryPacket
extends CustomPacket {
    public ChestInventoryPacket() {
        this.uniquename = "DangerZone:ChestInventoryPacket";
        this.packetID = CustomPackets.getIDByName(this.uniquename);
    }

    public void inventoryUpdateToServer(int eid, int index, InventoryContainer ic) {
        NetworkOutputBuffer os = DangerZone.server_connection.getOutputStream();
        if (os == null) {
            return;
        }
        int subtype = 0;
        os.writeInt(this.packetID);
        os.writeInt(eid);
        os.writeInt(subtype);
        os.writeInt(index);
        if (ic != null) {
            os.writeInt(ic.count);
            os.writeInt(ic.bid);
            os.writeInt(ic.iid);
            os.writeInt(ic.currentuses);
        } else {
            int i = 0;
            os.writeInt(i);
            os.writeInt(i);
            os.writeInt(i);
            os.writeInt(i);
        }
        DangerZone.server_connection.releaseOutputStream();
    }

    public void requestContents(int eid) {
        NetworkOutputBuffer os = DangerZone.server_connection.getOutputStream();
        if (os == null) {
            return;
        }
        int subtype = 1;
        os.writeInt(this.packetID);
        os.writeInt(eid);
        os.writeInt(subtype);
        DangerZone.server_connection.releaseOutputStream();
    }

    @Override
    public void messageFromServer(NetworkInputBuffer is) {
        int subtype = 0;
        int count = 0;
        int eid = 0;
        int bid = 0;
        int iid = 0;
        int currentuses = 0;
        int index = 0;
        eid = is.readInt();
        subtype = is.readInt();
        if (subtype == 0) {
            index = is.readInt();
            count = is.readInt();
            bid = is.readInt();
            iid = is.readInt();
            currentuses = is.readInt();
            EntityChest ce = (EntityChest)DangerZone.entityManager.findEntityByID(eid);
            if (ce != null && index >= 0 && index < ce.inventory.length) {
                if (count == 0) {
                    ce.inventory[index] = null;
                } else {
                    InventoryContainer ic = new InventoryContainer();
                    ic.count = count;
                    ic.bid = bid;
                    ic.iid = iid;
                    ic.currentuses = currentuses;
                    ce.inventory[index] = ic;
                }
            }
        }
    }

    public void inventoryUpdateToClient(Player p, int eid, int index, InventoryContainer ic) {
        if (p == null) {
            DangerZone.server.player_list_lock.lock();
            for (ListInt st : DangerZone.server.server_thread_list) {
                if (DangerZone.server.players[st.index] == null) continue;
                this.inventoryUpdateToClient(DangerZone.server.players[st.index].p, eid, index, ic);
            }
            DangerZone.server.player_list_lock.unlock();
        } else {
            NetworkOutputBuffer os = p.server_thread.getOutputStream();
            if (os == null) {
                return;
            }
            int subtype = 0;
            os.writeInt(this.packetID);
            os.writeInt(eid);
            os.writeInt(subtype);
            os.writeInt(index);
            if (ic != null) {
                os.writeInt(ic.count);
                os.writeInt(ic.bid);
                os.writeInt(ic.iid);
                os.writeInt(ic.currentuses);
            } else {
                int i = 0;
                os.writeInt(i);
                os.writeInt(i);
                os.writeInt(i);
                os.writeInt(i);
            }
            p.server_thread.releaseOutputStream();
        }
    }

    @Override
    public void messageFromClient(Player plyr, NetworkInputBuffer is) {
        block6: {
            Entity ent;
            int eid;
            int subtype;
            block5: {
                subtype = 0;
                int count = 0;
                eid = 0;
                int bid = 0;
                int iid = 0;
                int currentuses = 0;
                int index = 0;
                eid = is.readInt();
                subtype = is.readInt();
                if (subtype != 0) break block5;
                index = is.readInt();
                count = is.readInt();
                bid = is.readInt();
                iid = is.readInt();
                currentuses = is.readInt();
                Entity ent2 = DangerZone.server.entityManager.findEntityByID(eid);
                if (ent2 == null || !(ent2 instanceof EntityChest)) break block6;
                EntityChest ce = (EntityChest)ent2;
                if (index < 0 || index >= ce.inventory.length) break block6;
                if (count == 0) {
                    ce.inventory[index] = null;
                } else {
                    InventoryContainer ic = new InventoryContainer();
                    ic.count = count;
                    ic.bid = bid;
                    ic.iid = iid;
                    ic.currentuses = currentuses;
                    ce.inventory[index] = ic;
                }
                DangerZone.server.player_list_lock.lock();
                for (ListInt st : DangerZone.server.server_thread_list) {
                    if (DangerZone.server.players[st.index] == null || DangerZone.server.players[st.index].p.dimension != plyr.dimension) continue;
                    this.inventoryUpdateToClient(DangerZone.server.players[st.index].p, eid, index, ce.inventory[index]);
                }
                DangerZone.server.player_list_lock.unlock();
                break block6;
            }
            if (subtype == 1 && (ent = DangerZone.server.entityManager.findEntityByID(eid)) != null && ent instanceof EntityChest) {
                EntityChest ce = (EntityChest)ent;
                int i = 0;
                while (i < ce.inventory.length) {
                    this.inventoryUpdateToClient(plyr, eid, i, ce.inventory[i]);
                    ++i;
                }
            }
        }
    }
}

