/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.Chunk;
import dangerzone.CommandHandlers;
import dangerzone.Coords;
import dangerzone.CustomPackets;
import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.NetworkInputBuffer;
import dangerzone.NetworkOutputBuffer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ColoringBlock;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityExp;
import dangerzone.entities.EntityFire;
import dangerzone.items.Items;
import dangerzone.threads.ChunkSender;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;

public class ServerThread
implements Runnable {
    public Player p;
    NetworkOutputBuffer objectOutput = null;
    NetworkInputBuffer objectInput = null;
    private Lock lock = new ReentrantLock();
    private Lock lightinglock = new ReentrantLock();
    public volatile int fatal_error = 0;
    private volatile int ready = 0;
    private volatile boolean lightready = false;
    private volatile float lightvalue = 0.0f;
    private int save_ticker = 0;
    private ChunkSender chunker = null;
    private long timechecktime;
    private long averagetime;
    private int averagefps;

    ServerThread(Player pl) {
        this.p = pl;
        this.p.server_thread = this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block65: {
            name = null;
            forceall = false;
            packettype = 0;
            do_respawn = false;
            save_player = true;
            this.averagetime = 0L;
            this.averagefps = 100;
            this.timechecktime = System.currentTimeMillis();
            this.lock.lock();
            try {
                this.p.toClient.setReceiveBufferSize(131072);
            }
            catch (SocketException e2) {
                e2.printStackTrace();
            }
            try {
                this.p.toClient.setSendBufferSize(0x200000);
            }
            catch (SocketException e2) {
                e2.printStackTrace();
            }
            try {
                this.p.toClient.setSoTimeout(15000);
            }
            catch (SocketException e2) {
                e2.printStackTrace();
            }
            try {
                this.p.toClient.setTcpNoDelay(true);
            }
            catch (SocketException e2) {
                e2.printStackTrace();
            }
            try {
                block66: {
                    block67: {
                        this.objectInput = new NetworkInputBuffer(this.p.toClient.getInputStream(), 32768);
                        packettype = this.objectInput.readInt();
                        if (packettype != 86) {
                            this.lock.unlock();
                            this.objectInput.close();
                            try {
                                this.p.toClient.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            DangerZone.server.removeMe(this);
                            return;
                        }
                        this.objectOutput = new NetworkOutputBuffer(this.p.toClient.getOutputStream(), 65536);
                        clientversion = this.objectInput.readString();
                        if (clientversion == null || !clientversion.equals(DangerZone.versionstring)) break block66;
                        this.objectOutput.writeString(DangerZone.versionstring);
                        this.objectOutput.flush();
                        packettype = this.objectInput.readInt();
                        playername = this.objectInput.readString();
                        playerpassword = this.objectInput.readString();
                        if (packettype != 0) {
                            this.getSkin();
                            this.sendModNames();
                            this.objectOutput.flush();
                            this.sendServerIDs();
                            this.objectOutput.flush();
                            if (playername.equals("Player") || DangerZone.server.entityManager.findPlayerByName(playername) != null) {
                                save_player = false;
                                while (DangerZone.server.entityManager.findPlayerByName(newname = String.format("Player %d", new Object[]{DangerZone.rand.nextInt(1000)})) != null) {
                                }
                                playername = newname;
                            }
                            this.objectOutput.writeString(playername);
                            this.objectOutput.flush();
                        }
                        this.p.myname = playername;
                        this.p.setPetName(playername);
                        do_respawn = ServerThread.loadPlayer(this.p);
                        this.p.myname = playername;
                        this.p.setPetName(playername);
                        if (!this.verify_playername(this.p, playername, playerpassword)) {
                            packettype = 1;
                            this.objectOutput.writeInt(packettype);
                            this.objectOutput.flush();
                            this.fatal_error = 1;
                        }
                        if (this.fatal_error == 0) {
                            if (DangerZone.server.isBanned(playername)) {
                                packettype = 2;
                                this.objectOutput.writeInt(packettype);
                                this.objectOutput.flush();
                                this.fatal_error = 1;
                            } else {
                                packettype = 0;
                                this.objectOutput.writeInt(packettype);
                                this.objectOutput.flush();
                            }
                        }
                        if (this.fatal_error != 0) break block65;
                        this.p.world = DangerZone.server_world;
                        this.p.init();
                        if (!(this.p.getHealth() <= 0.0f)) break block67;
                        this.p.setVarFloat(1, this.p.getMaxHealth());
                        this.p.setExperience(0);
                        iw = 0;
                        if (true) ** GOTO lbl95
                        do {
                            this.p.setVarInventory(iw, null);
                            ++iw;
lbl95:
                            // 2 sources

                            this.p.getClass();
                        } while (iw < 100);
                        do_respawn = true;
                    }
                    this.sendPlayerToPlayer(this.p);
                    id = DangerZone.server.entityManager.addEntity(this.p);
                    if (id <= 0) {
                        this.fatal_error = 1;
                    } else {
                        this.objectOutput.writeInt(this.p.entityID);
                        this.objectOutput.flush();
                    }
                    break block65;
                }
                this.objectOutput.writeString(DangerZone.versionstring);
                this.objectOutput.flush();
                this.fatal_error = 1;
            }
            catch (IOException e) {
                this.fatal_error = 1;
            }
        }
        if (this.fatal_error != 0) {
            this.lock.unlock();
            if (this.objectInput != null) {
                this.objectInput.close();
            }
            if (this.objectOutput != null) {
                this.objectOutput.close();
            }
            try {
                this.p.toClient.close();
            }
            catch (IOException cnk) {
                // empty catch block
            }
            if (this.p.entityID > 0) {
                DangerZone.server.entityManager.removeEntityByID(this.p.entityID);
            }
            DangerZone.server.removeMe(this);
            return;
        }
        this.chunker = new ChunkSender(this.p, this);
        cnk = new Thread(this.chunker);
        cnk.start();
        this.ready = 1;
        this.lock.unlock();
        if (this.fatal_error == 0 && do_respawn) {
            this.p.posx += (DangerZone.server_world.rand.nextFloat() - DangerZone.server_world.rand.nextFloat()) * 64.0f;
            this.p.posz += (DangerZone.server_world.rand.nextFloat() - DangerZone.server_world.rand.nextFloat()) * 64.0f;
            Dimensions.DimensionArray[this.p.dimension].teleportToDimension(this.p, DangerZone.server_world, this.p.dimension, (int)this.p.posx, (int)this.p.posy, (int)this.p.posz);
            this.sendTeleportToPlayer(this.p.dimension, this.p.posx, this.p.posy, this.p.posz);
        }
        DangerZone.server.sendChatToAllExcept(String.format("Player: %s connected.\n", new Object[]{this.p.myname}), this.p);
        while (DangerZone.gameover == 0 && this.fatal_error == 0) {
            if (this.objectOutput.errorOccurred() || this.objectInput.errorOccurred()) break;
            packettype = this.objectInput.readInt();
            if (packettype == 135) {
                d = this.objectInput.readInt();
                x = this.objectInput.readInt();
                y = this.objectInput.readInt();
                z = this.objectInput.readInt();
                cl = new Coords();
                cl.d = d;
                cl.x = x >> 4;
                cl.z = z >> 4;
                this.chunker.addCoords(cl);
                continue;
            }
            if (packettype == 133) {
                d = this.objectInput.readInt();
                x = this.objectInput.readInt();
                y = this.objectInput.readInt();
                z = this.objectInput.readInt();
                id = this.objectInput.readInt();
                meta = this.objectInput.readInt();
                DangerZone.server_world.setblockandmeta(d, x, y, z, id, meta);
                DangerZone.server.sendBlockToAllExcept(this, d, x, y, z, id, meta);
                continue;
            }
            if (packettype == 152) {
                this.lightvalue = this.objectInput.readFloat();
                this.lightready = true;
                continue;
            }
            if (packettype == 129) {
                d = this.objectInput.readInt();
                mylongtime = System.currentTimeMillis();
                this.averagetime = (this.averagetime * 3L + (mylongtime -= this.timechecktime)) / 4L;
                this.averagefps = (this.averagefps * 3 + d) / 4;
                if (!DangerZone.show_server_stats) continue;
                System.out.printf("player: %s, averagetime = %d, fps = %d\n", new Object[]{this.p.myname, this.averagetime, this.averagefps});
                continue;
            }
            if (packettype == 166) {
                d = this.objectInput.readInt();
                if ((this.p.player_privs & 1) == 0 && (this.p.player_privs & 2) == 0) continue;
                this.sendNewGameMode(d);
                this.p.setGameMode(d);
                continue;
            }
            if (packettype == 147) {
                which = this.objectInput.readInt();
                slot = this.objectInput.readInt();
                bid = this.objectInput.readInt();
                iid = this.objectInput.readInt();
                count = this.objectInput.readInt();
                uses = this.objectInput.readInt();
                if (count == 0) {
                    ic = null;
                } else {
                    ic = new InventoryContainer();
                    ic.bid = bid;
                    ic.iid = iid;
                    ic.count = count;
                    ic.currentuses = uses;
                }
                if (which == 0) {
                    this.p.setHotbar(slot, ic);
                }
                if (which != 1) continue;
                this.p.setInventory(slot, ic);
                continue;
            }
            if (packettype == 148) {
                which = this.objectInput.readInt();
                what = this.objectInput.readInt();
                d = this.objectInput.readInt();
                if (which != 0) continue;
                DangerZone.server.sendPlayerActionToAllExcept(this.p, which, what);
                if (what == 0) {
                    this.p.leftclick(DangerZone.server_world, 0, 0, 0, 0, d);
                }
                if (what == 1) {
                    this.p.rightclick(DangerZone.server_world, 0, 0, 0, 0, d);
                }
                if (what != 2 || (itm = Items.getItem(d)) == null) continue;
                itm.onFoodEaten(this.p);
                continue;
            }
            if (packettype == 153) {
                s = this.objectInput.readString();
                DangerZone.server.sendChatToAll(s);
                continue;
            }
            if (packettype == 160) {
                whichpet = this.objectInput.readInt();
                s = this.objectInput.readString();
                ent = DangerZone.server.entityManager.findEntityByID(whichpet);
                if (ent == null) continue;
                ent.setPetName(s);
                continue;
            }
            if (packettype == 156) {
                s = this.objectInput.readString();
                CommandHandlers.parseCommand(this.p, s);
                DangerZone.server.sendCommandToAll(s);
                continue;
            }
            if (packettype == 154) {
                s = this.objectInput.readString();
                which = this.objectInput.readInt();
                d = this.objectInput.readInt();
                px = this.objectInput.readFloat();
                py = this.objectInput.readFloat();
                pz = this.objectInput.readFloat();
                DangerZone.server.sendSpawnParticleToAllExcept(this.p, s, which, d, px, py, pz);
                continue;
            }
            if (packettype == 159) {
                d = this.objectInput.readInt();
                px = this.objectInput.readFloat();
                py = this.objectInput.readFloat();
                pz = this.objectInput.readFloat();
                Utils.doTeleport(this.p, d, px, py, pz);
                continue;
            }
            if (packettype == 144) {
                d = this.objectInput.readInt();
                d = this.objectInput.readInt();
                forceall = false;
                if (d != this.p.dimension) {
                    forceall = true;
                }
                this.p.dimension = d;
                this.p.posx = this.objectInput.readFloat();
                this.p.posy = this.objectInput.readFloat();
                this.p.posz = this.objectInput.readFloat();
                this.p.motionx = this.objectInput.readFloat();
                this.p.motiony = this.objectInput.readFloat();
                this.p.motionz = this.objectInput.readFloat();
                this.p.rotation_pitch = this.objectInput.readFloat();
                this.p.rotation_yaw = this.objectInput.readFloat();
                this.p.rotation_roll = this.objectInput.readFloat();
                this.p.rotation_pitch_head = this.objectInput.readFloat();
                this.p.rotation_yaw_head = this.objectInput.readFloat();
                this.p.rotation_roll_head = this.objectInput.readFloat();
                this.p.rotation_pitch_motion = this.objectInput.readFloat();
                this.p.rotation_yaw_motion = this.objectInput.readFloat();
                this.p.rotation_roll_motion = this.objectInput.readFloat();
                d = this.objectInput.readInt();
                this.p.deadflag = d != 0;
                this.readVarsIntoEntity(this.p);
                ++this.save_ticker;
                if (save_player && this.save_ticker > 600) {
                    ServerThread.savePlayer(this.p);
                    this.save_ticker = 0;
                }
                DangerZone.server.sendPlayerUpdateToAllExcept(this.p, this.p, forceall);
                continue;
            }
            if (packettype == 146) {
                name = this.objectInput.readString();
                e = this.doSpawnEntity(name, pd = this.objectInput.readInt(), px = this.objectInput.readFloat(), py = this.objectInput.readFloat(), pz = this.objectInput.readFloat(), pitch = this.objectInput.readFloat(), yaw = this.objectInput.readFloat(), roll = this.objectInput.readFloat(), mx = this.objectInput.readFloat(), my = this.objectInput.readFloat(), mz = this.objectInput.readFloat());
                if (e != null) {
                    this.readVarsIntoEntity(e);
                    e.init();
                    if (DangerZone.server.entityManager.addEntity(e) <= 0) continue;
                    DangerZone.server.sendSpawnEntityToAll(e);
                    continue;
                }
                this.readVarsIntoNull();
                continue;
            }
            if (packettype == 150) {
                name = this.objectInput.readString();
                pd = this.objectInput.readInt();
                px = this.objectInput.readFloat();
                py = this.objectInput.readFloat();
                pz = this.objectInput.readFloat();
                vol = this.objectInput.readFloat();
                freq = this.objectInput.readFloat();
                DangerZone.server.sendSoundToAllExcept(this.p, name, pd, px, py, pz, vol, freq);
                continue;
            }
            if (packettype == 137) {
                id = this.objectInput.readInt();
                e = DangerZone.server.entityManager.findEntityByID(id);
                if (e == null) continue;
                this.sendSpawnEntityToPlayer(e);
                if (!(e instanceof Player)) continue;
                this.sendSkinToPlayer(e);
                continue;
            }
            if (packettype == 155) {
                id = this.objectInput.readInt();
                e = DangerZone.server.entityManager.findEntityByID(id);
                if (e == null) continue;
                ieid = DangerZone.server.entityManager.removeEntityByID(id);
                e.deadflag = true;
                if (ieid != id) continue;
                DangerZone.server.sendEntityDeathToAll(e);
                continue;
            }
            if (packettype == 164) {
                iid = this.objectInput.readInt();
                d = this.objectInput.readInt();
                x = this.objectInput.readInt();
                y = this.objectInput.readInt();
                z = this.objectInput.readInt();
                colordata = new float[16][16][4];
                i = 0;
                while (i < 16) {
                    j = 0;
                    while (j < 16) {
                        k = 0;
                        while (k < 4) {
                            colordata[i][j][k] = this.objectInput.readFloat();
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                this.doSaveColoringBlock(iid, d, x, y, z, colordata);
                continue;
            }
            CustomPackets.messageFromClient(packettype, this.p, this.objectInput);
        }
        this.fatal_error = 1;
        if (save_player) {
            ServerThread.savePlayer(this.p);
        }
        DangerZone.server.sendEntityRemoveToAllExcept(this.p, this.p);
        DangerZone.server.entityManager.removeEntityByID(this.p.entityID);
        DangerZone.server.removeMe(this);
        if (this.objectInput != null) {
            this.objectInput.close();
        }
        if (this.objectOutput != null) {
            this.objectOutput.close();
        }
        try {
            this.p.toClient.close();
        }
        catch (IOException var32_25) {
            // empty catch block
        }
    }

    private void checkReady() {
        while (this.fatal_error == 0 && DangerZone.gameover == 0) {
            if (this.ready != 0) {
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.fatal_error = 1;
            }
        }
    }

    public void sendSpawnEntityToPlayer(Entity e) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 146;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(e.uniquename);
        this.objectOutput.writeInt(e.entityID);
        this.objectOutput.writeInt(e.dimension);
        this.objectOutput.writeFloat(e.posx);
        this.objectOutput.writeFloat(e.posy);
        this.objectOutput.writeFloat(e.posz);
        this.objectOutput.writeFloat(e.rotation_pitch);
        this.objectOutput.writeFloat(e.rotation_yaw);
        this.objectOutput.writeFloat(e.rotation_roll);
        this.objectOutput.writeFloat(e.rotation_pitch_head);
        this.objectOutput.writeFloat(e.rotation_yaw_head);
        this.objectOutput.writeFloat(e.rotation_roll_head);
        this.objectOutput.writeFloat(e.motionx);
        this.objectOutput.writeFloat(e.motiony);
        this.objectOutput.writeFloat(e.motionz);
        int i = 0;
        while (i < e.maxvars) {
            if (e.entity_ints[i] != 0) {
                this.objectOutput.writeInt(i);
                this.objectOutput.writeInt(e.entity_ints[i]);
            }
            ++i;
        }
        pt = -1;
        this.objectOutput.writeInt(pt);
        i = 0;
        while (i < e.maxvars) {
            if (e.entity_floats[i] != 0.0f) {
                this.objectOutput.writeInt(i);
                this.objectOutput.writeFloat(e.entity_floats[i]);
            }
            ++i;
        }
        pt = -1;
        this.objectOutput.writeInt(pt);
        i = 0;
        while (i < e.maxvars) {
            if (e.entity_strings[i] != null) {
                this.objectOutput.writeInt(i);
                this.objectOutput.writeString(e.entity_strings[i]);
            }
            ++i;
        }
        pt = -1;
        this.objectOutput.writeInt(pt);
        InventoryContainer ic = null;
        i = 0;
        while (i < e.maxinv) {
            ic = e.getVarInventory(i);
            if (ic != null) {
                this.objectOutput.writeInt(i);
                this.objectOutput.writeInt(ic.bid);
                this.objectOutput.writeInt(ic.iid);
                this.objectOutput.writeInt(ic.count);
                this.objectOutput.writeInt(ic.currentuses);
            }
            ++i;
        }
        pt = -1;
        this.objectOutput.writeInt(pt);
        pt = -2;
        this.objectOutput.writeInt(pt);
        this.lock.unlock();
    }

    public void sendChunkToPlayer(Chunk c) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        ++DangerZone.chunks_per_second;
        this.lock.lock();
        int pt = 134;
        int separator = -1;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(c.chunkX);
        this.objectOutput.writeInt(c.chunkZ);
        this.objectOutput.writeInt(c.dimension);
        this.objectOutput.writeInt(c.isDecorated);
        this.objectOutput.writeInt(c.isChanged);
        this.objectOutput.writeInt(c.isValid);
        this.objectOutput.writeInt(c.must_be_written);
        this.objectOutput.writeInt(separator);
        int i = 0;
        while (i < 256) {
            if (c.blockdata[i] != null) {
                this.objectOutput.writeInt(i);
                short curval = c.blockdata[i][0];
                short curcount = 0;
                int indx = 0;
                while (indx < 256) {
                    if (c.blockdata[i][indx] == curval) {
                        curcount = (short)(curcount + 1);
                    } else {
                        this.objectOutput.writeShort(curcount);
                        this.objectOutput.writeShort(curval);
                        curcount = 1;
                        curval = c.blockdata[i][indx];
                    }
                    ++indx;
                }
                this.objectOutput.writeShort(curcount);
                this.objectOutput.writeShort(curval);
            }
            ++i;
        }
        this.objectOutput.writeInt(separator);
        i = 0;
        while (i < 256) {
            if (c.metadata[i] != null) {
                this.objectOutput.writeInt(i);
                this.objectOutput.writeShortArray(c.metadata[i], c.metadata[i].length);
            }
            ++i;
        }
        this.objectOutput.writeInt(separator);
        this.lock.unlock();
    }

    public void sendBlockToPlayer(int d, int x, int y, int z, int id, int meta) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 133;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeInt(x);
        this.objectOutput.writeInt(y);
        this.objectOutput.writeInt(z);
        this.objectOutput.writeInt(id);
        this.objectOutput.writeInt(meta);
        this.lock.unlock();
    }

    public void sendEntityDeathToPlayer(int eid) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 145;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(eid);
        this.lock.unlock();
    }

    public void sendChatToPlayer(String s) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 153;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(s);
        this.flushSendLocked();
        this.lock.unlock();
    }

    public void sendCommandToPlayer(String s) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 156;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(s);
        this.flushSendLocked();
        this.lock.unlock();
    }

    public void sendSpawnParticleToPlayer(String s, int hm, int d, float x, float y, float z) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        if (this.averagetime > 500L) {
            if (DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 1000L && DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 2000L && DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 3000L && DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 4000L && DangerZone.rand.nextBoolean()) {
                return;
            }
        }
        this.lock.lock();
        int pt = 154;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(s);
        this.objectOutput.writeInt(hm);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeFloat(x);
        this.objectOutput.writeFloat(y);
        this.objectOutput.writeFloat(z);
        this.lock.unlock();
    }

    public void sendVelocityUpdateToPlayer(float newx, float newy, float newz) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 151;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeFloat(newx);
        this.objectOutput.writeFloat(newy);
        this.objectOutput.writeFloat(newz);
        this.lock.unlock();
    }

    public void sendPositionAndVelocityUpdateToPlayer(Player p) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 165;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeFloat(p.posx);
        this.objectOutput.writeFloat(p.posy);
        this.objectOutput.writeFloat(p.posz);
        this.objectOutput.writeFloat(p.motionx);
        this.objectOutput.writeFloat(p.motiony);
        this.objectOutput.writeFloat(p.motionz);
        this.lock.unlock();
    }

    public void sendTeleportToPlayer(int dim, float newx, float newy, float newz) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 159;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(dim);
        this.objectOutput.writeFloat(newx);
        this.objectOutput.writeFloat(newy);
        this.objectOutput.writeFloat(newz);
        this.flushSendLocked();
        this.lock.unlock();
    }

    public void sendEntityRemoveToPlayer(int eid) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 138;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(eid);
        this.lock.unlock();
    }

    public float doLightingRequest(int d, int x, int y, int z) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lightinglock.lock();
        this.lightready = false;
        this.lightvalue = DangerZone.server_world.rand.nextFloat();
        this.lock.lock();
        int pt = 152;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(d);
        this.objectOutput.writeInt(x);
        this.objectOutput.writeInt(y);
        this.objectOutput.writeInt(z);
        this.lock.unlock();
        int tries = 100;
        while (tries > 0 && !this.lightready) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            --tries;
        }
        float lv = this.lightvalue;
        this.lightready = false;
        this.lightinglock.unlock();
        return lv;
    }

    public void sendEntityHitToPlayer(int eid, float newhealth) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 149;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(eid);
        this.objectOutput.writeFloat(newhealth);
        this.lock.unlock();
    }

    public void sendPlayerAction(Player p, int which, int what) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 148;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(p.entityID);
        this.objectOutput.writeInt(which);
        this.objectOutput.writeInt(what);
        this.lock.unlock();
    }

    public void sendExpAdjust(int what) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 157;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(what);
        this.lock.unlock();
    }

    public void sendVarIntUpdate(int which, int val) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 161;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(which);
        this.objectOutput.writeInt(val);
        this.lock.unlock();
    }

    public void sendVarFloatUpdate(int which, float val) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 163;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(which);
        this.objectOutput.writeFloat(val);
        this.lock.unlock();
    }

    public void sendMountCommand(int which) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 162;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(which);
        this.lock.unlock();
    }

    public void sendInventoryUpdateToPlayer(int which, int slot, InventoryContainer ic) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 147;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(which);
        this.objectOutput.writeInt(slot);
        if (ic != null) {
            this.objectOutput.writeInt(ic.bid);
            this.objectOutput.writeInt(ic.iid);
            this.objectOutput.writeInt(ic.count);
            this.objectOutput.writeInt(ic.currentuses);
        } else {
            pt = 0;
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(pt);
            this.objectOutput.writeInt(pt);
        }
        this.flushSendLocked();
        this.lock.unlock();
    }

    public void sendEntityUpdateToPlayer(Entity e) {
        this.checkReady();
        if (e.entityID == this.p.entityID) {
            return;
        }
        if (this.averagetime > 500L && (e instanceof EntityBlockItem || e instanceof EntityFire || e instanceof EntityExp)) {
            if (DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 1000L && DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 1500L && DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 2000L && DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 2500L && DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 3000L && DangerZone.rand.nextBoolean()) {
                return;
            }
            if (this.averagetime > 3500L && DangerZone.rand.nextBoolean()) {
                return;
            }
        }
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 144;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(e.entityID);
        this.objectOutput.writeInt(e.dimension);
        this.objectOutput.writeFloat(e.posx);
        this.objectOutput.writeFloat(e.posy);
        this.objectOutput.writeFloat(e.posz);
        this.objectOutput.writeFloat(e.motionx);
        this.objectOutput.writeFloat(e.motiony);
        this.objectOutput.writeFloat(e.motionz);
        this.objectOutput.writeFloat(e.rotation_pitch);
        this.objectOutput.writeFloat(e.rotation_yaw);
        this.objectOutput.writeFloat(e.rotation_roll);
        this.objectOutput.writeFloat(e.rotation_pitch_head);
        this.objectOutput.writeFloat(e.rotation_yaw_head);
        this.objectOutput.writeFloat(e.rotation_roll_head);
        this.objectOutput.writeFloat(e.rotation_pitch_motion);
        this.objectOutput.writeFloat(e.rotation_yaw_motion);
        this.objectOutput.writeFloat(e.rotation_roll_motion);
        if (e.deadflag) {
            pt = 1;
            this.objectOutput.writeInt(pt);
        } else {
            pt = 0;
            this.objectOutput.writeInt(pt);
        }
        if (e.changed != 0) {
            int i = 0;
            while (i < e.maxvars) {
                if ((e.changes[i] & 1) == 1) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeInt(e.entity_ints[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            i = 0;
            while (i < e.maxvars) {
                if ((e.changes[i] & 2) == 2) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeFloat(e.entity_floats[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            i = 0;
            while (i < e.maxvars) {
                if ((e.changes[i] & 4) == 4) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeString(e.entity_strings[i]);
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
            InventoryContainer ic = null;
            i = 0;
            while (i < e.maxinv) {
                if ((e.changes[i] & 8) == 8) {
                    this.objectOutput.writeInt(i);
                    ic = e.getVarInventory(i);
                    if (ic != null) {
                        this.objectOutput.writeInt(ic.bid);
                        this.objectOutput.writeInt(ic.iid);
                        this.objectOutput.writeInt(ic.count);
                        this.objectOutput.writeInt(ic.currentuses);
                    } else {
                        pt = 0;
                        this.objectOutput.writeInt(pt);
                        this.objectOutput.writeInt(pt);
                        this.objectOutput.writeInt(pt);
                        this.objectOutput.writeInt(pt);
                    }
                }
                ++i;
            }
            pt = -1;
            this.objectOutput.writeInt(pt);
        }
        pt = -2;
        this.objectOutput.writeInt(pt);
        this.lock.unlock();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public void sendPlayerToPlayer(Player e) {
        int pt;
        block19: {
            int i;
            InventoryContainer ic;
            block18: {
                block17: {
                    int i2;
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        pt = 0;
                                        this.objectOutput.writeInt(e.dimension);
                                        this.objectOutput.writeFloat(e.posx);
                                        this.objectOutput.writeFloat(e.posy);
                                        this.objectOutput.writeFloat(e.posz);
                                        this.objectOutput.writeFloat(e.motionx);
                                        this.objectOutput.writeFloat(e.motiony);
                                        this.objectOutput.writeFloat(e.motionz);
                                        this.objectOutput.writeFloat(e.rotation_pitch);
                                        this.objectOutput.writeFloat(e.rotation_yaw);
                                        this.objectOutput.writeFloat(e.rotation_roll);
                                        this.objectOutput.writeFloat(e.rotation_pitch_head);
                                        this.objectOutput.writeFloat(e.rotation_yaw_head);
                                        this.objectOutput.writeFloat(e.rotation_roll_head);
                                        this.objectOutput.writeFloat(e.rotation_pitch_motion);
                                        this.objectOutput.writeFloat(e.rotation_yaw_motion);
                                        this.objectOutput.writeFloat(e.rotation_roll_motion);
                                        if (e.deadflag) {
                                            pt = 1;
                                            this.objectOutput.writeInt(pt);
                                        } else {
                                            pt = 0;
                                            this.objectOutput.writeInt(pt);
                                        }
                                        i2 = 0;
                                        if (!true) break block12;
                                        e.getClass();
                                        if (i2 >= 32) break block13;
                                    }
                                    do {
                                        this.objectOutput.writeInt(i2);
                                        this.objectOutput.writeInt(e.entity_ints[i2]);
                                        ++i2;
                                        e.getClass();
                                    } while (i2 < 32);
                                }
                                pt = -1;
                                this.objectOutput.writeInt(pt);
                                i2 = 0;
                                if (!true) break block14;
                                e.getClass();
                                if (i2 >= 32) break block15;
                            }
                            do {
                                this.objectOutput.writeInt(i2);
                                this.objectOutput.writeFloat(e.entity_floats[i2]);
                                ++i2;
                                e.getClass();
                            } while (i2 < 32);
                        }
                        pt = -1;
                        this.objectOutput.writeInt(pt);
                        i2 = 0;
                        if (!true) break block16;
                        e.getClass();
                        if (i2 >= 32) break block17;
                    }
                    do {
                        this.objectOutput.writeInt(i2);
                        this.objectOutput.writeString(e.entity_strings[i2]);
                        ++i2;
                        e.getClass();
                    } while (i2 < 32);
                }
                pt = -1;
                this.objectOutput.writeInt(pt);
                ic = null;
                i = 0;
                if (!true) break block18;
                e.getClass();
                if (i >= 100) break block19;
            }
            do {
                this.objectOutput.writeInt(i);
                ic = e.getVarInventory(i);
                if (ic != null) {
                    this.objectOutput.writeInt(ic.bid);
                    this.objectOutput.writeInt(ic.iid);
                    this.objectOutput.writeInt(ic.count);
                    this.objectOutput.writeInt(ic.currentuses);
                } else {
                    pt = 0;
                    this.objectOutput.writeInt(pt);
                    this.objectOutput.writeInt(pt);
                    this.objectOutput.writeInt(pt);
                    this.objectOutput.writeInt(pt);
                }
                ++i;
                e.getClass();
            } while (i < 100);
        }
        pt = -1;
        this.objectOutput.writeInt(pt);
        pt = -2;
        this.objectOutput.writeInt(pt);
    }

    public void sendTimeToPlayer(int t, int l) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        this.timechecktime = System.currentTimeMillis();
        int pt = 128;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(t);
        this.objectOutput.writeInt(l);
        this.flushSendLocked();
        this.lock.unlock();
    }

    public void sendNewGameMode(int t) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 166;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeInt(t);
        this.flushSendLocked();
        this.lock.unlock();
    }

    public void flushSend() {
        this.checkReady();
        this.lock.lock();
        if (this.objectOutput != null) {
            this.objectOutput.flush();
        }
        this.lock.unlock();
    }

    public void flushSendLocked() {
        this.objectOutput.flush();
    }

    public Entity doSpawnEntity(String name, int pd, float px, float py, float pz, float pitch, float yaw, float roll, float mx, float my, float mz) {
        Entity e = Entities.spawnEntityByName(name, DangerZone.server_world);
        if (e != null) {
            e.posx = px;
            e.posy = py;
            e.posz = pz;
            e.rotation_pitch = pitch;
            e.rotation_yaw = yaw;
            e.rotation_roll = roll;
            e.rotation_pitch_head = pitch;
            e.rotation_yaw_head = yaw;
            e.rotation_roll_head = roll;
            e.motionx = mx;
            e.motiony = my;
            e.motionz = mz;
            e.dimension = pd;
        }
        return e;
    }

    private void readVarsIntoEntity(Entity ent) {
        int index = this.objectInput.readInt();
        if (index != -2) {
            while (index >= 0) {
                if (index < ent.maxvars) {
                    ent.entity_ints[index] = this.objectInput.readInt();
                    ent.changed = 1;
                    int n = index;
                    ent.changes[n] = (short)(ent.changes[n] | 1);
                }
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                if (index < ent.maxvars) {
                    ent.entity_floats[index] = this.objectInput.readFloat();
                    ent.changed = 1;
                    int n = index;
                    ent.changes[n] = (short)(ent.changes[n] | 2);
                }
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                if (index < ent.maxvars) {
                    ent.entity_strings[index] = this.objectInput.readString();
                    ent.changed = 1;
                    int n = index;
                    ent.changes[n] = (short)(ent.changes[n] | 4);
                }
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                InventoryContainer ic;
                int bid = this.objectInput.readInt();
                int iid = this.objectInput.readInt();
                int count = this.objectInput.readInt();
                int uses = this.objectInput.readInt();
                if (count == 0) {
                    ic = null;
                } else {
                    ic = new InventoryContainer();
                    ic.bid = bid;
                    ic.iid = iid;
                    ic.count = count;
                    ic.currentuses = uses;
                }
                ent.setVarInventory(index, ic);
                ent.setVarInventoryChanged(index);
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
        }
        if (index != -2) {
            this.fatal_error = 1;
        }
    }

    private void readVarsIntoNull() {
        int index = 0;
        index = this.objectInput.readInt();
        if (index != -2) {
            while (index >= 0) {
                this.objectInput.readInt();
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                this.objectInput.readFloat();
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                this.objectInput.readString();
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
            while (index >= 0) {
                this.objectInput.readInt();
                this.objectInput.readInt();
                this.objectInput.readInt();
                this.objectInput.readInt();
                index = this.objectInput.readInt();
            }
            index = this.objectInput.readInt();
        }
        if (index != -2) {
            this.fatal_error = 1;
        }
    }

    public void sendSound(String name, int pd, float px, float py, float pz, float vol, float freq) {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 150;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(name);
        this.objectOutput.writeInt(pd);
        this.objectOutput.writeFloat(px);
        this.objectOutput.writeFloat(py);
        this.objectOutput.writeFloat(pz);
        this.objectOutput.writeFloat(vol);
        this.objectOutput.writeFloat(freq);
        this.lock.unlock();
    }

    public void sendServerIDs() {
        try {
            int i = 1;
            while (i < 2048) {
                if (Items.ItemArray[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeString(Items.ItemArray[i].uniquename);
                }
                ++i;
            }
            i = -1;
            this.objectOutput.writeInt(i);
            i = 1;
            while (i < 2048) {
                if (Blocks.BlockArray[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeString(Blocks.BlockArray[i].uniquename);
                }
                ++i;
            }
            i = -1;
            this.objectOutput.writeInt(i);
            i = 1;
            while (i < 256) {
                if (Dimensions.DimensionArray[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeString(Dimensions.DimensionArray[i].uniquename);
                }
                ++i;
            }
            i = -1;
            this.objectOutput.writeInt(i);
            i = 1;
            while (i < 256) {
                if (CustomPackets.CustomPacketsArray[i] != null) {
                    this.objectOutput.writeInt(i);
                    this.objectOutput.writeString(CustomPackets.CustomPacketsArray[i].uniquename);
                }
                ++i;
            }
            i = -1;
            this.objectOutput.writeInt(i);
            float[][][] colordata = new float[16][16][4];
            int bid = 1;
            while (bid < 2048) {
                BufferedImage bi;
                String name = Blocks.getUniqueName(bid);
                if (name != null && name.startsWith("DangerZone:Coloring Block ") && (bi = ImageIO.read(new File(Blocks.BlockArray[bid].texturepath))) != null) {
                    int j = 0;
                    while (j < 16) {
                        i = 0;
                        while (i < 16) {
                            int color = bi.getRGB(i, j);
                            int r = color >> 16 & 0xFF;
                            int g = color >> 8 & 0xFF;
                            int b = color & 0xFF;
                            colordata[i][15 - j][0] = r;
                            colordata[i][15 - j][1] = g;
                            colordata[i][15 - j][2] = b;
                            colordata[i][15 - j][3] = 255.0f;
                            ++i;
                        }
                        ++j;
                    }
                    this.sendColoringBlock(name, bid, colordata, false);
                }
                ++bid;
            }
            i = -1;
            this.objectOutput.writeInt(i);
            this.objectOutput.flush();
        }
        catch (IOException err) {
            this.fatal_error = 1;
        }
    }

    public void sendModNames() {
        int i = DangerZone.all_the_mods.size();
        this.objectOutput.writeInt(i);
        int k = 0;
        while (k < i) {
            String s = DangerZone.all_the_mods.get((int)k).modname;
            this.objectOutput.writeString(s);
            ++k;
        }
        this.objectOutput.writeString(DangerZone.worldname);
        this.objectOutput.flush();
    }

    private void getSkin() {
        int seq = this.objectInput.readInt();
        if (seq != -3) {
            this.fatal_error = 1;
            return;
        }
        byte[] b = this.objectInput.readByteArray();
        if (b == null || b.length < 8192) {
            this.fatal_error = 1;
            return;
        }
        this.p.tdata = b;
    }

    private void sendSkinToPlayer(Entity e) {
        Player pe = (Player)e;
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        this.objectOutput.writeByteArray(pe.tdata, pe.tdata.length);
        this.flushSendLocked();
        this.lock.unlock();
    }

    public NetworkOutputBuffer getOutputStream() {
        this.checkReady();
        ++DangerZone.packets_per_second;
        this.lock.lock();
        return this.objectOutput;
    }

    public void releaseOutputStream() {
        this.lock.unlock();
    }

    public static boolean loadPlayer(Player p) {
        FileInputStream input = null;
        Properties playerprop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/players/%s.dat", DangerZone.worldname, p.myname);
        boolean isnew = false;
        try {
            input = new FileInputStream(filepath);
            playerprop.load(input);
        }
        catch (IOException ex) {
            input = null;
            isnew = true;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        p.readSelf(playerprop, "player:");
        return isnew;
    }

    public void storePlayer() {
        this.p.de_init();
        ServerThread.savePlayer(this.p);
    }

    public static void savePlayer(Player p) {
        Properties playerprop = new Properties();
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/players/%s.dat", DangerZone.worldname, p.myname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        p.writeSelf(playerprop, "player:");
        try {
            output = new FileOutputStream(filepath);
            playerprop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendColoringBlock(String name, int bid, float[][][] colordata, boolean check) {
        if (check) {
            this.checkReady();
        }
        ++DangerZone.packets_per_second;
        this.lock.lock();
        int pt = 164;
        this.objectOutput.writeInt(pt);
        this.objectOutput.writeString(name);
        this.objectOutput.writeInt(bid);
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                int k = 0;
                while (k < 4) {
                    this.objectOutput.writeFloat(colordata[i][j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.flushSendLocked();
        this.lock.unlock();
    }

    private void doSaveColoringBlock(int bid, int dim, int px, int py, int pz, float[][][] colordata) {
        int newbid = bid;
        String blkname = Blocks.getUniqueName(bid);
        if (blkname == null) {
            return;
        }
        if (!blkname.equals("DangerZone:Coloring Block")) {
            String fp = Blocks.BlockArray[bid].texturepath;
            if (fp == null) {
                return;
            }
            File file = new File(fp);
            int width = 16;
            int height = 16;
            String format = "PNG";
            BufferedImage image = new BufferedImage(width, height, 1);
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int r = (int)colordata[x][y][0] & 0xFF;
                    int g = (int)colordata[x][y][1] & 0xFF;
                    int b = (int)colordata[x][y][2] & 0xFF;
                    image.setRGB(x, height - (y + 1), 0xFF000000 | r << 16 | g << 8 | b);
                    ++y;
                }
                ++x;
            }
            try {
                ImageIO.write((RenderedImage)image, format, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            image.flush();
            DangerZone.server.sendColoringBlockToAll(blkname, newbid, colordata);
            return;
        }
        int index = 0;
        int blkindex = 0;
        boolean ok = false;
        boolean found = false;
        index = 0;
        block6: while (index < 100) {
            blkname = String.format("DangerZone:Coloring Block %2d", index);
            found = false;
            blkindex = 1;
            while (blkindex < 2048) {
                if (Blocks.BlockArray[blkindex] != null && blkname.equals(Blocks.getUniqueName(blkindex))) {
                    found = true;
                    break;
                }
                ++blkindex;
            }
            if (!found) {
                ok = true;
                blkindex = 1;
                while (blkindex < 2048) {
                    if (Blocks.BlockArray[blkindex] == null) break block6;
                    ++blkindex;
                }
                break;
            }
            ++index;
        }
        if (!ok) {
            return;
        }
        String fp = String.format("worlds/%s/coloring/coloringblock%2d.png", DangerZone.worldname, index);
        File file = new File(fp);
        int width = 16;
        int height = 16;
        String format = "PNG";
        BufferedImage image = new BufferedImage(width, height, 1);
        file.mkdirs();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int r = (int)colordata[x][y][0] & 0xFF;
                int g = (int)colordata[x][y][1] & 0xFF;
                int b = (int)colordata[x][y][2] & 0xFF;
                image.setRGB(x, height - (y + 1), 0xFF000000 | r << 16 | g << 8 | b);
                ++y;
            }
            ++x;
        }
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        image.flush();
        ColoringBlock cb = new ColoringBlock(blkname, "");
        cb.texturepath = file.getAbsolutePath();
        cb.blockID = blkindex;
        Blocks.BlockArray[blkindex] = cb;
        Blocks.addthis(blkname, blkindex);
        Blocks.save();
        DangerZone.server.sendColoringBlockToAll(blkname, blkindex, colordata);
        DangerZone.server_world.setblock(dim, px, py, pz, blkindex);
    }

    private boolean verify_playername(Player p, String pln, String pa) {
        if (!DangerZone.start_client) {
            p.player_privs = DangerZone.default_privs;
            if (DangerZone.require_valid_passwords) {
                if (pln == null || pa == null) {
                    return false;
                }
                if (pln.length() < 4) {
                    return false;
                }
                if (pln.length() > 16) {
                    return false;
                }
                if (pa.length() != 32) {
                    return false;
                }
                Socket ns_sock = null;
                ObjectInputStream ns_objectInput = null;
                ObjectOutputStream ns_objectOutput = null;
                BufferedOutputStream ns_bufobjectOutput = null;
                BufferedInputStream ns_bufobjectInput = null;
                int packettype = 0;
                boolean is_valid = false;
                try {
                    ns_sock = new Socket(DangerZone.nsserver_address, DangerZone.nsserver_port);
                    ns_bufobjectOutput = new BufferedOutputStream(ns_sock.getOutputStream());
                    ns_objectOutput = new ObjectOutputStream(ns_bufobjectOutput);
                    packettype = -1;
                    ns_objectOutput.writeInt(packettype);
                    ns_objectOutput.flush();
                    ns_bufobjectInput = new BufferedInputStream(ns_sock.getInputStream());
                    ns_objectInput = new ObjectInputStream(ns_bufobjectInput);
                    packettype = ns_objectInput.readInt();
                    packettype = 0;
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    packettype = 0;
                    ns_objectOutput.writeInt(packettype);
                    ns_objectOutput.writeObject(pln);
                    ns_objectOutput.writeObject(pa);
                    ns_objectOutput.flush();
                    int response = ns_objectInput.readInt();
                    is_valid = response != 0;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (ns_bufobjectInput != null) {
                        ns_bufobjectInput.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (ns_bufobjectOutput != null) {
                        ns_bufobjectOutput.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (ns_objectInput != null) {
                        ns_objectInput.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (ns_objectOutput != null) {
                        ns_objectOutput.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (ns_sock != null) {
                        ns_sock.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (!is_valid) {
                    return false;
                }
            }
            p.player_privs = DangerZone.server.find_privs(pln);
            return true;
        }
        p.player_privs = -1;
        return true;
    }
}

