/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.ListInt;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ColoringBlock;
import dangerzone.entities.Entity;
import dangerzone.threads.BlockTickerThread;
import dangerzone.threads.FastBlockTicker;
import dangerzone.threads.NotifyBlockTicker;
import dangerzone.threads.ServerEntityUpdateLoop;
import dangerzone.threads.ServerThread;
import dangerzone.threads.SpawnerThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Server
implements Runnable {
    ServerSocket myServerSocket;
    public List<ListInt> server_thread_list;
    public ServerThread[] players;
    public int max_players = 256;
    public Lock player_list_lock = new ReentrantLock();
    public Lock priv_lock = new ReentrantLock();
    private Player plyr;
    public ServerEntityUpdateLoop entityManager = null;

    @Override
    public void run() {
        this.server_thread_list = new ArrayList<ListInt>();
        try {
            this.myServerSocket = new ServerSocket(DangerZone.server_port);
        }
        catch (IOException e) {
            return;
        }
        this.entityManager = new ServerEntityUpdateLoop();
        Thread it = new Thread(this.entityManager);
        it.start();
        this.players = new ServerThread[this.max_players];
        int i = 0;
        while (i < this.max_players) {
            this.players[i] = null;
            ++i;
        }
        String cbname = new String();
        ColoringBlock cb = null;
        i = 0;
        while (i < 100) {
            cbname = String.format("DangerZone:Coloring Block %2d", i);
            int bid = Blocks.lookup(cbname);
            if (bid > 0) {
                cb = new ColoringBlock(cbname, String.format("worlds/%s/coloring/coloringblock%2d.png", DangerZone.worldname, i));
                Blocks.registerBlock(cb);
            }
            ++i;
        }
        Thread ftb = new Thread(new FastBlockTicker());
        ftb.start();
        Thread nty = new Thread(new NotifyBlockTicker());
        nty.start();
        Thread itb = new Thread(new BlockTickerThread());
        itb.start();
        Thread its = new Thread(new SpawnerThread());
        its.start();
        while (DangerZone.gameover == 0) {
            ServerThread st;
            Socket sock;
            try {
                sock = this.myServerSocket.accept();
            }
            catch (IOException e) {
                return;
            }
            this.player_list_lock.lock();
            i = this.get_player_count();
            if (i >= DangerZone.max_players_on_server) {
                try {
                    sock.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.player_list_lock.unlock();
                continue;
            }
            i = this.find_player_slot();
            if (i < 0) {
                try {
                    sock.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.player_list_lock.unlock();
                continue;
            }
            this.plyr = new Player(DangerZone.server_world);
            this.plyr.toClient = sock;
            this.players[i] = st = new ServerThread(this.plyr);
            this.server_thread_list.add(new ListInt(i));
            this.player_list_lock.unlock();
            if (DangerZone.show_server_stats) {
                InetAddress ia = sock.getInetAddress();
                String ias = ia.getHostAddress();
                System.out.printf("Connection from %s\n", ias);
            }
            Thread pit = new Thread(st);
            pit.start();
        }
    }

    private int find_player_slot() {
        int i = 0;
        while (i < this.max_players) {
            if (this.players[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int get_player_count() {
        int count = 0;
        int i = 0;
        while (i < this.max_players) {
            if (this.players[i] != null) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void sendChunkToAll(Chunk c) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            int dz;
            int z;
            int dx;
            int x;
            float dist;
            if (this.players[st.index] == null || this.players[st.index].p.dimension != c.dimension || !((dist = (float)Math.sqrt(((x = c.chunkX << 4) - (dx = (int)this.players[st.index].p.posx)) * (x - dx) + ((z = c.chunkZ << 4) - (dz = (int)this.players[st.index].p.posz)) * (z - dz))) < 512.0f)) continue;
            this.players[st.index].sendChunkToPlayer(c);
        }
        this.player_list_lock.unlock();
    }

    public void sendBlockToAll(int d, int x, int y, int z, int id, int meta) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            int dz;
            int dx;
            float dist;
            if (this.players[st.index] == null || this.players[st.index].p.dimension != d || !((dist = (float)Math.sqrt((x - (dx = (int)this.players[st.index].p.posx)) * (x - dx) + (z - (dz = (int)this.players[st.index].p.posz)) * (z - dz))) < 512.0f)) continue;
            this.players[st.index].sendBlockToPlayer(d, x, y, z, id, meta);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityDeathToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendEntityDeathToPlayer(e.entityID);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityDeathToAllExcept(Player pl, Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == pl || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendEntityDeathToPlayer(e.entityID);
        }
        this.player_list_lock.unlock();
    }

    public void sendSpawnParticleToAllExcept(Player pl, String s, int hm, int d, float x, float y, float z) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == pl || this.players[st.index].p.dimension != d || !(this.players[st.index].p.getDistanceFromEntityCenter(x, y, z) < 256.0f)) continue;
            this.players[st.index].sendSpawnParticleToPlayer(s, hm, d, x, y, z);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityRemoveToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendEntityRemoveToPlayer(e.entityID);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityRemoveToAllExcept(Player pl, Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == pl) continue;
            this.players[st.index].sendEntityRemoveToPlayer(e.entityID);
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityHitToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendEntityHitToPlayer(e.entityID, e.getHealth());
        }
        this.player_list_lock.unlock();
    }

    public void sendChatToAll(String s) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendChatToPlayer(s);
        }
        this.player_list_lock.unlock();
    }

    public void sendChatToAllExcept(String s, Player plr) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == plr) continue;
            this.players[st.index].sendChatToPlayer(s);
        }
        this.player_list_lock.unlock();
    }

    public void sendCommandToAll(String s) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendCommandToPlayer(s);
        }
        this.player_list_lock.unlock();
    }

    public void savePlayers() {
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].storePlayer();
        }
        this.player_list_lock.unlock();
    }

    public void sendEntityUpdateToAll(Entity e, boolean force) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (!force) {
                if (this.players[st.index] == null || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)e.maxrenderdist)) continue;
                this.players[st.index].sendEntityUpdateToPlayer(e);
                continue;
            }
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendEntityUpdateToPlayer(e);
        }
        this.player_list_lock.unlock();
        if (e.changed != 0) {
            e.changed = 0;
            int i = 0;
            while (i < e.maxinv) {
                e.changes[i] = 0;
                ++i;
            }
        }
    }

    public void sendPlayerUpdateToAllExcept(Entity e, Player p, boolean forceall) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (!forceall) {
                if (this.players[st.index] == null || this.players[st.index].p == p || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
                this.players[st.index].sendEntityUpdateToPlayer(e);
                continue;
            }
            if (this.players[st.index] == null || this.players[st.index].p == p) continue;
            this.players[st.index].sendEntityUpdateToPlayer(e);
        }
        this.player_list_lock.unlock();
        if (e.changed != 0) {
            e.changed = 0;
            int i = 0;
            while (i < e.maxinv) {
                e.changes[i] = 0;
                ++i;
            }
        }
    }

    public void sendPlayerActionToAllExcept(Player p, int which, int what) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == p || this.players[st.index].p.dimension != p.dimension || !(p.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendPlayerAction(p, which, what);
        }
        this.player_list_lock.unlock();
    }

    public void sendSpawnEntityToAll(Entity e) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendSpawnEntityToPlayer(e);
        }
        this.player_list_lock.unlock();
    }

    public void sendTimeToAll(int t, int l) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendTimeToPlayer(t, l);
        }
        this.player_list_lock.unlock();
    }

    public void sendBlockToAllExcept(ServerThread stp, int d, int x, int y, int z, int id, int meta) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            int dz;
            int dx;
            float dist;
            if (this.players[st.index] == null || this.players[st.index] == stp || this.players[st.index].p.dimension != d || !((dist = (float)Math.sqrt((x - (dx = (int)this.players[st.index].p.posx)) * (x - dx) + (z - (dz = (int)this.players[st.index].p.posz)) * (z - dz))) < 512.0f)) continue;
            this.players[st.index].sendBlockToPlayer(d, x, y, z, id, meta);
        }
        this.player_list_lock.unlock();
    }

    public void flushAll() {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        while (ii.hasNext()) {
            int i = ii.next().index;
            if (this.players[i] == null) continue;
            this.players[i].flushSend();
        }
        this.player_list_lock.unlock();
    }

    public Player getRandomPlayer(Random rand) {
        Player p = null;
        this.player_list_lock.lock();
        if (this.server_thread_list.size() != 0) {
            if (this.server_thread_list.size() == 1) {
                p = this.players[this.server_thread_list.get((int)0).index].p;
            } else {
                int i = rand.nextInt(this.server_thread_list.size());
                p = this.players[this.server_thread_list.get((int)i).index].p;
            }
        }
        this.player_list_lock.unlock();
        return p;
    }

    public boolean isAPlayerInDimension(int d) {
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index].p.dimension != d) continue;
            this.player_list_lock.unlock();
            return true;
        }
        this.player_list_lock.unlock();
        return false;
    }

    public boolean isPlayerCloseInDimension(Entity e) {
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.player_list_lock.unlock();
            return true;
        }
        this.player_list_lock.unlock();
        return false;
    }

    public boolean isPlayerCloseInDimension(Entity e, float dist) {
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < dist)) continue;
            this.player_list_lock.unlock();
            return true;
        }
        this.player_list_lock.unlock();
        return false;
    }

    public void removeMe(ServerThread stp) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.players[st.index] != stp) continue;
            ii.remove();
            this.players[st.index] = null;
            break;
        }
        this.player_list_lock.unlock();
    }

    public Player findNearestPlayer(Entity e) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        float dist = 999.0f;
        Player p = null;
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.players[st.index].p.dimension != e.dimension || !(e.getDistanceFromEntity(this.players[st.index].p) < dist)) continue;
            p = this.players[st.index].p;
            dist = e.getDistanceFromEntity(this.players[st.index].p);
        }
        this.player_list_lock.unlock();
        return p;
    }

    public Player findNearestPlayerToHere(int d, int x, int y, int z) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        float dist = 999.0f;
        Player p = null;
        while (ii.hasNext()) {
            float dz;
            float dy;
            float dx;
            float curdist;
            ListInt st = ii.next();
            if (this.players[st.index].p.dimension != d || !((curdist = (float)Math.sqrt((dx = this.players[st.index].p.posx - (float)x) * dx + (dy = this.players[st.index].p.posy - (float)y) * dy + (dz = this.players[st.index].p.posz - (float)z) * dz)) < dist)) continue;
            p = this.players[st.index].p;
            dist = curdist;
        }
        this.player_list_lock.unlock();
        return p;
    }

    public float distToNearestPlayerFromHere(int d, int x, int y, int z) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        float dist = 999.0f;
        while (ii.hasNext()) {
            float dz;
            float dy;
            float dx;
            float curdist;
            ListInt st = ii.next();
            if (this.players[st.index].p.dimension != d || !((curdist = (float)Math.sqrt((dx = this.players[st.index].p.posx - (float)x) * dx + (dy = this.players[st.index].p.posy - (float)y) * dy + (dz = this.players[st.index].p.posz - (float)z) * dz)) < dist)) continue;
            dist = curdist;
        }
        this.player_list_lock.unlock();
        return dist;
    }

    public float findNearestPlayerDistToHere(int d, int x, int z) {
        this.player_list_lock.lock();
        Iterator<ListInt> ii = this.server_thread_list.iterator();
        float dist = 9999.0f;
        while (ii.hasNext()) {
            float dz;
            float dx;
            float curdist;
            ListInt st = ii.next();
            if (this.players[st.index].p.dimension != d || !((curdist = (float)Math.sqrt((dx = this.players[st.index].p.posx - (float)x) * dx + (dz = this.players[st.index].p.posz - (float)z) * dz)) < dist)) continue;
            dist = curdist;
        }
        this.player_list_lock.unlock();
        return dist;
    }

    public void sendSoundToAllExcept(Player pl, String name, int pd, float px, float py, float pz, float vol, float freq) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p == pl || this.players[st.index].p.dimension != pl.dimension || !(pl.getDistanceFromEntity(this.players[st.index].p) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendSound(name, pd, px, py, pz, vol, freq);
        }
        this.player_list_lock.unlock();
    }

    public void sendSoundToAll(String name, int pd, float px, float py, float pz, float vol, float freq) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null || this.players[st.index].p.dimension != pd || !(this.players[st.index].p.getDistanceFromEntityCenter(px, py, pz) < (float)DangerZone.entityupdatedist)) continue;
            this.players[st.index].sendSound(name, pd, px, py, pz, vol, freq);
        }
        this.player_list_lock.unlock();
    }

    public void sendColoringBlockToAll(String name, int bid, float[][][] colordata) {
        if (DangerZone.gameover != 0) {
            return;
        }
        this.player_list_lock.lock();
        for (ListInt st : this.server_thread_list) {
            if (this.players[st.index] == null) continue;
            this.players[st.index].sendColoringBlock(name, bid, colordata, true);
        }
        this.player_list_lock.unlock();
    }

    public int find_privs(String pln) {
        this.priv_lock.lock();
        Properties privprop = new Properties();
        FileInputStream privinput = null;
        int privs = DangerZone.default_privs;
        String filepath = new String();
        filepath = String.format("worlds/%s/player_privs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            privinput = new FileInputStream(filepath);
            privprop.load(privinput);
            ((InputStream)privinput).close();
            privs = Utils.getPropertyInt(privprop, pln.toLowerCase(), 0, -1, DangerZone.default_privs);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.priv_lock.unlock();
        return privs;
    }

    public void save_privs(String pln, int privs) {
        this.priv_lock.lock();
        Properties privprop = new Properties();
        FileOutputStream privoutput = null;
        FileInputStream privinput = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/player_privs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            privinput = new FileInputStream(filepath);
            privprop.load(privinput);
            ((InputStream)privinput).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            privprop.setProperty(pln.toLowerCase(), String.format("%d", privs));
            privoutput = new FileOutputStream(filepath);
            privprop.store(privoutput, null);
            ((OutputStream)privoutput).close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        this.priv_lock.unlock();
    }

    public boolean isBanned(String pln) {
        this.priv_lock.lock();
        Properties privprop = new Properties();
        FileInputStream privinput = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/player_bans.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        boolean isnotok = false;
        try {
            privinput = new FileInputStream(filepath);
            privprop.load(privinput);
            ((InputStream)privinput).close();
            isnotok = Utils.getPropertyBoolean(privprop, pln.toLowerCase(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.priv_lock.unlock();
        return isnotok;
    }

    public void setBanned(String pln, boolean banstate) {
        this.priv_lock.lock();
        Properties privprop = new Properties();
        FileOutputStream privoutput = null;
        FileInputStream privinput = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/player_bans.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            privinput = new FileInputStream(filepath);
            privprop.load(privinput);
            ((InputStream)privinput).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            privprop.setProperty(pln.toLowerCase(), banstate ? "true" : "false");
            privoutput = new FileOutputStream(filepath);
            privprop.store(privoutput, null);
            ((OutputStream)privoutput).close();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        this.priv_lock.unlock();
    }
}

