/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.gui.InventoryMenus;
import dangerzone.items.Item;
import dangerzone.items.ItemAppleSeed;
import dangerzone.items.ItemArmor;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemBucket;
import dangerzone.items.ItemBucketMilk;
import dangerzone.items.ItemBucketWater;
import dangerzone.items.ItemCherrySeed;
import dangerzone.items.ItemCorn;
import dangerzone.items.ItemDark;
import dangerzone.items.ItemDoor;
import dangerzone.items.ItemFireStick;
import dangerzone.items.ItemFireball;
import dangerzone.items.ItemFood;
import dangerzone.items.ItemFurball;
import dangerzone.items.ItemHoe;
import dangerzone.items.ItemInstability;
import dangerzone.items.ItemLight;
import dangerzone.items.ItemPeachSeed;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemRadish;
import dangerzone.items.ItemRice;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSpawnEgg;
import dangerzone.items.ItemSpiderSilk;
import dangerzone.items.ItemStick;
import dangerzone.items.ItemSword;
import dangerzone.items.ItemTrophy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Items {
    public static Item stick = new ItemStick("DangerZone:Stick", "res/items/2by4.png");
    public static Item door = new ItemDoor("DangerZone:Door", "res/items/door.png");
    public static Item eggbutterfly = new ItemSpawnEgg("DangerZone:Spawn Butterfly", "res/items/eggbutterfly.png", "DangerZone:Butterfly");
    public static Item eggghost = new ItemSpawnEgg("DangerZone:Spawn Ghost", "res/items/eggghost.png", "DangerZone:Ghost");
    public static Item eggghostskelly = new ItemSpawnEgg("DangerZone:Spawn Ghost Skelly", "res/items/eggghostskelly.png", "DangerZone:GhostSkelly");
    public static Item eggrat = new ItemSpawnEgg("DangerZone:Spawn Rat", "res/items/eggrat.png", "DangerZone:Rat");
    public static Item eggcockroach = new ItemSpawnEgg("DangerZone:Spawn Cockroach", "res/items/eggcockroach.png", "DangerZone:Cockroach");
    public static Item eggmoose = new ItemSpawnEgg("DangerZone:Spawn Moose", "res/items/eggmoose.png", "DangerZone:Moose");
    public static Item egggoose = new ItemSpawnEgg("DangerZone:Spawn Goose", "res/items/egggoose.png", "DangerZone:Goose");
    public static Item egggosling = new ItemSpawnEgg("DangerZone:Spawn Gosling", "res/items/egggoose.png", "DangerZone:Gosling");
    public static Item eggostrich = new ItemSpawnEgg("DangerZone:Spawn Ostrich", "res/items/eggostrich.png", "DangerZone:Ostrich");
    public static Item eggsparklemuffin = new ItemSpawnEgg("DangerZone:Spawn Sparklemuffin", "res/items/eggsparklemuffin.png", "DangerZone:Sparklemuffin");
    public static Item eggskeletorus = new ItemSpawnEgg("DangerZone:Spawn Skeletorus", "res/items/eggskeletorus.png", "DangerZone:Skeletorus");
    public static Item egganteater = new ItemSpawnEgg("DangerZone:Spawn Anteater", "res/items/egganteater.png", "DangerZone:Anteater");
    public static Item eggwerewolf = new ItemSpawnEgg("DangerZone:Spawn Werewolf", "res/items/eggwerewolf.png", "DangerZone:Werewolf");
    public static Item eggvampire = new ItemSpawnEgg("DangerZone:Spawn Vampire", "res/items/eggvampire.png", "DangerZone:Vampire");
    public static Item eggthecount = new ItemSpawnEgg("DangerZone:Spawn The Count", "res/items/eggthecount.png", "DangerZone:The Count");
    public static Item eggvampiremoose = new ItemSpawnEgg("DangerZone:Spawn Vampire Moose", "res/items/eggvampiremoose.png", "DangerZone:Vampire Moose");
    public static Item eggfish = new ItemSpawnEgg("DangerZone:Spawn Fish", "res/items/eggfish.png", "DangerZone:Fish");
    public static Item eggcloud = new ItemSpawnEgg("DangerZone:Spawn Cloud", "res/items/egggoose.png", "DangerZone:Cloud");
    public static Item lumpcopper = new Item("DangerZone:Copper", "res/items/lumpcopper.png");
    public static Item lumptin = new Item("DangerZone:Tin", "res/items/lumptin.png");
    public static Item lumpsilver = new Item("DangerZone:Silver", "res/items/lumpsilver.png");
    public static Item lumpplatinum = new Item("DangerZone:Platinum", "res/items/lumpplatinum.png");
    public static Item coingold = new Item("DangerZone:Gold Coin", "res/items/coingold.png");
    public static Item coinsilver = new Item("DangerZone:Silver Coin", "res/items/coinsilver.png");
    public static Item coinplatinum = new Item("DangerZone:Platinum Coin", "res/items/coinplatinum.png");
    public static Item woodensword = new ItemSword("DangerZone:Wooden Sword", "res/items/woodensword.png", 200, 6);
    public static Item woodenpickaxe = new ItemPickAxe("DangerZone:Wooden Pickaxe", "res/items/woodenpickaxe.png", 400, 5, 8);
    public static Item woodenaxe = new ItemAxe("DangerZone:Wooden Axe", "res/items/woodenaxe.png", 200, 5, 2);
    public static Item woodenshovel = new ItemShovel("DangerZone:Wooden Shovel", "res/items/woodenshovel.png", 300, 3, 2);
    public static Item woodenhoe = new ItemHoe("DangerZone:Wooden Hoe", "res/items/woodenhoe.png", 200, 1, 3);
    public static Item stonesword = new ItemSword("DangerZone:Stone Sword", "res/items/stonesword.png", 400, 8);
    public static Item stonepickaxe = new ItemPickAxe("DangerZone:Stone Pickaxe", "res/items/stonepickaxe.png", 800, 8, 10);
    public static Item stoneaxe = new ItemAxe("DangerZone:Stone Axe", "res/items/stoneaxe.png", 400, 8, 3);
    public static Item stoneshovel = new ItemShovel("DangerZone:Stone Shovel", "res/items/stoneshovel.png", 60, 4, 3);
    public static Item stonehoe = new ItemHoe("DangerZone:Stone Hoe", "res/items/stonehoe.png", 400, 1, 6);
    public static Item coppersword = new ItemSword("DangerZone:Copper Sword", "res/items/coppersword.png", 500, 10);
    public static Item copperpickaxe = new ItemPickAxe("DangerZone:Copper Pickaxe", "res/items/copperpickaxe.png", 1200, 9, 12);
    public static Item copperaxe = new ItemAxe("DangerZone:Copper Axe", "res/items/copperaxe.png", 500, 9, 4);
    public static Item coppershovel = new ItemShovel("DangerZone:Copper Shovel", "res/items/coppershovel.png", 1000, 5, 4);
    public static Item copperhoe = new ItemHoe("DangerZone:Copper Hoe", "res/items/copperhoe.png", 500, 2, 7);
    public static Item tinsword = new ItemSword("DangerZone:Tin Sword", "res/items/tinsword.png", 600, 12);
    public static Item tinpickaxe = new ItemPickAxe("DangerZone:Tin Pickaxe", "res/items/tinpickaxe.png", 1400, 10, 14);
    public static Item tinaxe = new ItemAxe("DangerZone:Tin Axe", "res/items/tinaxe.png", 600, 10, 5);
    public static Item tinshovel = new ItemShovel("DangerZone:Tin Shovel", "res/items/tinshovel.png", 1200, 6, 5);
    public static Item tinhoe = new ItemHoe("DangerZone:Tin Hoe", "res/items/tinhoe.png", 600, 2, 8);
    public static Item silversword = new ItemSword("DangerZone:Silver Sword", "res/items/silversword.png", 800, 14);
    public static Item silverpickaxe = new ItemPickAxe("DangerZone:Silver Pickaxe", "res/items/silverpickaxe.png", 1600, 11, 16);
    public static Item silveraxe = new ItemAxe("DangerZone:Silver Axe", "res/items/silveraxe.png", 800, 11, 6);
    public static Item silvershovel = new ItemShovel("DangerZone:Silver Shovel", "res/items/silvershovel.png", 1400, 7, 6);
    public static Item silverhoe = new ItemHoe("DangerZone:Silver Hoe", "res/items/silverhoe.png", 800, 3, 10);
    public static Item platinumsword = new ItemSword("DangerZone:Platinum Sword", "res/items/platinumsword.png", 1600, 24);
    public static Item platinumpickaxe = new ItemPickAxe("DangerZone:Platinum Pickaxe", "res/items/platinumpickaxe.png", 2000, 16, 24);
    public static Item platinumaxe = new ItemAxe("DangerZone:Platinum Axe", "res/items/platinumaxe.png", 1600, 16, 8);
    public static Item platinumshovel = new ItemShovel("DangerZone:Platinum Shovel", "res/items/platinumshovel.png", 1600, 10, 7);
    public static Item platinumhoe = new ItemHoe("DangerZone:Platinum Hoe", "res/items/platinumhoe.png", 1000, 5, 20);
    public static Item dark = new ItemDark("DangerZone:Darkness", "res/items/dark.png");
    public static Item light = new ItemLight("DangerZone:Lightness", "res/items/light.png");
    public static Item diamond = new Item("DangerZone:Diamond", "res/items/diamond.png");
    public static Item emerald = new Item("DangerZone:Emerald", "res/items/emerald.png");
    public static Item bloodstone = new Item("DangerZone:Bloodstone", "res/items/bloodstone.png");
    public static Item sunstone = new Item("DangerZone:Sunstone", "res/items/sunstone.png");
    public static Item trophycockroach = new ItemTrophy("DangerZone:Cockroach Trophy", "DangerZone:Cockroach", 1.0f, 256);
    public static Item trophybutterfly = new ItemTrophy("DangerZone:Butterfly Trophy", "DangerZone:Butterfly", 0.45f, 256);
    public static Item trophyrat = new ItemTrophy("DangerZone:Rat Trophy", "DangerZone:Rat", 0.5f, 128);
    public static Item trophymoose = new ItemTrophy("DangerZone:Moose Trophy", "DangerZone:Moose", 0.25f, 16);
    public static Item trophyghost = new ItemTrophy("DangerZone:Ghost Trophy", "DangerZone:Ghost", 0.5f, 32);
    public static Item trophyghostskelly = new ItemTrophy("DangerZone:Ghost Skelly Trophy", "DangerZone:GhostSkelly", 0.45f, 32);
    public static Item trophygoose = new ItemTrophy("DangerZone:Goose Trophy", "DangerZone:Goose", 0.45f, 32);
    public static Item trophygosling = new ItemTrophy("DangerZone:Gosling Trophy", "DangerZone:Gosling", 0.95f, 64);
    public static Item trophyostrich = new ItemTrophy("DangerZone:Ostrich Trophy", "DangerZone:Ostrich", 0.4f, 16);
    public static Item trophysparklemuffin = new ItemTrophy("DangerZone:Sparklemuffin Trophy", "DangerZone:Sparklemuffin", 0.35f, 16);
    public static Item trophyskeletorus = new ItemTrophy("DangerZone:Skeletorus Trophy", "DangerZone:Skeletorus", 0.35f, 16);
    public static Item trophyanteater = new ItemTrophy("DangerZone:Anteater Trophy", "DangerZone:Anteater", 0.3f, 16);
    public static Item trophywerewolf = new ItemTrophy("DangerZone:Werewolf Trophy", "DangerZone:Werewolf", 0.45f, 16);
    public static Item trophyvampire = new ItemTrophy("DangerZone:Vampire Trophy", "DangerZone:Vampire", 0.45f, 16);
    public static Item trophythecount = new ItemTrophy("DangerZone:The Count Trophy", "DangerZone:The Count", 0.45f, 16);
    public static Item trophyvampiremoose = new ItemTrophy("DangerZone:Vampire Moose Trophy", "DangerZone:Vampire Moose", 0.25f, 16);
    public static Item trophyfish = new ItemTrophy("DangerZone:Fish Trophy", "DangerZone:Fish", 0.45f, 32);
    public static Item goosemeat = new ItemFood("DangerZone:Raw Goose", "res/items/goose_raw.png", 3);
    public static Item goosemeat_cooked = new ItemFood("DangerZone:Cooked Goose", "res/items/goose_cooked.png", 15);
    public static Item ostrichmeat = new ItemFood("DangerZone:Raw Ostrich", "res/items/goose_raw.png", 5);
    public static Item ostrichmeat_cooked = new ItemFood("DangerZone:Cooked Ostrich", "res/items/goose_cooked.png", 20);
    public static Item fishmeat = new ItemFood("DangerZone:Raw Fish", "res/items/fishraw.png", 2);
    public static Item fishmeat_cooked = new ItemFood("DangerZone:Cooked Fish", "res/items/fishcooked.png", 15);
    public static Item moosemeat = new ItemFood("DangerZone:Moose Meat", "res/items/moosemeat.png", 5);
    public static Item moosemeat_cooked = new ItemFood("DangerZone:Cooked Moose Meat", "res/items/moosemeat_cooked.png", 20);
    public static Item moosebone = new Item("DangerZone:Moose Bone", "res/items/moosebone.png");
    public static Item feather = new Item("DangerZone:Feather", "res/items/feather.png");
    public static Item radish = new ItemRadish("DangerZone:Radish", "res/items/radish.png");
    public static Item rice = new ItemRice("DangerZone:Rice", "res/items/rice.png");
    public static Item corn = new ItemCorn("DangerZone:Corn", "res/items/corn_seed.png");
    public static Item peach = new ItemFood("DangerZone:Peach", "res/items/peach.png", 8);
    public static Item cherries = new ItemFood("DangerZone:Cherries", "res/items/cherries.png", 6);
    public static Item apple = new ItemFood("DangerZone:Apple", "res/items/apple.png", 5);
    public static Item peachseed = new ItemPeachSeed("DangerZone:Peach Pit", "res/items/peachtree_seed.png");
    public static Item cherryseed = new ItemCherrySeed("DangerZone:Cherry Pit", "res/items/cherrytree_seed.png");
    public static Item appleseed = new ItemAppleSeed("DangerZone:Apple Seed", "res/items/appletree_seed.png");
    public static Item deadbug = new ItemFood("DangerZone:Dead Bug", "res/items/deadbug.png", 2);
    public static Item copperhelmet = new ItemArmor("DangerZone:Copper Helmet", "res/items/copperhelmet.png", "res/skins/copperarmor.png", "res/skins/copperarmor2.png", 0.25f, 500, 0);
    public static Item copperchestplate = new ItemArmor("DangerZone:Copper Chestplate", "res/items/copperchestplate.png", "res/skins/copperarmor.png", "res/skins/copperarmor2.png", 0.35f, 500, 1);
    public static Item copperleggings = new ItemArmor("DangerZone:Copper Leggings", "res/items/copperleggings.png", "res/skins/copperarmor.png", "res/skins/copperarmor2.png", 0.25f, 500, 2);
    public static Item copperboots = new ItemArmor("DangerZone:Copper Boots", "res/items/copperboots.png", "res/skins/copperarmor.png", "res/skins/copperarmor2.png", 0.33f, 500, 3);
    public static Item tinhelmet = new ItemArmor("DangerZone:Tin Helmet", "res/items/tinhelmet.png", "res/skins/tinarmor.png", "res/skins/tinarmor2.png", 0.65f, 1000, 0);
    public static Item tinchestplate = new ItemArmor("DangerZone:Tin Chestplate", "res/items/tinchestplate.png", "res/skins/tinarmor.png", "res/skins/tinarmor2.png", 0.75f, 1000, 1);
    public static Item tinleggings = new ItemArmor("DangerZone:Tin Leggings", "res/items/tinleggings.png", "res/skins/tinarmor.png", "res/skins/tinarmor2.png", 0.5f, 1000, 2);
    public static Item tinboots = new ItemArmor("DangerZone:Tin Boots", "res/items/tinboots.png", "res/skins/tinarmor.png", "res/skins/tinarmor2.png", 0.53f, 1000, 3);
    public static Item silverhelmet = new ItemArmor("DangerZone:Silver Helmet", "res/items/silverhelmet.png", "res/skins/silverarmor.png", "res/skins/silverarmor2.png", 1.0f, 2000, 0);
    public static Item silverchestplate = new ItemArmor("DangerZone:Silver Chestplate", "res/items/silverchestplate.png", "res/skins/silverarmor.png", "res/skins/silverarmor2.png", 1.25f, 2000, 1);
    public static Item silverleggings = new ItemArmor("DangerZone:Silver Leggings", "res/items/silverleggings.png", "res/skins/silverarmor.png", "res/skins/silverarmor2.png", 1.25f, 2000, 2);
    public static Item silverboots = new ItemArmor("DangerZone:Silver Boots", "res/items/silverboots.png", "res/skins/silverarmor.png", "res/skins/silverarmor2.png", 0.73f, 2000, 3);
    public static Item platinumhelmet = new ItemArmor("DangerZone:Platinum Helmet", "res/items/platinumhelmet.png", "res/skins/platinumarmor.png", "res/skins/platinumarmor2.png", 1.5f, 3000, 0);
    public static Item platinumchestplate = new ItemArmor("DangerZone:Platinum Chestplate", "res/items/platinumchestplate.png", "res/skins/platinumarmor.png", "res/skins/platinumarmor2.png", 1.75f, 3000, 1);
    public static Item platinumleggings = new ItemArmor("DangerZone:Platinum Leggings", "res/items/platinumleggings.png", "res/skins/platinumarmor.png", "res/skins/platinumarmor2.png", 1.5f, 3000, 2);
    public static Item platinumboots = new ItemArmor("DangerZone:Platinum Boots", "res/items/platinumboots.png", "res/skins/platinumarmor.png", "res/skins/platinumarmor2.png", 1.33f, 3000, 3);
    public static Item furball = new ItemFurball("DangerZone:Furball", "res/items/furball.png");
    public static Item vampireteeth = new Item("DangerZone:Vamire Teeth", "res/items/vampireteeth.png");
    public static Item instability = new ItemInstability("DangerZone:Instability", "res/items/instability.png", 1.0f);
    public static Item instabilitylarge = new ItemInstability("DangerZone:Large Instability", "res/items/instability_large.png", 10.0f);
    public static Item instabilityhuge = new ItemInstability("DangerZone:Huge Instability", "res/items/instability_huge.png", 100.0f);
    public static Item firestick = new ItemFireStick("DangerZone:Spawn Fire", "res/items/firestick.png");
    public static Item spidersilk = new ItemSpiderSilk("DangerZone:Spider Silk", "res/items/spidersilk.png");
    public static Item bucket = new ItemBucket("DangerZone:Bucket", "res/items/bucket.png");
    public static Item bucketwater = new ItemBucketWater("DangerZone:Water Bucket", "res/items/bucketwater.png");
    public static Item bucketmilk = new ItemBucketMilk("DangerZone:Milk Bucket", "res/items/bucketmilk.png", 12);
    public static Item fireball = new ItemFireball("DangerZone:Fireball", "res/items/itemfireball.png", 10);
    public static Item[] ItemArray;
    public static final int itemsMAX = 2048;
    public static Properties prop;

    static {
        prop = null;
    }

    public Items() {
        ItemArray = new Item[2048];
        int i = 0;
        while (i < 2048) {
            Items.ItemArray[i] = null;
            ++i;
        }
    }

    public static int registerItem(Item b) {
        int i = 0;
        i = 1;
        while (i < 2048) {
            if (ItemArray[i] != null && Items.ItemArray[i].uniquename.equals(b.uniquename)) {
                return 0;
            }
            ++i;
        }
        i = 1;
        while (i < 2048) {
            if (ItemArray[i] == null) break;
            ++i;
        }
        if (i >= 2047) {
            return 0;
        }
        if (prop != null) {
            i = Utils.getPropertyInt(prop, b.uniquename, 1, 2047, i);
        }
        if (ItemArray[i] == null) {
            Items.ItemArray[i] = b;
            b.itemID = i;
            if (prop != null) {
                prop.setProperty(b.uniquename, String.format("%d", i));
            }
            return i;
        }
        Item intruder = ItemArray[i];
        int isave = i;
        Items.ItemArray[i] = b;
        b.itemID = i;
        i = 1;
        while (i < 2048) {
            if (ItemArray[i] == null) {
                Items.ItemArray[i] = intruder;
                intruder.itemID = i;
                if (prop != null) {
                    prop.setProperty(intruder.uniquename, String.format("%d", i));
                }
                return isave;
            }
            ++i;
        }
        return 0;
    }

    public static void reRegisterItemAt(String s, int loc) {
        if (loc <= 0 || loc >= 2048) {
            return;
        }
        if (s == null || s.equals("")) {
            return;
        }
        if (ItemArray[loc] != null) {
            if (s.equals(Items.ItemArray[loc].uniquename)) {
                return;
            }
            int i = 1;
            while (i < 2048) {
                if (ItemArray[i] != null && s.equals(Items.ItemArray[i].uniquename)) {
                    Item me = ItemArray[i];
                    Item intruder = ItemArray[loc];
                    Items.ItemArray[loc] = me;
                    Items.ItemArray[loc].itemID = loc;
                    Items.ItemArray[i] = intruder;
                    Items.ItemArray[i].itemID = i;
                    return;
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < 2048) {
                if (ItemArray[i] != null && s.equals(Items.ItemArray[i].uniquename)) {
                    Items.ItemArray[loc] = ItemArray[i];
                    Items.ItemArray[loc].itemID = loc;
                    Items.ItemArray[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static void load() {
        FileInputStream input = null;
        prop = new Properties();
        String filepath = new String();
        filepath = String.format("worlds/%s/itemIDs.dat", DangerZone.worldname);
        try {
            input = new FileInputStream(filepath);
            prop.load(input);
        }
        catch (IOException ex) {
            input = null;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void save() {
        FileOutputStream output = null;
        String filepath = new String();
        filepath = String.format("worlds/%s/itemIDs.dat", DangerZone.worldname);
        File f = new File(filepath);
        f.getParentFile().mkdirs();
        try {
            output = new FileOutputStream(filepath);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean alwaystick(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].alwaystick;
    }

    public static boolean randomtick(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].randomtick;
    }

    public static boolean shouldShow(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].showInInventory;
    }

    public static Texture getTexture(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        if (ItemArray[itemid] == null) {
            return null;
        }
        return ItemArray[itemid].getTexture();
    }

    public static void doitemtick(World w, int d, int x, int y, int z, int itemid) {
        if (itemid <= 0) {
            return;
        }
        if (itemid >= 2048) {
            return;
        }
        if (ItemArray[itemid] == null) {
            return;
        }
        ItemArray[itemid].tickMe(w, d, x, y, z);
    }

    public static void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int itemid, int meta, int sides, boolean focused) {
        if (itemid <= 0) {
            return;
        }
        if (itemid >= 2048) {
            return;
        }
        if (ItemArray[itemid] == null) {
            return;
        }
        ItemArray[itemid].renderMe(wr, w, d, x, y, z, itemid, meta, sides, focused);
    }

    public static int getMaxStack(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].maxstack;
    }

    public static int getAttackStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].attackstrength;
    }

    public static int getWoodStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].woodstrength;
    }

    public static int getStoneStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].stonestrength;
    }

    public static int getDirtStrength(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].dirtstrength;
    }

    public static int getMaxUses(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].maxuses;
    }

    public static boolean rightClickOnBlock(int itemid, Player p, int d, int x, int y, int z, int side) {
        if (itemid <= 0) {
            return true;
        }
        if (itemid >= 2048) {
            return true;
        }
        if (ItemArray[itemid] == null) {
            return true;
        }
        return ItemArray[itemid].rightClickOnBlock(p, d, x, y, z, side);
    }

    public static Item getItem(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        return ItemArray[itemid];
    }

    public static String getUniqueName(int itemid) {
        if (itemid <= 0) {
            return null;
        }
        if (itemid >= 2048) {
            return null;
        }
        if (ItemArray[itemid] == null) {
            return null;
        }
        return Items.ItemArray[itemid].uniquename;
    }

    public static int findByName(String name) {
        if (name == null) {
            return 0;
        }
        int i = 1;
        while (i < 2048) {
            if (ItemArray[i] != null && Items.ItemArray[i].uniquename != null && name.equals(Items.ItemArray[i].uniquename)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static float getLightLevel(int itemid) {
        if (itemid <= 0) {
            return 0.0f;
        }
        if (itemid >= 2048) {
            return 0.0f;
        }
        if (ItemArray[itemid] == null) {
            return 0.0f;
        }
        return Items.ItemArray[itemid].brightness;
    }

    public static float getFoodValue(int itemid) {
        if (itemid <= 0) {
            return 0.0f;
        }
        if (itemid >= 2048) {
            return 0.0f;
        }
        if (ItemArray[itemid] == null) {
            return 0.0f;
        }
        return Items.ItemArray[itemid].foodvalue;
    }

    public static boolean isFood(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].isfood;
    }

    public static boolean eatAnyTime(int itemid) {
        if (itemid <= 0) {
            return false;
        }
        if (itemid >= 2048) {
            return false;
        }
        if (ItemArray[itemid] == null) {
            return false;
        }
        return Items.ItemArray[itemid].eatanytime;
    }

    public static int getBurnTime(int itemid) {
        if (itemid <= 0) {
            return 0;
        }
        if (itemid >= 2048) {
            return 0;
        }
        if (ItemArray[itemid] == null) {
            return 0;
        }
        return Items.ItemArray[itemid].burntime;
    }

    public static int getMenu(int itemid) {
        if (itemid <= 0) {
            return InventoryMenus.GENERIC;
        }
        if (itemid >= 2048) {
            return InventoryMenus.GENERIC;
        }
        if (ItemArray[itemid] == null) {
            return InventoryMenus.GENERIC;
        }
        return Items.ItemArray[itemid].menu;
    }
}

