/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.ThrownBlockItem;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class ThrownFireball
extends ThrownBlockItem {
    public float explosive_power = 1.0f;

    public ThrownFireball(World w) {
        super(w);
        this.uniquename = "DangerZone:ThrownFireball";
        this.setAttackDamage(10.0f);
        this.maxrenderdist = 120;
    }

    @Override
    public void doSpecialEffects(float x, float y, float z) {
        int pfreq = 40;
        if (this.explosive_power >= 10.0f) {
            pfreq = 20;
        }
        if (this.explosive_power >= 100.0f) {
            pfreq = 10;
        }
        if (this.explosive_power >= 1000.0f) {
            pfreq = 5;
        }
        if (this.world.rand.nextInt(pfreq) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleFire", this.world.rand.nextInt(2) + 1, this.dimension, x, y, z);
        }
        if (this.world.rand.nextInt(pfreq) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", this.world.rand.nextInt(2) + 1, this.dimension, x, y, z);
        }
    }

    @Override
    public void doHitSomething(boolean hb, float x, float y, float z, boolean he, Entity ent) {
        double fz;
        double fy;
        double fx;
        float dr;
        double dir;
        int which;
        if (this.explosive_power > 100.0f) {
            this.explosive_power = 100.0f;
        }
        if (he && ent != null) {
            ent.doAttackFrom(this.thrower, 9, this.getAttackDamage() * this.explosive_power);
            ent.doSetOnFire(100);
            float dir2 = (float)Math.atan2(ent.posz - z, ent.posx - x);
            float hdist = (float)Math.sqrt((ent.posx - x) * (ent.posx - x) + (ent.posz - z) * (ent.posz - z));
            float ydir = (float)Math.atan2(ent.posy + ent.getHeight() / 2.0f - y, hdist);
            float knockback = this.explosive_power / 5.0f;
            if (knockback > 10.0f) {
                knockback = 10.0f;
            }
            ent.motionx = (float)((double)ent.motionx + Math.cos(dir2) * 1.5 * (double)knockback * Math.cos(ydir));
            ent.motionz = (float)((double)ent.motionz + Math.sin(dir2) * 1.5 * (double)knockback * Math.cos(ydir));
            ent.motiony = (float)((double)ent.motiony + (double)(0.15f * knockback) * Math.sin(ydir));
            if (ent instanceof Player) {
                Player pl = (Player)ent;
                pl.server_thread.sendVelocityUpdateToPlayer(ent.motionx, ent.motiony, ent.motionz);
            }
        }
        if ((which = this.world.rand.nextInt(5)) == 0) {
            this.world.playSound("DangerZone:small_explosion1", this.dimension, this.posx + this.motionx, this.posy + this.motiony, this.posz + this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
        if (which == 1) {
            this.world.playSound("DangerZone:small_explosion2", this.dimension, this.posx + this.motionx, this.posy + this.motiony, this.posz + this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
        if (which == 2) {
            this.world.playSound("DangerZone:small_explosion3", this.dimension, this.posx + this.motionx, this.posy + this.motiony, this.posz + this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
        if (which == 3) {
            this.world.playSound("DangerZone:small_explosion4", this.dimension, this.posx + this.motionx, this.posy + this.motiony, this.posz + this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
        if (which == 4) {
            this.world.playSound("DangerZone:small_explosion5", this.dimension, this.posx + this.motionx, this.posy + this.motiony, this.posz + this.motionz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
        float raydist = (float)Math.sqrt(this.explosive_power);
        float curdist = 0.0f;
        int nray = (int)(this.explosive_power * 30.0f);
        int spk = 2;
        if (this.explosive_power >= 10.0f) {
            spk = 10;
        }
        int i = 0;
        while (i < nray) {
            int bid;
            int iz;
            int iy;
            int ix;
            dir = Math.toRadians(this.world.rand.nextDouble() * 360.0);
            double xzscale = Math.toRadians(this.world.rand.nextDouble() * 360.0);
            double dx = Math.cos(dir);
            double dz = Math.sin(dir);
            double dy = Math.cos(xzscale) / 2.0;
            xzscale = Math.abs(Math.sin(xzscale));
            dx *= xzscale;
            dz *= xzscale;
            float raypower = this.explosive_power * 20.0f;
            float powerlost = 0.0f;
            int lz = 0;
            int ly = 0;
            int lx = 0;
            dr = raydist + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f * raydist;
            curdist = i;
            curdist /= (float)nray;
            curdist *= dr;
            while (curdist < dr) {
                fx = (double)(this.posx + this.motionx) + dx * (double)curdist;
                fy = (double)(this.posy + this.motiony) + dy * (double)curdist;
                fz = (double)(this.posz + this.motionz) + dz * (double)curdist;
                ix = (int)fx;
                iy = (int)fy;
                iz = (int)fz;
                if (ix != lx || iy != ly || iz != lz) {
                    lx = ix;
                    ly = iy;
                    lz = iz;
                    bid = this.world.getblock(this.dimension, ix, iy, iz);
                    if (bid != 0) {
                        float powerleft = raypower * (dr - curdist) / dr;
                        if ((powerleft -= powerlost) <= 0.0f) break;
                        if (powerleft > (float)Blocks.getMinDamage(bid) && powerleft > (float)Blocks.getMaxDamage(bid)) {
                            if (this.explosive_power > 500.0f && curdist / dr < 0.9f) {
                                this.world.setblockandmetanonotify(this.dimension, ix, iy, iz, 0, 0);
                            } else {
                                this.world.setblockandmeta(this.dimension, ix, iy, iz, 0, 0);
                            }
                            if (this.world.rand.nextInt(spk) == 0) {
                                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", this.world.rand.nextInt(3) + 3, this.dimension, (float)fx, (float)fy, (float)fz);
                            }
                            if (this.world.rand.nextInt(spk * 2) == 0) {
                                Utils.doDropRand(this.world, bid, 0, raydist, this.dimension, (float)fx, (float)fy, (float)fz);
                            }
                        }
                        powerlost += (float)Blocks.getMaxDamage(bid);
                    }
                    if (this.world.rand.nextInt(spk) == 0) {
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 1, this.dimension, (float)fx, (float)fy, (float)fz);
                    }
                }
                curdist += 0.1701f;
            }
            if (powerlost == 0.0f) {
                lz = 0;
                ly = 0;
                lx = 0;
                while (curdist < dr * 4.0f) {
                    fx = (double)(this.posx + this.motionx) + dx * (double)curdist;
                    fy = (double)(this.posy + this.motiony) + dy * (double)curdist;
                    fz = (double)(this.posz + this.motionz) + dz * (double)curdist;
                    ix = (int)fx;
                    iy = (int)fy;
                    iz = (int)fz;
                    if (ix != lx || iy != ly || iz != lz) {
                        lx = ix;
                        ly = iy;
                        lz = iz;
                        bid = this.world.getblock(this.dimension, ix, iy, iz);
                        if (bid != 0) {
                            Entity eb;
                            if (Blocks.getBurnTime(bid) <= 0 || this.world.rand.nextInt(3) != 1 || (eb = this.world.createEntityByName("DangerZone:Fire", this.dimension, (float)ix + 0.5f, (float)iy - 0.0625f, (float)iz + 0.5f)) == null) break;
                            eb.init();
                            this.world.spawnEntityInWorld(eb);
                            break;
                        }
                        if (this.world.rand.nextInt((int)curdist + 1) == 0) {
                            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleFire", this.world.rand.nextInt(2) + 1, this.dimension, (float)fx, (float)fy, (float)fz);
                        }
                        if (this.world.rand.nextInt((int)curdist + 1) == 0) {
                            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", this.world.rand.nextInt(2) + 1, this.dimension, (float)fx, (float)fy, (float)fz);
                        }
                    }
                    curdist += 0.3301f;
                }
            }
            ++i;
        }
        dr = raydist * 2.0f;
        List<Entity> nearby_list = null;
        Entity enthit = null;
        float knockback = this.explosive_power / 2.0f;
        if (knockback > 20.0f) {
            knockback = 20.0f;
        }
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f + dr, this.dimension, this.posx, this.posy, this.posz);
        ListIterator<Entity> li = nearby_list.listIterator();
        while (li.hasNext()) {
            enthit = li.next();
            if (enthit == this || enthit.canthitme || enthit == this.thrower) continue;
            fx = this.posx + this.motionx - enthit.posx;
            fy = this.posy + this.motiony - enthit.posy;
            fz = this.posz + this.motionz - enthit.posz;
            curdist = (float)Math.sqrt(fx * fx + fy * fy + fz * fz);
            if ((curdist -= enthit.getWidth() / 2.0f) < 0.0f) {
                curdist = 0.0f;
            }
            if (!(curdist < dr)) continue;
            enthit.doSetOnFire(100);
            enthit.doAttackFrom(this.thrower, 9, this.getAttackDamage() * this.explosive_power * (dr - curdist) / dr);
            dir = Math.atan2(enthit.posz - z, enthit.posx - x);
            float hdist = (float)Math.sqrt((enthit.posx - x) * (enthit.posx - x) + (enthit.posz - z) * (enthit.posz - z));
            float ydir = (float)Math.atan2(enthit.posy + enthit.getHeight() / 2.0f - y, hdist);
            enthit.motionx = (float)((double)enthit.motionx + Math.cos(dir) * 1.5 * (double)knockback * (double)(dr - curdist) * Math.cos(ydir) / (double)dr);
            enthit.motionz = (float)((double)enthit.motionz + Math.sin(dir) * 1.5 * (double)knockback * (double)(dr - curdist) * Math.cos(ydir) / (double)dr);
            enthit.motiony = (float)((double)enthit.motiony + (double)(0.15f * knockback * (dr - curdist)) * Math.sin(ydir) / (double)dr);
            if (!(enthit instanceof Player)) continue;
            Player pl = (Player)enthit;
            pl.server_thread.sendVelocityUpdateToPlayer(enthit.motionx, enthit.motiony, enthit.motionz);
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/misc/fireball.png");
        }
        return this.texture;
    }
}

