/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Sparklemuffin
extends EntityLiving {
    public Sparklemuffin(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.65f;
        this.width = 1.25f;
        this.uniquename = "DangerZone:Sparklemuffin";
        this.moveSpeed = 0.35f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(5.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 75;
        this.setExperience(123);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:fuzzbutt_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:fuzzbutt_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:fuzzbutt_death";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophysparklemuffin.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        int howmany = 5 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.spidersilk.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Sparklemuffintexture.png");
        }
        return this.texture;
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        return !(this.getLightAtLocation(w, dimension, x, y, z) > 0.35f);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Sparklemuffin) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }
}

