/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Goose
extends EntityLiving {
    public Goose(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 1.25f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:Goose";
        this.moveSpeed = 0.1f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 55;
        this.setExperience(14);
        this.canSwim = true;
        this.swimoffset = -0.75f;
        this.setCanDespawn(false);
        this.takesFallDamage = false;
        this.setOnGround(true);
        this.enableFollowHeldFood(12);
        this.enableBreeding(10);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:goose_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:goose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:goose_death";
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.corn.itemID;
    }

    @Override
    public boolean isMate(Entity e) {
        return e instanceof Goose;
    }

    @Override
    public void makeBaby(Entity p1, Entity p2) {
        Entity newme = this.world.createEntityByName("DangerZone:Gosling", p1.dimension, (p1.posx + p2.posx) / 2.0f, (p1.posy + p2.posy) / 2.0f, (p1.posz + p2.posz) / 2.0f);
        if (newme != null) {
            newme.init();
            this.world.spawnEntityInWorld(newme);
            this.world.playSound("DangerZone:pop", this.dimension, (p1.posx + p2.posx) / 2.0f, (p1.posy + p2.posy) / 2.0f, (p1.posz + p2.posz) / 2.0f, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophygoose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.goosemeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        int i = 1 + this.world.rand.nextInt(4);
        int j = 0;
        while (j < i) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
            ++j;
        }
        if (this.world.rand.nextInt(1000) == 42) {
            j = 0;
            while (j < 1000) {
                Utils.doDropRand(this.world, 0, Items.feather.itemID, 3.5f, this.dimension, this.posx, this.posy, this.posz);
                ++j;
            }
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(5000) == 1) {
            Utils.doDropRand(this.world, 0, Items.egggosling.itemID, 0.1f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Goosetexture.png");
        }
        return this.texture;
    }
}

