/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.ModelBase;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class EntityTrophy
extends Entity {
    Entity trophyentity = null;
    ModelBase trophymodel = null;
    float trophyscale = 1.0f;
    int checker = 0;

    public EntityTrophy(World w) {
        super(w);
        this.uniquename = "DangerZone:EntityTrophy";
        this.ignoreCollisions = true;
        this.width = 1.0f;
        this.height = 1.0f;
        if (w != null) {
            this.checker = 100 + this.world.rand.nextInt(100);
        }
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (!this.world.isServer) {
            return;
        }
        if (dt == 9) {
            Utils.doDropRand(this.world, 0, this.getIID(), 1.0f, this.dimension, this.posx, this.posy, this.posz);
            this.deadflag = true;
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.trophyentity == null) {
            this.trophyentity = this.world.createEntityByName(this.getVarString(0), this.dimension, this.posx, this.posy, this.posz);
            if (this.trophyentity != null) {
                this.trophymodel = this.trophyentity.model;
                this.trophyscale = this.getVarFloat(0);
            }
        }
        --this.checker;
        if (this.checker <= 0 && this.world.isServer) {
            List<Entity> nearby_list = null;
            this.checker = 100 + this.world.rand.nextInt(100);
            nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(2.0f, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                Entity e = null;
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = li.next();
                    if (!(e instanceof EntityTrophy) || e == this || (int)e.posx != (int)this.posx || (int)e.posy != (int)this.posy || (int)e.posz != (int)this.posz) continue;
                    this.rightClickedByPlayer(null, null);
                    break;
                }
            }
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        this.rotation_yaw_motion = 1.0f;
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.trophyentity != null) {
            return this.trophyentity.getTexture();
        }
        return null;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (!this.world.isServer) {
            return false;
        }
        Utils.doDropRand(this.world, 0, this.getIID(), 1.0f, this.dimension, this.posx, this.posy, this.posz);
        this.deadflag = true;
        return false;
    }
}

