/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import java.util.List;
import java.util.ListIterator;

public class EntityLightning
extends Entity {
    public int countdown = 0;
    public int[] myranddata;
    public int nextrand = 0;

    public EntityLightning(World w) {
        super(w);
        this.uniquename = "DangerZone:Lightning";
        this.ignoreCollisions = true;
        this.width = 0.25f;
        this.height = 0.25f;
        this.setAttackDamage(0.0f);
    }

    @Override
    public void init() {
        this.nextrand = 0;
        this.myranddata = new int[100];
        int i = 0;
        while (i < 100) {
            this.myranddata[i] = this.world.rand.nextInt(1000);
            ++i;
        }
    }

    public void resetrand() {
        this.nextrand = 0;
    }

    public int getnextrand(int inrange) {
        ++this.nextrand;
        return this.myranddata[this.nextrand % 100] % inrange;
    }

    @Override
    public void update(float deltaT) {
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        if (this.world.isServer) {
            ++this.countdown;
            if (this.countdown == 1) {
                String thunder = String.format("DangerZone:thunder%d", this.world.rand.nextInt(4) + 1);
                this.world.playSound(thunder, this.dimension, this.posx, this.posy, this.posz, 7.3f, 1.0f);
                List<Entity> nearby_list = null;
                Entity enthit = null;
                nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f, this.dimension, this.posx, this.posy, this.posz);
                ListIterator<Entity> li = nearby_list.listIterator();
                while (li.hasNext()) {
                    enthit = li.next();
                    if (enthit == this || enthit.canthitme || !(enthit instanceof EntityLiving) || !(enthit.posy + enthit.getHeight() > this.posy - 3.0f) || !(enthit.posy < this.posy + 100.0f)) continue;
                    float edist = enthit.getHorizontalDistanceFromEntity(this.posx, this.posz);
                    edist -= this.getWidth() / 2.0f;
                    if (!((edist -= enthit.getWidth() / 2.0f) < 3.0f)) continue;
                    enthit.doAttackFrom(this, 12, 75.0f);
                }
            }
            if (this.countdown >= 10) {
                if ((int)this.getAttackDamage() > 0) {
                    Explosion.boom(this.world, this.dimension, this.posx, this.posy, this.posz, (int)this.getAttackDamage(), true);
                }
                this.deadflag = true;
            }
        }
        super.update(deltaT);
    }
}

