/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.ModelBase;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldRendererUtils;
import dangerzone.blocks.Blocks;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Entity {
    public int dimension;
    public float posx;
    public float posy;
    public float posz;
    public float motionx;
    public float motiony;
    public float motionz;
    public float rotation_yaw;
    public float rotation_pitch;
    public float rotation_roll;
    public volatile float rotation_yaw_head;
    public volatile float rotation_pitch_head;
    public float rotation_roll_head;
    public float rotation_yaw_motion;
    public float rotation_pitch_motion;
    public float rotation_roll_motion;
    public int prevdimension;
    public float prevposx;
    public float prevposy;
    public float prevposz;
    public float prevrotation_yaw;
    public float prevrotation_pitch;
    public float prevrotation_roll;
    public float prevrotation_yaw_head;
    public float prevrotation_pitch_head;
    public float prevrotation_roll_head;
    public float display_posx;
    public float display_posy;
    public float display_posz;
    public float display_rotation_yaw;
    public float display_rotation_pitch;
    public float display_rotation_roll;
    public float width = 0.75f;
    public float height = 1.95f;
    public boolean deadflag = false;
    public int entityID = 0;
    public long lasttime = System.currentTimeMillis();
    public long currtime;
    public World world = null;
    public int maxrenderdist = 256;
    public String uniquename;
    public long lifetimeticker;
    public int hurtanimationtimer;
    public int madtimer = 0;
    public int diffticker;
    public ModelBase model;
    public Texture texture;
    public final int maxvars = 32;
    public final int maxinv = 100;
    public short changed;
    public short[] changes;
    public int[] entity_ints;
    public float[] entity_floats;
    public String[] entity_strings;
    public InventoryContainer[] entity_inventory;
    public boolean has_inventory = false;
    public boolean takesFallDamage = false;
    public boolean ignoreCollisions = false;
    public boolean canthitme = false;
    public boolean movement_friction = true;
    public int stray_entity_ticker = 0;
    public int firecounter = 0;
    public boolean sit_when_riding = true;
    public boolean always_draw = false;
    public int temperament = 0;
    public boolean canFly = false;

    public Entity(World w) {
        this.world = w;
        this.posx = 0.0f;
        this.posy = 0.0f;
        this.posz = 0.0f;
        this.rotation_yaw = 0.0f;
        this.rotation_pitch = 0.0f;
        this.rotation_roll = 0.0f;
        this.rotation_yaw_head = 0.0f;
        this.rotation_pitch_head = 0.0f;
        this.rotation_roll_head = 0.0f;
        this.dimension = 1;
        this.prevdimension = 1;
        this.prevposz = 0.0f;
        this.prevposy = 0.0f;
        this.prevposx = 0.0f;
        this.prevrotation_roll = 0.0f;
        this.prevrotation_pitch = 0.0f;
        this.prevrotation_yaw = 0.0f;
        this.prevrotation_roll_head = 0.0f;
        this.prevrotation_pitch_head = 0.0f;
        this.prevrotation_yaw_head = 0.0f;
        this.deadflag = false;
        this.lifetimeticker = 0L;
        this.uniquename = "DangerZone:BaseEntity";
        this.changed = 0;
        this.entity_ints = new int[32];
        this.entity_floats = new float[32];
        this.entity_strings = new String[32];
        int i = 0;
        while (i < 32) {
            this.entity_ints[i] = 0;
            this.entity_floats[i] = 0.0f;
            this.entity_strings[i] = null;
            ++i;
        }
        this.changes = new short[100];
        i = 0;
        while (i < 100) {
            this.changes[i] = 0;
            ++i;
        }
        this.entity_inventory = new InventoryContainer[100];
        i = 0;
        while (i < 100) {
            this.entity_inventory[i] = null;
            ++i;
        }
        this.hurtanimationtimer = 0;
        this.texture = null;
        this.canthitme = false;
        this.setCanDespawn(true);
        this.diffticker = 0;
    }

    public void init() {
        this.setVarInt(10, 0);
        this.setVarInt(11, 0);
        this.setSitting(false);
    }

    public void de_init() {
        int i = this.getVarInt(10);
        int j = this.getVarInt(11);
        this.setVarInt(10, 0);
        this.setVarInt(11, 0);
        if (i != 0 || j != 0) {
            this.setSitting(false);
        }
    }

    public void setSize(float x_size, float y_size) {
        this.width = x_size;
        this.height = y_size;
    }

    public float getWidth() {
        if (this.isBaby()) {
            return this.width / 4.0f;
        }
        return this.width;
    }

    public float getHeight() {
        if (this.isBaby()) {
            return this.height / 4.0f;
        }
        return this.height;
    }

    public int getVarInt(int index) {
        if (index < 0 || index >= 32) {
            return 0;
        }
        return this.entity_ints[index];
    }

    public float getVarFloat(int index) {
        if (index < 0 || index >= 32) {
            return 0.0f;
        }
        return this.entity_floats[index];
    }

    public String getVarString(int index) {
        if (index < 0 || index >= 32) {
            return null;
        }
        return this.entity_strings[index];
    }

    public InventoryContainer getVarInventory(int index) {
        if (!this.has_inventory) {
            return null;
        }
        if (index < 0 || index >= 100) {
            return null;
        }
        return this.entity_inventory[index];
    }

    public void setVarInt(int index, int val) {
        if (index < 0 || index >= 32) {
            return;
        }
        if (this.entity_ints[index] != val) {
            this.entity_ints[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 1);
            this.changed = 1;
        }
    }

    public void setVarFloat(int index, float val) {
        if (index < 0 || index >= 32) {
            return;
        }
        if (this.entity_floats[index] != val) {
            this.entity_floats[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 2);
            this.changed = 1;
        }
    }

    public void setVarString(int index, String val) {
        if (index < 0 || index >= 32) {
            return;
        }
        if (this.entity_strings[index] != val) {
            this.entity_strings[index] = val;
            int n = index;
            this.changes[n] = (short)(this.changes[n] | 4);
            this.changed = 1;
        }
    }

    public void setVarInventory(int index, InventoryContainer val) {
        if (!this.has_inventory) {
            return;
        }
        if (index < 0 || index >= 100) {
            return;
        }
        if (val == null && this.entity_inventory[index] == null) {
            return;
        }
        this.entity_inventory[index] = val;
        int n = index;
        this.changes[n] = (short)(this.changes[n] | 8);
        this.changed = 1;
    }

    public void setVarInventoryChanged(int index) {
        if (!this.has_inventory) {
            return;
        }
        if (index < 0 || index >= 100) {
            return;
        }
        int n = index;
        this.changes[n] = (short)(this.changes[n] | 8);
        this.changed = 1;
    }

    public void setMaxHealth(float f) {
        this.setVarFloat(0, f);
    }

    public float getMaxHealth() {
        if (this.isBaby()) {
            return this.getVarFloat(0) / 16.0f;
        }
        return this.getVarFloat(0);
    }

    public void setHealth(float f) {
        if (f > this.getMaxHealth()) {
            f = this.getMaxHealth();
        }
        this.setVarFloat(1, f);
        if (this instanceof Player && this.world != null && this.world.isServer) {
            Player pl = (Player)this;
            if (pl.server_thread != null) {
                pl.server_thread.sendVarFloatUpdate(1, f);
            }
        }
    }

    public void heal(float f) {
        float mh = this.getMaxHealth();
        float newhealth = this.getHealth() + f;
        if (newhealth > mh) {
            newhealth = mh;
        }
        this.setHealth(newhealth);
    }

    public float getHealth() {
        float f = this.getVarFloat(1);
        if (f > this.getMaxHealth()) {
            f = this.getMaxHealth();
            this.setVarFloat(1, f);
            if (this instanceof Player && this.world != null && this.world.isServer) {
                Player pl = (Player)this;
                if (pl.server_thread != null) {
                    pl.server_thread.sendVarFloatUpdate(1, f);
                }
            }
        }
        return f;
    }

    public void setDefense(float f) {
        this.setVarFloat(2, f);
    }

    public float getDefense() {
        return this.getVarFloat(2);
    }

    public void setAttackDamage(float f) {
        this.setVarFloat(3, f);
    }

    public float getAttackDamage() {
        return this.getVarFloat(3);
    }

    public void setMaxHunger(float f) {
        this.setVarFloat(4, f);
    }

    public float getMaxHunger() {
        return this.getVarFloat(4);
    }

    public void setHunger(float f) {
        this.setVarFloat(5, f);
    }

    public float getHunger() {
        return this.getVarFloat(5);
    }

    public void setMaxAir(float f) {
        this.setVarFloat(6, f);
    }

    public float getMaxAir() {
        return this.getVarFloat(6);
    }

    public void setAir(float f) {
        this.setVarFloat(7, f);
    }

    public float getAir() {
        return this.getVarFloat(7);
    }

    public void setBID(int f) {
        this.setVarInt(0, f);
    }

    public int getBID() {
        return this.getVarInt(0);
    }

    public void setIID(int f) {
        this.setVarInt(1, f);
    }

    public int getIID() {
        return this.getVarInt(1);
    }

    public int getGameMode() {
        return this.getVarInt(2);
    }

    public void setGameMode(int f) {
        this.setVarInt(2, f);
    }

    public void sethotbarindex(int f) {
        this.setVarInt(3, f);
    }

    public int gethotbarindex() {
        return this.getVarInt(3);
    }

    public void setItemDamage(int f) {
        this.setVarInt(4, f);
    }

    public int getItemDamage() {
        return this.getVarInt(4);
    }

    public void setAttacking(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 1) : (f &= 0xFFFFFFFE);
        this.setVarInt(5, f);
    }

    public boolean getAttacking() {
        return (this.getVarInt(5) & 1) == 1;
    }

    public void setInLiquid(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 2) : (f &= 0xFFFFFFFD);
        this.setVarInt(5, f);
    }

    public boolean getInLiquid() {
        return (this.getVarInt(5) & 2) == 2;
    }

    public void setOnGround(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 4) : (f &= 0xFFFFFFFB);
        this.setVarInt(5, f);
    }

    public boolean getOnGround() {
        return (this.getVarInt(5) & 4) == 4;
    }

    public void setStaying(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 8) : (f &= 0xFFFFFFF7);
        this.setVarInt(5, f);
    }

    public boolean getStaying() {
        return (this.getVarInt(5) & 8) == 8;
    }

    public void setCanDespawn(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x10) : (f &= 0xFFFFFFEF);
        this.setVarInt(5, f);
    }

    public boolean getCanDespawn() {
        return (this.getVarInt(5) & 0x10) == 16;
    }

    public void setSitting(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x20) : (f &= 0xFFFFFFDF);
        this.setVarInt(5, f);
    }

    public boolean getSitting() {
        return (this.getVarInt(5) & 0x20) == 32;
    }

    public void setBaby(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x40) : (f &= 0xFFFFFFBF);
        this.setVarInt(5, f);
        if (this instanceof Player && this.world.isServer) {
            Player p = (Player)this;
            p.server_thread.sendVarIntUpdate(5, f);
        }
    }

    public boolean isBaby() {
        return (this.getVarInt(5) & 0x40) == 64;
    }

    public void setQuiet(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x80) : (f &= 0xFFFFFF7F);
        this.setVarInt(5, f);
    }

    public boolean getQuiet() {
        return (this.getVarInt(5) & 0x80) == 128;
    }

    public void setSinging(boolean tf) {
        int f = this.getVarInt(5);
        f = tf ? (f |= 0x100) : (f &= 0xFFFFFEFF);
        this.setVarInt(5, f);
    }

    public boolean getSinging() {
        return (this.getVarInt(5) & 0x100) == 256;
    }

    public void setExperience(int f) {
        this.setVarInt(6, f);
    }

    public int getExperience() {
        return this.getVarInt(6);
    }

    public void setInitialized(int f) {
        this.setVarInt(8, f);
    }

    public int getInitialized() {
        return this.getVarInt(8);
    }

    public void setOnFire(int f) {
        this.setVarInt(9, f);
    }

    public void doSetOnFire(int f) {
        if (!(this instanceof Player)) {
            this.setVarInt(9, f);
        } else if (this.world.isServer) {
            Player p = (Player)this;
            p.server_thread.sendVarIntUpdate(9, f);
        }
    }

    public int getOnFire() {
        return this.getVarInt(9);
    }

    public String getOwnerName() {
        return this.getVarString(0);
    }

    public void setOwnerName(String s) {
        this.setVarString(0, s);
    }

    public String getPetName() {
        return this.getVarString(1);
    }

    public void setPetName(String s) {
        this.setVarString(1, s);
    }

    public void Mount(Entity rider) {
        if (rider == null) {
            return;
        }
        this.setVarInt(10, rider.entityID);
        rider.setVarInt(11, this.entityID);
        if (this.world.isServer) {
            rider.setSitting(this.sit_when_riding);
            if (rider instanceof Player) {
                Player p = (Player)rider;
                p.server_thread.sendMountCommand(this.entityID);
            }
        }
    }

    public void unMount(Entity rider) {
        this.setVarInt(10, 0);
        if (rider != null) {
            rider.setVarInt(11, 0);
        }
        if (this.world.isServer && rider != null) {
            rider.setSitting(false);
            if (rider instanceof Player) {
                Player p = (Player)rider;
                p.server_thread.sendMountCommand(0);
            }
        }
    }

    public boolean isMountedBy(Entity e) {
        return this.getVarInt(10) == e.entityID;
    }

    public Entity getRiddenEntity() {
        Entity mounted = null;
        int i = this.getVarInt(11);
        if (i == 0) {
            return null;
        }
        mounted = this.world.isServer ? DangerZone.server.entityManager.findEntityByID(i) : DangerZone.entityManager.findEntityByID(i);
        return mounted;
    }

    public float getRiderYoffset() {
        return this.getHeight();
    }

    public float getRiderXZoffset() {
        return 0.0f;
    }

    public Entity getRiderEntity() {
        Entity rider = null;
        int i = this.getVarInt(10);
        if (i == 0) {
            return null;
        }
        rider = this.world.isServer ? DangerZone.server.entityManager.findEntityByID(i) : DangerZone.entityManager.findEntityByID(i);
        return rider;
    }

    public void setForward(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 1) : (f &= 0xFFFFFFFE);
        this.setVarInt(12, f);
    }

    public boolean getForward() {
        return (this.getVarInt(12) & 1) == 1;
    }

    public void setBackward(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 2) : (f &= 0xFFFFFFFD);
        this.setVarInt(12, f);
    }

    public boolean getBackward() {
        return (this.getVarInt(12) & 2) == 2;
    }

    public void setLeft(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 4) : (f &= 0xFFFFFFFB);
        this.setVarInt(12, f);
    }

    public boolean getLeft() {
        return (this.getVarInt(12) & 4) == 4;
    }

    public void setRight(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 8) : (f &= 0xFFFFFFF7);
        this.setVarInt(12, f);
    }

    public boolean getRight() {
        return (this.getVarInt(12) & 8) == 8;
    }

    public void setUp(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 0x10) : (f &= 0xFFFFFFEF);
        this.setVarInt(12, f);
    }

    public boolean getUp() {
        return (this.getVarInt(12) & 0x10) == 16;
    }

    public void setDown(boolean tf) {
        int f = this.getVarInt(12);
        f = tf ? (f |= 0x20) : (f &= 0xFFFFFFDF);
        this.setVarInt(12, f);
    }

    public boolean getDown() {
        return (this.getVarInt(12) & 0x20) == 32;
    }

    public InventoryContainer getInventory(int i) {
        if (i >= 0 && i <= 49) {
            return this.getVarInventory(i);
        }
        return null;
    }

    public InventoryContainer getHotbar(int i) {
        if (i >= 0 && i <= 9) {
            return this.getVarInventory(i + 50);
        }
        return null;
    }

    public InventoryContainer getArmor(int i) {
        if (i >= 0 && i <= 3) {
            return this.getVarInventory(i + 60);
        }
        return null;
    }

    public void setInventory(int i, InventoryContainer ic) {
        if (i >= 0 && i <= 49) {
            this.setVarInventory(i, ic);
        }
    }

    public void setInventoryChanged(int i) {
        if (i >= 0 && i <= 49) {
            this.setVarInventoryChanged(i);
        }
    }

    public void setHotbar(int i, InventoryContainer ic) {
        if (i >= 0 && i <= 9) {
            this.setVarInventory(i + 50, ic);
        }
    }

    public void setHotbarChanged(int i) {
        if (i >= 0 && i <= 9) {
            this.setVarInventoryChanged(i + 50);
        }
    }

    public void setArmor(int i, InventoryContainer ic) {
        if (i >= 0 && i <= 3) {
            this.setVarInventory(i + 60, ic);
        }
    }

    public void setArmorChanged(int i) {
        if (i >= 0 && i <= 3) {
            this.setVarInventoryChanged(i + 60);
        }
    }

    public void doAttackFrom(Entity e, int dt, float ouch) {
    }

    public boolean takesDamageFrom(int dt) {
        return true;
    }

    public void doHurtAnimation() {
    }

    public void onDeath() {
        Entity ridden = this.getRiddenEntity();
        Entity rider = this.getRiderEntity();
        if (rider != null) {
            this.unMount(rider);
        }
        if (ridden != null) {
            ridden.unMount(this);
        }
    }

    public void addKnockback(Entity hitter, float xz, float y) {
    }

    public void doArmorDamage(Entity e, int dt, float pain) {
    }

    public void jump() {
    }

    public float getRightArmAngle() {
        return 0.0f;
    }

    public boolean isHurt() {
        return false;
    }

    public boolean isMad() {
        return false;
    }

    public boolean isDying() {
        return false;
    }

    public String getLivingSound() {
        return null;
    }

    public float getLivingSoundPitch() {
        if (this.isBaby()) {
            return 2.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.2f;
        }
        return 1.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.2f;
    }

    public float getLivingSoundVolume() {
        if (this.isBaby()) {
            return 0.25f;
        }
        return 1.0f;
    }

    public String getHurtSound() {
        return null;
    }

    public String getDeathSound() {
        return null;
    }

    public String getAttackSound() {
        return null;
    }

    public void doDeathAnimation() {
    }

    public float getDeathFactor() {
        return 0.0f;
    }

    public void writeSelf(Properties prop, String tag) {
        while (this.rotation_yaw < 0.0f) {
            this.rotation_yaw += 360.0f;
        }
        this.rotation_yaw %= 360.0f;
        while (this.rotation_pitch < 0.0f) {
            this.rotation_pitch += 360.0f;
        }
        this.rotation_pitch %= 360.0f;
        while (this.rotation_roll < 0.0f) {
            this.rotation_roll += 360.0f;
        }
        this.rotation_roll %= 360.0f;
        while (this.rotation_yaw_head < 0.0f) {
            this.rotation_yaw_head += 360.0f;
        }
        this.rotation_yaw_head %= 360.0f;
        while (this.rotation_pitch_head < 0.0f) {
            this.rotation_pitch_head += 360.0f;
        }
        this.rotation_pitch_head %= 360.0f;
        while (this.rotation_roll_head < 0.0f) {
            this.rotation_roll_head += 360.0f;
        }
        this.rotation_roll_head %= 360.0f;
        prop.setProperty(String.format("%s%s", tag, "posx"), String.format("%f", Float.valueOf(this.posx)));
        prop.setProperty(String.format("%s%s", tag, "posy"), String.format("%f", Float.valueOf(this.posy)));
        prop.setProperty(String.format("%s%s", tag, "posz"), String.format("%f", Float.valueOf(this.posz)));
        prop.setProperty(String.format("%s%s", tag, "dimension"), String.format("%d", this.dimension));
        prop.setProperty(String.format("%s%s", tag, "rotation_yaw"), String.format("%f", Float.valueOf(this.rotation_yaw)));
        prop.setProperty(String.format("%s%s", tag, "rotation_pitch"), String.format("%f", Float.valueOf(this.rotation_pitch)));
        prop.setProperty(String.format("%s%s", tag, "rotation_roll"), String.format("%f", Float.valueOf(this.rotation_roll)));
        prop.setProperty(String.format("%s%s", tag, "rotation_yaw_motion"), String.format("%f", Float.valueOf(this.rotation_yaw_motion)));
        prop.setProperty(String.format("%s%s", tag, "rotation_pitch_motion"), String.format("%f", Float.valueOf(this.rotation_pitch_motion)));
        prop.setProperty(String.format("%s%s", tag, "rotation_roll_motion"), String.format("%f", Float.valueOf(this.rotation_roll_motion)));
        prop.setProperty(String.format("%s%s", tag, "motionx"), String.format("%f", Float.valueOf(this.motionx)));
        prop.setProperty(String.format("%s%s", tag, "motiony"), String.format("%f", Float.valueOf(this.motiony)));
        prop.setProperty(String.format("%s%s", tag, "motionz"), String.format("%f", Float.valueOf(this.motionz)));
        prop.setProperty(String.format("%s%s", tag, "width"), String.format("%f", Float.valueOf(this.width)));
        prop.setProperty(String.format("%s%s", tag, "height"), String.format("%f", Float.valueOf(this.height)));
        prop.setProperty(String.format("%s%s", tag, "maxrenderdist"), String.format("%d", this.maxrenderdist));
        prop.setProperty(String.format("%s%s", tag, "lifetimeticker"), String.format("%d", this.lifetimeticker));
        prop.setProperty(String.format("%s%s", tag, "rotation_yaw_head"), String.format("%f", Float.valueOf(this.rotation_yaw_head)));
        prop.setProperty(String.format("%s%s", tag, "rotation_pitch_head"), String.format("%f", Float.valueOf(this.rotation_pitch_head)));
        prop.setProperty(String.format("%s%s", tag, "rotation_roll_head"), String.format("%f", Float.valueOf(this.rotation_roll_head)));
        int i = 0;
        while (i < 32) {
            if (this.entity_ints[i] != 0) {
                prop.setProperty(String.format("%s%s%d", tag, "varint", i), String.format("%d", this.entity_ints[i]));
            }
            if (this.entity_floats[i] != 0.0f) {
                prop.setProperty(String.format("%s%s%d", tag, "varfloat", i), String.format("%f", Float.valueOf(this.entity_floats[i])));
            }
            if (this.entity_strings[i] != null) {
                prop.setProperty(String.format("%s%s%d", tag, "varstring", i), this.entity_strings[i]);
            }
            ++i;
        }
        if (this.has_inventory) {
            int i2 = 0;
            while (i2 < 100) {
                String s = String.format("%sInventory_%d:", tag, i2);
                if (this.entity_inventory[i2] != null) {
                    prop.setProperty(String.format("%s%s", s, "data"), "valid");
                    this.entity_inventory[i2].writeSelf(prop, s);
                } else {
                    prop.setProperty(String.format("%s%s", s, "data"), "null");
                }
                ++i2;
            }
        }
    }

    public void readSelf(Properties prop, String tag) {
        this.posx = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posx"), 0.0f, Float.MAX_VALUE, 10000.0f);
        this.posy = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posy"), 0.0f, 256.0f, 75.0f);
        this.posz = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "posz"), 0.0f, Float.MAX_VALUE, 10000.0f);
        this.dimension = Utils.getPropertyInt(prop, String.format("%s%s", tag, "dimension"), 1, 256, 1);
        this.rotation_yaw = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw"), 0.0f, 360.0f, 0.0f);
        this.rotation_pitch = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch"), 0.0f, 360.0f, 0.0f);
        this.rotation_roll = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll"), 0.0f, 360.0f, 0.0f);
        this.rotation_yaw_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw_motion"), -300.0f, 300.0f, 0.0f);
        this.rotation_pitch_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch_motion"), -300.0f, 300.0f, 0.0f);
        this.rotation_roll_motion = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll_motion"), -300.0f, 300.0f, 0.0f);
        this.motionx = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motionx"), -10.0f, 10.0f, 0.0f);
        this.motiony = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motiony"), -10.0f, 10.0f, 0.0f);
        this.motionz = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "motionz"), -10.0f, 10.0f, 0.0f);
        this.width = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "width"), 0.1f, 30.0f, this.width);
        this.height = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "height"), 0.1f, 50.0f, this.height);
        this.maxrenderdist = Utils.getPropertyInt(prop, String.format("%s%s", tag, "maxrenderdist"), 2, 512, 16 * DangerZone.renderdistance);
        this.lifetimeticker = Utils.getPropertyLong(prop, String.format("%s%s", tag, "lifetimeticker"), 0L, Long.MAX_VALUE, 0L);
        this.rotation_yaw_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_yaw_head"), 0.0f, 360.0f, 0.0f);
        this.rotation_pitch_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_pitch_head"), 0.0f, 360.0f, 0.0f);
        this.rotation_roll_head = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "rotation_roll_head"), 0.0f, 360.0f, 0.0f);
        int i = 0;
        while (i < 32) {
            this.entity_ints[i] = Utils.getPropertyInt(prop, String.format("%s%s%d", tag, "varint", i), Integer.MIN_VALUE, Integer.MAX_VALUE, this.entity_ints[i]);
            if (this.entity_ints[i] != 0) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 1);
            }
            this.entity_floats[i] = Utils.getPropertyFloat(prop, String.format("%s%s%d", tag, "varfloat", i), -3.4028235E38f, Float.MAX_VALUE, this.entity_floats[i]);
            if (this.entity_floats[i] != 0.0f) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 2);
            }
            this.entity_strings[i] = Utils.getPropertyString(prop, String.format("%s%s%d", tag, "varstring", i), this.entity_strings[i]);
            if (this.entity_strings[i] != null) {
                this.changed = 1;
                int n = i;
                this.changes[n] = (short)(this.changes[n] | 4);
            }
            ++i;
        }
        if (this.has_inventory) {
            int i2 = 0;
            while (i2 < 100) {
                this.entity_inventory[i2] = null;
                String s = String.format("%sInventory_%d:", tag, i2);
                String n = prop.getProperty(String.format("%s%s", s, "data"));
                if (n != null && !n.equals("null")) {
                    this.entity_inventory[i2] = new InventoryContainer();
                    this.entity_inventory[i2].readSelf(prop, s);
                }
                ++i2;
            }
        }
    }

    public void doEntityCollisions(float deltaT) {
    }

    public void doEntityAction(float deltaT) {
    }

    public void doDeathDrops() {
        if (this.has_inventory) {
            float mdst = this.getHeight() * 2.0f;
            if (mdst > 10.0f) {
                mdst = 10.0f;
            }
            int i = 0;
            while (i < 100) {
                InventoryContainer ic = this.getVarInventory(i);
                if (ic != null) {
                    Utils.doDropRand(this.world, ic, mdst, this.dimension, this.posx, this.posy, this.posz);
                    this.setVarInventory(i, null);
                    if (this instanceof Player) {
                        Player ple = (Player)this;
                        ple.sendInventoryUpdate(3, i, null);
                    }
                }
                ++i;
            }
        }
    }

    public void update(float deltaT) {
        int different = 0;
        float rate = DangerZone.entityupdaterate;
        rate /= (float)DangerZone.serverentityupdaterate;
        ++this.lifetimeticker;
        if (deltaT > 1.5f) {
            this.lifetimeticker += (long)((int)(deltaT + 0.5f - 1.0f));
        }
        if (this.posy > 1024.0f && this.motiony > 0.0f) {
            this.posy = 1024.0f;
            this.motiony = -1.0f;
        }
        if (this.posy < -1024.0f && this.motiony < 0.0f) {
            this.posy = -1024.0f;
            this.motiony = 1.0f;
        }
        if (!this.world.isServer) {
            if (this instanceof Player) {
                Player p = (Player)this;
                if (p.getGameMode() == 2) {
                    this.motiony *= 1.0f - 0.15f * deltaT * rate;
                }
            } else {
                this.prevdimension = this.dimension;
                this.prevposy = this.posy;
                this.prevposx = this.posx;
                this.prevposz = this.posz;
                this.prevrotation_yaw = this.rotation_yaw;
                this.prevrotation_pitch = this.rotation_pitch;
                this.prevrotation_roll = this.rotation_roll;
                this.prevrotation_yaw_head = this.rotation_yaw_head;
                this.prevrotation_pitch_head = this.rotation_pitch_head;
                this.prevrotation_roll_head = this.rotation_roll_head;
            }
            if (this.movement_friction) {
                this.motionx *= 1.0f - 0.35f * deltaT * rate;
                this.motiony *= 1.0f - 0.05f * deltaT * rate;
                this.motionz *= 1.0f - 0.35f * deltaT * rate;
                this.rotation_pitch_motion *= 1.0f - 0.25f * deltaT * rate;
                this.rotation_yaw_motion *= 1.0f - 0.25f * deltaT * rate;
                this.rotation_roll_motion *= 1.0f - 0.25f * deltaT * rate;
            }
            this.posy += this.motiony * deltaT * rate;
            this.posx += this.motionx * deltaT * rate;
            this.posz += this.motionz * deltaT * rate;
            this.rotation_pitch += this.rotation_pitch_motion * deltaT * rate;
            if (this instanceof Player) {
                this.rotation_yaw_head += this.rotation_yaw_motion * deltaT * rate;
            } else {
                this.rotation_yaw += this.rotation_yaw_motion * deltaT * rate;
            }
            this.rotation_roll += this.rotation_roll_motion * deltaT * rate;
            this.display_posx = this.posx;
            this.display_posy = this.posy;
            this.display_posz = this.posz;
            this.display_rotation_pitch = this.rotation_pitch;
            this.display_rotation_yaw = this.rotation_yaw;
            this.display_rotation_roll = this.rotation_roll;
        } else {
            if (this.movement_friction) {
                this.motionx *= 1.0f - 0.35f * deltaT;
                this.motiony *= 1.0f - 0.05f * deltaT;
                this.motionz *= 1.0f - 0.35f * deltaT;
                this.rotation_pitch_motion *= 1.0f - 0.25f * deltaT;
                this.rotation_yaw_motion *= 1.0f - 0.25f * deltaT;
                this.rotation_roll_motion *= 1.0f - 0.25f * deltaT;
            }
            this.posy += this.motiony * deltaT;
            this.posx += this.motionx * deltaT;
            this.posz += this.motionz * deltaT;
            this.rotation_pitch += this.rotation_pitch_motion * deltaT;
            this.rotation_yaw += this.rotation_yaw_motion * deltaT;
            this.rotation_roll += this.rotation_roll_motion * deltaT;
        }
        while (this.rotation_yaw < 0.0f) {
            this.rotation_yaw += 360.0f;
        }
        this.rotation_yaw %= 360.0f;
        while (this.rotation_pitch < 0.0f) {
            this.rotation_pitch += 360.0f;
        }
        this.rotation_pitch %= 360.0f;
        while (this.rotation_roll < 0.0f) {
            this.rotation_roll += 360.0f;
        }
        this.rotation_roll %= 360.0f;
        while (this.rotation_yaw_head < 0.0f) {
            this.rotation_yaw_head += 360.0f;
        }
        this.rotation_yaw_head %= 360.0f;
        while (this.rotation_pitch_head < 0.0f) {
            this.rotation_pitch_head += 360.0f;
        }
        this.rotation_pitch_head %= 360.0f;
        while (this.rotation_roll_head < 0.0f) {
            this.rotation_roll_head += 360.0f;
        }
        this.rotation_roll_head %= 360.0f;
        Entity e = this.getRiddenEntity();
        if (e != null) {
            this.motionx = e.motionx;
            this.motiony = e.motiony;
            this.motionz = e.motionz;
            this.posx = (float)((double)e.posx + Math.sin(Math.toRadians(e.rotation_yaw)) * (double)e.getRiderXZoffset());
            this.posy = e.posy + e.getRiderYoffset();
            this.posz = (float)((double)e.posz + Math.cos(Math.toRadians(e.rotation_yaw)) * (double)e.getRiderXZoffset());
            this.display_posx = this.posx;
            this.display_posy = this.posy;
            this.display_posz = this.posz;
        }
        if ((e = this.getRiderEntity()) != null) {
            e.motionx = this.motionx;
            e.motiony = this.motiony;
            e.motionz = this.motionz;
            e.posx = (float)((double)this.posx + Math.sin(Math.toRadians(this.rotation_yaw)) * (double)this.getRiderXZoffset());
            e.posy = this.posy + this.getRiderYoffset();
            e.posz = (float)((double)this.posz + Math.cos(Math.toRadians(this.rotation_yaw)) * (double)this.getRiderXZoffset());
            e.display_posx = e.posx;
            e.display_posy = e.posy;
            e.display_posz = e.posz;
        }
        if (this.world.isServer && this instanceof Player) {
            return;
        }
        if (!this.world.isServer && this != DangerZone.player) {
            return;
        }
        different = 0;
        this.currtime = System.currentTimeMillis();
        long too_long = this.currtime - this.lasttime;
        if (too_long >= 3000L) {
            ++different;
        }
        if (this.changed != 0) {
            ++different;
        }
        if (this.prevdimension != this.dimension || this.prevposx != this.posx || this.prevposy != this.posy || this.prevposz != this.posz) {
            ++different;
        }
        if (this.prevrotation_yaw != this.rotation_yaw || this.prevrotation_pitch != this.rotation_pitch || this.prevrotation_roll != this.rotation_roll) {
            ++different;
        }
        if (this.prevrotation_yaw_head != this.rotation_yaw_head || this.prevrotation_pitch_head != this.rotation_pitch_head || this.prevrotation_roll_head != this.rotation_roll_head) {
            ++different;
        }
        if (different == 0) {
            ++this.diffticker;
            if (this.diffticker < 3) {
                ++different;
            }
        } else {
            this.diffticker = 0;
        }
        if (different != 0) {
            this.lasttime = this.currtime;
            this.prevdimension = this.dimension;
            this.prevposy = this.posy;
            this.prevposx = this.posx;
            this.prevposz = this.posz;
            this.prevrotation_yaw = this.rotation_yaw;
            this.prevrotation_pitch = this.rotation_pitch;
            this.prevrotation_roll = this.rotation_roll;
            this.prevrotation_yaw_head = this.rotation_yaw_head;
            this.prevrotation_pitch_head = this.rotation_pitch_head;
            this.prevrotation_roll_head = this.rotation_roll_head;
            if (this instanceof Player) {
                if (!this.world.isServer && this == DangerZone.player) {
                    DangerZone.server_connection.sendPlayerEntityUpdate(this);
                }
            } else if (this.world.isServer) {
                DangerZone.server.sendEntityUpdateToAll(this, false);
            }
        }
    }

    public float getAdjustedFallDamage(float damage) {
        if (!this.takesFallDamage) {
            return 0.0f;
        }
        return damage;
    }

    public float getDistanceFromEntity(Entity p) {
        float d1 = p.posx - this.posx;
        float d2 = p.posy - this.posy;
        float d3 = p.posz - this.posz;
        if (p.dimension != this.dimension) {
            return 9999.0f;
        }
        return (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public float getDistanceFromEntityCenter(Entity p) {
        float d1 = p.posx - this.posx;
        float d2 = p.posy + p.getHeight() / 2.0f - (this.posy + this.getHeight() / 2.0f);
        float d3 = p.posz - this.posz;
        return (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public float getHorizontalDistanceFromEntity(Entity p) {
        float d1 = p.posx - this.posx;
        float d3 = p.posz - this.posz;
        return (float)Math.sqrt(d1 * d1 + d3 * d3);
    }

    public float getHorizontalDistanceFromEntity(float x, float z) {
        float d1 = x - this.posx;
        float d3 = z - this.posz;
        return (float)Math.sqrt(d1 * d1 + d3 * d3);
    }

    public float getDistanceFromEntityCenter(float x, float y, float z) {
        float d1 = x - this.posx;
        float d2 = y - (this.posy + this.getHeight() / 2.0f);
        float d3 = z - this.posz;
        return (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        return false;
    }

    public boolean leftClickedByPlayer(Player p, InventoryContainer ic) {
        return true;
    }

    public void onKill(Entity deadthing) {
    }

    public Texture getTexture() {
        return this.texture;
    }

    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        return true;
    }

    public boolean isFoodForMe(int bid, int iid) {
        return this.isFoodBlock(bid) || this.isFoodItem(iid);
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        return this.isFoodForMe(bid, iid);
    }

    public boolean isFoodBlock(int bid) {
        return false;
    }

    public boolean isFoodItem(int iid) {
        return false;
    }

    public void findBlockFood(int maxdistxz, int maxdisty, int healamount, int eatitdistance) {
    }

    public void playburp() {
    }

    public float getSpinz() {
        return 0.0f;
    }

    public void doFromSpawner() {
    }

    public float getLightAtLocation(World w, int d, int x, int y, int z) {
        if (!w.isServer) {
            return WorldRendererUtils.getTotalLightAt(w, d, x, y, z);
        }
        if (DangerZone.start_client) {
            return WorldRendererUtils.getTotalLightAt(DangerZone.world, d, x, y, z);
        }
        return w.rand.nextFloat();
    }

    public boolean CanProbablySee(int d, float x, float y, float z, int distinblocks) {
        double xzoff = this.getWidth() / 2.0f;
        int nblks = distinblocks;
        if (distinblocks < 1) {
            return true;
        }
        double cx = (double)this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double cz = (double)this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        float startx = (float)cx;
        float starty = this.posy + this.getHeight() * 7.0f / 8.0f;
        float startz = (float)cz;
        float dx = (x - startx) / (float)distinblocks;
        float dy = (y - starty) / (float)distinblocks;
        float dz = (z - startz) / (float)distinblocks;
        if ((double)Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((float)nblks * Math.abs(dx));
            if (dx > 1.0f) {
                dx = 1.0f;
            }
            if (dx < -1.0f) {
                dx = -1.0f;
            }
        }
        if ((double)Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((float)nblks * Math.abs(dy));
            if (dy > 1.0f) {
                dy = 1.0f;
            }
            if (dy < -1.0f) {
                dy = -1.0f;
            }
        }
        if ((double)Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((float)nblks * Math.abs(dz));
            if (dz > 1.0f) {
                dz = 1.0f;
            }
            if (dz < -1.0f) {
                dz = -1.0f;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid(this.world.getblock(d, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)), this.world, d, (int)startx, (int)starty, (int)startz)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean CanProbablySeeEntity(Entity e) {
        double xzoff = this.getWidth() / 2.0f;
        int nblks = (int)this.getDistanceFromEntity(e);
        if (nblks < 1) {
            return true;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if ((double)ddiff > 2.356194490192345) {
            return false;
        }
        if ((double)ddiff < -2.356194490192345) {
            return false;
        }
        double cx = (double)this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double cz = (double)this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        float startx = (float)cx;
        float starty = this.posy + this.getHeight() * 7.0f / 8.0f;
        float startz = (float)cz;
        float dx = (e.posx - startx) / (float)nblks;
        float dy = (e.posy + e.getHeight() * 7.0f / 8.0f - starty) / (float)nblks;
        float dz = (e.posz - startz) / (float)nblks;
        if ((double)Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((float)nblks * Math.abs(dx));
            if (dx > 1.0f) {
                dx = 1.0f;
            }
            if (dx < -1.0f) {
                dx = -1.0f;
            }
        }
        if ((double)Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((float)nblks * Math.abs(dy));
            if (dy > 1.0f) {
                dy = 1.0f;
            }
            if (dy < -1.0f) {
                dy = -1.0f;
            }
        }
        if ((double)Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((float)nblks * Math.abs(dz));
            if (dz > 1.0f) {
                dz = 1.0f;
            }
            if (dz < -1.0f) {
                dz = -1.0f;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid(this.world.getblock(this.dimension, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)), this.world, this.dimension, (int)startx, (int)starty, (int)startz)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

