/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Anteater;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Cockroach
extends EntityLiving {
    public Cockroach(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:Cockroach";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.15f);
        this.movefrequency = 20;
        this.daytimespawn = true;
        this.setExperience(2);
        this.canSwim = false;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableHostility(8.0f, 1.5f);
        this.temperament = 2;
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        if (this.getCanDespawn() && this.world.rand.nextInt(1000) == 1) {
            this.deadflag = true;
        }
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (ic != null && ic.count != 0) {
            return false;
        }
        if (!this.world.isServer) {
            int i = 0;
            while (i < 256) {
                int id = (this.dimension + i + 1) % 256;
                if (Dimensions.DimensionArray[id] != null) {
                    Dimensions.DimensionArray[id].teleportToDimension(p, p.world, id, (int)p.posx, (int)p.posy, (int)p.posz);
                    this.world.playSound("DangerZone:big_splat", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
                    Utils.spawnParticles(p.world, "DangerZone:ParticleHurt", 10, this.dimension, this.posx, this.posy, this.posz, true);
                    break;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    @Override
    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophycockroach.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
        Utils.doDropRand(this.world, 0, Items.deadbug.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Cockroach) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Anteater && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Cockroachtexture.png");
        }
        return this.texture;
    }
}

