/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.StitchedTexture;
import dangerzone.World;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityFurnace;
import dangerzone.gui.PlayerFurnaceGUI;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class BlockFurnace
extends Block {
    Texture ttop = null;
    Texture tbottom = null;
    Texture tleft = null;
    Texture tright = null;
    Texture tfront = null;
    Texture tback = null;
    String topname = "res/blocks/furnace_top.png";
    String bottomname = "res/blocks/furnace_bottom.png";
    String leftname = "res/blocks/furnace_left.png";
    String rightname = "res/blocks/furnace_right.png";
    String frontname = "res/blocks/furnace_front.png";
    String backname = "res/blocks/furnace_back.png";
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stbottom = new StitchedTexture();
    StitchedTexture stleft = new StitchedTexture();
    StitchedTexture stright = new StitchedTexture();
    StitchedTexture stfront = new StitchedTexture();
    StitchedTexture stback = new StitchedTexture();

    public BlockFurnace(String n) {
        super(n, "");
        this.maxstack = 8;
        this.isStone = true;
        this.hasFront = true;
        this.renderAllSides = true;
        this.renderSmaller = true;
        this.isSolidForRendering = false;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z) {
        if (p == null || p.world.isServer) {
            return false;
        }
        PlayerFurnaceGUI pcg = new PlayerFurnaceGUI();
        List<Entity> nearby_list = null;
        EntityFurnace ec = null;
        nearby_list = DangerZone.entityManager.findEntitiesInRange(2.0f, dimension, x, y, z);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof EntityFurnace)) continue;
                if ((int)e.posx == x && (int)e.posy == y && (int)e.posz == z) {
                    ec = (EntityFurnace)e;
                    break;
                }
                ec = null;
            }
        }
        if (ec == null) {
            Entity eb = p.world.createEntityByName("DangerZone:EntityFurnace", dimension, (float)x + 0.5f, (float)y + 0.05f, (float)z + 0.5f);
            if (eb != null) {
                eb.init();
                eb.setBID(Blocks.furnace.blockID);
                eb.setIID(Blocks.furnaceOn.blockID);
                p.world.spawnEntityInWorld(eb);
            }
            return false;
        }
        pcg.ec = ec;
        DangerZone.setActiveGui(pcg);
        return false;
    }

    @Override
    public void onBlockPlaced(World w, int dimension, int x, int y, int z) {
        Entity eb;
        if (!w.isServer && (eb = w.createEntityByName("DangerZone:EntityFurnace", dimension, (float)x + 0.5f, (float)y + 0.05f, (float)z + 0.5f)) != null) {
            eb.init();
            eb.setBID(Blocks.furnace.blockID);
            eb.setIID(Blocks.furnaceOn.blockID);
            w.spawnEntityInWorld(eb);
        }
    }

    @Override
    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tbottom == null) {
            this.tbottom = this.initBlockTexture(this.bottomname);
        }
        if (this.tleft == null) {
            this.tleft = this.initBlockTexture(this.leftname);
        }
        if (this.tright == null) {
            this.tright = this.initBlockTexture(this.rightname);
        }
        if (this.tfront == null) {
            this.tfront = this.initBlockTexture(this.frontname);
        }
        if (this.tback == null) {
            this.tback = this.initBlockTexture(this.backname);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 5) {
            return this.tbottom;
        }
        if (side == 3) {
            return this.tleft;
        }
        if (side == 4) {
            return this.tright;
        }
        if (side == 1) {
            return this.tfront;
        }
        if (side == 2) {
            return this.tback;
        }
        return null;
    }

    @Override
    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 5) {
            return this.stbottom;
        }
        if (side == 3) {
            return this.stleft;
        }
        if (side == 4) {
            return this.stright;
        }
        if (side == 1) {
            return this.stfront;
        }
        return this.stback;
    }

    @Override
    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 5) {
            return this.bottomname;
        }
        if (side == 3) {
            return this.leftname;
        }
        if (side == 4) {
            return this.rightname;
        }
        if (side == 1) {
            return this.frontname;
        }
        return this.backname;
    }
}

