/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.Chunk;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.ListInt;
import dangerzone.StitchedTexture;
import dangerzone.StitchedTextureFile;
import dangerzone.TextureMapper;
import dangerzone.VBOBuffer;
import dangerzone.World;
import dangerzone.WorldRendererUtils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.threads.CleanerThread;
import dangerzone.threads.VBODataBuilderThread;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;

public class WorldRenderer {
    private volatile List<long[]> VBO_delete_list;
    public static Lock VBOlistlock = new ReentrantLock();
    public static Texture heart_texture = null;
    public static Texture unheart_texture = null;
    public static Texture hungerfull_texture = null;
    public static Texture hungerempty_texture = null;
    public static Texture bubble_texture = null;
    public static Texture sun_texture = null;
    public static Texture moon_texture = null;
    public static int last_texture = -1;
    public static StitchedTextureFile[] stitches = null;
    public static int next_stitch = 0;
    public volatile int oneblock = -1;
    public int blockrenderwidth = 16;
    public static volatile int focus_x;
    public static volatile int focus_y;
    public static volatile int focus_z;
    public static volatile int focus_side;
    public static volatile boolean do_draw_focus;
    public static volatile int focus_bid;
    public static volatile int focus_meta;
    public static volatile float focus_damage;
    public static volatile float focus_maxdamage;
    public static volatile float focus_dist;
    public static volatile Entity focus_entity;
    public float linewidth = 3.0f;
    private int topid;
    private int bottomid;
    private int leftid;
    private int rightid;
    private int frontid;
    private int backid;
    private Font awtfont = null;
    public TrueTypeFont font = null;
    public static float brightness_red;
    public static float brightness_green;
    public static float brightness_blue;
    private float sky_red;
    private float sky_green;
    private float sky_blue;
    private Entity ent;
    private static Lock lock;
    private long lasttime = 0L;
    private long nowtime = 0L;
    public int fps = 0;
    private int fpscounter = 0;
    private int pps = 0;
    private float bounce = 0.0f;
    private float lastbounce = 0.0f;
    private float eatbounce = 0.0f;
    private int hit_cycles = 7;
    private int hit_cycle_count = 0;
    private int hit_cycle_dir = 1;
    private float hitx = -20.0f;
    private float hity = 10.0f;
    private float hitz = -25.0f;
    private float hitp = 62.0f;
    private float hitw = 34.0f;
    private float hitr = -137.0f;
    private int eat_cycles = 7;
    private int eat_cycle_count = 0;
    private int eat_cycle_dir = 1;
    private int eat_delay_count = 0;
    private float eatx = -10.5f;
    private float eaty = -2.1f;
    private float eatz = 18.5f;
    private float eatp = -58.1f;
    private float eatw = -80.8f;
    private float eatr = 59.0f;
    boolean washurt = false;
    float ouch = 1.0f;
    private static boolean compiled;
    private float f5x;
    private float f5y;
    private float f5z;
    private float f5yaw;
    private float f5pitch;
    private float cdir;
    private float tdir;
    private float pdiff;
    private float ydiff;
    private float rdiff;
    private static volatile long nextVBOid;
    private long nextDeleteVBOid;
    public static volatile Map<Long, VBOBuffer> VBOmap;
    private volatile List<VBOBuffer> translucentVBOs;
    public volatile int VBOmemorysize;
    public int lastplayerdimension = 0;
    private boolean eat_sound = true;
    private float traveled = 0.0f;
    public long framecounter = 0L;
    public static volatile int vbocount;
    public VBODataBuilderThread builder = null;
    private int usex;
    private int usey;
    private int usez;
    private int uses;
    private Entity usee = null;

    static {
        do_draw_focus = false;
        focus_damage = 0.0f;
        focus_maxdamage = 0.0f;
        focus_dist = 0.0f;
        focus_entity = null;
        lock = new ReentrantLock();
        compiled = false;
        VBOmap = null;
        vbocount = 0;
    }

    public WorldRenderer() {
        heart_texture = TextureMapper.getTexture("res/menus/heart.png");
        unheart_texture = TextureMapper.getTexture("res/menus/unheart.png");
        hungerfull_texture = TextureMapper.getTexture("res/menus/hungerfull.png");
        hungerempty_texture = TextureMapper.getTexture("res/menus/hungerempty.png");
        bubble_texture = TextureMapper.getTexture("res/menus/bubble.png");
        sun_texture = TextureMapper.getTexture("res/misc/sun.png");
        moon_texture = TextureMapper.getTexture("res/misc/moon.png");
        stitches = new StitchedTextureFile[20];
        nextVBOid = 1L;
        this.nextDeleteVBOid = 1L;
        VBOmap = new HashMap<Long, VBOBuffer>();
        this.VBO_delete_list = new ArrayList<long[]>();
        this.translucentVBOs = new ArrayList<VBOBuffer>();
        this.framecounter = 0L;
        vbocount = 0;
        this.VBOmemorysize = 0;
        if (this.font == null) {
            this.awtfont = new Font("Times New Roman", 0, 24);
            this.font = new TrueTypeFont(this.awtfont, false);
        }
        this.oneblock = -1;
    }

    public void loadBlockTextures() {
        StitchedTexture st = null;
        int bid = 0;
        while (bid < 2048) {
            if (Blocks.BlockArray[bid] != null) {
                int side = 0;
                while (side < 6) {
                    st = Blocks.BlockArray[bid].getStitchedTexture(side);
                    if (st.texturesindex < 0) {
                        StitchedTextureFile stf = stitches[next_stitch];
                        if (stf == null) {
                            WorldRenderer.stitches[WorldRenderer.next_stitch] = new StitchedTextureFile();
                        }
                        stf = stitches[next_stitch];
                        if (stf.nexty >= 32) {
                            WorldRenderer.stitches[++WorldRenderer.next_stitch] = new StitchedTextureFile();
                        }
                        st.texturesindex = next_stitch;
                        StitchedTexture stnew = stitches[next_stitch].doAddTexture(Blocks.BlockArray[bid].getStitchedTextureName(side));
                        if (stnew != null) {
                            st.yoffsetmax = stnew.yoffsetmax;
                            st.yoffsetmin = stnew.yoffsetmin;
                            st.xoffsetmax = stnew.xoffsetmax;
                            st.xoffsetmin = stnew.xoffsetmin;
                        }
                    }
                    ++side;
                }
            }
            ++bid;
        }
    }

    public void loadOneBlockTexture(int bid) {
        StitchedTexture st = null;
        if (Blocks.BlockArray[bid] != null) {
            int side = 0;
            while (side < 6) {
                st = Blocks.BlockArray[bid].getStitchedTexture(side);
                if (st.texturesindex < 0) {
                    StitchedTextureFile stf = stitches[next_stitch];
                    if (stf == null) {
                        WorldRenderer.stitches[WorldRenderer.next_stitch] = new StitchedTextureFile();
                    }
                    stf = stitches[next_stitch];
                    if (stf.nexty >= 32) {
                        WorldRenderer.stitches[++WorldRenderer.next_stitch] = new StitchedTextureFile();
                    }
                    st.texturesindex = next_stitch;
                    StitchedTexture stnew = stitches[next_stitch].doAddTexture(Blocks.BlockArray[bid].getStitchedTextureName(side));
                    if (stnew != null) {
                        st.yoffsetmax = stnew.yoffsetmax;
                        st.yoffsetmin = stnew.yoffsetmin;
                        st.xoffsetmax = stnew.xoffsetmax;
                        st.xoffsetmin = stnew.xoffsetmin;
                    }
                }
                ++side;
            }
        }
    }

    public void renderWorld(World world) {
        InventoryContainer ic;
        float velocity;
        int pbid;
        double rhdir;
        double rr;
        double rdd;
        double pi = 3.1415926545;
        int torender = 6;
        float dist = 0.0f;
        ++this.framecounter;
        if (this.builder == null) {
            this.builder = new VBODataBuilderThread(world);
            Thread cwt = new Thread(this.builder);
            cwt.setPriority(5);
            cwt.start();
        }
        ++this.fpscounter;
        this.nowtime = System.currentTimeMillis();
        if (this.nowtime - this.lasttime > 1000L) {
            this.fps = this.fpscounter;
            this.fpscounter = 0;
            this.lasttime = this.nowtime;
            this.pps = DangerZone.packets_per_second;
            DangerZone.packets_per_second = 0;
            DangerZone.chunks_per_second = 0;
        }
        if (this.lastplayerdimension != DangerZone.player.dimension) {
            world.chunkcache.releaseAllVBOs();
            this.nextDeleteVBOid = nextVBOid;
            this.lastplayerdimension = DangerZone.player.dimension;
            CleanerThread.cleanmenowplease = true;
            while (CleanerThread.cleanmenowplease) {
                Thread.yield();
            }
        }
        if (this.oneblock != -1) {
            this.loadOneBlockTexture(this.oneblock);
            this.oneblock = -1;
        }
        VBOlistlock.lock();
        if (!this.VBO_delete_list.isEmpty()) {
            Iterator<long[]> ii = this.VBO_delete_list.iterator();
            while (ii.hasNext()) {
                long[] st = ii.next();
                if (st != null) {
                    int vdx = 0;
                    while (vdx < 20) {
                        if (st[vdx] != 0L) {
                            VBOBuffer v = VBOmap.get(st[vdx]);
                            if (v != null) {
                                VBOmap.remove(v.VBOid);
                                --vbocount;
                                v.free();
                            }
                            st[vdx] = 0L;
                        }
                        ++vdx;
                    }
                }
                ii.remove();
            }
        }
        if (vbocount > 3000 || this.VBOmemorysize / 0x100000 > 500) {
            long recheckfrom = -1L;
            while (vbocount > 2500 || this.VBOmemorysize / 0x100000 > 350) {
                VBOBuffer v = VBOmap.get(this.nextDeleteVBOid);
                if (v != null) {
                    if (this.framecounter - v.lastusedframe > 10L) {
                        VBOmap.remove(v.VBOid);
                        --vbocount;
                        v.free();
                    } else if (recheckfrom < 0L) {
                        recheckfrom = this.nextDeleteVBOid;
                    }
                }
                ++this.nextDeleteVBOid;
                if (this.nextDeleteVBOid < nextVBOid) continue;
            }
            if (recheckfrom > 0L) {
                this.nextDeleteVBOid = recheckfrom;
            }
        }
        VBOlistlock.unlock();
        if (DangerZone.player.getGameMode() != 2 && DangerZone.player.getRiddenEntity() == null) {
            rdd = Math.sqrt(DangerZone.player.motionx * DangerZone.player.motionx + DangerZone.player.motionz * DangerZone.player.motionz);
            this.traveled = (float)((double)this.traveled + rdd);
            if (DangerZone.player.isBaby()) {
                this.traveled = (float)((double)this.traveled + rdd);
                rdd /= 2.0;
            }
            rdd /= 18.0;
            if (DangerZone.gofast != 0) {
                this.bounce = (float)(rdd * Math.cos(Math.toRadians(this.traveled * 11.3f)));
            } else {
                this.bounce = (float)(rdd * Math.cos(Math.toRadians(this.traveled * 13.3f)));
                this.bounce = (float)((double)this.bounce * 2.5);
            }
            if (!DangerZone.player.getOnGround()) {
                this.bounce = 0.0f;
            }
        } else {
            this.bounce = 0.0f;
        }
        if (this.bounce != 0.0f && (this.lastbounce > 0.0f && this.bounce < 0.0f || this.lastbounce < 0.0f && this.bounce > 0.0f)) {
            DangerZone.world.playSound(Blocks.getStepSound(DangerZone.world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy - 0.1f), (int)DangerZone.player.posz)), DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.15f, 1.0f + (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.2f);
        }
        this.lastbounce = this.bounce;
        DangerZone.player.posx = (float)((double)DangerZone.player.posx + Math.cos(Math.toRadians(DangerZone.player.rotation_yaw)) * (double)this.bounce / 12.0);
        DangerZone.player.posz = (float)((double)DangerZone.player.posz + Math.sin(Math.toRadians(DangerZone.player.rotation_yaw)) * (double)this.bounce / 12.0);
        if (this.bounce < 0.0f) {
            this.bounce = -this.bounce;
        }
        DangerZone.player.rotation_pitch_head %= 360.0f;
        DangerZone.player.rotation_yaw_head %= 360.0f;
        DangerZone.player.rotation_roll_head %= 360.0f;
        this.find_focus(world);
        this.recalcSkyBrightness();
        GL11.glClearColor((float)this.sky_red, (float)this.sky_green, (float)this.sky_blue, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        WorldRenderer.recalcBrightness(DangerZone.player.dimension, 60);
        this.setBrightness();
        last_texture = -1;
        this.f5pitch = 0.0f;
        this.f5yaw = 0.0f;
        this.f5z = 0.0f;
        this.f5y = 0.0f;
        this.f5x = 0.0f;
        if (DangerZone.f5_front) {
            float dst = 8.0f;
            float t = (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head));
            this.f5y = (float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head)) * dst * (float)this.blockrenderwidth;
            this.f5x = (float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head + 90.0f)) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = (float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head + 90.0f)) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 180.0f;
            this.f5pitch = -DangerZone.player.rotation_pitch_head * 2.0f;
        }
        if (DangerZone.f5_back) {
            float dst = 8.0f;
            float t = (float)Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head));
            this.f5y = -((float)Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head))) * dst * (float)this.blockrenderwidth;
            this.f5x = -((float)Math.cos(Math.toRadians(DangerZone.player.rotation_yaw_head + 90.0f))) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5z = -((float)Math.sin(Math.toRadians(DangerZone.player.rotation_yaw_head + 90.0f))) * dst * (float)this.blockrenderwidth * Math.abs(t);
            this.f5yaw = 0.0f;
            this.f5pitch = 0.0f;
        }
        if (DangerZone.f5_front || DangerZone.f5_back) {
            this.Scalef5toSolid();
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)(DangerZone.player.rotation_pitch_head + this.f5pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(DangerZone.player.rotation_yaw_head + this.f5yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(-(DangerZone.player.posx * (float)this.blockrenderwidth % (float)(16 * this.blockrenderwidth)) + (float)(this.blockrenderwidth / 2) + this.f5x), (float)(-((DangerZone.player.posy + DangerZone.player.eyeheight + this.bounce - 0.5f) * (float)this.blockrenderwidth) + this.f5y), (float)(-(DangerZone.player.posz * (float)this.blockrenderwidth % (float)(16 * this.blockrenderwidth)) + (float)(this.blockrenderwidth / 2) + this.f5z));
        torender = DangerZone.player.rotation_pitch_head < 45.0f || DangerZone.player.rotation_pitch_head > 315.0f ? DangerZone.renderdistance : DangerZone.renderdistance - 2;
        if (torender < 3) {
            torender = 3;
        }
        do_draw_focus = false;
        WorldRendererUtils.drawSunAndMoon(world);
        int i = -torender;
        while (i <= torender) {
            int j = -torender;
            while (j <= torender) {
                if (Math.sqrt(i * i + j * j) <= (double)torender) {
                    dist = (float)Math.sqrt(i * i + j * j);
                    rr = (float)Math.atan2(j * 16, i * 16);
                    rdd = Math.abs(rr - (rhdir = Math.toRadians((DangerZone.player.rotation_yaw_head + this.f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                    if (rdd > pi) {
                        rdd -= pi * 2.0;
                    }
                    rdd = Math.abs(rdd);
                    if (!((DangerZone.player.rotation_pitch_head < 45.0f || DangerZone.player.rotation_pitch_head > 315.0f) && (dist > 8.0f && rdd > pi / 3.0 * (double)DangerZone.fieldOfView / 45.0 || dist > 4.0f && rdd > pi / 2.0 * (double)DangerZone.fieldOfView / 45.0 || dist > 1.0f && rdd > pi * 3.0 / 4.0 * (double)DangerZone.fieldOfView / 45.0 && !DangerZone.f5_front && !DangerZone.f5_back))) {
                        this.renderChunk(world, i, j, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz);
                    }
                }
                ++j;
            }
            ++i;
        }
        GL11.glPopMatrix();
        GL11.glFlush();
        if (focus_x != 0 && focus_z != 0 && ((pbid = world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy + DangerZone.player.eyeheight), (int)DangerZone.player.posz)) == 0 || !Blocks.isSolid(pbid) || Blocks.isLiquid(pbid))) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)(DangerZone.player.rotation_pitch_head + this.f5pitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(DangerZone.player.rotation_yaw_head + this.f5yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-((DangerZone.player.posx - ((float)focus_x + 0.5f)) * (float)this.blockrenderwidth) + this.f5x), (float)(-((DangerZone.player.posy + DangerZone.player.eyeheight + this.bounce - ((float)focus_y + 0.5f)) * (float)this.blockrenderwidth) + this.f5y), (float)(-((DangerZone.player.posz - ((float)focus_z + 0.5f)) * (float)this.blockrenderwidth) + this.f5z));
            if (focus_damage != 0.0f && focus_maxdamage > 0.0f) {
                GL11.glScalef((float)(1.0f - 0.65f * focus_damage / focus_maxdamage), (float)(1.0f - 0.65f * focus_damage / focus_maxdamage), (float)(1.0f - 0.65f * focus_damage / focus_maxdamage));
                GL11.glRotatef((float)((float)((double)(15.0f * focus_damage / focus_maxdamage) * Math.cos(Math.toRadians(DangerZone.player.lifetimeticker * 3L)))), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)((float)((double)(15.0f * focus_damage / focus_maxdamage) * Math.cos(Math.toRadians(DangerZone.player.lifetimeticker * 7L)))), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)((float)((double)(15.0f * focus_damage / focus_maxdamage) * Math.cos(Math.toRadians(DangerZone.player.lifetimeticker * 5L)))), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GL11.glScalef((float)1.001f, (float)1.001f, (float)1.001f);
            }
            this.setBrightnessFocusBlock();
            if (Blocks.hasOwnRenderer(focus_bid)) {
                Blocks.renderMe(this, world, DangerZone.player.dimension, focus_x, focus_y, focus_z, focus_bid, focus_meta, 255, true);
            } else {
                this.drawTexturedCube(255, Blocks.isSolidForRender(focus_bid), focus_bid, focus_meta, true);
            }
            this.setBrightness();
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)(DangerZone.player.rotation_pitch_head + this.f5pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(DangerZone.player.rotation_yaw_head + this.f5yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        int inext = 0;
        boolean doforce = false;
        while (true) {
            DangerZone.entityManager.entity_list_lock.lock();
            if (inext >= DangerZone.entityManager.entity_list.size()) break;
            ListInt st = DangerZone.entityManager.entity_list.get(inext);
            this.ent = DangerZone.entityManager.entities[st.index];
            DangerZone.entityManager.entity_list_lock.unlock();
            if (this.ent != null && this.ent.dimension == DangerZone.player.dimension && this.ent.entityID != DangerZone.player.entityID && this.ent.getDistanceFromEntity(DangerZone.player) <= (float)this.ent.maxrenderdist && this.ent.getDistanceFromEntity(DangerZone.player) <= (float)(torender * 16)) {
                rr = (float)Math.atan2(this.ent.display_posz - DangerZone.player.posz, this.ent.display_posx - DangerZone.player.posx);
                rdd = Math.abs(rr - (rhdir = Math.toRadians((DangerZone.player.rotation_yaw_head + this.f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                if (rdd > pi) {
                    rdd -= pi * 2.0;
                }
                rdd = Math.abs(rdd);
                if (!this.ent.always_draw && (DangerZone.player.rotation_pitch_head < 45.0f || DangerZone.player.rotation_pitch_head > 315.0f) && this.ent.getDistanceFromEntity(DangerZone.player) > 16.0f && rdd > pi / 2.0 * (double)DangerZone.fieldOfView / 45.0 && !DangerZone.f5_front && !DangerZone.f5_back) {
                    ++inext;
                    continue;
                }
                if (this.ent.model != null) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(-((DangerZone.player.posx - this.ent.display_posx) * (float)this.blockrenderwidth) + this.f5x), (float)(-((DangerZone.player.posy + DangerZone.player.eyeheight + this.bounce - this.ent.display_posy) * (float)this.blockrenderwidth) + this.f5y), (float)(-((DangerZone.player.posz - this.ent.display_posz) * (float)this.blockrenderwidth) + this.f5z));
                    GL11.glRotatef((float)this.ent.display_rotation_roll, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)this.ent.display_rotation_yaw, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.ent.display_rotation_pitch, (float)1.0f, (float)0.0f, (float)0.0f);
                    WorldRenderer.recalcBrightness(DangerZone.player.dimension, (int)(this.ent.display_posy + this.ent.getHeight() / 2.0f));
                    this.setBrightness(WorldRendererUtils.getLightMapValue(this.ent.world, this.ent.dimension, (int)this.ent.display_posx, (int)(this.ent.display_posy + this.ent.getHeight() / 2.0f), (int)this.ent.display_posz));
                    this.ouch = 1.0f;
                    this.washurt = this.ent.isHurt();
                    if (this.washurt) {
                        this.ouch = 1.1f;
                        GL11.glColor3f((float)1.0f, (float)0.15f, (float)0.15f);
                    }
                    if (this.ent.getDeathFactor() > 0.1f) {
                        this.ouch = this.ent.getDeathFactor();
                    }
                    velocity = (float)Math.sqrt(this.ent.motionx * this.ent.motionx + this.ent.motiony * this.ent.motiony + this.ent.motionz * this.ent.motionz);
                    this.cdir = (float)Math.toRadians(this.ent.display_rotation_pitch);
                    this.tdir = (float)Math.toRadians(this.ent.rotation_pitch_head);
                    this.pdiff = this.tdir - this.cdir;
                    while ((double)this.pdiff > Math.PI) {
                        this.pdiff = (float)((double)this.pdiff - Math.PI * 2);
                    }
                    while ((double)this.pdiff < -Math.PI) {
                        this.pdiff = (float)((double)this.pdiff + Math.PI * 2);
                    }
                    this.pdiff = (float)Math.toDegrees(this.pdiff);
                    this.cdir = (float)Math.toRadians(this.ent.display_rotation_yaw);
                    this.tdir = (float)Math.toRadians(this.ent.rotation_yaw_head);
                    this.ydiff = this.tdir - this.cdir;
                    while ((double)this.ydiff > Math.PI) {
                        this.ydiff = (float)((double)this.ydiff - Math.PI * 2);
                    }
                    while ((double)this.ydiff < -Math.PI) {
                        this.ydiff = (float)((double)this.ydiff + Math.PI * 2);
                    }
                    this.ydiff = (float)Math.toDegrees(this.ydiff);
                    this.cdir = (float)Math.toRadians(this.ent.display_rotation_roll);
                    this.tdir = (float)Math.toRadians(this.ent.rotation_roll_head);
                    this.rdiff = this.tdir - this.cdir;
                    while ((double)this.rdiff > Math.PI) {
                        this.rdiff = (float)((double)this.rdiff - Math.PI * 2);
                    }
                    while ((double)this.rdiff < -Math.PI) {
                        this.rdiff = (float)((double)this.rdiff + Math.PI * 2);
                    }
                    this.rdiff = (float)Math.toDegrees(this.rdiff);
                    if (doforce) {
                        this.forceloadtexture(this.ent.model.getTexture(this.ent));
                        doforce = false;
                    } else {
                        this.loadtexture(this.ent.model.getTexture(this.ent));
                    }
                    if (this.ent.getPetName() != null) {
                        GL11.glPushMatrix();
                    }
                    this.ent.model.doScale(this.ent);
                    this.ent.model.render(this.ent, this.ent.lifetimeticker, velocity, this.pdiff, this.ydiff, this.rdiff, this.ouch);
                    if (this.ent.getOnFire() > 0) {
                        GL11.glRotatef((float)(-this.ent.display_rotation_roll), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(-this.ent.display_rotation_yaw), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(-this.ent.display_rotation_pitch), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)(-(DangerZone.player.rotation_yaw_head + this.f5yaw)), (float)0.0f, (float)1.0f, (float)0.0f);
                        WorldRendererUtils.drawEntityOnFire(this.ent);
                    }
                    if (this.ent.getPetName() != null) {
                        GL11.glPopMatrix();
                    }
                    if (this.washurt) {
                        this.setBrightness();
                    }
                    if (this.ent.getPetName() != null) {
                        doforce = true;
                        GL11.glRotatef((float)(-this.ent.display_rotation_roll), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(-this.ent.display_rotation_yaw), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(-this.ent.display_rotation_pitch), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)(-(DangerZone.player.rotation_yaw_head + this.f5yaw)), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glScalef((float)0.15f, (float)0.15f, (float)0.15f);
                        WorldRendererUtils.textAt(this.font, -(5 * this.ent.getPetName().length()), this.ent.getHeight() * 130.0f + 20.0f, this.ent.getPetName());
                    }
                    GL11.glPopMatrix();
                }
            }
            ++inext;
        }
        DangerZone.entityManager.entity_list_lock.unlock();
        inext = 0;
        while (true) {
            DangerZone.particleManager.particle_list_lock.lock();
            if (inext >= DangerZone.particleManager.particle_list.size()) break;
            Particle pst = DangerZone.particleManager.particle_list.get(inext);
            DangerZone.particleManager.particle_list_lock.unlock();
            if (pst == null || pst.dimension != DangerZone.player.dimension) {
                ++inext;
                continue;
            }
            if (pst.getDistanceFromEntity(DangerZone.player) <= (float)pst.maxrenderdist && pst.getDistanceFromEntity(DangerZone.player) <= (float)(torender * 16)) {
                rr = (float)Math.atan2(pst.posz - DangerZone.player.posz, pst.posx - DangerZone.player.posx);
                rdd = Math.abs(rr - (rhdir = Math.toRadians((DangerZone.player.rotation_yaw_head + this.f5yaw - 90.0f) % 360.0f))) % (pi * 2.0);
                if (rdd > pi) {
                    rdd -= pi * 2.0;
                }
                rdd = Math.abs(rdd);
                if ((DangerZone.player.rotation_pitch_head < 45.0f || DangerZone.player.rotation_pitch_head > 315.0f) && pst.getDistanceFromEntity(DangerZone.player) > 4.0f && rdd > pi / 2.0 * (double)DangerZone.fieldOfView / 45.0 && !DangerZone.f5_front && !DangerZone.f5_back) {
                    ++inext;
                    continue;
                }
                if (pst.model != null) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(-((DangerZone.player.posx - pst.posx) * (float)this.blockrenderwidth) + this.f5x), (float)(-((DangerZone.player.posy + DangerZone.player.eyeheight + this.bounce - pst.posy) * (float)this.blockrenderwidth) + this.f5y), (float)(-((DangerZone.player.posz - pst.posz) * (float)this.blockrenderwidth) + this.f5z));
                    GL11.glRotatef((float)pst.rotation_roll, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)pst.rotation_yaw, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)pst.rotation_pitch, (float)1.0f, (float)0.0f, (float)0.0f);
                    WorldRenderer.recalcBrightness(DangerZone.player.dimension, (int)pst.posy);
                    this.setBrightness(pst.brightness + WorldRendererUtils.getLightMapValue(world, pst.dimension, (int)pst.posx, (int)pst.posy, (int)pst.posz));
                    GL11.glScalef((float)pst.scale, (float)pst.scale, (float)pst.scale);
                    if (doforce) {
                        this.forceloadtexture(pst.model.getTexture(pst));
                        doforce = false;
                    } else {
                        this.loadtexture(pst.model.getTexture(pst));
                    }
                    pst.model.renderParticle(pst);
                    GL11.glPopMatrix();
                }
            }
            ++inext;
        }
        DangerZone.particleManager.particle_list_lock.unlock();
        if (DangerZone.f5_front || DangerZone.f5_back) {
            this.ent = DangerZone.player;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-((DangerZone.player.posx - this.ent.posx) * (float)this.blockrenderwidth) + this.f5x), (float)(-((DangerZone.player.posy + DangerZone.player.eyeheight + this.bounce - this.ent.posy) * (float)this.blockrenderwidth) + this.f5y), (float)(-((DangerZone.player.posz - this.ent.posz) * (float)this.blockrenderwidth) + this.f5z));
            float fyw = 360.0f - (this.ent.rotation_yaw + 180.0f) % 360.0f;
            GL11.glRotatef((float)fyw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.ent.rotation_pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            WorldRenderer.recalcBrightness(DangerZone.player.dimension, (int)(DangerZone.player.posy + DangerZone.player.getHeight() / 2.0f));
            this.setBrightness(WorldRendererUtils.getLightMapValue(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy + this.ent.getHeight() / 2.0f), (int)DangerZone.player.posz));
            this.loadtexture(this.ent.model.getTexture(this.ent));
            this.ent.model.doScale(this.ent);
            this.ouch = 1.0f;
            this.washurt = this.ent.isHurt();
            if (this.washurt) {
                this.ouch = 1.1f;
                GL11.glColor3f((float)1.0f, (float)0.15f, (float)0.15f);
            }
            if (this.ent.getDeathFactor() > 0.1f) {
                this.ouch = this.ent.getDeathFactor();
            }
            velocity = (float)Math.sqrt(this.ent.motionx * this.ent.motionx + this.ent.motiony * this.ent.motiony + this.ent.motionz * this.ent.motionz);
            this.cdir = (float)Math.toRadians(this.ent.rotation_pitch);
            this.tdir = (float)Math.toRadians(this.ent.rotation_pitch_head);
            this.pdiff = this.tdir - this.cdir;
            while ((double)this.pdiff > Math.PI) {
                this.pdiff = (float)((double)this.pdiff - Math.PI * 2);
            }
            while ((double)this.pdiff < -Math.PI) {
                this.pdiff = (float)((double)this.pdiff + Math.PI * 2);
            }
            this.pdiff = (float)Math.toDegrees(this.pdiff);
            this.cdir = (float)Math.toRadians(this.ent.rotation_yaw);
            this.tdir = (float)Math.toRadians(this.ent.rotation_yaw_head);
            this.ydiff = this.tdir - this.cdir;
            while ((double)this.ydiff > Math.PI) {
                this.ydiff = (float)((double)this.ydiff - Math.PI * 2);
            }
            while ((double)this.ydiff < -Math.PI) {
                this.ydiff = (float)((double)this.ydiff + Math.PI * 2);
            }
            this.ydiff = (float)Math.toDegrees(this.ydiff);
            this.cdir = (float)Math.toRadians(this.ent.rotation_roll);
            this.tdir = (float)Math.toRadians(this.ent.rotation_roll_head);
            this.rdiff = this.tdir - this.cdir;
            while ((double)this.rdiff > Math.PI) {
                this.rdiff = (float)((double)this.rdiff - Math.PI * 2);
            }
            while ((double)this.rdiff < -Math.PI) {
                this.rdiff = (float)((double)this.rdiff + Math.PI * 2);
            }
            this.rdiff = (float)Math.toDegrees(this.rdiff);
            this.ent.model.render(this.ent, this.ent.lifetimeticker, velocity, this.pdiff, -this.ydiff, this.rdiff, this.ouch);
            if (this.ent.getOnFire() > 0) {
                GL11.glRotatef((float)(-this.ent.display_rotation_roll), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-this.ent.display_rotation_pitch), (float)1.0f, (float)0.0f, (float)0.0f);
                WorldRendererUtils.drawEntityOnFire(this.ent);
            }
            if (this.washurt) {
                this.setBrightness();
            }
            if (this.ent.getPetName() != null) {
                GL11.glRotatef((float)(-this.ent.display_rotation_roll), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-this.ent.display_rotation_pitch), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)0.15f, (float)0.15f, (float)0.15f);
                WorldRendererUtils.textAt(this.font, -(5 * this.ent.getPetName().length()), this.ent.getHeight() * 130.0f + 20.0f, this.ent.getPetName());
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (this.hit_cycle_count != 0) {
            i = this.fps / 10;
            if (i < 1) {
                i = 1;
            }
            if (i > 6) {
                i = 6;
            }
            this.hit_cycles = i + 1;
            this.hit_cycle_count += this.hit_cycle_dir;
            if (this.hit_cycle_count >= this.hit_cycles) {
                if (DangerZone.doleftclick) {
                    DangerZone.player.leftclick(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID);
                    DangerZone.doleftclick = false;
                }
                if (DangerZone.dorightclick) {
                    DangerZone.player.rightclick(world, this.usex, this.usey, this.usez, this.uses, this.usee == null ? 0 : this.usee.entityID);
                    DangerZone.dorightclick = false;
                }
                this.hit_cycle_dir = -1;
            }
        } else if (DangerZone.do_hit_cycle != 0) {
            this.hit_cycle_count = 1;
            this.hit_cycle_dir = 1;
            this.usex = focus_x;
            this.usey = focus_y;
            this.usez = focus_z;
            this.uses = focus_side;
            this.usee = focus_entity;
        }
        if (this.eat_cycle_count != 0) {
            i = this.fps / 2;
            if (i < 1) {
                i = 1;
            }
            if (i > 30) {
                i = 30;
            }
            this.eat_cycles = i + 1;
            this.eat_cycle_count += this.eat_cycle_dir;
            if (this.eat_cycle_count >= this.eat_cycles) {
                this.eat_cycle_count = this.eat_cycles;
                if (this.eat_delay_count > 0) {
                    if (this.eat_sound) {
                        world.playSound("DangerZone:eating", DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.55f, 1.0f);
                    }
                    this.eat_sound = false;
                    --this.eat_delay_count;
                } else {
                    InventoryContainer ic2 = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
                    if (ic2 != null && Items.isFood(ic2.iid) && (DangerZone.player.getHunger() < DangerZone.player.getMaxHunger() || Items.eatAnyTime(ic2.iid))) {
                        DangerZone.player.setHunger(DangerZone.player.getHunger() + Items.getFoodValue(ic2.iid));
                        Item itm = ic2.getItem();
                        if (itm != null) {
                            itm.onFoodEaten(DangerZone.player);
                            DangerZone.server_connection.playerActionToServer(0, 2, itm.itemID);
                        }
                        if (DangerZone.player.getGameMode() == 0) {
                            --ic2.count;
                            if (ic2.count <= 0) {
                                DangerZone.player.setBID(0);
                                DangerZone.player.setIID(0);
                                DangerZone.player.setHotbar(DangerZone.player.gethotbarindex(), null);
                            }
                            DangerZone.server_connection.inventoryUpdate(0, DangerZone.player.gethotbarindex(), DangerZone.player.getHotbar(DangerZone.player.gethotbarindex()));
                        }
                    }
                    this.eat_cycle_dir = -1;
                }
            }
        } else if (DangerZone.do_food_cycle != 0 && (ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex())) != null && Items.isFood(ic.iid) && (DangerZone.player.getHunger() < DangerZone.player.getMaxHunger() || Items.eatAnyTime(ic.iid))) {
            this.eat_cycle_count = 1;
            this.eat_cycle_dir = 1;
            this.eat_delay_count = this.fps + 10;
            this.eat_sound = true;
        }
        if (DangerZone.player.getHotbar(DangerZone.player.gethotbarindex()) != null && !DangerZone.f5_front && !DangerZone.f5_back) {
            ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
            GL11.glPushMatrix();
            GL11.glTranslatef((float)6.0f, (float)(-(4.0f + this.bounce * 2.0f)), (float)(-540.0f / (float)DangerZone.fieldOfView));
            GL11.glRotatef((float)-15.0f, (float)1.0f, (float)3.0f, (float)0.0f);
            WorldRenderer.recalcBrightness(DangerZone.player.dimension, (int)(DangerZone.player.posy + DangerZone.player.getHeight() / 2.0f));
            this.setBrightness(WorldRendererUtils.getLightMapValue(world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy + DangerZone.player.getHeight() / 2.0f), (int)DangerZone.player.posz));
            if (ic.bid != 0) {
                if (this.hit_cycle_count != 0) {
                    GL11.glTranslatef((float)(this.hitx * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f), (float)(this.hity * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f), (float)(this.hitz * ((float)this.hit_cycle_count / (float)this.hit_cycles) / 2.0f));
                    GL11.glRotatef((float)(-this.hitp * ((float)this.hit_cycle_count / (float)this.hit_cycles)), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(this.hitw * ((float)this.hit_cycle_count / (float)this.hit_cycles)), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-this.hitr * ((float)this.hit_cycle_count / (float)this.hit_cycles)), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                GL11.glScalef((float)0.2f, (float)0.2f, (float)0.2f);
                if (Blocks.hasOwnRenderer(ic.bid)) {
                    Blocks.renderMe(this, world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz, ic.bid, 0, 255, false);
                } else {
                    DangerZone.wr.drawTexturedCube(255, Blocks.isSolidForRender(ic.bid), ic.bid, 0, false);
                }
            } else if (ic.iid != 0) {
                GL11.glScalef((float)0.35f, (float)0.35f, (float)0.35f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                if (this.hit_cycle_count != 0) {
                    GL11.glTranslatef((float)(1.0f + DangerZone.testx + this.hitx * ((float)this.hit_cycle_count / (float)this.hit_cycles)), (float)(3.0f + DangerZone.testy + this.hity * ((float)this.hit_cycle_count / (float)this.hit_cycles)), (float)(3.0f + DangerZone.testz + this.hitz * ((float)this.hit_cycle_count / (float)this.hit_cycles)));
                    GL11.glRotatef((float)(-91.0f + DangerZone.testp + this.hitp * ((float)this.hit_cycle_count / (float)this.hit_cycles)), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(102.0f + this.bounce * 4.0f + DangerZone.testw + this.hitw * ((float)this.hit_cycle_count / (float)this.hit_cycles)), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-124.0f + this.bounce * 4.0f + DangerZone.testr + this.hitr * ((float)this.hit_cycle_count / (float)this.hit_cycles)), (float)0.0f, (float)0.0f, (float)1.0f);
                } else if (this.eat_cycle_count != 0) {
                    this.eatbounce = this.bounce;
                    if (this.eat_cycle_count >= this.eat_cycles && this.eat_delay_count > 0) {
                        this.eatbounce = (float)Math.cos(Math.toRadians((float)DangerZone.player.lifetimeticker * 25.3f));
                    }
                    GL11.glTranslatef((float)(1.0f + DangerZone.testx + this.eatx * ((float)this.eat_cycle_count / (float)this.eat_cycles)), (float)(3.0f + DangerZone.testy + this.eaty * ((float)this.eat_cycle_count / (float)this.eat_cycles)), (float)(3.0f + DangerZone.testz + this.eatz * ((float)this.eat_cycle_count / (float)this.eat_cycles)));
                    GL11.glRotatef((float)(-91.0f + DangerZone.testp + this.eatp * ((float)this.eat_cycle_count / (float)this.eat_cycles)), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(102.0f + this.eatbounce * 4.0f + DangerZone.testw + this.eatw * ((float)this.eat_cycle_count / (float)this.eat_cycles)), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-124.0f + this.eatbounce * 4.0f + DangerZone.testr + this.eatr * ((float)this.eat_cycle_count / (float)this.eat_cycles)), (float)0.0f, (float)0.0f, (float)1.0f);
                } else {
                    GL11.glTranslatef((float)(1.0f + DangerZone.testx), (float)(3.0f + DangerZone.testy), (float)(3.0f + DangerZone.testz));
                    GL11.glRotatef((float)(-91.0f + DangerZone.testp), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(102.0f + this.bounce * 4.0f + DangerZone.testw), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-124.0f + this.bounce * 4.0f + DangerZone.testr), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                DangerZone.wr.loadtexture(Items.getTexture(ic.iid));
                Items.renderMe(DangerZone.wr, world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz, ic.iid, 0, 0, false);
                GL11.glDisable((int)3042);
            }
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)(DangerZone.player.rotation_pitch_head + this.f5pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(DangerZone.player.rotation_yaw_head + this.f5yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(-(DangerZone.player.posx * (float)this.blockrenderwidth % (float)(16 * this.blockrenderwidth)) + (float)(this.blockrenderwidth / 2) + this.f5x), (float)(-((DangerZone.player.posy + DangerZone.player.eyeheight + this.bounce - 0.5f) * (float)this.blockrenderwidth) + this.f5y), (float)(-(DangerZone.player.posz * (float)this.blockrenderwidth % (float)(16 * this.blockrenderwidth)) + (float)(this.blockrenderwidth / 2) + this.f5z));
        if (!this.translucentVBOs.isEmpty()) {
            Iterator<VBOBuffer> iitr = this.translucentVBOs.iterator();
            while (iitr.hasNext()) {
                VBOBuffer sstr = iitr.next();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)sstr.xoff, (float)0.0f, (float)sstr.zoff);
                this.loadStitchedtexture(sstr.textureindex);
                sstr.lastusedframe = this.framecounter;
                sstr.draw();
                GL11.glPopMatrix();
                iitr.remove();
            }
        }
        GL11.glPopMatrix();
        WorldRenderer.recalcBrightness(DangerZone.player.dimension, 60);
        this.setBrightness();
        if (!DangerZone.f5_front && !DangerZone.f5_back) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glLineWidth((float)1.0f);
            GL11.glBegin((int)3);
            GL11.glColor3f((float)0.65f, (float)0.65f, (float)0.65f);
            GL11.glVertex3f((float)-0.04f, (float)0.0f, (float)-2.0f);
            GL11.glVertex3f((float)0.04f, (float)0.0f, (float)-2.0f);
            GL11.glEnd();
            GL11.glBegin((int)3);
            GL11.glColor3f((float)0.65f, (float)0.65f, (float)0.65f);
            GL11.glVertex3f((float)0.0f, (float)0.04f, (float)-2.0f);
            GL11.glVertex3f((float)0.0f, (float)-0.04f, (float)-2.0f);
            GL11.glEnd();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
        }
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)DangerZone.screen_width, (double)0.0, (double)DangerZone.screen_height, (double)-320.0, (double)320.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        WorldRendererUtils.drawHotbar(world);
        WorldRendererUtils.drawHealth(world);
        WorldRendererUtils.drawHunger(world);
        WorldRendererUtils.drawAir(world);
        if (DangerZone.messagetimer > 0 && DangerZone.messagestring != null) {
            --DangerZone.messagetimer;
            WorldRendererUtils.textAt(this.font, 50.0f, 150.0f, DangerZone.messagestring);
        }
        if (DangerZone.hotmessagetimer > 0 && DangerZone.hotmessagestring != null) {
            --DangerZone.hotmessagetimer;
            WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2 - 5 * DangerZone.hotmessagestring.length() - 30, 115.0f, DangerZone.hotmessagestring);
        } else if (DangerZone.current_gui == null) {
            String s = String.format("%d", DangerZone.player.getExperience());
            WorldRendererUtils.textAt(this.font, DangerZone.screen_width / 2 - 5 * s.length() - 30, 115.0f, s);
        }
        if (DangerZone.f3_on && DangerZone.current_gui == null) {
            String s = String.format("Version: %s", DangerZone.versionstring);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 10, s);
            s = String.format("FPS: %d at Render Distance: %d", this.fps, DangerZone.renderdistance);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 50, s);
            s = String.format("XPOS: %d", (int)DangerZone.player.posx);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 90, s);
            s = String.format("YPOS: %d", (int)DangerZone.player.posy);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 130, s);
            s = String.format("ZPOS: %d", (int)DangerZone.player.posz);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 170, s);
            s = String.format("Packets: %d", this.pps);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 210, s);
            s = String.format("VBO memory: %d MB", this.VBOmemorysize / 0x100000);
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 250, s);
            s = String.format("Light LVL: %f", Float.valueOf(WorldRendererUtils.getTotalLightAt(DangerZone.player.world, DangerZone.player.dimension, (int)DangerZone.player.posx, (int)DangerZone.player.posy, (int)DangerZone.player.posz)));
            WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 290, s);
            if (DangerZone.server != null) {
                s = String.format("Entity Freelist: %d", DangerZone.server.entityManager.entity_free_list.size());
                WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 330, s);
                s = String.format("Entities: %d", DangerZone.server.entityManager.entity_list.size());
                WorldRendererUtils.textAt(this.font, 10.0f, DangerZone.screen_height - 370, s);
            }
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        GL11.glFlush();
    }

    private void find_focus(World w) {
        double dist;
        ListIterator<Entity> li;
        double delta = 0.0;
        Entity tempe = null;
        List<Entity> nearby_list = null;
        ArrayList<Entity> check_list = new ArrayList<Entity>();
        int riddenid = 0;
        Entity ridden = DangerZone.player.getRiddenEntity();
        if (ridden != null) {
            riddenid = ridden.entityID;
        }
        float fx = DangerZone.player.posx;
        float fy = DangerZone.player.posy + DangerZone.player.eyeheight;
        float fz = DangerZone.player.posz;
        int x = (int)fx;
        int y = (int)fy;
        int z = (int)fz;
        double dir = Math.toRadians((DangerZone.player.rotation_yaw_head - 90.0f) % 360.0f);
        double dx = Math.cos(dir);
        double dz = Math.sin(dir);
        double dy = Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head % 360.0f));
        double xzscale = Math.abs(Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head % 360.0f)));
        dx *= xzscale;
        dz *= xzscale;
        dy = -dy;
        nearby_list = DangerZone.entityManager.findEntitiesInRange(16.0f, DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            li = nearby_list.listIterator();
            while (li.hasNext()) {
                tempe = li.next();
                dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fy - tempe.posy) * (fy - tempe.posy) + (fz - tempe.posz) * (fz - tempe.posz));
                dist -= 0.125;
                dist -= (double)(tempe.getWidth() / 2.0f);
                if (tempe == DangerZone.player || tempe.canthitme || !(dist < 10.0) || tempe.entityID == riddenid && !(dy < -0.75)) continue;
                check_list.add(tempe);
            }
        }
        int lz = 0;
        int ly = 0;
        int lx = 0;
        int lfx = focus_x;
        int lfy = focus_y;
        int lfz = focus_z;
        while (delta < 6.0) {
            fx = (float)((double)DangerZone.player.posx + dx * delta);
            fy = (float)((double)(DangerZone.player.posy + DangerZone.player.eyeheight) + dy * delta);
            fz = (float)((double)DangerZone.player.posz + dz * delta);
            x = (int)fx;
            y = (int)fy;
            z = (int)fz;
            if (delta < 5.0 && check_list != null && !check_list.isEmpty()) {
                li = check_list.listIterator();
                while (li.hasNext()) {
                    tempe = li.next();
                    if (!(fy > tempe.posy - 0.125f) || !(fy < tempe.posy + tempe.getHeight() + 0.125f)) continue;
                    dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fz - tempe.posz) * (fz - tempe.posz));
                    dist -= 0.125;
                    if (!((dist -= (double)(tempe.getWidth() / 2.0f)) < 0.0)) continue;
                    focus_meta = 0;
                    focus_bid = 0;
                    focus_z = 0;
                    focus_y = 0;
                    focus_x = 0;
                    focus_dist = (float)dist;
                    focus_entity = tempe;
                    return;
                }
            }
            if (x != lx || y != ly || z != lz) {
                lx = x;
                ly = y;
                lz = z;
                int bid = w.getblock(DangerZone.player.dimension, x, y, z);
                if (DangerZone.player.getInLiquid() && Blocks.isLiquid(bid)) {
                    bid = 0;
                }
                if (bid != 0) {
                    double delta2 = delta;
                    x = (int)((double)DangerZone.player.posx + dx * (delta -= (double)0.1f));
                    y = (int)((double)(DangerZone.player.posy + DangerZone.player.eyeheight) + dy * delta);
                    z = (int)((double)DangerZone.player.posz + dz * delta);
                    lx = x;
                    ly = y;
                    lz = z;
                    while (delta < delta2 + (double)0.01f) {
                        fx = (float)((double)DangerZone.player.posx + dx * delta);
                        fy = (float)((double)(DangerZone.player.posy + DangerZone.player.eyeheight) + dy * delta);
                        fz = (float)((double)DangerZone.player.posz + dz * delta);
                        x = (int)fx;
                        y = (int)fy;
                        z = (int)fz;
                        if (x != lx || y != ly || z != lz) {
                            lx = x;
                            ly = y;
                            lz = z;
                            bid = w.getblock(DangerZone.player.dimension, x, y, z);
                            if (bid != 0) {
                                dx = (float)((double)DangerZone.player.posx + dx * delta);
                                dy = (float)((double)(DangerZone.player.posy + DangerZone.player.eyeheight) + dy * delta);
                                dz = (float)((double)DangerZone.player.posz + dz * delta);
                                dist = 2.0;
                                double lastdist = 2.0;
                                focus_side = 0;
                                double sx = (float)x + 0.5f;
                                double sy = (float)y + 1.0f;
                                double sz = (float)z + 0.5f;
                                dist = Math.sqrt((sx - dx) * (sx - dx) + (sy - dy) * (sy - dy) + (sz - dz) * (sz - dz));
                                if (dist < lastdist) {
                                    lastdist = dist;
                                    focus_side = 0;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 0.5f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.5f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 0.0f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 2;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 0.5f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.5f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 1.0f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 1;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 0.0f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.5f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 0.5f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 3;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 1.0f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.5f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 0.5f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 4;
                                }
                                if ((dist = Math.sqrt(((sx = (double)((float)x + 0.5f)) - dx) * (sx - dx) + ((sy = (double)((float)y + 0.0f)) - dy) * (sy - dy) + ((sz = (double)((float)z + 0.5f)) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    focus_side = 5;
                                }
                                focus_x = lx;
                                focus_y = ly;
                                focus_z = lz;
                                focus_bid = bid;
                                focus_meta = w.getblockmeta(DangerZone.player.dimension, x, y, z);
                                focus_dist = (float)delta;
                                focus_entity = null;
                                if (lfx != focus_x || lfy != focus_y || lfz != focus_z) {
                                    focus_damage = 0.0f;
                                    focus_maxdamage = Blocks.getMaxDamage(bid);
                                    if (focus_maxdamage < 1.0f) {
                                        focus_maxdamage = 1.0f;
                                    }
                                }
                                return;
                            }
                        }
                        delta += (double)0.01f;
                    }
                }
            }
            delta += 0.1;
        }
        focus_meta = 0;
        focus_bid = 0;
        focus_z = 0;
        focus_y = 0;
        focus_x = 0;
        focus_dist = 0.0f;
        focus_entity = null;
    }

    private void renderChunk(World world, int xrel, int zrel, float px, float py, float pz) {
        VBOBuffer v = null;
        int xpos = xrel * 16 + (int)px;
        int zpos = zrel * 16 + (int)pz;
        Chunk c = world.chunkcache.getDecoratedChunkForRenderer(DangerZone.player.dimension, xpos, 0, zpos);
        if (c == null) {
            return;
        }
        VBOlistlock.lock();
        int itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            v = VBOmap.get(c.VBOids[itemp]);
            if (v == null) {
                int ivi = 0;
                while (ivi < 20) {
                    if (c.VBOids[ivi] > 0L) {
                        v = VBOmap.get(c.VBOids[ivi]);
                        if (v != null) {
                            VBOmap.remove(v.VBOid);
                            --vbocount;
                            v.free();
                        }
                        c.VBOids[ivi] = 0L;
                    }
                    ++ivi;
                }
                VBOlistlock.unlock();
                return;
            }
            ++itemp;
        }
        VBOlistlock.unlock();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(xrel * 16 * this.blockrenderwidth), (float)0.0f, (float)(zrel * 16 * this.blockrenderwidth));
        itemp = 0;
        while (itemp <= 20) {
            if (c.VBOids[itemp] <= 0L) break;
            VBOlistlock.lock();
            v = VBOmap.get(c.VBOids[itemp]);
            VBOlistlock.unlock();
            if (v != null) {
                if (!v.isTranslucent) {
                    this.loadStitchedtexture(v.textureindex);
                    v.lastusedframe = this.framecounter;
                    v.draw();
                } else {
                    v.xoff = xrel * 16 * this.blockrenderwidth;
                    v.zoff = zrel * 16 * this.blockrenderwidth;
                    this.translucentVBOs.add(v);
                }
            }
            ++itemp;
        }
        GL11.glPopMatrix();
    }

    public void drawTexturedCube(int sides, boolean isSolid, int bid, int meta, boolean focus) {
        if (bid <= 0 || bid >= 2048) {
            return;
        }
        if (Blocks.BlockArray[bid] == null) {
            return;
        }
        if (!isSolid) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        if ((meta & 0xFC00) != 0) {
            GL11.glPushMatrix();
            if ((meta & 0xC000) == 16384) {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if ((meta & 0xC000) == 32768) {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if ((meta & 0xC000) == 49152) {
                GL11.glRotatef((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if ((meta & 0x3000) == 4096) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if ((meta & 0x3000) == 8192) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if ((meta & 0x3000) == 12288) {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if ((meta & 0xC00) == 1024) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if ((meta & 0xC00) == 2048) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if ((meta & 0xC00) == 3072) {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            sides = 255;
        }
        if (!compiled) {
            this.topid = this.getNextRenderID();
            GL11.glNewList((int)this.topid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glEnd();
            GL11.glEndList();
            this.bottomid = this.getNextRenderID();
            GL11.glNewList((int)this.bottomid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glEnd();
            GL11.glEndList();
            this.frontid = this.getNextRenderID();
            GL11.glNewList((int)this.frontid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glEnd();
            GL11.glEndList();
            this.backid = this.getNextRenderID();
            GL11.glNewList((int)this.backid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glEnd();
            GL11.glEndList();
            this.leftid = this.getNextRenderID();
            GL11.glNewList((int)this.leftid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glEnd();
            GL11.glEndList();
            this.rightid = this.getNextRenderID();
            GL11.glNewList((int)this.rightid, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glEnd();
            GL11.glEndList();
            compiled = true;
        }
        if ((sides & 0x20) != 0 && this.loadtextureforblockside(0, bid, isSolid)) {
            GL11.glCallList((int)this.topid);
        }
        if ((sides & 0x10) != 0 && this.loadtextureforblockside(5, bid, isSolid)) {
            GL11.glCallList((int)this.bottomid);
        }
        if ((sides & 8) != 0 && this.loadtextureforblockside(1, bid, isSolid)) {
            GL11.glCallList((int)this.frontid);
        }
        if ((sides & 4) != 0 && this.loadtextureforblockside(2, bid, isSolid)) {
            GL11.glCallList((int)this.backid);
        }
        if ((sides & 1) != 0 && this.loadtextureforblockside(3, bid, isSolid)) {
            GL11.glCallList((int)this.leftid);
        }
        if ((sides & 2) != 0 && this.loadtextureforblockside(4, bid, isSolid)) {
            GL11.glCallList((int)this.rightid);
        }
        if ((meta & 0xFC00) != 0) {
            GL11.glPopMatrix();
        }
        if (!isSolid) {
            GL11.glDisable((int)3042);
        }
        if (focus && focus_side == 0) {
            GL11.glLineWidth((float)this.linewidth);
            GL11.glBegin((int)3);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glEnd();
        }
        if (focus && focus_side == 5) {
            GL11.glLineWidth((float)this.linewidth);
            GL11.glBegin((int)3);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glEnd();
        }
        if (focus && focus_side == 1) {
            GL11.glLineWidth((float)this.linewidth);
            GL11.glBegin((int)3);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glEnd();
        }
        if (focus && focus_side == 2) {
            GL11.glLineWidth((float)this.linewidth);
            GL11.glBegin((int)3);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glEnd();
        }
        if (focus && focus_side == 3) {
            GL11.glLineWidth((float)this.linewidth);
            GL11.glBegin((int)3);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glEnd();
        }
        if (focus && focus_side == 4) {
            GL11.glLineWidth((float)this.linewidth);
            GL11.glBegin((int)3);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glVertex3f((float)(this.blockrenderwidth / 2), (float)(this.blockrenderwidth / 2), (float)(-this.blockrenderwidth / 2));
            GL11.glEnd();
        }
    }

    public void loadStitchedtexture(int which) {
        if (which < 0 || which > 19) {
            return;
        }
        if (stitches[which] != null && last_texture != WorldRenderer.stitches[which].textureID) {
            stitches[which].bind();
            last_texture = WorldRenderer.stitches[which].textureID;
        }
    }

    public boolean loadtextureforblockside(int side, int bid, boolean solid) {
        Texture lt = Blocks.BlockArray[bid].getTexture(side);
        if (lt == null) {
            return false;
        }
        if (last_texture != lt.getTextureID()) {
            TextureImpl.unbind();
            lt.bind();
            last_texture = lt.getTextureID();
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        return true;
    }

    public boolean forceloadtexture(Texture lt) {
        if (lt == null) {
            return false;
        }
        last_texture = -1;
        TextureImpl.unbind();
        lt.bind();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return true;
    }

    public boolean loadtexture(Texture lt) {
        if (lt == null) {
            return false;
        }
        if (last_texture != lt.getTextureID()) {
            last_texture = lt.getTextureID();
            TextureImpl.unbind();
            lt.bind();
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        return true;
    }

    public static void recalcBrightness(int d, int yp) {
        float f = WorldRendererUtils.getBrightnessForLevel(d, yp);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        brightness_green = brightness_blue = f;
        brightness_red = brightness_blue;
    }

    public void recalcSkyBrightness() {
        float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
        float fsin = (float)Math.sin(Math.toRadians(tod / (float)DangerZone.world.lengthOfDay * 360.0f));
        float fsky = 0.5f + 0.45f * fsin;
        float maxfsky = 1.0f - 0.5f * ((float)DangerZone.thundercount / 300.0f);
        if (maxfsky < 0.5f) {
            maxfsky = 0.5f;
        }
        if (fsky > maxfsky) {
            fsky = maxfsky;
        }
        this.sky_red = 0.445f * fsky;
        this.sky_green = 0.682f * fsky;
        this.sky_blue = 1.0f * fsky;
    }

    public void setBrightness() {
        GL11.glColor3f((float)brightness_red, (float)brightness_green, (float)brightness_blue);
    }

    public void setBrightness(float m) {
        float flb;
        float flg;
        float flr = brightness_red + m;
        if (flr < 0.0f) {
            flr = 0.0f;
        }
        if (flr > 1.0f) {
            flr = 1.0f;
        }
        if ((flg = brightness_green + m) < 0.0f) {
            flg = 0.0f;
        }
        if (flg > 1.0f) {
            flg = 1.0f;
        }
        if ((flb = brightness_blue + m) < 0.0f) {
            flb = 0.0f;
        }
        if (flb > 1.0f) {
            flb = 1.0f;
        }
        GL11.glColor3f((float)flr, (float)flg, (float)flb);
    }

    public void setBrightnessFocus() {
        float bval = 1.0f;
        if (!DangerZone.world.isDaytime()) {
            bval = 0.75f;
        }
        GL11.glColor3f((float)bval, (float)bval, (float)bval);
    }

    public void setBrightnessFocusBlock() {
        float bval = WorldRendererUtils.getTotalLightAt(DangerZone.world, DangerZone.player.dimension, focus_x, focus_y, focus_z);
        if (bval > 1.0f) {
            bval = 1.0f;
        }
        if (bval < 0.0f) {
            bval = 0.0f;
        }
        bval = bval > 0.65f ? (bval -= 0.35f) : (bval += 0.35f);
        GL11.glColor3f((float)bval, (float)bval, (float)bval);
    }

    public void setBrightnessNonFocus() {
        float bval = 0.75f;
        if (!DangerZone.world.isDaytime()) {
            bval = 0.5f;
        }
        GL11.glColor3f((float)bval, (float)bval, (float)bval);
    }

    public int getNextRenderID() {
        lock.lock();
        int i = GL11.glGenLists((int)1);
        lock.unlock();
        return i;
    }

    public static long getNextVBOid() {
        lock.lock();
        long i = nextVBOid++;
        lock.unlock();
        return i;
    }

    public void deleteVBOlist(long[] vboids) {
        VBOlistlock.lock();
        this.VBO_delete_list.add(vboids);
        VBOlistlock.unlock();
    }

    private void Scalef5toSolid() {
        float dst = 0.0f;
        float dz = 0.0f;
        float dy = 0.0f;
        float dx = 0.0f;
        int lz = 0;
        int ly = 0;
        int lx = 0;
        while (dst <= 8.0f) {
            dx = this.f5x * dst / 8.0f;
            dy = this.f5y * dst / 8.0f;
            dz = this.f5z * dst / 8.0f;
            int ix = (int)(DangerZone.player.posx - dx / (float)this.blockrenderwidth);
            int iy = (int)(DangerZone.player.posy + DangerZone.player.eyeheight - dy / (float)this.blockrenderwidth);
            int iz = (int)(DangerZone.player.posz - dz / (float)this.blockrenderwidth);
            if (ix != lx || iy != ly || iz != lz) {
                lx = ix;
                ly = iy;
                lz = iz;
                int bid = DangerZone.world.getblock(DangerZone.player.dimension, ix, iy, iz);
                if (bid != 0 && Blocks.isSolidForRender(bid)) {
                    if ((dst -= 0.25f) < 0.0f) {
                        dst = 0.0f;
                    }
                    dx = this.f5x * dst / 8.0f;
                    dy = this.f5y * dst / 8.0f;
                    dz = this.f5z * dst / 8.0f;
                    break;
                }
            }
            dst += 0.1f;
        }
        this.f5x = dx;
        this.f5y = dy;
        this.f5z = dz;
    }
}

