/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.WorldRenderer;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSword;
import dangerzone.items.Items;
import dangerzone.threads.LightingThread;
import dangerzone.threads.ServerConnection;
import dangerzone.threads.ServerThread;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class Player
extends EntityLiving {
    public Socket toServer;
    public Socket toClient;
    public ServerThread server_thread;
    public ServerConnection server_connection;
    public float eyeheight = 1.75f;
    public float armangle = 0.0f;
    public int armdir = 0;
    public float hit_x;
    public float hit_y;
    public float hit_z;
    public byte[] tdata = null;
    public boolean donewtexture = false;
    public String myname = null;
    public int starthealth = 50;
    public int swimdelay = 0;
    public int jump_delay = 0;
    public int lightupdatecounter = 0;
    public int inventoryticker = 0;
    public int player_privs = 0;

    public Player(World w) {
        super(w);
        this.width = 0.65f;
        this.height = 1.75f;
        this.eyeheight = 1.65f;
        this.uniquename = "DangerZone:Player";
        this.has_inventory = true;
        this.setMaxHealth(this.starthealth);
        this.setHealth(this.starthealth);
        this.setDefense(1.0f);
        this.setMaxHunger(50.0f);
        this.setHunger(50.0f);
        this.setAttackDamage(1.0f);
        this.setMaxAir(50.0f);
        this.setAir(50.0f);
        this.setCanDespawn(false);
    }

    @Override
    public void init() {
        super.init();
        this.eyeheight = 0.943f * this.getHeight();
        this.setSitting(false);
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (this.getGameMode() != 0) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
    }

    @Override
    public String getHurtSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ouch1";
        }
        if (i == 1) {
            return "DangerZone:ouch2";
        }
        return "DangerZone:ouch3";
    }

    @Override
    public float getRightArmAngle() {
        return -this.armangle;
    }

    @Override
    public void update(float deltaT) {
        Entity e;
        this.stray_entity_ticker = 0;
        if (!this.world.isServer && (e = this.getRiddenEntity()) != null) {
            e.update(deltaT);
        }
        if (!(this.getForward() || this.getBackward() || this.getLeft() || this.getRight() || this.getGameMode() == 2)) {
            if (this.world.isServer) {
                this.motionx *= 1.0f - 0.35f * deltaT;
                this.motionz *= 1.0f - 0.35f * deltaT;
            } else {
                float rate = DangerZone.entityupdaterate;
                this.motionx *= 1.0f - 0.35f * deltaT * (rate /= (float)DangerZone.serverentityupdaterate);
                this.motionz *= 1.0f - 0.35f * deltaT * rate;
            }
        }
        if (this.jump_delay > 0) {
            --this.jump_delay;
        }
        this.eyeheight = this.getSitting() ? 0.586f * this.getHeight() : 0.943f * this.getHeight();
        if (!this.world.isServer) {
            InventoryContainer ic = null;
            Item icitem = null;
            ++this.inventoryticker;
            if (this.inventoryticker > 5) {
                this.inventoryticker = 0;
                int j = 0;
                while (j < 100) {
                    ic = this.entity_inventory[j];
                    if (ic != null && (icitem = ic.getItem()) != null) {
                        icitem.update(this, ic);
                    }
                    ++j;
                }
            }
            this.setMaxHealth(this.starthealth + this.getExperience() / 1000);
            this.setDefense(1.0f + (float)this.getExperience() / 100000.0f);
            this.setAttackDamage(1.0f + (float)this.getExperience() / 10000.0f);
            if (this.getHealth() <= 0.0f) {
                this.deadflag = true;
            }
            if (this == DangerZone.player && this.getGameMode() == 0) {
                if (this.getHunger() > 0.0f) {
                    this.setHunger(this.getHunger() - 2.0E-4f);
                }
                if (this.getHealth() >= 0.0f && this.getHealth() < this.getMaxHealth() && this.getHunger() > this.getMaxHunger() / 2.0f) {
                    this.setHealth(this.getHealth() + this.getMaxHealth() * 4.0E-5f);
                }
                if (this.getHunger() <= 0.0f && this.world.rand.nextInt(100) == 1) {
                    this.doAttackFrom(null, 11, 0.1f);
                }
            }
            if (this.armdir != 0) {
                if (this.armdir > 0) {
                    this.armangle += 22.0f * deltaT;
                    if (this.armangle > 150.0f) {
                        this.armdir = -1;
                    }
                }
                if (this.armdir < 0) {
                    this.armangle -= 22.0f * deltaT;
                    if (this.armangle <= 0.0f) {
                        this.armdir = 0;
                        this.armangle = 0.0f;
                    }
                }
            }
            ++this.lightupdatecounter;
            if (this.lightupdatecounter > 5) {
                ic = this.getHotbar(this.gethotbarindex());
                if (ic != null) {
                    float lvl = 0.0f;
                    if (ic.bid != 0) {
                        lvl = Blocks.getLightLevel(ic.bid);
                    }
                    if (ic.iid != 0) {
                        lvl = Items.getLightLevel(ic.iid);
                    }
                    if (lvl != 0.0f) {
                        LightingThread.addRequest(this.dimension, (int)this.posx, (int)(this.posy + 1.25f), (int)this.posz, lvl);
                    }
                }
                this.lightupdatecounter = 0;
            }
        }
        boolean wasOnGround = this.getOnGround();
        super.update(deltaT);
        if (!this.world.isServer && !wasOnGround && this.getOnGround() && this.steppedOnCockroach()) {
            int i = 0;
            while (i < 256) {
                int id = (this.dimension + i + 1) % 256;
                if (Dimensions.DimensionArray[id] != null) {
                    Dimensions.DimensionArray[id].teleportToDimension(this, this.world, id, (int)this.posx, (int)this.posy, (int)this.posz);
                    this.world.playSound("DangerZone:big_splat", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
                    Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, this.posx, this.posy, this.posz, true);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void jump() {
        if (this.getInLiquid() && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + 1.5f), (int)this.posz))) {
            ++this.swimdelay;
            if (this.swimdelay > 40) {
                this.swimdelay = 0;
            }
            if (this.swimdelay > 15) {
                this.motiony += 0.035f;
                if (this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.35f, this.posz)) {
                    this.motiony += 0.55f;
                }
                if (!this.world.isServer && this.getHunger() > 0.0f && this.getGameMode() == 0) {
                    this.setHunger(this.getHunger() - 0.002f);
                }
            }
        }
        if (this.jump_delay > 0) {
            return;
        }
        if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.02f, this.posz)) {
            return;
        }
        if (Math.abs(this.motiony) > 0.05f) {
            return;
        }
        this.motiony = this.isBaby() ? (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 1, (int)this.posz) != 0 ? (this.motiony += 0.7f) : (this.motiony += 0.95f)) : (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 2, (int)this.posz) != 0 || this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + 3, (int)this.posz) != 0 ? (this.motiony += 0.7f) : (this.motiony += 0.95f));
        this.jump_delay = 5;
        if (!this.world.isServer && this.getHunger() > 0.0f && this.getGameMode() == 0) {
            this.setHunger(this.getHunger() - 0.08f);
        }
    }

    public void leftclick(World world, int focus_x, int focus_y, int focus_z, int focus_side, int eid) {
        Entity e = null;
        boolean do_uses = false;
        if (world.isServer) {
            InventoryContainer ic = this.getHotbar(this.gethotbarindex());
            e = DangerZone.server.entityManager.findEntityByID(eid);
            boolean leftcontinue = true;
            if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    leftcontinue = it.onLeftClick(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    leftcontinue = bl.onLeftClick(this, e, ic);
                }
            }
            if (leftcontinue && e != null) {
                int dt = 0;
                float damage = 1.0f;
                if (ic != null) {
                    if (ic.bid != 0) {
                        dt = 3;
                    } else if (ic.iid > 0 && ic.iid < 2048) {
                        damage = Items.getAttackStrength(ic.iid);
                        Item it = ic.getItem();
                        if (it != null) {
                            if (it instanceof ItemSword) {
                                dt = 1;
                            }
                            if (it instanceof ItemPickAxe) {
                                dt = 2;
                            }
                            if (it instanceof ItemAxe) {
                                dt = 2;
                            }
                            if (it instanceof ItemShovel) {
                                dt = 2;
                            }
                        }
                    }
                }
                if (e.leftClickedByPlayer(this, ic)) {
                    e.doAttackFrom(this, dt, damage);
                }
            }
        } else {
            this.armdir = 1;
            e = DangerZone.entityManager.findEntityByID(eid);
            if (e == null) {
                this.server_connection.playerActionToServer(0, 0, 0);
            } else {
                this.server_connection.playerActionToServer(0, 0, e.entityID);
            }
            InventoryContainer ic = this.getHotbar(this.gethotbarindex());
            boolean leftcontinue = true;
            if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    leftcontinue = it.onLeftClick(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    leftcontinue = bl.onLeftClick(this, e, ic);
                }
            }
            if (leftcontinue) {
                if (e == null) {
                    int bid;
                    if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) > 0) {
                        do_uses = true;
                        if (Blocks.leftClickOnBlock(bid, this, this.dimension, focus_x, focus_y, focus_z) || this.getGameMode() != 0) {
                            String particlename;
                            int dmg = 1;
                            if (ic != null && ic.iid != 0) {
                                if (Blocks.isWood(bid) || Blocks.isLeaves(bid)) {
                                    dmg = Items.getWoodStrength(ic.iid);
                                }
                                if (Blocks.isStone(bid)) {
                                    dmg = Items.getStoneStrength(ic.iid);
                                }
                                if (Blocks.isDirt(bid)) {
                                    dmg = Items.getDirtStrength(ic.iid);
                                }
                                if (ic.getItem() instanceof ItemSword && !Blocks.isLeaves(bid)) {
                                    dmg = 0;
                                }
                                if (ic.getItem() instanceof ItemSword && Blocks.isLeaves(bid)) {
                                    dmg = Items.getAttackStrength(ic.iid);
                                }
                                ic.getItem().leftClickOnBlock(this, this.dimension, focus_x, focus_y, focus_z, focus_side);
                            }
                            if ((particlename = Blocks.getParticleName(bid)) == null || particlename.equals("")) {
                                particlename = "DangerZone:ParticleBreak";
                            }
                            Utils.spawnParticles(this.world, particlename, 10, this.dimension, (float)focus_x + 0.5f, (float)focus_y + 0.5f, (float)focus_z + 0.5f, true);
                            int md = Blocks.getMinDamage(bid);
                            if (dmg >= md) {
                                WorldRenderer.focus_damage += (float)dmg;
                            }
                            if (dmg != 0 && (WorldRenderer.focus_damage >= WorldRenderer.focus_maxdamage || this.getGameMode() != 0)) {
                                world.playSound(Blocks.getBreakSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
                                Blocks.onBlockBroken(bid, this, this.dimension, focus_x, focus_y, focus_z);
                                int dbid = Blocks.getBlockDrop(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                                int diid = Blocks.getItemDrop(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                                int howmany = Blocks.getDropCount(bid, this, this.world, this.dimension, focus_x, focus_y, focus_z);
                                world.setblockandmeta(this.dimension, focus_x, focus_y, focus_z, 0, 0);
                                if (howmany > 0) {
                                    int i = 0;
                                    while (i < howmany) {
                                        EntityBlockItem eb;
                                        if (dbid > 0 && (eb = (EntityBlockItem)world.createEntityByName(DangerZone.blockitemname, this.dimension, (float)focus_x + 0.5f, (float)focus_y + 0.5f, (float)focus_z + 0.5f)) != null) {
                                            eb.setBID(dbid);
                                            eb.setIID(0);
                                            world.spawnEntityInWorld(eb);
                                        }
                                        if (diid > 0 && (eb = (EntityBlockItem)world.createEntityByName(DangerZone.blockitemname, this.dimension, (float)focus_x + 0.5f, (float)focus_y + 0.5f, (float)focus_z + 0.5f)) != null) {
                                            eb.setBID(0);
                                            eb.setIID(diid);
                                            world.spawnEntityInWorld(eb);
                                        }
                                        ++i;
                                    }
                                }
                            } else {
                                world.playSound(Blocks.getHitSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
                            }
                        }
                    }
                } else {
                    do_uses = true;
                    Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, this.hit_x, this.hit_y, this.hit_z, true);
                    if (this.getHunger() > 0.0f && this.getGameMode() == 0) {
                        this.setHunger(this.getHunger() - 0.25f);
                    }
                }
                if (do_uses && this.getGameMode() == 0 && ic != null && ic.iid > 0 && ic.iid < 2048 && ic.count == 1) {
                    ++ic.currentuses;
                    this.setHotbarChanged(this.gethotbarindex());
                    if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                        this.setHotbar(this.gethotbarindex(), null);
                    }
                }
            }
        }
    }

    public void middleclick(World world, int focus_x, int focus_y, int focus_z, int eid) {
        int bid;
        if (focus_x > 0 && focus_y > 0 && focus_z > 0 && (bid = world.getblock(this.dimension, focus_x, focus_y, focus_z)) != 0) {
            world.playSound(Blocks.getHitSound(bid), this.dimension, focus_x, focus_y, focus_z, 0.35f, 1.0f);
            DangerZone.messagetimer = 100;
            DangerZone.messagestring = Blocks.BlockArray[bid].uniquename;
        }
    }

    public void rightclick(World world, int focusx, int focusy, int focusz, int side, int eid) {
        Entity e = null;
        InventoryContainer ic = this.getHotbar(this.gethotbarindex());
        boolean rightcontinue = true;
        if (world.isServer) {
            e = DangerZone.server.entityManager.findEntityByID(eid);
            if (e != null) {
                if (e.rightClickedByPlayer(this, ic) && this.getGameMode() == 0) {
                    if (ic != null) {
                        --ic.count;
                        if (ic.count <= 0) {
                            ic = null;
                        }
                    }
                    this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                } else if (ic != null) {
                    Block bl;
                    Item it = ic.getItem();
                    if (it != null) {
                        rightcontinue = it.onRightClick(this, e, ic);
                    }
                    if ((bl = ic.getBlock()) != null) {
                        rightcontinue = bl.onRightClick(this, e, ic);
                    }
                    if (this.getGameMode() == 0 && rightcontinue) {
                        if (ic.count == 1) {
                            ++ic.currentuses;
                            this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                            if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                                this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), null);
                            }
                        } else {
                            --ic.count;
                            if (ic.count <= 0) {
                                ic = null;
                            }
                            this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                        }
                    }
                }
            } else if (ic != null) {
                Block bl;
                Item it = ic.getItem();
                if (it != null) {
                    rightcontinue = it.onRightClick(this, e, ic);
                }
                if ((bl = ic.getBlock()) != null) {
                    rightcontinue = bl.onRightClick(this, e, ic);
                }
                if (this.getGameMode() == 0 && rightcontinue) {
                    if (ic.count == 1) {
                        ++ic.currentuses;
                        this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                        if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                            this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), null);
                        }
                    } else {
                        --ic.count;
                        if (ic.count <= 0) {
                            ic = null;
                        }
                        this.server_thread.sendInventoryUpdateToPlayer(0, this.gethotbarindex(), ic);
                    }
                }
            }
        } else {
            e = DangerZone.entityManager.findEntityByID(eid);
            if (e != null) {
                this.server_connection.playerActionToServer(0, 1, e.entityID);
                e.rightClickedByPlayer(this, ic);
            } else {
                int bid = 0;
                int iid = 0;
                if (ic != null && ic.count >= 1) {
                    bid = ic.bid;
                    iid = ic.iid;
                }
                if (focusx > 0 && focusy >= 0 && focusz > 0) {
                    int fbid = world.getblock(this.dimension, focusx, focusy, focusz);
                    boolean cont = Blocks.rightClickOnBlock(fbid, this, this.dimension, focusx, focusy, focusz);
                    if (cont) {
                        if (bid != 0) {
                            Blocks.doPlaceBlock(bid, fbid, this, world, this.dimension, focusx, focusy, focusz, side);
                        } else if (ic != null && iid != 0) {
                            boolean delme = Items.rightClickOnBlock(iid, this, this.dimension, focusx, focusy, focusz, side);
                            world.playSound(Blocks.getHitSound(fbid), this.dimension, focusx, focusy, focusz, 0.35f, 1.0f);
                            if (this.getGameMode() == 0 && delme) {
                                if (ic.count == 1) {
                                    ++ic.currentuses;
                                    this.setHotbarChanged(this.gethotbarindex());
                                    if (ic.currentuses >= Items.getMaxUses(ic.iid)) {
                                        this.setHotbar(this.gethotbarindex(), null);
                                    }
                                } else {
                                    --ic.count;
                                    if (ic.count <= 0) {
                                        this.setHotbar(this.gethotbarindex(), null);
                                        ic = null;
                                    }
                                    this.setHotbarChanged(this.gethotbarindex());
                                }
                            }
                        }
                    }
                } else {
                    this.server_connection.playerActionToServer(0, 1, 0);
                }
            }
        }
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
    }

    public boolean putMeInASlot(int bid, int iid, int uses) {
        InventoryContainer ic;
        int i = 0;
        while (i < 10) {
            ic = this.getHotbar(i);
            if (ic != null && ic.bid == bid && ic.iid == iid) {
                if (ic.bid != 0 && ic.count < Blocks.getMaxStack(bid)) {
                    ++ic.count;
                    this.setHotbarChanged(i);
                    this.sendInventoryUpdate(0, i, ic);
                    return true;
                }
                if (ic.iid != 0 && ic.count < Items.getMaxStack(iid)) {
                    ++ic.count;
                    this.setHotbarChanged(i);
                    this.sendInventoryUpdate(0, i, ic);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            ic = this.getInventory(i);
            if (ic != null && ic.bid == bid && ic.iid == iid) {
                if (ic.bid != 0 && ic.count < Blocks.getMaxStack(bid)) {
                    ++ic.count;
                    this.setInventoryChanged(i);
                    this.sendInventoryUpdate(1, i, ic);
                    return true;
                }
                if (ic.iid != 0 && ic.count < Items.getMaxStack(iid)) {
                    ++ic.count;
                    this.setInventoryChanged(i);
                    this.sendInventoryUpdate(1, i, ic);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            if (this.getHotbar(i) == null) {
                ic = new InventoryContainer();
                this.setHotbar(i, ic);
                ic.bid = bid;
                ic.iid = iid;
                ic.count = 1;
                ic.currentuses = uses;
                this.sendInventoryUpdate(0, i, ic);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            if (this.getInventory(i) == null) {
                ic = new InventoryContainer();
                this.setInventory(i, ic);
                ic.bid = bid;
                ic.iid = iid;
                ic.count = 1;
                ic.currentuses = uses;
                this.sendInventoryUpdate(1, i, ic);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void sendInventoryUpdate(int which, int slot, InventoryContainer ic) {
        if (this.world.isServer) {
            this.server_thread.sendInventoryUpdateToPlayer(which, slot, ic);
        } else {
            this.server_connection.inventoryUpdate(which, slot, ic);
        }
    }

    private boolean steppedOnCockroach() {
        List<Entity> nearby_list = null;
        if (this.world.isServer) {
            return false;
        }
        nearby_list = DangerZone.entityManager.findEntitiesInRange(4.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                float dist;
                e = li.next();
                if (!(e instanceof Cockroach) || !((dist = this.getDistanceFromEntity(e)) < 0.75f)) continue;
                Utils.spawnParticles(this.world, "DangerZone:ParticleHurt", 10, this.dimension, e.posx, e.posy, e.posz, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public Texture getTexture() {
        if (this.donewtexture) {
            File file = null;
            try {
                file = File.createTempFile("TmpSkin", ".tmp");
                file.deleteOnExit();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            int width = 64;
            int height = 32;
            String format = "PNG";
            BufferedImage image = new BufferedImage(width, height, 1);
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int i = (x + width * y) * 4;
                    int r = this.tdata[i] & 0xFF;
                    int g = this.tdata[i + 1] & 0xFF;
                    int b = this.tdata[i + 2] & 0xFF;
                    int a = this.tdata[i + 3] & 0xFF;
                    image.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                    ++y;
                }
                ++x;
            }
            try {
                ImageIO.write((RenderedImage)image, format, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            image.flush();
            if (this.texture != null) {
                this.texture.release();
                this.texture = null;
            }
            try {
                this.texture = TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)file.getPath()));
                this.tdata = this.texture.getTextureData();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.texture = null;
            }
            this.donewtexture = false;
        }
        if (this.texture == null) {
            try {
                this.texture = TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)"Player.png"));
                this.tdata = this.texture.getTextureData();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.texture = null;
            }
        }
        return this.texture;
    }
}

