/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class Runnit {
    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        if (os == null) {
            throw new IllegalStateException("os.name");
        }
        os = os.toLowerCase();
        return os.startsWith("windows");
    }

    public static File getJreExecutable() throws FileNotFoundException {
        String jreDirectory = System.getProperty("java.home");
        if (jreDirectory == null) {
            throw new IllegalStateException("java.home");
        }
        File exe = Runnit.isWindows() ? new File(jreDirectory, "bin/java.exe") : new File(jreDirectory, "bin/java");
        if (!exe.isFile()) {
            throw new FileNotFoundException(exe.toString());
        }
        return exe;
    }

    public static int launch(String which, List<String> cmdarray) throws IOException, InterruptedException {
        int r;
        byte[] buffer = new byte[1024];
        ProcessBuilder processBuilder = new ProcessBuilder(cmdarray);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        InputStream in = process.getInputStream();
        String filepath = "logs/" + which + ".log";
        File f = new File(filepath);
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        f.getParentFile().mkdirs();
        int linelimit = 0;
        os = new FileOutputStream(filepath);
        bos = new BufferedOutputStream(os, 10000);
        while ((r = in.read(buffer)) > 0) {
            if (linelimit > 1000) continue;
            bos.write(buffer, 0, r);
            ++linelimit;
        }
        bos.close();
        os.close();
        return process.waitFor();
    }
}

