/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import launcher.Runnit;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;

public class LauncherMain {
    public static String version_string = "0.8";
    public static int screen_width = 1000;
    public static int screen_height = 600;
    public static String windowTitle = "DangerZone Launcher";
    public static Font awtfont = null;
    public static TrueTypeFont font = null;
    private static Texture logotexture = null;
    private static Texture buttontexture = null;
    private static Texture runbuttontexture = null;
    private static Texture checktexture = null;
    private static Texture unchecktexture = null;
    private static Texture textinputtexture = null;
    private static Texture pic1 = null;
    private static Texture pic2 = null;
    private static Texture pic3 = null;
    private static Texture pic4 = null;
    private static Texture pic5 = null;
    public static boolean quit = false;
    public static List<ButtonHandler> buttons;
    public static boolean escaped;
    public static boolean entered;
    public static Properties prop;
    public static int picnum;
    public static int picnum_counter;
    public static String server_address;
    public static int server_port;
    public static String server_port_string;
    public static String worldname;
    public static String playername;
    public static boolean keepitsqueakyclean;
    public static String alt_texture_path;
    public static int current_screen;
    public static Iterator<ButtonHandler> bb;
    public static Audio popsound;
    public static boolean playernameinput;
    public static boolean serveraddressinput;
    public static boolean newworldinput;
    public static boolean serverportinput;
    public static int worldliststart;
    public static int numworld;
    public static boolean displaydeleteconfirm;
    public static boolean dodelete;
    public static String newworldname;
    private static final Class[] parameters;

    static {
        escaped = false;
        entered = false;
        prop = new Properties();
        picnum = 0;
        picnum_counter = 0;
        server_address = "127.0.0.1";
        server_port = 18668;
        server_port_string = "";
        worldname = "my_world";
        playername = "Player";
        keepitsqueakyclean = true;
        alt_texture_path = "";
        current_screen = 0;
        playernameinput = false;
        serveraddressinput = false;
        newworldinput = false;
        serverportinput = false;
        worldliststart = 0;
        numworld = 0;
        displaydeleteconfirm = false;
        dodelete = false;
        newworldname = "New World";
        parameters = new Class[]{URL.class};
    }

    public static void initGL() {
        screen_width = Display.getWidth();
        screen_height = Display.getHeight();
        GL11.glViewport((int)0, (int)0, (int)screen_width, (int)screen_height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(45.0f, (float)screen_width / (float)screen_height, 1.0f, 100.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glHint((int)3152, (int)4353);
        GL11.glEnable((int)3553);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
    }

    public static void startGUI() {
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(screen_width, screen_height));
            Display.setResizable((boolean)false);
            Display.setVSyncEnabled((boolean)false);
            Display.setTitle((String)windowTitle);
            Display.create();
            Keyboard.create();
            Mouse.create();
            SoundStore.get().init();
            LauncherMain.initGL();
        }
        catch (LWJGLException e1) {
            System.out.printf("Something went horribly wrong with initialization!\n", new Object[0]);
            e1.printStackTrace();
            System.exit(1);
        }
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)screen_width, (double)0.0, (double)screen_height, (double)-30.0, (double)30.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void stopGUI() {
        Mouse.destroy();
        Keyboard.destroy();
        Display.destroy();
        AL.destroy();
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        String curdir = System.getProperty("user.dir");
        File libfile = new File(String.valueOf(curdir) + "/DangerZone_lib/native");
        if (libfile.exists()) {
            System.setProperty("org.lwjgl.librarypath", String.valueOf(curdir) + "/DangerZone_lib/native");
        }
        CodeSource codeSource = LauncherMain.class.getProtectionDomain().getCodeSource();
        try {
            File myfile = new File(codeSource.getLocation().toURI().getPath());
            LauncherMain.addFile(myfile);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LauncherMain.startGUI();
        awtfont = new Font("Times New Roman", 0, 36);
        font = new TrueTypeFont(awtfont, false);
        try {
            logotexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/logo.png"));
            buttontexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/button.png"));
            runbuttontexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/runbutton.png"));
            checktexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/check.png"));
            unchecktexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/uncheck.png"));
            textinputtexture = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/textinput.png"));
            pic1 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic1.png"));
            pic2 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic2.png"));
            pic3 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic3.png"));
            pic4 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic4.png"));
            pic5 = TextureLoader.getTexture("PNG", ResourceLoader.getResourceAsStream("launchres/menus/pic5.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            popsound = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("launchres/sounds/pop.wav"));
        }
        catch (Exception e) {
            popsound = null;
        }
        LauncherMain.readConfig();
        picnum = 0;
        picnum_counter = 0;
        LauncherMain.showLogo();
        LauncherMain.textAt(25.0f, screen_height - 50, "Hi " + playername + "!");
        LauncherMain.textAt(675.0f, screen_height - 50, "Launcher Ver " + version_string);
        Display.update();
        Thread.sleep(2000L);
        picnum = 1;
        while (!quit) {
            if (++picnum_counter > 300) {
                picnum_counter = 0;
                if (++picnum > 5) {
                    picnum = 1;
                }
            }
            LauncherMain.showLogo();
            if (current_screen == 0) {
                LauncherMain.doHomeScreen();
            }
            if (current_screen == 1) {
                LauncherMain.doMultiPlayerScreen();
            }
            if (current_screen == 2) {
                LauncherMain.doOptionsScreen();
            }
            if (current_screen == 3) {
                LauncherMain.doSinglePlayerScreen();
            }
            Display.update();
            Thread.sleep(16L);
            if (Display.isCloseRequested()) {
                quit = true;
                break;
            }
            if (quit) break;
            SoundStore.get().poll(0);
        }
        picnum = 0;
        LauncherMain.showLogo();
        LauncherMain.textAt(10.0f, 10.0f, "Bye!");
        Display.update();
        LauncherMain.writeConfig();
        Thread.sleep(1000L);
        LauncherMain.stopGUI();
        System.exit(0);
    }

    private static void showLogo() {
        GL11.glPushMatrix();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glLoadIdentity();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (picnum == 0) {
            logotexture.bind();
        }
        if (picnum == 1) {
            pic1.bind();
        }
        if (picnum == 2) {
            pic2.bind();
        }
        if (picnum == 3) {
            pic3.bind();
        }
        if (picnum == 4) {
            pic4.bind();
        }
        if (picnum == 5) {
            pic5.bind();
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        float x = 210.0f;
        float y = 200.0f;
        if (picnum > 0) {
            x = 480.0f;
            y = 280.0f;
        }
        GL11.glTranslatef((float)(screen_width / 2), (float)(screen_height / 2), (float)-5.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)(-x), (float)y, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)(-x), (float)(-y), (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)x, (float)(-y), (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void textAt(float xpos, float ypos, String text) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)font.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        font.drawString(0.0f, 0.0f, text, Color.white);
        GL11.glPopMatrix();
    }

    public static void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize) {
        float w = t.getWidth();
        float h = t.getHeight();
        t.bind();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)(xsize / t.getWidth()), (float)(ysize / t.getHeight()), (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static String getTextChar() {
        boolean caps = false;
        escaped = false;
        entered = false;
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            caps = true;
        }
        while (Keyboard.next()) {
            int currk;
            if (Keyboard.getEventKey() == 1 && Keyboard.isKeyDown((int)1)) {
                escaped = true;
            }
            if (Keyboard.getEventKey() == 28 && Keyboard.isKeyDown((int)28)) {
                entered = true;
            }
            if (!Keyboard.isKeyDown((int)(currk = Keyboard.getEventKey()))) continue;
            switch (currk) {
                case 211: {
                    return "delete";
                }
                case 14: {
                    return "delete";
                }
                case 11: {
                    if (caps) {
                        return ")";
                    }
                    return "0";
                }
                case 2: {
                    if (caps) {
                        return "!";
                    }
                    return "1";
                }
                case 3: {
                    if (caps) {
                        return "@";
                    }
                    return "2";
                }
                case 4: {
                    if (caps) {
                        return "#";
                    }
                    return "3";
                }
                case 5: {
                    if (caps) {
                        return "$";
                    }
                    return "4";
                }
                case 6: {
                    if (caps) {
                        return "%";
                    }
                    return "5";
                }
                case 7: {
                    if (caps) {
                        return "^";
                    }
                    return "6";
                }
                case 8: {
                    if (caps) {
                        return "&";
                    }
                    return "7";
                }
                case 9: {
                    if (caps) {
                        return "*";
                    }
                    return "8";
                }
                case 10: {
                    if (caps) {
                        return "(";
                    }
                    return "9";
                }
                case 30: {
                    if (caps) {
                        return "A";
                    }
                    return "a";
                }
                case 48: {
                    if (caps) {
                        return "B";
                    }
                    return "b";
                }
                case 46: {
                    if (caps) {
                        return "C";
                    }
                    return "c";
                }
                case 32: {
                    if (caps) {
                        return "D";
                    }
                    return "d";
                }
                case 18: {
                    if (caps) {
                        return "E";
                    }
                    return "e";
                }
                case 33: {
                    if (caps) {
                        return "F";
                    }
                    return "f";
                }
                case 34: {
                    if (caps) {
                        return "G";
                    }
                    return "g";
                }
                case 35: {
                    if (caps) {
                        return "H";
                    }
                    return "h";
                }
                case 23: {
                    if (caps) {
                        return "I";
                    }
                    return "i";
                }
                case 36: {
                    if (caps) {
                        return "J";
                    }
                    return "j";
                }
                case 37: {
                    if (caps) {
                        return "K";
                    }
                    return "k";
                }
                case 38: {
                    if (caps) {
                        return "L";
                    }
                    return "l";
                }
                case 50: {
                    if (caps) {
                        return "M";
                    }
                    return "m";
                }
                case 49: {
                    if (caps) {
                        return "N";
                    }
                    return "n";
                }
                case 24: {
                    if (caps) {
                        return "O";
                    }
                    return "o";
                }
                case 25: {
                    if (caps) {
                        return "P";
                    }
                    return "p";
                }
                case 16: {
                    if (caps) {
                        return "Q";
                    }
                    return "q";
                }
                case 19: {
                    if (caps) {
                        return "R";
                    }
                    return "r";
                }
                case 31: {
                    if (caps) {
                        return "S";
                    }
                    return "s";
                }
                case 20: {
                    if (caps) {
                        return "T";
                    }
                    return "t";
                }
                case 22: {
                    if (caps) {
                        return "U";
                    }
                    return "u";
                }
                case 47: {
                    if (caps) {
                        return "V";
                    }
                    return "v";
                }
                case 17: {
                    if (caps) {
                        return "W";
                    }
                    return "w";
                }
                case 45: {
                    if (caps) {
                        return "X";
                    }
                    return "x";
                }
                case 21: {
                    if (caps) {
                        return "Y";
                    }
                    return "y";
                }
                case 44: {
                    if (caps) {
                        return "Z";
                    }
                    return "z";
                }
                case 52: {
                    if (caps) {
                        return ">";
                    }
                    return ".";
                }
                case 51: {
                    if (caps) {
                        return "<";
                    }
                    return ",";
                }
                case 53: {
                    if (caps) {
                        return "?";
                    }
                    return "/";
                }
                case 39: {
                    if (caps) {
                        return ":";
                    }
                    return ";";
                }
                case 40: {
                    if (caps) {
                        return "\"";
                    }
                    return "'";
                }
                case 15: 
                case 57: {
                    return " ";
                }
                case 43: {
                    if (caps) {
                        return "|";
                    }
                    return "\\";
                }
                case 26: {
                    if (caps) {
                        return "{";
                    }
                    return "[";
                }
                case 27: {
                    if (caps) {
                        return "}";
                    }
                    return "]";
                }
                case 12: {
                    if (caps) {
                        return "_";
                    }
                    return "-";
                }
                case 13: {
                    if (caps) {
                        return "+";
                    }
                    return "=";
                }
            }
        }
        return null;
    }

    private static void readConfig() {
        FileInputStream input = null;
        server_address = "127.0.0.1";
        server_port = 18668;
        worldname = "my_world";
        playername = "Player";
        keepitsqueakyclean = true;
        alt_texture_path = "";
        try {
            input = new FileInputStream("DangerZone.properties");
            prop.load(input);
            server_address = LauncherMain.getPropertyString(prop, "ServerAddress", "127.0.0.1");
            server_port = LauncherMain.getPropertyInt(prop, "ServerPort", 0, Integer.MAX_VALUE, 18668);
            worldname = LauncherMain.getPropertyString(prop, "WorldName", "my_world");
            playername = LauncherMain.getPropertyString(prop, "Playername", "Player");
            keepitsqueakyclean = LauncherMain.getPropertyBoolean(prop, "RunFinalization", true);
            alt_texture_path = LauncherMain.getPropertyString(prop, "AltTextureDir", "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void writeConfig() {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream("DangerZone.properties");
            prop.setProperty("ServerAddress", server_address);
            prop.setProperty("ServerPort", String.format("%d", server_port));
            prop.setProperty("WorldName", worldname);
            prop.setProperty("Playername", playername);
            prop.setProperty("RunFinalization", String.format("%s", keepitsqueakyclean ? "true" : "false"));
            prop.setProperty("AltTextureDir", alt_texture_path);
            prop.store(output, null);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        if (output != null) {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void doHomeScreen() {
        LauncherMain.textAt(25.0f, screen_height - 55, "Hi " + playername + "!");
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 155, 105, 45, runbuttontexture, "PLAY", 1));
        LauncherMain.textAt(150.0f, screen_height - 155, ": " + worldname);
        buttons.add(new ButtonHandler(25, 50, 225, 45, buttontexture, "Multi-Player", 2));
        buttons.add(new ButtonHandler(25, 150, 350, 45, buttontexture, "Single Player Options", 5));
        buttons.add(new ButtonHandler(25, 100, 285, 45, buttontexture, "General Options", 3));
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKey() == 1 && Keyboard.isKeyDown((int)1) && Keyboard.getEventKeyState()) {
                quit = true;
                break;
            }
            if (Keyboard.getEventKey() == 45 && Keyboard.isKeyDown((int)45) && Keyboard.getEventKeyState()) {
                quit = true;
                break;
            }
            if (Keyboard.getEventKey() != 16 || !Keyboard.isKeyDown((int)16) || !Keyboard.getEventKeyState()) continue;
            quit = true;
            break;
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static void doOptionsScreen() {
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 55, 125, 45, buttontexture, "Back", 4));
        LauncherMain.textAt(25.0f, screen_height - 155, "Player Name:");
        buttons.add(new ButtonHandler(225, screen_height - 155, 290, 45, playernameinput ? textinputtexture : null, playername, 7));
        buttons.add(new ButtonHandler(25, screen_height - 205, 45, 45, keepitsqueakyclean ? checktexture : unchecktexture, "     Java Cleaner", 6));
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        String s = LauncherMain.getTextChar();
        if (playernameinput) {
            if (entered) {
                playernameinput = false;
                if (playername.length() <= 0) {
                    playername = "Player";
                }
            }
            if (escaped) {
                playernameinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (playername.length() < 16) {
                        playername = String.valueOf(playername) + s;
                    }
                } else if (playername.length() > 0) {
                    String newstring = new String();
                    int i = 0;
                    while (i < playername.length() - 1) {
                        newstring = String.valueOf(newstring) + playername.charAt(i);
                        ++i;
                    }
                    playername = newstring;
                }
            }
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static void doMultiPlayerScreen() {
        int i;
        String newstring;
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 55, 125, 45, buttontexture, "Back", 4));
        LauncherMain.textAt(25.0f, screen_height - 155, "Server Address:");
        buttons.add(new ButtonHandler(325, screen_height - 155, 325, 45, serveraddressinput ? textinputtexture : null, server_address, 8));
        LauncherMain.textAt(25.0f, screen_height - 205, "Server Port:");
        server_port_string = String.format("%d", server_port);
        buttons.add(new ButtonHandler(325, screen_height - 205, 325, 45, serverportinput ? textinputtexture : null, server_port_string, 9));
        buttons.add(new ButtonHandler(25, screen_height - 355, 325, 45, runbuttontexture, "START A SERVER", 10));
        buttons.add(new ButtonHandler(25, screen_height - 255, 400, 45, runbuttontexture, "CONNECT TO SERVER", 11));
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        String s = LauncherMain.getTextChar();
        if (serveraddressinput) {
            if (entered) {
                serveraddressinput = false;
                if (server_address.length() <= 0) {
                    server_address = "127.0.0.1";
                }
            }
            if (escaped) {
                serveraddressinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (server_address.length() < 24) {
                        server_address = String.valueOf(server_address) + s;
                    }
                } else if (server_address.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < server_address.length() - 1) {
                        newstring = String.valueOf(newstring) + server_address.charAt(i);
                        ++i;
                    }
                    server_address = newstring;
                }
            }
        }
        if (serverportinput) {
            if (entered) {
                serverportinput = false;
                if (server_port_string.length() <= 0) {
                    server_port_string = "18668";
                }
            }
            if (escaped) {
                serverportinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (server_port_string.length() < 6) {
                        server_port_string = String.valueOf(server_port_string) + s;
                    }
                } else if (server_port_string.length() > 0) {
                    newstring = new String();
                    i = 0;
                    while (i < server_port_string.length() - 1) {
                        newstring = String.valueOf(newstring) + server_port_string.charAt(i);
                        ++i;
                    }
                    server_port_string = newstring;
                }
            }
            server_port = Integer.parseInt(server_port_string);
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static void removedir(String dir) {
        File[] files;
        File[] fileArray = files = new File(dir).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                LauncherMain.removedir(String.valueOf(dir) + "/" + file.getName());
            } else {
                file.delete();
            }
            ++n2;
        }
        File curdir = new File(dir);
        curdir.delete();
    }

    public static void doSinglePlayerScreen() {
        String curdir = System.getProperty("user.dir");
        File[] files = new File(String.valueOf(curdir) + "/worlds").listFiles();
        String currworldname = "";
        int newnumworld = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (worldliststart == newnumworld) {
                    currworldname = file.getName();
                }
                ++newnumworld;
            }
            ++n2;
        }
        if (worldliststart >= newnumworld) {
            worldliststart = 0;
        }
        numworld = newnumworld;
        buttons = new ArrayList<ButtonHandler>();
        buttons.add(new ButtonHandler(25, screen_height - 55, 125, 45, buttontexture, "Back", 4));
        LauncherMain.textAt(25.0f, screen_height - 155, "World:");
        LauncherMain.textAt(175.0f, screen_height - 155, currworldname);
        if (currworldname != "") {
            worldname = currworldname;
        }
        buttons.add(new ButtonHandler(175, screen_height - 205, 100, 45, buttontexture, "Next", 12));
        buttons.add(new ButtonHandler(325, screen_height - 205, 100, 45, buttontexture, "Prev", 13));
        buttons.add(new ButtonHandler(25, screen_height - 305, 150, 45, buttontexture, "Create", 14));
        buttons.add(new ButtonHandler(225, screen_height - 305, 325, 45, newworldinput ? textinputtexture : null, newworldname, 18));
        buttons.add(new ButtonHandler(25, screen_height - 355, 150, 45, buttontexture, "Delete", 15));
        if (displaydeleteconfirm) {
            LauncherMain.textAt(200.0f, screen_height - 355, "Delete: " + worldname);
            LauncherMain.textAt(200.0f, screen_height - 405, "Are you sure?");
            buttons.add(new ButtonHandler(425, screen_height - 405, 45, 45, checktexture, "", 16));
            buttons.add(new ButtonHandler(475, screen_height - 405, 45, 45, unchecktexture, "", 17));
        }
        bb = buttons.iterator();
        while (bb.hasNext()) {
            bb.next().draw();
        }
        String s = LauncherMain.getTextChar();
        if (newworldinput) {
            if (entered) {
                newworldinput = false;
                if (newworldname.length() <= 0) {
                    newworldname = "New World";
                }
            }
            if (escaped) {
                newworldinput = false;
            }
            if (s != null) {
                if (!s.equals("delete")) {
                    if (newworldname.length() < 24) {
                        newworldname = String.valueOf(newworldname) + s;
                    }
                } else if (newworldname.length() > 0) {
                    String newstring = new String();
                    int i = 0;
                    while (i < newworldname.length() - 1) {
                        newstring = String.valueOf(newstring) + newworldname.charAt(i);
                        ++i;
                    }
                    newworldname = newstring;
                }
            }
        }
        while (Mouse.next()) {
            int clickx = Mouse.getEventX();
            int clicky = Mouse.getEventY();
            if (!Mouse.getEventButtonState() || Mouse.getEventButton() < 0) continue;
            bb = buttons.iterator();
            ButtonHandler fb = null;
            while (bb.hasNext()) {
                ButtonHandler mb = bb.next();
                if (clickx < mb.x || clickx > mb.x + mb.xsize || clicky < mb.y || clicky > mb.y + mb.ysize) continue;
                fb = mb;
                break;
            }
            if (Mouse.getEventButton() == 0 && fb != null) {
                fb.leftclickhandler();
            }
            if (Mouse.getEventButton() != 1 || fb == null) continue;
            fb.rightclickhandler();
        }
    }

    public static int getPropertyInt(Properties prop, String propname, int min, int max, int dflt) {
        int retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Integer.parseInt(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static long getPropertyLong(Properties prop, String propname, long min, long max, long dflt) {
        long retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Long.parseLong(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static float getPropertyFloat(Properties prop, String propname, float min, float max, float dflt) {
        float retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Float.parseFloat(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static double getPropertyDouble(Properties prop, String propname, double min, double max, double dflt) {
        double retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Double.parseDouble(s);
            if (retval < min) {
                retval = min;
            }
            if (retval > max) {
                retval = max;
            }
        }
        return retval;
    }

    public static boolean getPropertyBoolean(Properties prop, String propname, boolean dflt) {
        boolean retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = Boolean.parseBoolean(s);
        }
        return retval;
    }

    public static String getPropertyString(Properties prop, String propname, String dflt) {
        String retval = dflt;
        String s = prop.getProperty(propname);
        if (s != null) {
            retval = s;
        }
        return retval;
    }

    public static void addFile(File f) throws IOException {
        LauncherMain.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static class ButtonHandler {
        Texture t;
        int x;
        int y;
        int xsize;
        int ysize;
        String s;
        int which;

        public ButtonHandler(int xpos, int ypos, int bxsize, int bysize, Texture tx, String ot, int b) {
            this.x = xpos;
            this.y = ypos;
            this.xsize = bxsize;
            this.ysize = bysize;
            this.t = tx;
            this.s = ot;
            this.which = b;
        }

        public void leftclickhandler() {
            String where;
            ArrayList<String> cmdarray;
            String curdir;
            popsound.playAsSoundEffect(1.0f, 1.0f, false);
            if (this.which == 1) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList<String>();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.writeConfig();
                cmdarray.add("-Xmx1g");
                cmdarray.add("-XX:MaxDirectMemorySize=2g");
                where = String.valueOf(curdir) + "/DangerZone.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                try {
                    Runnit.launch("singleplayer", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
                LauncherMain.readConfig();
            }
            if (this.which == 2) {
                current_screen = 1;
            }
            if (this.which == 3) {
                current_screen = 2;
            }
            if (this.which == 4) {
                current_screen = 0;
                playernameinput = false;
                serveraddressinput = false;
                serverportinput = false;
                displaydeleteconfirm = false;
                newworldinput = false;
            }
            if (this.which == 5) {
                current_screen = 3;
            }
            if (this.which == 6) {
                keepitsqueakyclean = !keepitsqueakyclean;
            }
            if (this.which == 7) {
                playernameinput = true;
            }
            if (this.which == 8) {
                serveraddressinput = true;
                serverportinput = false;
            }
            if (this.which == 9) {
                serverportinput = true;
                serveraddressinput = false;
            }
            if (this.which == 10) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.writeConfig();
                cmdarray.add("-Xmx2g");
                cmdarray.add("-XX:MaxDirectMemorySize=1g");
                where = String.valueOf(curdir) + "/DangerZone.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                cmdarray.add("server");
                cmdarray.add("-server");
                cmdarray.add("--server");
                try {
                    Runnit.launch("server", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.readConfig();
            }
            if (this.which == 11) {
                curdir = System.getProperty("user.dir");
                cmdarray = new ArrayList();
                try {
                    cmdarray.add(Runnit.getJreExecutable().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.writeConfig();
                cmdarray.add("-Xmx1g");
                cmdarray.add("-XX:MaxDirectMemorySize=2g");
                where = String.valueOf(curdir) + "/DangerZone.jar";
                cmdarray.add("-jar");
                cmdarray.add(where);
                cmdarray.add("client");
                cmdarray.add("-client");
                cmdarray.add("--client");
                try {
                    Runnit.launch("client", cmdarray);
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                LauncherMain.readConfig();
            }
            if (this.which == 12) {
                if (++worldliststart >= numworld) {
                    worldliststart = numworld - 1;
                }
                if (worldliststart < 0) {
                    worldliststart = 0;
                }
            }
            if (this.which == 13 && --worldliststart < 0) {
                worldliststart = 0;
            }
            if (this.which == 14) {
                boolean files;
                newworldinput = false;
                if (newworldname != null && newworldname != "" && !newworldname.contains("..") && (files = new File(String.valueOf(curdir = System.getProperty("user.dir")) + "/worlds/" + newworldname).mkdirs())) {
                    newworldname = "New World";
                }
            }
            if (this.which == 15) {
                displaydeleteconfirm = true;
            }
            if (this.which == 16) {
                displaydeleteconfirm = false;
                if (worldname != null && worldname != "" && !worldname.contains("..")) {
                    curdir = System.getProperty("user.dir");
                    LauncherMain.removedir(String.valueOf(curdir) + "/worlds/" + worldname);
                }
            }
            if (this.which == 17) {
                displaydeleteconfirm = false;
            }
            if (this.which == 18) {
                newworldinput = true;
            }
        }

        public void rightclickhandler() {
        }

        public void draw() {
            if (this.t != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                LauncherMain.drawRectangleWithTexture(this.t, this.x, this.y, this.xsize, this.ysize);
            }
            if (this.s != null && !this.s.equals("")) {
                LauncherMain.textAt(this.x + 6, this.y, this.s);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

