/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.ListInt;
import dangerzone.Player;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServerEntityUpdateLoop
implements Runnable {
    public List<ListInt> entity_list;
    public List<ListInt> entity_free_list;
    public Entity[] entities;
    public Lock entity_list_lock = new ReentrantLock();

    @Override
    public void run() {
        long lasttime = System.currentTimeMillis();
        long loop_interval = DangerZone.serverentityupdaterate;
        int inext = 0;
        this.entity_list_lock.lock();
        this.entities = new Entity[DangerZone.max_entities];
        this.entity_list = new ArrayList<ListInt>();
        this.entity_free_list = new ArrayList<ListInt>();
        int j = 1;
        while (j < DangerZone.max_entities) {
            this.entity_free_list.add(new ListInt(j));
            ++j;
        }
        this.entity_list_lock.unlock();
        while (DangerZone.gameover == 0) {
            long currtime = System.currentTimeMillis();
            long tlong = currtime - lasttime;
            if ((tlong = loop_interval - tlong) < 0L) {
                tlong = 0L;
            }
            if (tlong > loop_interval) {
                tlong = loop_interval;
            }
            if (tlong > 0L) {
                try {
                    Thread.sleep(tlong);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                currtime = System.currentTimeMillis();
            }
            tlong = currtime - lasttime;
            lasttime = currtime;
            float deltaT = tlong;
            if (deltaT < 100.0f) {
                deltaT = 100.0f;
            }
            if (deltaT > 500.0f) {
                deltaT = 500.0f;
            }
            deltaT /= (float)loop_interval;
            inext = 0;
            while (true) {
                this.entity_list_lock.lock();
                if (inext >= this.entity_list.size()) break;
                ListInt i = this.entity_list.get(inext);
                Entity ent = this.entities[i.index];
                if (ent != null && ent.deadflag) {
                    this.entity_list.remove(inext);
                    this.entity_free_list.add(new ListInt(i.index));
                    this.entities[i.index] = null;
                }
                this.entity_list_lock.unlock();
                if (ent.deadflag) {
                    DangerZone.server.sendEntityRemoveToAll(ent);
                    ent = null;
                }
                if (ent != null && DangerZone.server.isPlayerCloseInDimension(ent)) {
                    ent.doEntityAction(deltaT);
                    ent.doEntityCollisions(deltaT);
                    ent.update(deltaT);
                }
                ++inext;
            }
            this.entity_list_lock.unlock();
            DangerZone.server.flushAll();
        }
        return;
    }

    private int find_entity_slot() {
        int retval = -1;
        if (this.entity_free_list.size() > 0) {
            ListInt il = this.entity_free_list.get(0);
            retval = il.index;
            this.entity_free_list.remove(0);
        }
        return retval;
    }

    public int addEntity(Entity e) {
        this.entity_list_lock.lock();
        int i = this.find_entity_slot();
        if (i <= 0) {
            e.entityID = -1;
            this.entity_list_lock.unlock();
            return -1;
        }
        this.entities[i] = e;
        e.entityID = i;
        this.entity_list.add(new ListInt(i));
        this.entity_list_lock.unlock();
        return i;
    }

    public Entity[] getEntitiesInChunk(int dim, int cx, int cz) {
        this.entity_list_lock.lock();
        Entity[] retlist = new Entity[DangerZone.max_entities];
        Iterator<ListInt> ii = this.entity_list.iterator();
        int i = 0;
        while (i < DangerZone.max_entities) {
            retlist[i] = null;
            ++i;
        }
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim || (int)this.entities[st.index].posx >> 4 != cx || (int)this.entities[st.index].posz >> 4 != cz) continue;
            retlist[st.index] = this.entities[st.index];
        }
        this.entity_list_lock.unlock();
        return retlist;
    }

    public boolean areEntitiesInChunk(int dim, int cx, int cz) {
        this.entity_list_lock.lock();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim || (int)this.entities[st.index].posx >> 4 != cx || (int)this.entities[st.index].posz >> 4 != cz) continue;
            this.entity_list_lock.unlock();
            return true;
        }
        this.entity_list_lock.unlock();
        return false;
    }

    public Entity findEntityByID(int eid) {
        Entity ent = null;
        if (eid == 0) {
            return null;
        }
        this.entity_list_lock.lock();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].entityID != eid) continue;
            ent = this.entities[st.index];
            break;
        }
        this.entity_list_lock.unlock();
        return ent;
    }

    public Entity findPlayerByName(String playername) {
        if (playername == null) {
            return null;
        }
        Entity ent = null;
        this.entity_list_lock.lock();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || !(this.entities[st.index] instanceof Player)) continue;
            Player p = (Player)this.entities[st.index];
            if (!p.myname.equals(playername)) continue;
            ent = this.entities[st.index];
            break;
        }
        this.entity_list_lock.unlock();
        return ent;
    }

    public int removeEntityByID(int eid) {
        this.entity_list_lock.lock();
        Iterator<ListInt> ii = this.entity_list.iterator();
        int retid = -1;
        while (ii.hasNext()) {
            ListInt st = ii.next();
            if (this.entities[st.index] == null || this.entities[st.index].entityID != eid) continue;
            this.entities[st.index] = null;
            ii.remove();
            this.entity_free_list.add(new ListInt(st.index));
            retid = eid;
            break;
        }
        this.entity_list_lock.unlock();
        return retid;
    }

    public List<Entity> findEntitiesInRange(float range, int dim, float x, float y, float z) {
        this.entity_list_lock.lock();
        ArrayList<Entity> retlist = new ArrayList<Entity>();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim) continue;
            float dx = x - this.entities[st.index].posx;
            float dy = y - this.entities[st.index].posy;
            float dz = z - this.entities[st.index].posz;
            if (!((dx = (float)Math.sqrt(dx * dx + dy * dy + dz * dz)) < range) || !(this.entities[st.index] instanceof EntityLiving)) continue;
            retlist.add(this.entities[st.index]);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }

    public List<Entity> findALLEntitiesInRange(float range, int dim, float x, float y, float z) {
        this.entity_list_lock.lock();
        ArrayList<Entity> retlist = new ArrayList<Entity>();
        for (ListInt st : this.entity_list) {
            if (this.entities[st.index] == null || this.entities[st.index].dimension != dim) continue;
            float dx = x - this.entities[st.index].posx;
            float dy = y - this.entities[st.index].posy;
            float dz = z - this.entities[st.index].posz;
            if (!((dx = (float)Math.sqrt(dx * dx + dy * dy + dz * dz)) < range)) continue;
            retlist.add(this.entities[st.index]);
        }
        this.entity_list_lock.unlock();
        return retlist;
    }
}

