/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.EntityHostile;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class VampireMoose
extends EntityHostile {
    public int lightcount = 0;

    public VampireMoose(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 3.33f;
        this.width = 1.33f;
        this.uniquename = "DangerZone:Vampire Moose";
        this.moveSpeed = 0.37f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(15.0f);
        this.searchDistance = 20.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 65;
        this.setExperience(199);
        this.canSwim = true;
        this.isHostile = true;
    }

    @Override
    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 0) {
            return null;
        }
        return "DangerZone:vampire_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:moose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:moose_death";
    }

    @Override
    public String getAttackSound() {
        return "DangerZone:werewolf_attack";
    }

    @Override
    public void doDeathDrops() {
        super.doDeathDrops();
        Utils.doDropRand(this.world, 0, Items.trophyvampiremoose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.vampireteeth.itemID, 2.0f, this.dimension, this.posx, this.posy, this.posz);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer) {
            ++this.lightcount;
            if (this.world.isDaytime() && this.lightcount > 100) {
                this.lightcount = 0;
                if (this.getLightAtLocation(this.world, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) > 0.55f) {
                    this.setOnFire(50);
                    if (this.world.rand.nextInt(20) == 0) {
                        this.doAttackFrom(null, 7, 1.0f);
                    }
                }
            }
        }
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/VampireMoosetexture.png");
        }
        return this.texture;
    }
}

