/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityHostile;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Moose
extends EntityHostile {
    public Moose(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 3.33f;
        this.width = 1.33f;
        this.uniquename = "DangerZone:Moose";
        this.moveSpeed = 0.33f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 10.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 65;
        this.setExperience(99);
        this.canSwim = true;
        this.daytimecheck = false;
        this.setCanDespawn(false);
    }

    @Override
    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        if (this.target == null && this.world.isDaytime() && this.world.rand.nextInt(60) == 1) {
            this.findBlockFood(13, 5, 12);
        }
    }

    @Override
    public boolean isFoodBlock(int bid) {
        return bid == Blocks.grass.blockID;
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:moose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:moose_death";
    }

    @Override
    public void doDeathDrops() {
        int howmany = 5 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosemeat.itemID, 4.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand(this.world, 0, Items.moosebone.itemID, 3.0f, this.dimension, this.posx, this.posy, this.posz);
            ++i;
        }
        Utils.doDropRand(this.world, 0, Items.trophymoose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Moose) {
            return false;
        }
        if (e.isHostile && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof EntityHostile && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Moosetexture.png");
        }
        return this.texture;
    }
}

