/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.GenericTargetSorter;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class Goose
extends EntityLiving {
    private GenericTargetSorter FoodSorter = null;
    public int breeding = 0;

    public Goose(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 1.25f;
        this.width = 0.75f;
        this.uniquename = "DangerZone:Goose";
        this.moveSpeed = 0.1f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 55;
        this.setExperience(14);
        this.canSwim = true;
        this.swimoffset = -0.75f;
        this.setCanDespawn(false);
        this.takesFallDamage = false;
        this.setOnGround(true);
    }

    @Override
    public void init() {
        super.init();
        this.FoodSorter = new GenericTargetSorter(this);
    }

    @Override
    public String getLivingSound() {
        return "DangerZone:goose_living";
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:goose_hit";
    }

    @Override
    public String getDeathSound() {
        return "DangerZone:goose_death";
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.corn.itemID;
    }

    public Entity followFood() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(this.width / 2.0f + 10.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.FoodSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                Player p;
                InventoryContainer ic;
                e = li.next();
                if (!(e instanceof Player) || (ic = (p = (Player)e).getHotbar(p.gethotbarindex())) == null || !this.isFoodForMe(ic.bid, ic.iid)) continue;
                return e;
            }
        }
        return null;
    }

    public Entity findMate() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(this.width / 2.0f + 10.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.FoodSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof Goose) || e == this) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public void doEntityAction(float deltaT) {
        Entity e;
        if (this.breeding > 0) {
            --this.breeding;
        }
        if (this.breeding == 0 && this.target == null && this.world.rand.nextInt(this.movefrequency / 10) == 1 && (e = this.followFood()) != null) {
            this.target = new TargetHelper(e, e.posx, e.posy, e.posz);
        }
        if (this.breeding != 0 && this.target == null && this.world.rand.nextInt(this.movefrequency / 6) == 1 && (e = this.findMate()) != null) {
            Goose g = (Goose)e;
            this.target = new TargetHelper(g, g.posx, g.posy, g.posz);
            if (g.breeding != 0 && this.getDistanceFromEntity(g) < this.width * 2.0f && this.world.rand.nextInt(2) == 1) {
                this.breeding = 0;
                g.breeding = 0;
                int howmany = 3 + this.world.rand.nextInt(5);
                int j = 0;
                while (j < howmany) {
                    Entity newme = this.world.createEntityByName("DangerZone:Gosling", this.dimension, (this.posx + g.posx) / 2.0f, (this.posy + g.posy) / 2.0f, (this.posz + g.posz) / 2.0f);
                    if (newme != null) {
                        newme.init();
                        this.world.spawnEntityInWorld(newme);
                        this.world.playSound("DangerZone:pop", this.dimension, (this.posx + g.posx) / 2.0f, (this.posy + g.posy) / 2.0f, (this.posz + g.posz) / 2.0f, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    }
                    ++j;
                }
            }
        }
        if (this.breeding != 0 && this.world.rand.nextInt(5) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 2, this.dimension, this.posx, this.posy + this.height, this.posz);
        }
        super.doEntityAction(deltaT);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer && ic != null && this.isFoodForMe(ic.bid, ic.iid)) {
            if (this.world.rand.nextInt(3) == 1) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + this.height, this.posz);
                this.heal(10.0f);
                this.breeding = 200 + this.world.rand.nextInt(200);
            }
            this.playburp();
            return true;
        }
        return false;
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.trophygoose.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        Utils.doDropRand(this.world, 0, Items.goosemeat.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        int i = 1 + this.world.rand.nextInt(4);
        int j = 0;
        while (j < i) {
            Utils.doDropRand(this.world, 0, Items.feather.itemID, 1.5f, this.dimension, this.posx, this.posy, this.posz);
            ++j;
        }
        if (this.world.rand.nextInt(1000) == 42) {
            j = 0;
            while (j < 1000) {
                Utils.doDropRand(this.world, 0, Items.feather.itemID, 3.5f, this.dimension, this.posx, this.posy, this.posz);
                ++j;
            }
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(5000) == 1) {
            Utils.doDropRand(this.world, 0, Items.egggosling.itemID, 0.1f, this.dimension, this.posx, this.posy, this.posz);
        }
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Goosetexture.png");
        }
        return this.texture;
    }
}

