/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.EntityLiving;

public class EntityTransient
extends EntityLiving {
    public boolean daytimecheck = true;
    public boolean nighttimecheck = false;

    public EntityTransient(World w) {
        super(w);
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.getCanDespawn()) {
            float dist = 0.0f;
            Player p = DangerZone.server.findNearestPlayer(this);
            if (p == null) {
                this.deadflag = true;
            } else {
                dist = Utils.getDistanceBetweenEntities(this, p);
                if (dist > (float)DangerZone.entityupdatedist) {
                    this.deadflag = true;
                } else if (dist > (float)(DangerZone.entityupdatedist / 2)) {
                    if (this.world.rand.nextInt(500) == 0) {
                        this.deadflag = true;
                    }
                } else if (dist > (float)(DangerZone.entityupdatedist / 4)) {
                    if (this.world.rand.nextInt(1000) == 0) {
                        this.deadflag = true;
                    }
                } else if (dist > (float)(DangerZone.entityupdatedist / 8) && this.world.rand.nextInt(2000) == 0) {
                    this.deadflag = true;
                }
            }
        }
        super.update(deltaT);
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        if (this.daytimecheck) {
            if (!w.isDaytime()) {
                return false;
            }
            if (this.getLightAtLocation(w, dimension, x, y, z) < 0.5f) {
                return false;
            }
        }
        if (this.nighttimecheck) {
            if (w.isDaytime()) {
                return false;
            }
            if (this.getLightAtLocation(w, dimension, x, y, z) > 0.5f) {
                return false;
            }
        }
        return true;
    }
}

