/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Dimensions;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.GenericTargetSorter;
import dangerzone.entities.TargetHelper;
import dangerzone.gui.PlayerPetNameGUI;
import dangerzone.items.Items;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class EntityTameable
extends EntityLiving {
    private int secondcounter = 0;
    private GenericTargetSorter FoodSorter = null;
    public float maxdisttoowner = 14.0f;
    public int foodsearchDistance = 12;

    public EntityTameable(World w) {
        super(w);
        this.canSwim = true;
        this.setCanDespawn(false);
        this.maxdisttoowner = 14.0f;
        this.foodsearchDistance = 12;
    }

    @Override
    public void init() {
        super.init();
        this.FoodSorter = new GenericTargetSorter(this);
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic != null && this.isFoodForMe(ic.bid, ic.iid) && this.getOwnerName() == null) {
                if (this.world.rand.nextInt(3) == 1) {
                    this.setOwnerName(p.myname);
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + this.height, this.posz);
                    this.heal(10.0f);
                }
                this.playburp();
                return true;
            }
            if (ic != null && this.isFoodForMe(ic.bid, ic.iid) && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 10, this.dimension, this.posx, this.posy + this.height, this.posz);
                this.playburp();
                this.heal(5.0f);
                return true;
            }
            if (ic != null && ic.iid == Items.moosebone.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + this.height, this.posz);
                this.heal(1.0f);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
            if (ic != null && ic.iid == Items.vampireteeth.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 10, this.dimension, this.posx, this.posy + this.height, this.posz);
                this.setStaying(false);
                this.setOwnerName(null);
                this.setPetName(null);
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
            if (ic != null && this.getOwnerName() != null && p.myname.equals(this.getOwnerName()) && this.getRiderEntity() == null) {
                if (this.getStaying()) {
                    this.setStaying(false);
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleHappy", 20, this.dimension, this.posx, this.posy + this.height, this.posz);
                } else {
                    this.setStaying(true);
                    this.setAttacking(false);
                    this.motionz = 0.0f;
                    this.motionx = 0.0f;
                    this.target = null;
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 10, this.dimension, this.posx, this.posy + this.height, this.posz);
                }
            }
        } else if (ic != null && ic.iid == Items.moosebone.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
            PlayerPetNameGUI pg = new PlayerPetNameGUI(this);
            DangerZone.setActiveGui(pg);
            return false;
        }
        return false;
    }

    public void findNewTargetNearOwner(Entity e) {
        if (this.target == null) {
            this.target = new TargetHelper(e.posx, e.posy, e.posz);
        }
        int tries = 8;
        block0: while (tries > 0) {
            --tries;
            float newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= 180.0f;
            float newdist = 2.0f + this.world.rand.nextFloat() * this.width * this.height * 2.0f;
            int intdist = (int)(newdist + 0.995f);
            float newx = (float)((double)e.posx + Math.cos(newdir += this.rotation_yaw) * (double)newdist);
            float newz = (float)((double)e.posz + Math.sin(newdir) * (double)newdist);
            float newy = e.posy;
            int i = intdist;
            while (i > -intdist) {
                newy = this.posy + (float)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0f, newz) && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0f, newz, (int)newdist)) {
                    if (!this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block0;
                    newy += 1.0f;
                    newy = (int)newy;
                    this.target.setTarget(newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                --i;
            }
        }
    }

    @Override
    public void doEntityAction(float deltaT) {
        ++this.secondcounter;
        if (this.secondcounter > 10) {
            float dist;
            Entity e;
            this.secondcounter = this.world.rand.nextInt(5);
            this.accellerator = 1.0f;
            if (this.getOwnerName() != null && !this.getStaying() && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && (dist = this.getDistanceFromEntity(e)) > this.maxdisttoowner) {
                this.accellerator = 1.75f;
                this.findNewTargetNearOwner(e);
                if (dist > this.maxdisttoowner * 2.0f) {
                    this.target = null;
                    this.accellerator = 1.0f;
                    if (e.getOnGround()) {
                        Dimensions.DimensionArray[e.dimension].teleportToDimension(this, this.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz);
                    }
                }
            }
            if (this.target == null && !this.getStaying() && (e = this.followFood()) != null) {
                this.target = new TargetHelper(e.posx, e.posy, e.posz);
            }
            if (this.target == null) {
                e = this.findSomethingToEat();
                this.setAttacking(false);
                if (e != null) {
                    if (e.getDistanceFromEntity(this) < 3.0f) {
                        e.deadflag = true;
                        this.playburp();
                        this.heal(2.0f);
                        this.target = null;
                    } else if (!this.getStaying()) {
                        this.target = new TargetHelper(e.posx, e.posy, e.posz);
                        this.setAttacking(true);
                    }
                }
            } else if (this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0f && (e = this.findSomethingToEat()) != null && e.getDistanceFromEntity(this) < 3.0f) {
                e.deadflag = true;
                this.playburp();
                this.heal(2.0f);
                this.target = null;
                this.setAttacking(false);
            }
        }
        if (!this.getStaying()) {
            super.doEntityAction(deltaT);
        }
    }

    @Override
    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(200) == 1) {
            this.heal(1.0f);
        }
        super.update(deltaT);
    }

    @Override
    public float getDefense() {
        float df = super.getDefense();
        if (this.getOwnerName() != null && df < 2.0f) {
            df = 2.0f;
        }
        return df;
    }

    public Entity findSomethingToEat() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(this.width / 2.0f + (float)this.foodsearchDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.FoodSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!this.isSuitableFood(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isSuitableFood(Entity e) {
        Entity p;
        if (!(e instanceof EntityBlockItem)) {
            return false;
        }
        EntityBlockItem eb = (EntityBlockItem)e;
        if (!this.isFoodForMe(eb.getBID(), eb.getIID())) {
            return false;
        }
        if (this.getOwnerName() != null && (p = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && p.getDistanceFromEntity(eb) > this.maxdisttoowner) {
            return false;
        }
        return this.CanProbablySeeEntity(eb);
    }

    public Entity followFood() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(this.width / 2.0f + (float)this.foodsearchDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.FoodSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                Player p;
                InventoryContainer ic;
                e = li.next();
                if (!(e instanceof Player) || (ic = (p = (Player)e).getHotbar(p.gethotbarindex())) == null || !this.isFoodForMe(ic.bid, ic.iid)) continue;
                return e;
            }
        }
        return null;
    }
}

