/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.ModelBase;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import org.newdawn.slick.opengl.Texture;

public class EntitySpawner
extends Entity {
    Entity trophyentity = null;
    ModelBase trophymodel = null;
    float trophyscale = 1.0f;
    int timer = 100;

    public EntitySpawner(World w) {
        super(w);
        this.uniquename = "DangerZone:EntitySpawner";
        this.ignoreCollisions = true;
        this.canthitme = true;
        this.width = 0.25f;
        this.height = 0.25f;
    }

    @Override
    public void update(float deltaT) {
        int bid = 0;
        if (this.trophyentity == null) {
            this.trophyentity = this.world.createEntityByName(this.getVarString(0), this.dimension, this.posx, this.posy, this.posz);
            if (this.trophyentity != null) {
                this.trophymodel = this.trophyentity.model;
                this.trophyscale = this.getVarFloat(0);
            }
        }
        if (this.world.isServer && DangerZone.server.isPlayerCloseInDimension(this, 14.0f)) {
            --this.timer;
            if (this.timer <= 0) {
                Entity tmpe;
                float lv;
                this.timer = this.getVarInt(0);
                if (this.timer > 1) {
                    this.timer += this.world.rand.nextInt(this.timer);
                }
                if ((lv = this.getLightAtLocation(this.world, this.dimension, (int)this.posx, (int)this.posy, (int)this.posz)) > this.getVarFloat(1) && lv < this.getVarFloat(2) && (tmpe = this.world.createEntityByName(this.getVarString(0), this.dimension, this.posx, this.posy + 1.0f, this.posz)) != null) {
                    int i = 0;
                    while (i < this.getVarInt(1)) {
                        Entity e;
                        int range = (int)tmpe.width;
                        range += 3;
                        int ht = (int)tmpe.height;
                        ++ht;
                        boolean fits = false;
                        float px = this.posx;
                        float py = this.posy;
                        float pz = this.posz;
                        int tries = 0;
                        while (tries < 10 && !fits) {
                            px = this.posx + (float)(this.world.rand.nextInt(range) * (this.world.rand.nextInt(2) - this.world.rand.nextInt(2)));
                            pz = this.posz + (float)(this.world.rand.nextInt(range) * (this.world.rand.nextInt(2) - this.world.rand.nextInt(2)));
                            py = this.posy;
                            int k = -1;
                            while (k <= ht && !fits) {
                                if (this.isSolidHere(this.world, this.dimension, px, py + (float)k, pz, tmpe.width) && !this.isSolidHere(this.world, this.dimension, px, py + (float)k + 1.0f, pz, tmpe.width)) {
                                    fits = true;
                                    if (ht > 1) {
                                        int j = 2;
                                        while (j <= ht && fits) {
                                            if (this.isSolidHere(this.world, this.dimension, px, py + (float)k + (float)j, pz, tmpe.width)) {
                                                fits = false;
                                            }
                                            ++j;
                                        }
                                    }
                                    if (fits) {
                                        py = py + (float)k + 1.0f;
                                    }
                                }
                                ++k;
                            }
                            ++tries;
                        }
                        if (fits && (e = this.world.createEntityByName(this.getVarString(0), this.dimension, px, py, pz)) != null) {
                            e.init();
                            this.world.spawnEntityInWorld(e);
                        }
                        ++i;
                    }
                }
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz)) == 0) {
                this.deadflag = true;
            }
            if (this.world.rand.nextInt(this.timer + 1) == 1) {
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleFire", 4, this.dimension, this.posx, this.posy + 0.25f, this.posz);
                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 6, this.dimension, this.posx, this.posy + 0.25f, this.posz);
            }
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        this.rotation_yaw_motion = 10.0f;
        super.update(deltaT);
    }

    @Override
    public Texture getTexture() {
        if (this.trophyentity != null) {
            return this.trophyentity.getTexture();
        }
        return null;
    }

    private boolean isSolidHere(World w, int d, float x, float y, float z, float width) {
        int intwidth = (int)(width / 2.0f + 0.5f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(w.getblock(d, (int)x + i, (int)y, (int)z + j))) {
                    int itemp = (int)x + i;
                    float dx = x - ((float)itemp + 0.5f);
                    if ((dx = Math.abs(dx)) < 0.49f + width / 2.0f) {
                        itemp = (int)z + j;
                        float dz = z - ((float)itemp + 0.5f);
                        if ((dz = Math.abs(dz)) < 0.49f + width / 2.0f) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

