/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityExp;
import dangerzone.entities.GenericTargetSorter;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Item;
import dangerzone.items.ItemArmor;
import dangerzone.items.Items;
import dangerzone.threads.LightingThread;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class EntityLiving
extends Entity {
    private float deathfactor = 0.0f;
    public TargetHelper target = null;
    public TargetHelper idletarget = null;
    public float moveSpeed = 0.25f;
    public float accellerator = 1.0f;
    public boolean newtargetnow = false;
    public int movefrequency = 100;
    public int damage_backoff = 0;
    public int fallcount = 0;
    public int lastbx;
    public int lastby;
    public int lastbz;
    public int lastbd;
    public boolean canSwim = true;
    public float eyeheight = 1.0f;
    public float swimoffset = 0.0f;
    public int closest = 99999;
    public int tx = 0;
    public int ty = 0;
    public int tz = 0;
    public int tickadjust = 0;
    private GenericTargetSorter LookTargetSorter = null;
    public float lookDistance = 16.0f;
    public boolean knockbackcheck = false;
    public float jumpstrength = 1.0f;
    public boolean canBreateUnderWater = false;
    public boolean isImmuneToFire = false;
    public boolean targetLiquidOnly = false;

    public EntityLiving(World w) {
        super(w);
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(1.0f);
        this.deathfactor = 0.0f;
        this.takesFallDamage = true;
        this.canSwim = true;
        this.setMaxAir(40.0f);
        this.setAir(40.0f);
        this.setCanDespawn(true);
    }

    @Override
    public void init() {
        super.init();
        this.eyeheight = this.height * 9.0f / 10.0f;
        this.LookTargetSorter = new GenericTargetSorter(this);
        this.lookDistance = this.width * 20.0f;
        if (this.lookDistance > 64.0f) {
            this.lookDistance = 64.0f;
        }
        this.jumpstrength = 0.15f * this.height;
    }

    /*
     * Unable to fully structure code
     */
    public boolean doSolidsPushback(float kf, float deltaT) {
        intwidth = (int)(this.width / 2.0f + 0.995f);
        tmx = this.motionx * deltaT;
        tmz = this.motionz * deltaT;
        rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        if (!this.world.isServer) {
            tmx *= rate;
            tmz *= rate;
        }
        hitsomething = false;
        dist = (float)Math.sqrt(tmx * tmx + tmz * tmz);
        curdist = 0.0f;
        if (dist != 0.0f) ** GOTO lbl65
        return false;
lbl-1000:
        // 1 sources

        {
            if ((curdist += 0.1f) > dist) {
                curdist = dist;
            }
            mx = curdist / dist * tmx;
            mz = curdist / dist * tmz;
            upx = this.posx + mx;
            upz = this.posz + mz;
            i = -intwidth;
            while (i <= intwidth) {
                j = -intwidth;
                while (j <= intwidth) {
                    if (Blocks.isSolid(this.world.getblock(this.dimension, (int)upx + i, (int)(this.posy + kf), (int)upz + j), this.world, this.dimension, (int)upx + i, (int)(this.posy + kf), (int)upz + j)) {
                        itemp = (int)upx + i;
                        dx = (float)itemp + 0.5f - this.posx;
                        itemp = (int)upz + j;
                        dz = (float)itemp + 0.5f - this.posz;
                        if (Math.abs(dx) - (0.51f + this.width / 2.0f) < 0.0f && Math.abs(dz) - (0.51f + this.width / 2.0f) < 0.0f) {
                            this.posx = dx > 0.0f ? (this.posx -= 0.02f) : (this.posx += 0.02f);
                            this.posz = dz > 0.0f ? (this.posz -= 0.02f) : (this.posz += 0.02f);
                            itemp = (int)this.posx + i;
                            dx = (float)itemp + 0.5f - this.posx;
                            itemp = (int)this.posz + j;
                            dz = (float)itemp + 0.5f - this.posz;
                        }
                        dxsave = dx;
                        if (dx < 0.0f && mx < 0.0f) {
                            if (Math.abs(dz) < 0.51f + this.width / 2.0f) {
                                dx += 0.51f;
                                if ((dx += this.width / 2.0f) > mx) {
                                    this.motionx = dx / deltaT;
                                    hitsomething = true;
                                }
                            }
                        } else if (dx > 0.0f && mx > 0.0f && Math.abs(dz) < 0.51f + this.width / 2.0f) {
                            dx -= 0.51f;
                            if ((dx -= this.width / 2.0f) < mx) {
                                this.motionx = dx / deltaT;
                                hitsomething = true;
                            }
                        }
                        dx = dxsave;
                        if (dz < 0.0f && mz < 0.0f) {
                            if (Math.abs(dx) < 0.51f + this.width / 2.0f) {
                                dz += 0.51f;
                                if ((dz += this.width / 2.0f) > mz) {
                                    this.motionz = dz / deltaT;
                                    hitsomething = true;
                                }
                            }
                        } else if (dz > 0.0f && mz > 0.0f && Math.abs(dx) < 0.51f + this.width / 2.0f) {
                            dz -= 0.51f;
                            if ((dz -= this.width / 2.0f) < mz) {
                                this.motionz = dz / deltaT;
                                hitsomething = true;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
lbl65:
            // 2 sources

            ** while (curdist < dist && !hitsomething)
        }
lbl66:
        // 1 sources

        return hitsomething;
    }

    public boolean wouldBump(float x, float y, float z, float w) {
        int intwidth = (int)(w / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(this.world.getblock(this.dimension, (int)x + i, (int)y, (int)z + j), this.world, this.dimension, (int)x + i, (int)y, (int)z + j)) {
                    int itemp = (int)this.posx + i;
                    float dx = x - ((float)itemp + 0.5f);
                    float dz = z - ((float)(itemp = (int)this.posz + j) + 0.5f);
                    if (Math.sqrt(dx * dx + dz * dz) < (double)(0.5f + w / 2.0f)) {
                        return true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isSolidAtLevel(int d, float x, float y, float z) {
        int intwidth = (int)(this.width / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isSolid(this.world.getblock(d, (int)x + i, (int)y, (int)z + j), this.world, d, (int)x + i, (int)y, (int)z + j)) {
                    int itemp = (int)x + i;
                    float dx = x - ((float)itemp + 0.5f);
                    if ((dx = Math.abs(dx)) < 0.49f + this.width / 2.0f) {
                        itemp = (int)z + j;
                        float dz = z - ((float)itemp + 0.5f);
                        if ((dz = Math.abs(dz)) < 0.49f + this.width / 2.0f) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isLiquidAtLevel(int d, float x, float y, float z) {
        int intwidth = (int)(this.width / 2.0f + 0.995f);
        int i = -intwidth;
        while (i <= intwidth) {
            int j = -intwidth;
            while (j <= intwidth) {
                if (Blocks.isLiquid(this.world.getblock(d, (int)x + i, (int)y, (int)z + j))) {
                    int itemp = (int)x + i;
                    float dx = x - ((float)itemp + 0.5f);
                    if ((dx = Math.abs(dx)) < 0.49f + this.width / 2.0f) {
                        itemp = (int)z + j;
                        float dz = z - ((float)itemp + 0.5f);
                        if ((dz = Math.abs(dz)) < 0.49f + this.width / 2.0f) {
                            return true;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isDying() {
        return this.deathfactor > 0.0f && this.deathfactor < 8.0f;
    }

    @Override
    public void doDeathAnimation() {
        this.deathfactor = 0.9f;
        this.motionz = 0.0f;
        this.motionx = 0.0f;
        this.motiony = 0.0f;
    }

    @Override
    public float getDeathFactor() {
        return this.deathfactor;
    }

    @Override
    public void doEntityCollisions(float deltaT) {
        List<Entity> nearby_list = null;
        Entity ridden = this.getRiddenEntity();
        Entity rider = this.getRiderEntity();
        int riddenid = 0;
        int riderid = 0;
        if (ridden != null) {
            riddenid = ridden.entityID;
        }
        if (rider != null) {
            riderid = rider.entityID;
        }
        if ((nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.width / 2.0f + 10.0f, this.dimension, this.posx, this.posy, this.posz)) != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (e == this || e.ignoreCollisions || !(e.posy > this.posy && e.posy < this.posy + this.height || e.posy + e.height > this.posy && e.posy + e.height < this.posy + this.height || this.posy > e.posy && this.posy < e.posy + e.height) && (!(this.posy + this.height > e.posy) || !(this.posy + this.height < e.posy + e.height))) continue;
                double dist = e.getHorizontalDistanceFromEntity(this);
                dist -= (double)(this.width / 2.0f);
                if (!((dist -= (double)(e.width / 2.0f)) < 0.0) || riddenid == e.entityID || riderid == e.entityID) continue;
                double dir = Math.atan2(e.posz - this.posz, e.posx - this.posx);
                this.motionx = (float)((double)this.motionx + Math.cos(dir) * dist * (double)deltaT);
                this.motionz = (float)((double)this.motionz + Math.sin(dir) * dist * (double)deltaT);
            }
        }
    }

    @Override
    public void update(float deltaT) {
        block105: {
            Entity rider;
            float rate;
            block106: {
                float ff;
                int bid;
                int imax;
                int i;
                float gravity;
                block104: {
                    float ff2;
                    int bid2;
                    int imax2;
                    int i2;
                    gravity = 0.045f * deltaT;
                    rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
                    rider = null;
                    if (this.damage_backoff > 0) {
                        --this.damage_backoff;
                    }
                    if (this.hurtanimationtimer > 0) {
                        --this.hurtanimationtimer;
                    }
                    if (this.madtimer > 0) {
                        --this.madtimer;
                    }
                    if (this.deadflag) {
                        this.deathfactor += 0.11f;
                    }
                    if (this.deathfactor > 8.0f) {
                        this.deadflag = true;
                    }
                    if (this.isDying()) {
                        this.deadflag = true;
                    }
                    if (this.world.isServer && !this.isHurt() && !this.deadflag && this.world.rand.nextInt(100) == 1) {
                        this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + this.height / 2.0f, this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
                    }
                    if (this.ignoreCollisions) {
                        if (this.getOnFire() > 0) {
                            this.setOnFire(0);
                        }
                        super.update(deltaT);
                        return;
                    }
                    if (!this.world.isServer) break block104;
                    gravity = 0.2f * deltaT;
                    if (this instanceof Player) break block105;
                    if (this.getOnFire() > 0) {
                        this.setOnFire(this.getOnFire() - 1);
                        ++this.firecounter;
                        if (this.firecounter > 20) {
                            this.doAttackFrom(this, 10, 1.0f);
                            this.firecounter = 0;
                        }
                    }
                    float startheight = this.height / 4.0f;
                    while (startheight < this.height) {
                        this.doSolidsPushback(startheight, deltaT);
                        startheight += 1.0f;
                        if (!(startheight > this.height)) continue;
                        this.doSolidsPushback(this.height, deltaT);
                    }
                    if (this.getInLiquid()) {
                        gravity /= 5.0f;
                    }
                    this.motiony -= gravity;
                    if (this.isSolidAtLevel(this.dimension, this.posx, this.posy, this.posz)) {
                        this.motiony += gravity * 2.0f;
                    }
                    float df = this.motiony * deltaT;
                    int idf = (int)df;
                    df -= (float)idf;
                    if (this.motiony < 0.0f) {
                        i2 = 0;
                        while (i2 >= idf) {
                            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + df + (float)i2, this.posz)) {
                                imax2 = (int)(this.posy + df + (float)i2) + 1;
                                this.motiony = 0.0f;
                                this.posy = (float)imax2 + 0.01f;
                                if (this.fallcount > 7) {
                                    this.doAttackFrom(this, 5, this.getAdjustedFallDamage(this.fallcount - 7));
                                }
                                this.fallcount = 0;
                                break;
                            }
                            --i2;
                        }
                    }
                    if (this.motiony >= 0.0f && !this.isSolidAtLevel(this.dimension, this.posx, this.posy + this.height, this.posz)) {
                        df = this.motiony * deltaT;
                        idf = (int)df;
                        df -= (float)idf;
                        i2 = 0;
                        while (i2 <= idf) {
                            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + df + this.height + (float)i2, this.posz)) {
                                imax2 = (int)(this.posy + df + this.height + (float)i2);
                                this.motiony = 0.0f;
                                this.posy = (float)imax2 - this.height - 0.01f;
                                this.fallcount = 0;
                                break;
                            }
                            ++i2;
                        }
                    }
                    if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.15f, this.posz) && this.getRiddenEntity() == null) {
                        this.setOnGround(false);
                        if (!this.takesFallDamage) {
                            this.fallcount = 0;
                        } else if (this.motiony < 0.0f) {
                            ++this.fallcount;
                        }
                        this.lastbd = 0;
                        this.lastbz = 0;
                        this.lastby = 0;
                        this.lastbx = 0;
                    } else {
                        this.setOnGround(true);
                        this.fallcount = 0;
                        bid2 = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.25f), (int)this.posz);
                        float ff3 = Blocks.getFriction(bid2);
                        if (ff3 != 0.0f) {
                            if ((ff3 = 1.0f - ff3) < 0.0f) {
                                ff3 = 0.0f;
                            }
                            this.motionx *= ff3;
                            this.motionz *= ff3;
                        }
                        if (this.dimension != this.lastbd || (int)this.posx != this.lastbx || (int)(this.posy - 0.25f) != this.lastby || (int)this.posz != this.lastbz) {
                            this.lastbd = this.dimension;
                            this.lastbx = (int)this.posx;
                            this.lastby = (int)(this.posy - 0.25f);
                            this.lastbz = (int)this.posz;
                            Blocks.doSteppedOn(bid2, this, this.world, this.dimension, (int)this.posx, (int)(this.posy - 0.25f), (int)this.posz);
                        }
                    }
                    int intheight = (int)this.height;
                    ++intheight;
                    boolean tmpb = false;
                    boolean tmps = false;
                    int sbid = 0;
                    int lbid = 0;
                    int k = 0;
                    while (k < intheight) {
                        bid2 = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                        if (Blocks.isLiquid(bid2)) {
                            tmpb = true;
                            lbid = bid2;
                        }
                        if (Blocks.isSquishy(bid2)) {
                            tmps = true;
                            sbid = bid2;
                        }
                        ++k;
                    }
                    this.setInLiquid(tmpb);
                    if (this.getInLiquid()) {
                        this.fallcount = 0;
                        ff2 = Blocks.getFriction(lbid);
                        if (ff2 != 0.0f) {
                            if ((ff2 = 1.0f - ff2) < 0.0f) {
                                ff2 = 0.0f;
                            }
                            this.motionx *= ff2;
                            this.motionz *= ff2;
                            this.motiony *= ff2;
                        }
                    }
                    if (tmps) {
                        this.fallcount = 0;
                        ff2 = Blocks.getFriction(sbid);
                        if (ff2 != 0.0f) {
                            if ((ff2 = 1.0f - ff2) < 0.0f) {
                                ff2 = 0.0f;
                            }
                            this.motionx *= ff2;
                            this.motionz *= ff2;
                            this.motiony *= ff2;
                        }
                    }
                    if (this.getInLiquid() && this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + this.height * 3.0f / 4.0f + this.swimoffset), (int)this.posz)) && this.world.rand.nextInt(9) != 0) {
                        this.motiony += 0.08f;
                    }
                    if (!Blocks.isLiquid(bid2 = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + this.eyeheight), (int)this.posz))) {
                        this.setAir(this.getMaxAir());
                    } else {
                        this.setAir(this.getAir() - 0.06f * deltaT);
                    }
                    if (this.getAir() < 0.0f) {
                        this.doAttackFrom(null, 6, 2.5f * deltaT);
                    }
                    if (!this.has_inventory) break block105;
                    Item it = Items.getItem(this.getHelmetID());
                    ItemArmor ia = null;
                    if (it instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getChestplateID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getLeggingsID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getBootsID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if (!(this.posy < 0.0f)) break block105;
                    float h = this.getHealth();
                    if (h > 20.0f) {
                        this.setHealth(this.getHealth() / 4.0f);
                    } else {
                        this.setHealth(this.getHealth() - 1.0f);
                    }
                    break block105;
                }
                if (this.getOnFire() != 0 && this.world.rand.nextInt(60) == 0) {
                    LightingThread.addRequest(this.dimension, (int)this.posx, (int)(this.posy + this.height / 2.0f), (int)this.posz, 0.55f);
                }
                if (!(this instanceof Player)) break block106;
                if (this != DangerZone.player) break block105;
                float cdir = (float)Math.toRadians(this.rotation_yaw);
                float tdir = (float)Math.toRadians(this.rotation_yaw_head);
                float ddiff = tdir - cdir;
                while ((double)ddiff > Math.PI) {
                    ddiff = (float)((double)ddiff - Math.PI * 2);
                }
                while ((double)ddiff < -Math.PI) {
                    ddiff = (float)((double)ddiff + Math.PI * 2);
                }
                this.rotation_yaw = (float)((double)this.rotation_yaw + (double)(ddiff * 180.0f) / Math.PI / 10.0);
                if (this.getOnFire() > 0) {
                    if (this.world.rand.nextInt(6) == 0) {
                        this.setOnFire(this.getOnFire() - 1);
                    }
                    ++this.firecounter;
                    if (this.firecounter / 6 > 20) {
                        this.doAttackFrom(this, 10, 1.0f);
                        this.firecounter = 0;
                    }
                }
                if (DangerZone.player.getGameMode() == 2) {
                    int intheight = (int)this.height;
                    ++intheight;
                    boolean tmpb = false;
                    int lbid = 0;
                    int k = 0;
                    while (k < intheight) {
                        int bid3 = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                        if (Blocks.isLiquid(bid3)) {
                            tmpb = true;
                            lbid = bid3;
                        }
                        ++k;
                    }
                    this.setInLiquid(tmpb);
                    super.update(deltaT);
                    return;
                }
                float startheight = this.height / 4.0f;
                while (startheight < this.height) {
                    this.doSolidsPushback(startheight, deltaT);
                    startheight += 1.0f;
                    if (!(startheight > this.height)) continue;
                    this.doSolidsPushback(this.height, deltaT);
                }
                if (this.getInLiquid()) {
                    gravity /= 5.0f;
                }
                this.motiony -= gravity;
                if (this.isSolidAtLevel(this.dimension, this.posx, this.posy, this.posz)) {
                    this.motiony += gravity * 2.0f;
                }
                float df = this.motiony * deltaT * rate;
                int idf = (int)df;
                df -= (float)idf;
                if (this.motiony < 0.0f) {
                    i = 0;
                    while (i >= idf) {
                        if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + df + (float)i, this.posz)) {
                            imax = (int)(this.posy + df + (float)i) + 1;
                            this.motiony = 0.0f;
                            this.posy = (float)imax + 0.001f;
                            if (this.fallcount > 40) {
                                this.doAttackFrom(this, 5, this.getAdjustedFallDamage((float)(this.fallcount - 40) * rate));
                            }
                            this.fallcount = 0;
                            break;
                        }
                        --i;
                    }
                }
                if (this.motiony >= 0.0f && !this.isSolidAtLevel(this.dimension, this.posx, this.posy + this.height, this.posz)) {
                    df = this.motiony * deltaT * rate;
                    idf = (int)df;
                    df -= (float)idf;
                    i = 0;
                    while (i <= idf) {
                        if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + df + this.height + (float)i, this.posz)) {
                            imax = (int)(this.posy + df + this.height + (float)i);
                            this.motiony = 0.0f;
                            this.posy = (float)imax - this.height - 0.01f;
                            this.fallcount = 0;
                            break;
                        }
                        ++i;
                    }
                }
                if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.1f, this.posz) && this.getRiddenEntity() == null) {
                    this.setOnGround(false);
                    if (this.motiony < 0.0f) {
                        ++this.fallcount;
                    }
                    if (this.getGameMode() != 0) {
                        this.fallcount = 0;
                    }
                    this.lastbd = 0;
                    this.lastbz = 0;
                    this.lastby = 0;
                    this.lastbx = 0;
                } else {
                    this.setOnGround(true);
                    this.fallcount = 0;
                    if (this.getGameMode() != 2) {
                        bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.25f), (int)this.posz);
                        float ff4 = Blocks.getFriction(bid);
                        if (ff4 != 0.0f) {
                            if ((ff4 = 1.0f - ff4) < 0.0f) {
                                ff4 = 0.0f;
                            }
                            this.motionx *= ff4;
                            this.motionz *= ff4;
                        }
                        if (this.dimension != this.lastbd || (int)this.posx != this.lastbx || (int)(this.posy - 0.25f) != this.lastby || (int)this.posz != this.lastbz) {
                            this.lastbd = this.dimension;
                            this.lastbx = (int)this.posx;
                            this.lastby = (int)(this.posy - 0.25f);
                            this.lastbz = (int)this.posz;
                            Blocks.doSteppedOn(bid, this, this.world, this.dimension, (int)this.posx, (int)(this.posy - 0.25f), (int)this.posz);
                        }
                    }
                }
                int intheight = (int)this.height;
                ++intheight;
                boolean tmpb = false;
                boolean tmps = false;
                int sbid = 0;
                int lbid = 0;
                int k = 0;
                while (k < intheight) {
                    bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy + k, (int)this.posz);
                    if (Blocks.isLiquid(bid)) {
                        tmpb = true;
                        lbid = bid;
                    }
                    if (Blocks.isSquishy(bid)) {
                        tmps = true;
                        sbid = bid;
                    }
                    ++k;
                }
                this.setInLiquid(tmpb);
                if (this.getInLiquid()) {
                    this.fallcount = 0;
                    if (this.getGameMode() != 2 && (ff = Blocks.getFriction(lbid)) != 0.0f) {
                        if ((ff = 1.0f - ff) < 0.0f) {
                            ff = 0.0f;
                        }
                        this.motionx *= ff;
                        this.motionz *= ff;
                        this.motiony *= ff;
                    }
                }
                if (tmps) {
                    this.fallcount = 0;
                    if (this.getGameMode() != 2 && (ff = Blocks.getFriction(sbid)) != 0.0f) {
                        if ((ff = 1.0f - ff) < 0.0f) {
                            ff = 0.0f;
                        }
                        this.motionx *= ff;
                        this.motionz *= ff;
                        this.motiony *= ff;
                    }
                }
                if (!Blocks.isLiquid(bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + this.eyeheight), (int)this.posz))) {
                    this.setAir(this.getMaxAir());
                } else if (this.getGameMode() == 0) {
                    this.setAir(this.getAir() - 0.02f * deltaT);
                }
                if (this.getAir() < 0.0f && this.getGameMode() == 0) {
                    this.doAttackFrom(null, 6, 1.5f * deltaT);
                }
                ++this.tickadjust;
                if (this.has_inventory && this.tickadjust >= 6) {
                    this.tickadjust = 0;
                    Item it = Items.getItem(this.getHelmetID());
                    ItemArmor ia = null;
                    if (it instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getChestplateID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getLeggingsID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                    if ((it = Items.getItem(this.getBootsID())) instanceof ItemArmor) {
                        ia = (ItemArmor)it;
                        ia.inUseTick(this);
                    }
                }
                if (this.getGameMode() != 0 || !(this.posy < 0.0f)) break block105;
                float h = this.getHealth();
                if (h > 10.0f) {
                    this.setHealth(this.getHealth() - 1.0f);
                } else {
                    this.setHealth(this.getHealth() - 0.01f);
                }
                break block105;
            }
            rider = this.getRiderEntity();
            if (rider != null && rider.entityID == DangerZone.player.entityID) {
                int imax;
                int i;
                float startheight = this.height / 4.0f;
                while (startheight < this.height) {
                    this.doSolidsPushback(startheight, deltaT);
                    startheight += 1.0f;
                    if (!(startheight > this.height)) continue;
                    this.doSolidsPushback(this.height, deltaT);
                }
                float df = this.motiony * deltaT * rate;
                int idf = (int)df;
                df -= (float)idf;
                if (this.motiony < 0.0f) {
                    i = 0;
                    while (i >= idf) {
                        if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + df + (float)i, this.posz)) {
                            imax = (int)(this.posy + df + (float)i) + 1;
                            this.motiony = 0.0f;
                            this.posy = (float)imax + 0.001f;
                            if (this.fallcount > 40) {
                                this.doAttackFrom(this, 5, this.getAdjustedFallDamage((float)(this.fallcount - 40) * rate));
                            }
                            this.fallcount = 0;
                            break;
                        }
                        --i;
                    }
                }
                if (this.motiony >= 0.0f && !this.isSolidAtLevel(this.dimension, this.posx, this.posy + this.height, this.posz)) {
                    df = this.motiony * deltaT * rate;
                    idf = (int)df;
                    df -= (float)idf;
                    i = 0;
                    while (i <= idf) {
                        if (this.isSolidAtLevel(this.dimension, this.posx, this.posy + df + this.height + (float)i, this.posz)) {
                            imax = (int)(this.posy + df + this.height + (float)i);
                            this.motiony = 0.0f;
                            this.posy = (float)imax - this.height - 0.01f;
                            this.fallcount = 0;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        super.update(deltaT);
    }

    public int getHelmetID() {
        if (this.getArmor(0) != null) {
            return this.getArmor((int)0).iid;
        }
        return 0;
    }

    public int getChestplateID() {
        if (this.getArmor(1) != null) {
            return this.getArmor((int)1).iid;
        }
        return 0;
    }

    public int getLeggingsID() {
        if (this.getArmor(2) != null) {
            return this.getArmor((int)2).iid;
        }
        return 0;
    }

    public int getBootsID() {
        if (this.getArmor(3) != null) {
            return this.getArmor((int)3).iid;
        }
        return 0;
    }

    @Override
    public float getDefense() {
        float df = super.getDefense();
        if (this.has_inventory) {
            Item it = Items.getItem(this.getHelmetID());
            ItemArmor ia = null;
            if (it instanceof ItemArmor) {
                ia = (ItemArmor)it;
                df += ia.protection;
            }
            if ((it = Items.getItem(this.getChestplateID())) instanceof ItemArmor) {
                ia = (ItemArmor)it;
                df += ia.protection;
            }
            if ((it = Items.getItem(this.getLeggingsID())) instanceof ItemArmor) {
                ia = (ItemArmor)it;
                df += ia.protection;
            }
            if ((it = Items.getItem(this.getBootsID())) instanceof ItemArmor) {
                ia = (ItemArmor)it;
                df += ia.protection;
            }
        }
        return df;
    }

    @Override
    public void doArmorDamage(Entity e, int dt, float pain) {
        super.doArmorDamage(e, dt, pain);
        if (pain <= 0.0f) {
            return;
        }
        int which = this.world.rand.nextInt(4);
        if (this.getArmor(which) != null) {
            int ad = (int)(pain + 1.0f);
            this.getArmor((int)which).currentuses += ad;
            if (this.getArmor((int)which).currentuses >= Items.getMaxUses(this.getArmor((int)which).iid)) {
                this.setArmor(which, null);
            }
            if (this instanceof Player) {
                Player pl = (Player)this;
                pl.server_thread.sendInventoryUpdateToPlayer(2, which, this.getArmor(which));
            } else {
                this.setArmorChanged(which);
            }
        }
    }

    @Override
    public void doHurtAnimation() {
        this.hurtanimationtimer = 35;
        this.madtimer = this.world.rand.nextInt(200) + 60;
        this.jump();
    }

    @Override
    public boolean isHurt() {
        return this.hurtanimationtimer > 0;
    }

    @Override
    public void jump() {
        Entity e = this.getRiddenEntity();
        if (e != null) {
            e.jump();
            return;
        }
        if (this.getInLiquid() && this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy + this.height * 3.0f / 4.0f + this.swimoffset), (int)this.posz)) && this.world.rand.nextInt(2) == 0) {
            this.motiony += 0.155f;
            if (this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.35f, this.posz)) {
                this.motiony += 0.55f;
            }
        }
        if (!this.isSolidAtLevel(this.dimension, this.posx, this.posy - 0.1f, this.posz)) {
            return;
        }
        if (Math.abs(this.motiony) > 0.15f) {
            return;
        }
        this.motiony += 0.75f + this.jumpstrength;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        float dfn;
        if (!this.world.isServer) {
            return;
        }
        if (dt == 10 && this.isImmuneToFire) {
            return;
        }
        if (dt == 6 && this.canBreateUnderWater) {
            return;
        }
        if (dt != 5 && dt != 11 && dt != 6 && dt != 7 && dt != 9 && dt != 10 && dt != 12) {
            if (this.damage_backoff > 0) {
                return;
            }
            this.damage_backoff = 5;
        }
        if ((dfn = this.getDefense()) <= 0.1f) {
            dfn = 0.1f;
        }
        if (dfn > 1000.0f) {
            dfn = 1000.0f;
        }
        float totalpain = pain / dfn;
        if (!this.takesDamageFrom(dt)) {
            totalpain = 0.0f;
        }
        if (totalpain == 0.0f) {
            return;
        }
        if (this.has_inventory) {
            this.doArmorDamage(e, dt, pain);
        }
        if ((totalpain = this.getHealth() - totalpain) > this.getMaxHealth()) {
            totalpain = this.getMaxHealth();
        }
        this.setHealth(totalpain);
        if (this instanceof Player) {
            Player pl = (Player)this;
            if (totalpain < 0.0f) {
                totalpain -= 10.0f;
            }
            pl.server_thread.sendVarFloatUpdate(1, totalpain);
        }
        if (e != null && dt != 5 && dt != 7 && dt != 10 && dt != 11 && dt != 6) {
            float dir = (float)Math.atan2(this.posz - e.posz, this.posx - e.posx);
            float sf = e.height * e.width;
            if (sf < 0.25f) {
                sf = 0.25f;
            }
            if (sf > 100.0f) {
                sf = 100.0f;
            }
            this.motionx = (float)((double)this.motionx + Math.cos(dir) * (double)0.55f * (double)sf);
            this.motionz = (float)((double)this.motionz + Math.sin(dir) * (double)0.55f * (double)sf);
            this.motiony += 0.15f * sf;
            if (this instanceof Player) {
                Player pl = (Player)this;
                pl.server_thread.sendVelocityUpdateToPlayer(this.motionx, this.motiony, this.motionz);
            }
        }
        this.newtargetnow = true;
        if (this.getHealth() > 0.0f) {
            if (this.getHurtSound() != null) {
                this.world.playSound(this.getHurtSound(), this.dimension, this.posx, this.posy + this.height / 2.0f, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f);
            }
            DangerZone.server.sendEntityHitToAll(this);
        } else {
            if (this.getDeathSound() != null) {
                this.world.playSound(this.getDeathSound(), this.dimension, this.posx, this.posy + this.height / 2.0f, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.1f);
            }
            if (e != null && e != this) {
                e.onKill(this);
            }
            this.doDeathDrops();
            this.deadflag = true;
            this.onDeath();
            DangerZone.server.sendEntityDeathToAll(this);
        }
    }

    @Override
    public void onDeath() {
        if (this.world.isServer) {
            EntityExp e;
            int iexp = this.getExperience();
            while (iexp >= 1000) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(1000);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    e.motiony = this.world.rand.nextFloat() * this.height / 4.0f;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 1000;
            }
            while (iexp >= 100) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(100);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    e.motiony = this.world.rand.nextFloat() * this.height / 4.0f;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 100;
            }
            while (iexp >= 10) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(10);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    e.motiony = this.world.rand.nextFloat() * this.height / 4.0f;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    this.world.spawnEntityInWorld(e);
                }
                iexp -= 10;
            }
            while (iexp >= 1) {
                e = (EntityExp)this.world.createEntityByName("DangerZone:Experience", this.dimension, this.posx, this.posy, this.posz);
                if (e != null) {
                    e.setBID(0);
                    e.setIID(0);
                    e.setExperience(1);
                    e.rotation_pitch = 0.0f;
                    e.rotation_yaw = this.world.rand.nextInt(360);
                    e.rotation_roll = 0.0f;
                    e.motionx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    e.motiony = this.world.rand.nextFloat() * this.height / 4.0f;
                    e.motionz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * this.width;
                    this.world.spawnEntityInWorld(e);
                }
                --iexp;
            }
        }
        super.onDeath();
    }

    @Override
    public void doEntityAction(float deltaT) {
        Entity rider = this.getRiderEntity();
        if (rider != null && rider instanceof EntityLiving && !(rider instanceof Player)) {
            EntityLiving erider = (EntityLiving)rider;
            this.target = erider.target;
            if (this.target != null) {
                if (this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < this.width / 2.0f) {
                    erider.target = null;
                    this.target = null;
                }
            } else {
                float cdir = (float)Math.toRadians(this.rotation_yaw);
                float tdir = (float)Math.toRadians(erider.rotation_yaw);
                float ddiff = tdir - cdir;
                while ((double)ddiff > Math.PI) {
                    ddiff = (float)((double)ddiff - Math.PI * 2);
                }
                while ((double)ddiff < -Math.PI) {
                    ddiff = (float)((double)ddiff + Math.PI * 2);
                }
                this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            }
        }
        if (this.world.rand.nextInt(this.movefrequency) == 0 || this.newtargetnow) {
            this.findNewTarget();
            this.idletarget = null;
        }
        if (this.target != null && this.target.getDistanceToTarget(this.posx, this.posy, this.posz) > this.width / 2.0f) {
            this.moveTowardsTarget(deltaT);
        } else {
            this.target = null;
            if (this.world.rand.nextInt(this.movefrequency / 10 + 1) == 0) {
                Entity lookentity = this.findEntityToLookAt();
                this.idletarget = lookentity != null ? new TargetHelper(lookentity, lookentity.posx, lookentity.posy, lookentity.posz) : null;
            }
        }
        this.doLookAction();
        super.doEntityAction(deltaT);
    }

    public void doLookAction() {
        TargetHelper look = this.target;
        if (look == null && (look = this.idletarget) != null && look.te != null) {
            look.setTarget(look.te.posx, look.te.posy, look.te.posz);
        }
        if (look != null) {
            float cdir = (float)Math.toRadians(this.rotation_yaw_head);
            float tdir = (float)Math.atan2(look.targetx - this.posx, look.targetz - this.posz);
            float ddiff = tdir - cdir;
            float ht = 0.0f;
            float mht = 0.0f;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
            if (look.te != null) {
                ht = look.te.height * 7.0f / 8.0f;
                mht = this.eyeheight;
            }
            cdir = (float)Math.toRadians(this.rotation_pitch_head);
            tdir = (float)Math.atan2(this.posy + mht - (look.targety + ht), look.getDistanceToTarget(this.posx, look.targety, this.posz));
            ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_pitch_head = (float)((double)this.rotation_pitch_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
            cdir = (float)Math.toRadians(this.rotation_yaw);
            tdir = (float)Math.atan2(look.targetx - this.posx, look.targetz - this.posz);
            ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 50.0);
        }
    }

    public Entity findEntityToLookAt() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.width / 2.0f + this.lookDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.LookTargetSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!(e instanceof Player) || !this.isSuitableLookTarget(e)) continue;
                return e;
            }
            while (li.hasNext()) {
                e = li.next();
                if (!this.isSuitableLookTarget(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isSuitableLookTarget(Entity e) {
        if (e == this) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    public void moveTowardsTarget(float deltaT) {
        int startheight;
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float dist = this.target.getDistanceToTarget(this.posx, this.posy, this.posz);
        float speed = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if ((speed = dist / (speed * 10.0f)) > 1.0f) {
            speed = 1.0f;
        }
        if (this.damage_backoff > 0) {
            this.knockbackcheck = true;
        }
        if (this.getOnGround()) {
            this.knockbackcheck = false;
        }
        if (!this.knockbackcheck) {
            this.motionx = (float)((double)this.motionx + (double)(this.moveSpeed * this.accellerator * speed) * Math.sin(tdir));
            this.motionz = (float)((double)this.motionz + (double)(this.moveSpeed * this.accellerator * speed) * Math.cos(tdir));
        }
        if (!(this.isSolidAtLevel(this.dimension, this.posx + this.motionx * deltaT, this.posy - 1.0f, this.posz + this.motionz * deltaT) || this.isSolidAtLevel(this.dimension, this.posx + this.motionx * deltaT, this.posy - this.height / 4.0f - 2.0f, this.posz + this.motionz * deltaT) || this.isLiquidAtLevel(this.dimension, this.posx + this.motionx * deltaT, this.posy - this.height / 4.0f - 2.0f, this.posz + this.motionz * deltaT) && this.canSwim)) {
            if (!this.knockbackcheck) {
                this.motionz = 0.0f;
                this.motionx = 0.0f;
            }
            this.newtargetnow = true;
            return;
        }
        Entity e = this.getRiddenEntity();
        float useheight = this.height;
        float usewidth = this.width;
        float usex = this.posx + this.motionx * deltaT;
        float usey = this.posy;
        float usez = this.posz + this.motionz * deltaT;
        if (e != null) {
            useheight = e.height;
            usewidth = e.width;
            usex = e.posx + this.motionx * deltaT;
            usey = e.posy;
            usez = e.posz + this.motionz * deltaT;
        }
        int intheight = (int)(useheight + 0.995f);
        int k = startheight = (int)useheight / 4;
        while (k < intheight) {
            if (this.wouldBump(usex, usey + (float)k, usez, usewidth)) {
                if (k <= startheight + 1) {
                    if (this.world.rand.nextInt(3) == 0) {
                        this.jump();
                        break;
                    }
                } else {
                    this.motionx /= 2.0f * deltaT;
                    this.motionz /= 2.0f * deltaT;
                    this.newtargetnow = true;
                    break;
                }
            }
            ++k;
        }
    }

    public void findNewTarget() {
        int i;
        float newy;
        float newz;
        float newx;
        int intdist;
        float newdist;
        float newdir;
        int tries = 4;
        block0: while (tries > 0) {
            --tries;
            newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= 90.0f;
            newdist = 2.0f + this.world.rand.nextFloat() * this.width * this.height * 2.0f;
            intdist = (int)(newdist + 0.995f);
            newx = (float)((double)this.posx + Math.cos(newdir += this.rotation_yaw) * (double)newdist);
            newz = (float)((double)this.posz + Math.sin(newdir) * (double)newdist);
            newy = this.posy;
            i = intdist;
            while (i > -intdist) {
                newy = this.posy + (float)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0f, newz)) {
                    if (!this.targetLiquidOnly && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0f, newz, (int)newdist)) {
                        if (!this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block0;
                        newy += 1.0f;
                        newy = (int)newy;
                        this.target = new TargetHelper(null, newx, newy, newz);
                        this.newtargetnow = false;
                        return;
                    }
                    if (this.canSwim && this.isLiquidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0f, newz, (int)newdist)) {
                        newy += 1.0f;
                        newy = (int)newy;
                        this.target = new TargetHelper(null, newx, newy, newz);
                        this.newtargetnow = false;
                        return;
                    }
                }
                --i;
            }
        }
        tries = 1;
        block2: while (tries > 0) {
            --tries;
            newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= 90.0f;
            newdist = 2.0f + this.world.rand.nextFloat() * this.width * this.height * 4.0f;
            intdist = (int)(newdist + 0.995f);
            newx = (float)((double)this.posx + Math.cos(newdir += this.rotation_yaw + 180.0f) * (double)newdist);
            newz = (float)((double)this.posz + Math.sin(newdir) * (double)newdist);
            newy = this.posy;
            i = intdist;
            while (i > -intdist) {
                newy = this.posy + (float)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0f, newz) && !this.targetLiquidOnly && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0f, newz, (int)newdist)) {
                    if (!this.canSwim && Blocks.isLiquid(this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block2;
                    newy += 1.0f;
                    newy = (int)newy;
                    this.target = new TargetHelper(null, newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                if (this.canSwim && this.isLiquidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0f, newz, (int)newdist)) {
                    newy += 1.0f;
                    newy = (int)newy;
                    this.target = new TargetHelper(null, newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                --i;
            }
        }
    }

    public boolean CanProbablySee(int d, float x, float y, float z, int distinblocks) {
        double xzoff = this.width / 2.0f;
        int nblks = distinblocks;
        double cx = (double)this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double cz = (double)this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        float startx = (float)cx;
        float starty = this.posy + this.height * 7.0f / 8.0f;
        float startz = (float)cz;
        float dx = (x - startx) / (float)distinblocks;
        float dy = (y - starty) / (float)distinblocks;
        float dz = (z - startz) / (float)distinblocks;
        if ((double)Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((float)nblks * Math.abs(dx));
            if (dx > 1.0f) {
                dx = 1.0f;
            }
            if (dx < -1.0f) {
                dx = -1.0f;
            }
        }
        if ((double)Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((float)nblks * Math.abs(dy));
            if (dy > 1.0f) {
                dy = 1.0f;
            }
            if (dy < -1.0f) {
                dy = -1.0f;
            }
        }
        if ((double)Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((float)nblks * Math.abs(dz));
            if (dz > 1.0f) {
                dz = 1.0f;
            }
            if (dz < -1.0f) {
                dz = -1.0f;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid(this.world.getblock(d, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)), this.world, d, (int)startx, (int)starty, (int)startz)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean CanProbablySeeEntity(Entity e) {
        double xzoff = this.width / 2.0f;
        int nblks = (int)this.getDistanceFromEntity(e);
        if (nblks < 1) {
            return true;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(e.posx - this.posx, e.posz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if ((double)ddiff > 2.356194490192345) {
            return false;
        }
        if ((double)ddiff < -2.356194490192345) {
            return false;
        }
        double cx = (double)this.posx + xzoff * Math.cos(Math.toRadians(this.rotation_yaw));
        double cz = (double)this.posz + xzoff * Math.sin(Math.toRadians(this.rotation_yaw));
        float startx = (float)cx;
        float starty = this.posy + this.height * 7.0f / 8.0f;
        float startz = (float)cz;
        float dx = (e.posx - startx) / (float)nblks;
        float dy = (e.posy + e.height * 7.0f / 8.0f - starty) / (float)nblks;
        float dz = (e.posz - startz) / (float)nblks;
        if ((double)Math.abs(dx) > 1.0) {
            dy /= Math.abs(dx);
            dz /= Math.abs(dx);
            nblks = (int)((float)nblks * Math.abs(dx));
            if (dx > 1.0f) {
                dx = 1.0f;
            }
            if (dx < -1.0f) {
                dx = -1.0f;
            }
        }
        if ((double)Math.abs(dy) > 1.0) {
            dx /= Math.abs(dy);
            dz /= Math.abs(dy);
            nblks = (int)((float)nblks * Math.abs(dy));
            if (dy > 1.0f) {
                dy = 1.0f;
            }
            if (dy < -1.0f) {
                dy = -1.0f;
            }
        }
        if ((double)Math.abs(dz) > 1.0) {
            dy /= Math.abs(dz);
            dx /= Math.abs(dz);
            nblks = (int)((float)nblks * Math.abs(dz));
            if (dz > 1.0f) {
                dz = 1.0f;
            }
            if (dz < -1.0f) {
                dz = -1.0f;
            }
        }
        int i = 0;
        while (i < nblks) {
            if (Blocks.isSolid(this.world.getblock(this.dimension, (int)(startx += dx), (int)(starty += dy), (int)(startz += dz)), this.world, this.dimension, (int)startx, (int)starty, (int)startz)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void findBlockFood(int maxdist, int healamount, int eatitdistance) {
        this.closest = 99999;
        this.tz = 0;
        this.ty = 0;
        this.tx = 0;
        int i = 1;
        while (i < maxdist) {
            int j = i;
            if (j > 3) {
                j = 3;
            }
            if (this.scan_it((int)this.posx, (int)this.posy + 1, (int)this.posz, i, j, i)) break;
            if (i >= 6) {
                ++i;
            }
            ++i;
        }
        if (this.closest < 99999) {
            this.target = new TargetHelper(this.tx, this.ty - 1, this.tz);
            if (this.closest < eatitdistance) {
                this.heal(healamount);
                this.doEatFoodAction(this.dimension, this.tx, this.ty, this.tz);
                this.target = null;
            }
        }
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        if (this.world.rand.nextInt(4) == 1) {
            this.playburp();
        }
        this.world.setblockandmeta(d, x, y, z, 0, 0);
    }

    @Override
    public void playburp() {
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            this.world.playSound("DangerZone:burp1", this.dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (which == 1) {
            this.world.playSound("DangerZone:burp2", this.dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (which == 2) {
            this.world.playSound("DangerZone:burp3", this.dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
        if (which == 3) {
            this.world.playSound("DangerZone:burp", this.dimension, this.posx, this.posy, this.posz, 0.55f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f);
        }
    }

    public boolean scan_it(int x, int y, int z, int dx, int dy, int dz) {
        int d;
        int bid;
        int j;
        int found = 0;
        int i = -dy;
        while (i <= dy) {
            j = -dz;
            while (j <= dz) {
                bid = this.world.getblock(this.dimension, x + dx, y + i, z + j);
                if (this.isFoodBlock(bid) && (d = dx * dx + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + dx;
                    this.ty = y + i;
                    this.tz = z + j;
                    ++found;
                }
                if (this.isFoodBlock(bid = this.world.getblock(this.dimension, x - dx, y + i, z + j)) && (d = dx * dx + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x - dx;
                    this.ty = y + i;
                    this.tz = z + j;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        i = -dx;
        while (i <= dx) {
            j = -dz;
            while (j <= dz) {
                bid = this.world.getblock(this.dimension, x + i, y + dy, z + j);
                if (this.isFoodBlock(bid) && (d = dy * dy + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + dy;
                    this.tz = z + j;
                    ++found;
                }
                if (this.isFoodBlock(bid = this.world.getblock(this.dimension, x + i, y - dy, z + j)) && (d = dy * dy + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y - dy;
                    this.tz = z + j;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        i = -dx;
        while (i <= dx) {
            j = -dy;
            while (j <= dy) {
                bid = this.world.getblock(this.dimension, x + i, y + j, z + dz);
                if (this.isFoodBlock(bid) && (d = dz * dz + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + j;
                    this.tz = z + dz;
                    ++found;
                }
                if (this.isFoodBlock(bid = this.world.getblock(this.dimension, x + i, y + j, z - dz)) && (d = dz * dz + j * j + i * i) < this.closest) {
                    this.closest = d;
                    this.tx = x + i;
                    this.ty = y + j;
                    this.tz = z - dz;
                    ++found;
                }
                ++j;
            }
            ++i;
        }
        return found != 0;
    }

    @Override
    public float getAdjustedFallDamage(float ouch) {
        float damage = ouch;
        if (this.getOwnerName() != null && damage > 1.0f) {
            damage = 1.0f;
        }
        return damage;
    }
}

