/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.GenericTargetSorter;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Item;
import dangerzone.items.ItemAxe;
import dangerzone.items.ItemPickAxe;
import dangerzone.items.ItemShovel;
import dangerzone.items.ItemSword;
import dangerzone.items.Items;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class EntityHostile
extends EntityLiving {
    private GenericTargetSorter TargetSorter = null;
    public float searchDistance = 16.0f;
    public float attackRange = 2.0f;
    public int searchcounter = 0;
    public Entity hurtMe = null;
    public Entity targetentity = null;
    public boolean daytimecheck = true;
    public float armangle = 0.0f;
    public int armdir = 0;

    public EntityHostile(World w) {
        super(w);
    }

    @Override
    public void init() {
        super.init();
        this.TargetSorter = new GenericTargetSorter(this);
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        if (e != this && !DangerZone.playnicely) {
            this.hurtMe = e;
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(15) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < this.attackRange + this.targetentity.width / 2.0f + this.width / 2.0f) {
            this.doAttack();
        }
        super.doEntityAction(deltaT);
    }

    public void doAttack() {
        InventoryContainer ic;
        float dmg = this.getAttackDamage();
        int dt = 4;
        if (this.has_inventory && (ic = this.getHotbar(this.gethotbarindex())) != null) {
            if (ic.bid != 0) {
                dt = 3;
            } else if (ic.iid > 0 && ic.iid < 2048) {
                dmg = Items.getAttackStrength(ic.iid);
                dt = 0;
                Item it = ic.getItem();
                if (it != null) {
                    if (it instanceof ItemSword) {
                        dt = 1;
                    }
                    if (it instanceof ItemPickAxe) {
                        dt = 2;
                    }
                    if (it instanceof ItemAxe) {
                        dt = 2;
                    }
                    if (it instanceof ItemShovel) {
                        dt = 2;
                    }
                }
            }
        }
        this.targetentity.doAttackFrom(this, dt, dmg);
    }

    @Override
    public float getRightArmAngle() {
        return -this.armangle;
    }

    public Entity findSomethingToAttack() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.width / 2.0f + this.searchDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!this.isSuitableTarget(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Cockroach) {
            return this.CanProbablySeeEntity(e);
        }
        if (e instanceof Player) {
            return this.CanProbablySeeEntity(e);
        }
        return false;
    }

    public boolean isIgnorable(Entity e) {
        if (DangerZone.playnicely) {
            return true;
        }
        if (e == this) {
            return true;
        }
        if (!(e instanceof EntityLiving)) {
            return true;
        }
        if (e.deadflag) {
            return true;
        }
        return e instanceof Player && e.getGameMode() != 0;
    }

    @Override
    public boolean getCanSpawnHereNow(World w, int dimension, int x, int y, int z) {
        if (this.daytimecheck) {
            if (w.isDaytime()) {
                return false;
            }
            if (this.getLightAtLocation(w, dimension, x, y, z) > 0.35f) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void update(float deltaT) {
        if (this.getAttacking() && this.armdir == 0) {
            this.armdir = 1;
        }
        if (this.armdir != 0) {
            if (this.armdir > 0) {
                this.armangle += 22.0f * deltaT;
                if (this.armangle > 150.0f) {
                    this.armdir = -1;
                }
            }
            if (this.armdir < 0) {
                this.armangle -= 22.0f * deltaT;
                if (this.armangle <= 0.0f) {
                    this.armdir = 0;
                    this.armangle = 0.0f;
                }
            }
        }
        if (this.getCanDespawn() && this.world.isServer) {
            if (this.daytimecheck) {
                if (this.world.isDaytime() && this.world.rand.nextInt(100) == 1) {
                    float dist = 0.0f;
                    Player p = DangerZone.server.findNearestPlayer(this);
                    if (p == null) {
                        this.deadflag = true;
                    } else {
                        dist = Utils.getDistanceBetweenEntities(this, p);
                        if (dist > (float)this.maxrenderdist) {
                            this.deadflag = true;
                        }
                        if (dist > (float)(this.world.rand.nextInt(100) + 16)) {
                            this.deadflag = true;
                        }
                    }
                }
            } else if (this.world.rand.nextInt(1000) == 1) {
                float dist = 0.0f;
                Player p = DangerZone.server.findNearestPlayer(this);
                if (p == null) {
                    this.deadflag = true;
                } else {
                    dist = Utils.getDistanceBetweenEntities(this, p);
                    if (dist > (float)this.maxrenderdist) {
                        this.deadflag = true;
                    }
                    if (dist > (float)(this.world.rand.nextInt(100) + 16)) {
                        this.deadflag = true;
                    }
                }
            }
        }
        super.update(deltaT);
    }
}

