/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class EntityExp
extends Entity {
    public int deathtimer = 1200;
    public int pickup_delay = 0;
    public int points = 0;
    int nexttext = 0;
    int nexttextcount = 0;
    int countdir = 1;

    public EntityExp(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:Experience";
        this.pickup_delay = 10;
        this.points = 0;
        if (w != null) {
            this.nexttext = w.rand.nextInt(8);
            this.nexttextcount = w.rand.nextInt(10);
        }
        this.canthitme = true;
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer));
        prop.setProperty(String.format("%s%s", tag, "POINTS"), String.format("%d", this.points));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
        this.points = Utils.getPropertyInt(prop, String.format("%s%s", tag, "POINTS"), 0, 10000, 1);
    }

    @Override
    public void update(float deltaT) {
        float rate = (float)DangerZone.entityupdaterate / (float)DangerZone.serverentityupdaterate;
        if (this.world.isServer) {
            Player p;
            if (this.posy < -10.0f) {
                this.deadflag = true;
                return;
            }
            int bbid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - (this.height + 0.25f)), (int)this.posz);
            this.motiony = Blocks.isSolid(bbid) ? (this.motiony += 0.007f * deltaT) : (this.motiony -= 0.005f * deltaT);
            this.motiony *= 1.0f - 0.05f * deltaT * rate;
            this.motionx *= 1.0f - 0.05f * deltaT * rate;
            this.motionz *= 1.0f - 0.05f * deltaT * rate;
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
            if (this.pickup_delay > 0) {
                --this.pickup_delay;
            }
            this.rotation_yaw_motion = 0.0f;
            this.rotation_pitch_motion = 0.0f;
            this.rotation_roll_motion = 0.0f;
            this.rotation_pitch = 0.0f;
            this.rotation_yaw = 0.0f;
            this.rotation_roll = 0.0f;
            if (!this.deadflag && this.pickup_delay <= 0 && (p = DangerZone.server.findNearestPlayer(this)) != null && this.getDistanceFromEntity(p) < 7.0f) {
                if (this.getDistanceFromEntityCenter(p) < p.width) {
                    p.server_thread.sendExpAdjust(this.getExperience());
                    this.deadflag = true;
                    this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                }
                float tdir = (float)Math.atan2(p.posx - this.posx, p.posz - this.posz);
                float factor = 1.0f;
                float dist = this.getDistanceFromEntity(p);
                factor = 7.0f / dist;
                if (factor > 1.0f) {
                    factor = 1.0f;
                }
                this.motionx = (float)((double)this.motionx + (double)(0.04f * factor) * Math.sin(tdir) * (double)deltaT);
                this.motionz = (float)((double)this.motionz + (double)(0.04f * factor) * Math.cos(tdir) * (double)deltaT);
                if (this.posy > p.posy + p.height / 2.0f) {
                    this.motiony -= 0.02f * deltaT;
                }
                if (this.posy < p.posy + p.height / 2.0f) {
                    this.motiony += 0.06f * deltaT;
                }
            }
        } else {
            this.motiony *= 1.0f - 0.05f * deltaT * rate;
            this.motionx *= 1.0f - 0.05f * deltaT * rate;
            this.motionz *= 1.0f - 0.05f * deltaT * rate;
        }
        super.update(deltaT);
    }

    public int getSubTexture() {
        int howfast = 5;
        if (this.getExperience() >= 10) {
            howfast = 4;
        }
        if (this.getExperience() >= 100) {
            howfast = 3;
        }
        if (this.getExperience() >= 1000) {
            howfast = 2;
        }
        ++this.nexttextcount;
        if (this.nexttextcount >= howfast) {
            this.nexttextcount = 0;
            this.nexttext += this.countdir;
            if (this.nexttext > 7) {
                this.nexttext = 7;
                this.countdir = -1;
            }
            if (this.nexttext < 0) {
                this.nexttext = 0;
                this.countdir = 1;
            }
        }
        return this.nexttext;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/misc/exp.png");
        }
        return this.texture;
    }
}

