/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import java.util.Properties;

public class EntityBlockItem
extends Entity {
    public int deathtimer = 1200;
    public int pickup_delay = 0;
    private float mx;
    private float mz;

    public EntityBlockItem(World w) {
        super(w);
        this.maxrenderdist = 40;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = DangerZone.blockitemname;
        this.pickup_delay = 10;
        this.canthitme = true;
        if (w != null) {
            this.rotation_pitch = w.rand.nextInt(360);
            this.rotation_yaw = w.rand.nextInt(360);
            this.rotation_roll = w.rand.nextInt(360);
        }
        this.mx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.006f;
        this.mz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.006f;
    }

    @Override
    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
    }

    @Override
    public void update(float deltaT) {
        this.rotation_pitch_motion = 3.0f;
        this.rotation_yaw_motion = 9.0f;
        this.rotation_roll_motion = 5.0f;
        if (this.world.isServer) {
            Player p;
            if (this.posy < -10.0f) {
                this.deadflag = true;
                return;
            }
            if (this.world.rand.nextInt(100) == 1) {
                float f = this.world.rand.nextFloat() * 0.12f;
                this.motiony += f;
            }
            if (this.world.rand.nextInt(200) == 1) {
                this.mx = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.006f;
            }
            if (this.world.rand.nextInt(200) == 1) {
                this.mz = (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.006f;
            }
            this.motionx += this.mx;
            this.motionz += this.mz;
            int bbid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - this.height), (int)this.posz);
            this.motiony = Blocks.isSolid(bbid) ? (this.motiony += 0.25f * deltaT) : (this.motiony -= 0.05f * deltaT);
            --this.deathtimer;
            if (this.deathtimer <= 0) {
                this.deadflag = true;
                return;
            }
            if (this.pickup_delay > 0) {
                --this.pickup_delay;
            }
            if (!this.deadflag && this.pickup_delay <= 0 && (p = DangerZone.server.findNearestPlayer(this)) != null && this.getDistanceFromEntity(p) < p.width / 2.0f + 5.0f) {
                if (this.getDistanceFromEntity(p) < p.width * 3.0f / 2.0f) {
                    boolean doplaysound = false;
                    int ntimes = this.gethotbarindex();
                    if (ntimes <= 0) {
                        ntimes = 1;
                    }
                    while (ntimes > 0) {
                        if (!p.putMeInASlot(this.getBID(), this.getIID(), this.getItemDamage())) {
                            doplaysound = false;
                            this.sethotbarindex(ntimes);
                            break;
                        }
                        doplaysound = true;
                        --ntimes;
                    }
                    if (doplaysound) {
                        this.deadflag = true;
                        this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                    }
                }
                float tdir = (float)Math.atan2(p.posx - this.posx, p.posz - this.posz);
                float factor = 1.0f;
                float dist = this.getDistanceFromEntity(p);
                factor = (p.width / 2.0f + 5.0f) / dist;
                if (factor > 1.0f) {
                    factor = 1.0f;
                }
                this.motionx = (float)((double)this.motionx + (double)(0.08f * factor) * Math.sin(tdir) * (double)deltaT);
                this.motionz = (float)((double)this.motionz + (double)(0.08f * factor) * Math.cos(tdir) * (double)deltaT);
                if (this.posy > p.posy) {
                    this.motiony -= 0.05f * deltaT;
                }
                if (this.posy < p.posy) {
                    this.motiony += 0.15f * deltaT;
                }
            }
        } else {
            float rate = DangerZone.entityupdaterate;
            int bbid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - this.height), (int)this.posz);
            this.motiony = Blocks.isSolid(bbid) ? (this.motiony += 0.25f * rate * deltaT) : (this.motiony -= 0.05f * (rate /= (float)DangerZone.serverentityupdaterate) * deltaT);
        }
        super.update(deltaT);
    }
}

