/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.EntityTameable;
import dangerzone.entities.GenericTargetSorter;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class Anteater
extends EntityTameable {
    Entity targetentity = null;
    Entity hurtMe = null;
    float attackRange = 0.0f;
    int searchDistance = 14;
    int searchcounter = 0;
    private GenericTargetSorter TargetSorter = null;

    public Anteater(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.25f;
        this.width = 0.95f;
        this.uniquename = "DangerZone:Anteater";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(5.0f);
        this.attackRange = 3.5f;
        this.movefrequency = 45;
        this.setExperience(50);
        this.searchDistance = 14;
        this.canSwim = true;
        this.setCanDespawn(false);
        this.maxdisttoowner = 14.0f;
    }

    @Override
    public void init() {
        super.init();
        this.TargetSorter = new GenericTargetSorter(this);
    }

    @Override
    public boolean isFoodItem(int foodid) {
        return foodid == Items.deadbug.itemID;
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float pain) {
        Entity eo;
        if (this.world.isServer && e != this && e != null && e != (eo = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName()))) {
            if (!DangerZone.playnicely) {
                this.hurtMe = e;
            }
            this.setStaying(false);
        }
        super.doAttackFrom(e, dt, pain);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (!this.getStaying()) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(10) == 1) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = new TargetHelper(this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                    this.setAttacking(true);
                } else {
                    this.setAttacking(false);
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < this.attackRange + this.targetentity.width / 2.0f + this.width / 2.0f) {
                this.targetentity.doAttackFrom(this, 4, this.getAttackDamage());
            }
        }
        super.doEntityAction(deltaT);
    }

    public Entity findSomethingToAttack() {
        List<Entity> nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(this.width / 2.0f + (float)this.searchDistance, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (!this.isSuitableTarget(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isSuitableTarget(Entity e) {
        if (DangerZone.playnicely) {
            return false;
        }
        if (this.getOwnerName() != null && this.getDistanceFromEntity(e) > this.maxdisttoowner) {
            return false;
        }
        if (!(e instanceof EntityLiving)) {
            return false;
        }
        if (e.deadflag) {
            return false;
        }
        if (e.width * e.height > 0.063f) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        return "DangerZone:anteater_hit";
    }

    @Override
    public String getDeathSound() {
        return null;
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand(this.world, 0, Items.trophyanteater.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        super.doDeathDrops();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Anteatertexture.png");
        }
        return this.texture;
    }
}

